/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFactory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.util.RequestProcessor;

public class RefreshManager {
    private final ExecutionEnvironment env;
    private final RemoteFileObjectFactory factory;
    private final RequestProcessor.Task updateTask;
    private volatile long updateTaskScheduled = 0L;
    private final LinkedList<String> queue = new LinkedList();
    private final Set<String> set = new HashSet<String>();
    private final Object queueLock = new Object();
    private static final boolean REFRESH_ON_FOCUS = RemoteFileSystemUtils.getBoolean("cnd.remote.refresh.on.focus", true);
    public static final boolean REFRESH_ON_CONNECT = RemoteFileSystemUtils.getBoolean("cnd.remote.refresh.on.connect", true);
    private static final int REPORT_LONG_REFRESH = Integer.getInteger("cnd.remote.report.long.refresh", 5000);

    private boolean permissionDenied(ExecutionException e) {
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof FileInfoProvider.SftpIOException)) continue;
            switch (((FileInfoProvider.SftpIOException)ex).getId()) {
                case 3: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.clear();
            this.set.clear();
        }
    }

    public RefreshManager(ExecutionEnvironment env, RemoteFileObjectFactory factory) {
        this.env = env;
        this.factory = factory;
        this.updateTask = new RequestProcessor("Remote File System RefreshManager " + env.getDisplayName(), 1).create((Runnable)new RefreshWorker(false));
    }

    public void scheduleRefreshOnFocusGained() {
        if (REFRESH_ON_FOCUS) {
            if (RemoteFileSystemTransport.needsClientSidePollingRefresh(this.env)) {
                Collection<RemoteFileObjectBase> fileObjects = this.factory.getCachedFileObjects();
                RemoteLogger.getInstance().log(Level.FINE, "Refresh on focus gained schedulled for {0} directories on {1}", new Object[]{fileObjects.size(), this.env});
                this.scheduleRefreshImpl(this.filterDirectories(fileObjects), false);
            } else {
                RemoteFileSystemTransport.onFocusGained(this.env);
            }
        }
    }

    public void scheduleRefreshOnConnect() {
        if (REFRESH_ON_CONNECT && RemoteFileSystemTransport.needsClientSidePollingRefresh(this.env)) {
            Collection<RemoteFileObjectBase> fileObjects = this.factory.getCachedFileObjects();
            RemoteLogger.getInstance().log(Level.FINE, "Refresh on connect schedulled for {0} directories on {1}", new Object[]{fileObjects.size(), this.env});
            this.scheduleRefreshImpl(this.filterDirectories(fileObjects), false);
        } else {
            RemoteFileSystemTransport.onConnect(this.env);
        }
    }

    private Collection<RemoteFileObjectBase> filterDirectories(Collection<RemoteFileObjectBase> fileObjects) {
        TreeSet<RemoteFileObjectBase> result = new TreeSet<RemoteFileObjectBase>(new PathComparator(true));
        for (RemoteFileObjectBase fo : fileObjects) {
            if (!RefreshManager.isDirectory(fo)) continue;
            result.add(fo);
        }
        return result;
    }

    private static boolean isDirectory(RemoteFileObjectBase fo) {
        return fo != null && fo instanceof RemoteDirectory;
    }

    public void scheduleRefreshExistent(Collection<String> paths, boolean addExistingChildren) {
        ArrayList<RemoteFileObjectBase> fileObjects = new ArrayList<RemoteFileObjectBase>(paths.size());
        for (String path : paths) {
            RemoteFileObjectBase fo = this.factory.getCachedFileObject(path);
            if (fo == null) continue;
            fileObjects.add(fo);
        }
        this.scheduleRefresh(fileObjects, addExistingChildren);
    }

    public void scheduleRefresh(Collection<RemoteFileObjectBase> fileObjects, boolean addExistingChildren) {
        if (addExistingChildren) {
            TreeSet<RemoteFileObjectBase> toRefresh = new TreeSet<RemoteFileObjectBase>(new PathComparator(false));
            for (RemoteFileObjectBase fo : fileObjects) {
                this.addExistingChildren(fo, toRefresh);
            }
            this.scheduleRefreshImpl(toRefresh, true);
        } else {
            this.scheduleRefreshImpl(fileObjects, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRefresh(String path) {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.set.contains(path)) {
                this.set.remove(path);
                this.queue.remove(path);
            }
        }
    }

    private void addExistingChildren(RemoteFileObjectBase fo, Collection<RemoteFileObjectBase> bag) {
        if (RefreshManager.isDirectory(fo)) {
            bag.add(fo);
            for (RemoteFileObjectBase child : fo.getExistentChildren()) {
                this.addExistingChildren(child, bag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRefreshImpl(Collection<RemoteFileObjectBase> fileObjects, boolean toTheHead) {
        if (!ConnectionManager.getInstance().isConnectedTo(this.env)) {
            RemoteLogger.getInstance().warning("scheduleRefresh(Collection<FileObject>) is called while host is not connected");
        }
        if (fileObjects.isEmpty()) {
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            for (RemoteFileObjectBase fo : fileObjects) {
                String path = fo.getPath();
                if (this.set.contains(path)) {
                    this.queue.remove(path);
                } else {
                    this.set.add(path);
                }
                this.queue.add(toTheHead ? 0 : this.queue.size(), path);
            }
        }
        this.updateTask.schedule(0);
        this.updateTaskScheduled = System.currentTimeMillis();
    }

    void testWaitLastRefreshFinished(long time) {
        if (this.updateTaskScheduled < time) {
            for (int i = 0; i < 100 && this.updateTaskScheduled < time; ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.updateTaskScheduled > 0L) {
            this.updateTask.waitFinished();
        }
    }

    static /* synthetic */ Object access$000(RefreshManager x0) {
        return x0.queueLock;
    }

    static /* synthetic */ LinkedList access$100(RefreshManager x0) {
        return x0.queue;
    }

    static /* synthetic */ Set access$200(RefreshManager x0) {
        return x0.set;
    }

    static /* synthetic */ RemoteFileObjectFactory access$300(RefreshManager x0) {
        return x0.factory;
    }

    static /* synthetic */ ExecutionEnvironment access$400(RefreshManager x0) {
        return x0.env;
    }

    static /* synthetic */ void access$500(RefreshManager x0) {
        x0.clear();
    }

    static /* synthetic */ boolean access$600(RefreshManager x0, ExecutionException x1) {
        return x0.permissionDenied(x1);
    }

    static /* synthetic */ int access$700() {
        return REPORT_LONG_REFRESH;
    }

    private static class PathComparator
    implements Comparator<RemoteFileObjectBase> {
        private final boolean childrenFirst;

        public PathComparator(boolean childrenFirst) {
            this.childrenFirst = childrenFirst;
        }

        @Override
        public int compare(RemoteFileObjectBase o1, RemoteFileObjectBase o2) {
            int result = o1.getPath().compareTo(o2.getPath());
            return this.childrenFirst ? -result : result;
        }
    }

    private final class RefreshWorker
    implements Runnable {
        private final boolean expected;

        private RefreshWorker(boolean expected) {
            this.expected = expected;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

