/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ConstantRedeclarationHintError
extends HintErrorRule {
    public String getDisplayName() {
        return Bundle.ConstantRedeclarationHintErrorDisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        FileScope fileScope = context.fileScope;
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && fileObject != null) {
            this.checkTypeScopes(ModelUtils.getDeclaredClasses(fileScope), hints, fileObject);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredInterfaces(fileScope), hints, fileObject);
        }
    }

    private void checkTypeScopes(Collection<? extends TypeScope> typeScopes, List<Hint> hints, FileObject fileObject) {
        for (TypeScope typeScope : typeScopes) {
            for (ClassConstantElement constant : this.getRedeclaredConstants(typeScope)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                hints.add(new Hint((Rule)this, Bundle.ConstantRedeclarationCustom(constant.getName()), fileObject, constant.getNameRange(), null, 500));
            }
        }
    }

    private Set<ClassConstantElement> getRedeclaredConstants(TypeScope typeScope) {
        if (!(typeScope instanceof ClassScope) && !(typeScope instanceof InterfaceScope)) {
            return Collections.emptySet();
        }
        Collection<? extends ClassConstantElement> declaredConstants = typeScope.getDeclaredConstants();
        HashSet<ClassConstantElement> redeclaredConstants = new HashSet<ClassConstantElement>();
        HashMap<String, ClassConstantElement> firstDeclaredConstants = new HashMap<String, ClassConstantElement>();
        for (ClassConstantElement classConstantElement : declaredConstants) {
            String constantName = classConstantElement.getName();
            ClassConstantElement firstDeclaredConstant = (ClassConstantElement)firstDeclaredConstants.get(constantName);
            if (firstDeclaredConstant == null) {
                firstDeclaredConstants.put(constantName, classConstantElement);
                continue;
            }
            if (firstDeclaredConstant.getOffset() > classConstantElement.getOffset()) {
                ClassConstantElement oldConstant = firstDeclaredConstants.replace(constantName, classConstantElement);
                redeclaredConstants.add(oldConstant);
                continue;
            }
            redeclaredConstants.add(classConstantElement);
        }
        return redeclaredConstants;
    }
}

