/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes.actions;

import java.util.Enumeration;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.UndeployModuleCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class UndeployModuleAction
extends NodeAction {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("JBoss undeploy UI", 1);

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            UndeployModuleCookie uCookie = (UndeployModuleCookie)nodes[i].getCookie(UndeployModuleCookie.class);
            if (uCookie == null) continue;
            final RequestProcessor.Task t = uCookie.undeploy();
            final Node node = nodes[i].getParentNode();
            PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    Node apps;
                    t.waitFinished();
                    if (node != null && (apps = node.getParentNode()) != null) {
                        Enumeration appTypes = apps.getChildren().nodes();
                        while (appTypes.hasMoreElements()) {
                            Node appType = (Node)appTypes.nextElement();
                            RefreshModulesCookie cookie = (RefreshModulesCookie)appType.getCookie(RefreshModulesCookie.class);
                            if (cookie == null) continue;
                            cookie.refresh();
                        }
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            UndeployModuleCookie cookie = (UndeployModuleCookie)nodes[i].getCookie(UndeployModuleCookie.class);
            if (cookie != null && !cookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(UndeployModuleAction.class, (String)"LBL_UndeployAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

