/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PlatformTypes;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetManagerEvents;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetProvider;
import org.netbeans.modules.cnd.spi.toolchain.ToolChainPathProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerAccessorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetPreferences;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetProviderFactoryImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetReporter;
import org.netbeans.modules.cnd.toolchain.compilerset.SPIAccessor;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class CompilerSetManagerImpl
extends CompilerSetManager {
    static final boolean DISABLED = Boolean.getBoolean("cnd.toolchain.disabled");
    static final boolean PREFER_STUDIO = "true".equals(System.getProperty("cnd.toolchain.prefer.studio", "true"));
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private static final RequestProcessor RP = new RequestProcessor(CompilerSetManagerImpl.class.getName(), 1);
    private final CopyOnWriteArrayList<CompilerSet> sets;
    private final ExecutionEnvironment executionEnvironment;
    private volatile State state;
    private int platform = -1;
    private RequestProcessor.Task initializationTask;
    private CompilerSetProvider provider;
    private boolean canceled;
    private final RequestProcessor requestProcessor;

    public CompilerSetManagerImpl(ExecutionEnvironment env) {
        this(env, true);
    }

    public CompilerSetManagerImpl(ExecutionEnvironment env, final boolean initialize) {
        this.sets = new CopyOnWriteArrayList();
        this.executionEnvironment = env;
        this.requestProcessor = new RequestProcessor("Compiler set manager " + env, 40);
        if (!initialize || DISABLED) {
            this.state = State.STATE_UNINITIALIZED;
            return;
        }
        this.state = State.STATE_PENDING;
        if (this.executionEnvironment.isLocal()) {
            this.platform = ToolUtils.computeLocalPlatform();
            this.initCompilerSets(Path.getPath());
        } else {
            final AtomicReference threadRef = new AtomicReference();
            String progressMessage = NbBundle.getMessage(this.getClass(), (String)"PROGRESS_TEXT", (Object)env.getDisplayName());
            final ProgressHandle progressHandle = ProgressHandle.createHandle((String)progressMessage, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    Thread thread = (Thread)threadRef.get();
                    if (thread != null) {
                        thread.interrupt();
                    }
                    return true;
                }
            });
            log.log(Level.FINE, "CSM.init: initializing remote compiler set @{0} for: {1}", new Object[]{System.identityHashCode(this), this.toString()});
            progressHandle.start();
            RP.post((Runnable)new NamedRunnable(progressMessage){

                protected void runImpl() {
                    threadRef.set(Thread.currentThread());
                    try {
                        CompilerSetManagerImpl.this.initRemoteCompilerSets(false, initialize);
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
        }
    }

    CompilerSetManagerImpl(ExecutionEnvironment env, List<CompilerSet> sets, int platform) {
        this.executionEnvironment = env;
        this.requestProcessor = new RequestProcessor("Compiler set manager " + env, 4);
        this.sets = new CopyOnWriteArrayList<CompilerSet>(sets);
        this.platform = platform;
        this.completeCompilerSets();
        if (DISABLED) {
            this.state = State.STATE_UNINITIALIZED;
            log.log(Level.FINE, "CSM DISABLED", this.toString());
        } else if (env.isRemote() && this.isEmpty()) {
            this.state = State.STATE_UNINITIALIZED;
            log.log(Level.FINE, "CSM restoring from pref: Adding empty CS to host {0}", this.toString());
        } else {
            this.state = State.STATE_COMPLETE;
        }
    }

    public boolean isValid() {
        return this.sets.size() > 0 && !this.sets.get(0).getName().equals("None");
    }

    @Override
    public boolean isPending() {
        return this.state == State.STATE_PENDING;
    }

    @Override
    public boolean isUninitialized() {
        return this.state == State.STATE_UNINITIALIZED;
    }

    @Override
    public boolean isComplete() {
        return this.state == State.STATE_COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize(boolean save, boolean runCompilerSetDataLoader, Writer reporter) {
        this.canceled = false;
        CompilerSetReporter.setWriter(reporter);
        ProgressHandle pHandle = null;
        try {
            CndUtils.assertNonUiThread();
            if (this.isUninitialized() && !DISABLED) {
                log.log(Level.FINE, "CSM.getDefault: Doing remote setup from EDT?{0}", SwingUtilities.isEventDispatchThread());
                pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"PROGRESS_TEXT", (Object)this.getExecutionEnvironment().getDisplayName()));
                pHandle.start();
                this.sets.clear();
                this.initRemoteCompilerSets(true, runCompilerSetDataLoader);
                if (this.initializationTask != null) {
                    this.initializationTask.waitFinished();
                    this.initializationTask = null;
                }
            }
            if (save && !DISABLED) {
                CompilerSetManagerAccessorImpl.save(this);
            }
        }
        finally {
            CompilerSetReporter.setWriter(null);
            if (pHandle != null) {
                pHandle.finish();
            }
            this.canceled = false;
        }
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        CompilerSetProvider aProvider = this.provider;
        if (aProvider != null) {
            return aProvider.cancel();
        }
        return false;
    }

    @Override
    public int getPlatform() {
        if (this.platform < 0) {
            if (this.executionEnvironment.isLocal()) {
                this.platform = ToolUtils.computeLocalPlatform();
            } else {
                if (this.isPending()) {
                    log.log(Level.WARNING, "calling getPlatform() on uninitialized {0}", this.getClass().getSimpleName());
                }
                HostInfo hostInfo = null;
                if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.executionEnvironment)) {
                    try {
                        hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (hostInfo != null) {
                    return PlatformTypes.getPlatformFromHostInfo(hostInfo);
                }
            }
        }
        return this.platform == -1 ? 6 : this.platform;
    }

    public CompilerSetManagerImpl deepCopy() {
        if (this.isPending()) {
            log.log(Level.WARNING, "calling deepCopy() on uninitialized {0}", this.getClass().getSimpleName());
        }
        ArrayList<CompilerSet> setsCopy = new ArrayList<CompilerSet>();
        CompilerSetImpl copyOfDefaultCompilerSet = null;
        for (CompilerSet set : this.getCompilerSets()) {
            CompilerSetImpl copy = ((CompilerSetImpl)set).createCopy(this.executionEnvironment);
            setsCopy.add(copy);
            if (!this.isDefaultCompilerSet(set)) continue;
            copyOfDefaultCompilerSet = copy;
        }
        CompilerSetManagerImpl copy = new CompilerSetManagerImpl(this.executionEnvironment, setsCopy, this.platform);
        copy.setDefault(copyOfDefaultCompilerSet);
        return copy;
    }

    public String getUniqueCompilerSetName(String baseName) {
        int n = 0;
        String suggestedName = baseName;
        while (this.getCompilerSet(suggestedName = baseName + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        return suggestedName;
    }

    private Collection<FolderDescriptor> getPaths(ToolchainManager.ToolchainDescriptor d, CompilerFlavor flavor, ArrayList<String> dirlist) {
        String path;
        List<String> list;
        LinkedHashSet<FolderDescriptor> dirs = new LinkedHashSet<FolderDescriptor>();
        String base = ToolUtils.getBaseFolder(d, this.getPlatform());
        if (base != null) {
            dirs.add(new FolderDescriptor(base, true));
        }
        for (String p : dirlist) {
            dirs.add(new FolderDescriptor(p, false));
        }
        Map<String, List<String>> map = d.getDefaultLocations();
        if (map != null && (list = map.get(ToolUtils.getPlatformName(this.getPlatform()))) != null) {
            for (String p : list) {
                dirs.add(new FolderDescriptor(p, true));
            }
        }
        if ((path = ToolChainPathProvider.getDefault().getPath(flavor)) != null) {
            dirs.add(new FolderDescriptor(path, true));
        }
        return dirs;
    }

    private synchronized void initCompilerSets(final ArrayList<String> dirlist) {
        if (this.state == State.STATE_COMPLETE) {
            return;
        }
        if (this.initializationTask != null) {
            return;
        }
        String progressMessage = NbBundle.getMessage(this.getClass(), (String)"PROGRESS_TEXT", (Object)this.executionEnvironment.getDisplayName());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompilerSetManagerImpl.this.initCompilerSetsImpl(dirlist);
            }
        };
        if (CndUtils.isStandalone() || CndUtils.isUnitTestMode()) {
            runnable.run();
        } else {
            ProgressHandle progressHandle = ProgressHandle.createHandle((String)progressMessage);
            progressHandle.start();
            this.initializationTask = RP.post(runnable);
            this.initializationTask.waitFinished();
            this.initializationTask = null;
            progressHandle.finish();
        }
    }

    private void initCompilerSetsImpl(ArrayList<String> dirlist) {
        File folder;
        HashSet<CompilerFlavor> flavors = new HashSet<CompilerFlavor>();
        String SunStudioPath = System.getProperty("spro.bin");
        boolean OSS_TOOLCHAIN_ONLY = "true".equals(System.getProperty("oss.toolchain.only"));
        boolean DEBUGGER_ONLY = "on".equals(System.getProperty("PL_MODE"));
        if (SunStudioPath != null && (folder = new File(SunStudioPath)).isDirectory()) {
            for (ToolchainManager.ToolchainDescriptor d : ToolchainManagerImpl.getImpl().getToolchains(this.getPlatform())) {
                CompilerFlavor flavor;
                if (d.isAbstract() || !d.isAutoDetected() || (flavor = CompilerFlavorImpl.toFlavor(d.getName(), this.getPlatform())) == null || flavors.contains(flavor)) continue;
                CompilerSetImpl cs = CompilerSetImpl.create(flavor, this.executionEnvironment, folder.getAbsolutePath());
                cs.setAutoGenerated(true);
                if (this.initCompilerSet(SunStudioPath, cs, true)) {
                    flavors.add(flavor);
                    this.addUnsafe(cs);
                    if (cs.getCompilerFlavor().getToolchainDescriptor().getAliases().length <= 0) continue;
                    cs.setSunStudioDefault(true);
                    continue;
                }
                if (!DEBUGGER_ONLY || !this.initCompilerSet(SunStudioPath, cs, true, PredefinedToolKind.DebuggerTool)) continue;
                flavors.add(flavor);
                this.addUnsafe(cs);
                if (cs.getCompilerFlavor().getToolchainDescriptor().getAliases().length <= 0) break;
                cs.setSunStudioDefault(true);
                break;
            }
        }
        if (!OSS_TOOLCHAIN_ONLY) {
            block1: for (ToolchainManager.ToolchainDescriptor d : ToolchainManagerImpl.getImpl().getToolchains(this.getPlatform())) {
                CompilerFlavor flavor;
                if (d.isAbstract() || !d.isAutoDetected() || (flavor = CompilerFlavorImpl.toFlavor(d.getName(), this.getPlatform())) == null || flavors.contains(flavor)) continue;
                for (FolderDescriptor folderDescriptor : this.getPaths(d, flavor, dirlist)) {
                    File dir;
                    String path = folderDescriptor.path;
                    if (path.equals("/usr/ucb")) continue;
                    if (!CndPathUtilities.isAbsolute((CharSequence)path)) {
                        path = CndFileUtils.normalizeAbsolutePath((String)new File(path).getAbsolutePath());
                    }
                    if (!(dir = new File(path)).isDirectory() || !ToolUtils.isMyFolder(dir.getAbsolutePath(), d, this.getPlatform(), folderDescriptor.knownFolder, PredefinedToolKind.CCompiler) || d.getModuleID() != null || d.isAbstract()) continue;
                    CompilerSetImpl cs = CompilerSetImpl.create(flavor, this.executionEnvironment, dir.getAbsolutePath());
                    cs.setAutoGenerated(true);
                    if (!this.initCompilerSet(path, cs, folderDescriptor.knownFolder)) continue;
                    flavors.add(flavor);
                    this.addUnsafe(cs);
                    continue block1;
                }
            }
        }
        this.removeSubstitutions();
        this.addFakeCompilerSets();
        this.completeCompilerSets();
        this.state = State.STATE_COMPLETE;
    }

    public static ArrayList<String> appendDefaultLocations(int platform, ArrayList<String> dirlist) {
        for (ToolchainManager.ToolchainDescriptor d : ToolchainManagerImpl.getImpl().getToolchains(platform)) {
            String pname;
            List<String> list;
            Map<String, List<String>> map;
            if (d.isAbstract() || !d.isAutoDetected() || (map = d.getDefaultLocations()) == null || (list = map.get(pname = ToolUtils.getPlatformName(platform))) == null) continue;
            for (String dir : list) {
                if (dirlist.contains(dir)) continue;
                dirlist.add(dir);
            }
        }
        return dirlist;
    }

    private void setDefaltCompilerSet() {
        for (CompilerSet cs : this.sets) {
            if (!((CompilerSetImpl)cs).isDefault()) continue;
            return;
        }
        CompilerSet bestCandidate = null;
        String defaultToolchain = System.getProperty("cnd.default.toolchain");
        if (defaultToolchain != null) {
            for (CompilerSet cs : this.sets) {
                if (!cs.getName().equalsIgnoreCase(defaultToolchain)) continue;
                bestCandidate = cs;
            }
        }
        if (PREFER_STUDIO) {
            for (CompilerSet cs : this.sets) {
                if (!cs.getCompilerFlavor().isSunStudioCompiler()) continue;
                if ("OracleDeveloperStudio".equals(cs.getName())) {
                    this.setDefault(cs);
                    return;
                }
                if (bestCandidate != null) continue;
                bestCandidate = cs;
            }
        }
        if (bestCandidate != null) {
            this.setDefault(bestCandidate);
            return;
        }
        if (!this.sets.isEmpty()) {
            this.setDefault(this.sets.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompilerSet> findRemoteCompilerSets(String path) {
        String[] arData;
        ServerRecord record = ServerList.get((ExecutionEnvironment)this.executionEnvironment);
        assert (record != null);
        record.validate(true);
        if (!record.isOnline()) {
            return Collections.emptyList();
        }
        try {
            this.provider = CompilerSetProviderFactoryImpl.createNew(this.executionEnvironment);
            arData = this.provider.getCompilerSetData(path);
        }
        finally {
            this.provider = null;
        }
        ArrayList<CompilerSet> css = new ArrayList<CompilerSet>();
        if (arData != null) {
            for (String data : arData) {
                CompilerSetImpl cs;
                if (data == null || data.length() <= 0) continue;
                if (this.platform < 0) {
                    HostInfo hostInfo = null;
                    if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.executionEnvironment)) {
                        try {
                            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ConnectionManager.CancellationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (hostInfo != null) {
                        this.platform = PlatformTypes.getPlatformFromHostInfo(hostInfo);
                    }
                }
                if ((cs = this.parseCompilerSetString(this.platform, data)) != null) {
                    cs.setAutoGenerated(false);
                    css.add(cs);
                    continue;
                }
                log.log(Level.WARNING, "Not recognized CompilerSetString: {0}", data);
            }
        }
        ArrayList<CompilerSet> all = new ArrayList<CompilerSet>(this.getCompilerSets());
        all.addAll(css);
        for (CompilerSet cs : css) {
            CompilerSetManagerImpl.completeCompilerSet(this.executionEnvironment, (CompilerSetImpl)cs, all);
        }
        return css;
    }

    private CompilerSetImpl parseCompilerSetString(int platform, String data) {
        String path;
        String flavor;
        log.log(Level.FINE, "CSM.initRemoteCompileSets: line = [{0}]", data);
        String versionStart = ";version=";
        int v = data.indexOf(versionStart);
        String version = null;
        if (v > 0) {
            version = data.substring(v + versionStart.length());
            data = data.substring(0, v);
        }
        StringTokenizer st = new StringTokenizer(data, ";");
        try {
            flavor = st.nextToken();
            path = st.nextToken();
        }
        catch (NoSuchElementException ex) {
            log.log(Level.WARNING, "Malformed compilerSetString: {0}", data);
            return null;
        }
        CompilerFlavor compilerFlavor = CompilerFlavorImpl.toFlavor(flavor, platform);
        if (compilerFlavor == null) {
            log.log(Level.WARNING, "NULL compiler flavor for {0} on platform {1}", new Object[]{flavor, platform});
            return null;
        }
        CompilerSetImpl cs = CompilerSetImpl.create(compilerFlavor, this.executionEnvironment, path);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            int i = name.indexOf(61);
            if (i < 0) continue;
            String tool = name.substring(0, i);
            String p = name.substring(i + 1);
            i = name.lastIndexOf(47);
            if (i < 0) {
                i = name.lastIndexOf(92);
            }
            if (i > 0) {
                name = name.substring(i + 1);
            }
            PredefinedToolKind kind = PredefinedToolKind.UnknownTool;
            if (tool.equals("c")) {
                kind = PredefinedToolKind.CCompiler;
            } else if (tool.equals("cpp")) {
                kind = PredefinedToolKind.CCCompiler;
            } else if (tool.equals("fortran")) {
                kind = PredefinedToolKind.FortranCompiler;
            } else if (tool.equals("assembler")) {
                kind = PredefinedToolKind.Assembler;
            } else if (tool.equals("make")) {
                kind = PredefinedToolKind.MakeTool;
            } else if (tool.equals("debugger")) {
                kind = PredefinedToolKind.DebuggerTool;
            } else if (tool.equals("cmake")) {
                kind = PredefinedToolKind.CMakeTool;
            } else if (tool.equals("qmake")) {
                kind = PredefinedToolKind.QMakeTool;
            } else if (tool.equals("c(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.CCompiler, p);
            } else if (tool.equals("cpp(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.CCCompiler, p);
            } else if (tool.equals("fortran(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.FortranCompiler, p);
            } else if (tool.equals("assembler(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.Assembler, p);
            } else if (tool.equals("make(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.MakeTool, p);
            } else if (tool.equals("debugger(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.DebuggerTool, p);
            } else if (tool.equals("cmake(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.CMakeTool, p);
            } else if (tool.equals("qmake(PATH)")) {
                cs.addPathCandidate(PredefinedToolKind.QMakeTool, p);
            }
            if (kind == PredefinedToolKind.UnknownTool) continue;
            cs.addTool(this.executionEnvironment, name, p, kind, null);
        }
        return cs;
    }

    private synchronized void initRemoteCompilerSets(boolean connect, final boolean runCompilerSetDataLoader) {
        if (this.state == State.STATE_COMPLETE) {
            return;
        }
        if (this.initializationTask != null) {
            return;
        }
        ServerRecord record = ServerList.get((ExecutionEnvironment)this.executionEnvironment);
        assert (record != null);
        log.log(Level.FINE, "CSM.initRemoteCompilerSets for {0} [{1}]", new Object[]{this.executionEnvironment, this.state});
        boolean wasOffline = record.isOffline();
        if (wasOffline) {
            CompilerSetReporter.report("CSM_Conn", false, this.executionEnvironment.getHost());
        }
        record.validate(connect);
        if (record.isOnline()) {
            if (wasOffline) {
                CompilerSetReporter.report("CSM_Done");
            }
            this.initializationTask = RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        CompilerSetManagerImpl.this.provider = CompilerSetProviderFactoryImpl.createNew(CompilerSetManagerImpl.this.executionEnvironment);
                        assert (CompilerSetManagerImpl.this.provider != null);
                        CompilerSetManagerImpl.this.provider.init();
                        CompilerSetManagerImpl.this.platform = CompilerSetManagerImpl.this.provider.getPlatform();
                        CompilerSetReporter.report("CSM_ValPlatf", true, PlatformTypes.toString(CompilerSetManagerImpl.this.platform));
                        CompilerSetReporter.report("CSM_LFTC");
                        log.log(Level.FINE, "CSM.initRemoteCompileSets: platform = {0}", CompilerSetManagerImpl.this.platform);
                        CompilerSetPreferences.putEnv(CompilerSetManagerImpl.this.executionEnvironment, CompilerSetManagerImpl.this.platform);
                        while (CompilerSetManagerImpl.this.provider.hasMoreCompilerSets()) {
                            String data = CompilerSetManagerImpl.this.provider.getNextCompilerSetData();
                            CompilerSetImpl cs = CompilerSetManagerImpl.this.parseCompilerSetString(CompilerSetManagerImpl.this.platform, data);
                            if (cs != null) {
                                CompilerSetReporter.report("CSM_Found", true, ((CompilerSet)cs).getDisplayName(), ((CompilerSet)cs).getDirectory());
                                CompilerSetManagerImpl.this.addUnsafe(cs);
                                final List<Tool> toolsCopy = ((CompilerSet)cs).getTools();
                                CompilerSetManagerImpl.this.requestProcessor.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (Tool tool : toolsCopy) {
                                            if (tool.isReady()) continue;
                                            tool.waitReady(true);
                                        }
                                    }
                                });
                                continue;
                            }
                            if (!CompilerSetReporter.canReport()) continue;
                            CompilerSetReporter.report("CSM_Err", true, data);
                        }
                        CompilerSetManagerImpl.this.removeSubstitutions();
                        CompilerSetManagerImpl.this.completeCompilerSets(false);
                        log.log(Level.FINE, "CSM.initRemoteCompilerSets: Found {0} compiler sets", CompilerSetManagerImpl.this.sets.size());
                        if (CompilerSetManagerImpl.this.sets.isEmpty()) {
                            CompilerSetReporter.report("CSM_Done_NF");
                        } else {
                            CompilerSetReporter.report("CSM_Done_OK", true, CompilerSetManagerImpl.this.sets.size());
                        }
                        CompilerSetManagerImpl.this.state = State.STATE_COMPLETE;
                        CompilerSetReporter.report(CompilerSetManagerImpl.this.canceled ? "CSM_Canceled" : "CSM_Conigured");
                        if (runCompilerSetDataLoader) {
                            CompilerSetManagerImpl.this.finishInitialization();
                        }
                    }
                    catch (Throwable thr) {
                        CompilerSetManagerImpl.this.state = State.STATE_UNINITIALIZED;
                        log.log(Level.FINE, "Error initiaizing compiler set @" + this.hashCode() + " on " + CompilerSetManagerImpl.this.executionEnvironment, thr);
                        CompilerSetReporter.report("CSM_Fail");
                        CompilerSetManagerImpl.this.completeCompilerSets();
                    }
                    finally {
                        CompilerSetManagerImpl.this.provider = null;
                    }
                }
            });
        } else {
            CompilerSetReporter.report("CSM_Fail");
            log.log(Level.FINE, "CSM.initRemoteCompilerSets: Adding empty CS to OFFLINE host {0}", this.executionEnvironment);
            this.completeCompilerSets(false);
            this.state = State.STATE_UNINITIALIZED;
        }
    }

    @Override
    public void finishInitialization() {
        log.log(Level.FINE, "Code Model Ready for {0}", this.toString());
        if (!ServerList.get((ExecutionEnvironment)this.executionEnvironment).isDeleted()) {
            SPIAccessor.get().runTasks(CompilerSetManagerEvents.get(this.executionEnvironment));
        }
    }

    public void initCompilerSet(CompilerSet cs) {
        CompilerSetImpl impl = (CompilerSetImpl)cs;
        this.initCompilerSet(impl.getDirectory(), impl, false);
        CompilerSetManagerImpl.completeCompilerSet(this.executionEnvironment, impl, this.sets);
    }

    public boolean initCompilerSet(String path, CompilerSetImpl cs, boolean known) {
        return this.initCompilerSet(path, cs, known, PredefinedToolKind.CCompiler);
    }

    private boolean initCompilerSet(String path, CompilerSetImpl cs, boolean known, ToolKind requiredTool) {
        CompilerFlavor flavor = cs.getCompilerFlavor();
        ToolchainManager.ToolchainDescriptor d = flavor.getToolchainDescriptor();
        if (d != null && ToolUtils.isMyFolder(path, d, this.getPlatform(), known, requiredTool)) {
            ToolchainManager.CompilerDescriptor compiler = d.getC();
            if (compiler != null && !compiler.skipSearch()) {
                this.initCompiler(PredefinedToolKind.CCompiler, path, cs, compiler.getNames());
            }
            if ((compiler = d.getCpp()) != null && !compiler.skipSearch()) {
                this.initCompiler(PredefinedToolKind.CCCompiler, path, cs, compiler.getNames());
            }
            if ((compiler = d.getFortran()) != null && !compiler.skipSearch()) {
                this.initCompiler(PredefinedToolKind.FortranCompiler, path, cs, compiler.getNames());
            }
            if ((compiler = d.getAssembler()) != null && !compiler.skipSearch()) {
                this.initCompiler(PredefinedToolKind.Assembler, path, cs, compiler.getNames());
            }
            if (d.getMake() != null && !d.getMake().skipSearch()) {
                this.initCompiler(PredefinedToolKind.MakeTool, path, cs, d.getMake().getNames());
            }
            if (d.getDebugger() != null && !d.getDebugger().skipSearch()) {
                this.initCompiler(PredefinedToolKind.DebuggerTool, path, cs, d.getDebugger().getNames());
            }
            if (d.getQMake() != null && !d.getQMake().skipSearch()) {
                this.initCompiler(PredefinedToolKind.QMakeTool, path, cs, d.getQMake().getNames());
            }
            if (d.getCMake() != null && !d.getCMake().skipSearch()) {
                this.initCompiler(PredefinedToolKind.CMakeTool, path, cs, d.getCMake().getNames());
            }
            return true;
        }
        return false;
    }

    private void initCompiler(ToolKind kind, String path, CompilerSetImpl cs, String[] names) {
        File dir = new File(path);
        if (cs.findTool(kind) != null) {
            return;
        }
        for (String name : names) {
            File file = new File(dir, name);
            if (file.exists() && !file.isDirectory()) {
                cs.addTool(this.executionEnvironment, name, file.getAbsolutePath(), kind, null);
                return;
            }
            file = new File(dir, name + ".exe");
            if (file.exists() && !file.isDirectory()) {
                cs.addTool(this.executionEnvironment, name, file.getAbsolutePath(), kind, null);
                return;
            }
            File file2 = new File(dir, name + ".exe.lnk");
            if (!file2.exists() || file2.isDirectory()) continue;
            cs.addTool(this.executionEnvironment, name, file.getAbsolutePath(), kind, null);
            return;
        }
    }

    private void removeSubstitutions() {
        HashSet<CompilerSet> toRemove = new HashSet<CompilerSet>();
        for (CompilerSet cs : this.sets) {
            String subsitute = cs.getCompilerFlavor().getToolchainDescriptor().getSubstitute();
            if (subsitute == null) continue;
            for (CompilerSet c : this.sets) {
                String numbered;
                String general;
                if (!c.isAutoGenerated() || !subsitute.equals(c.getCompilerFlavor().getToolchainDescriptor().getName()) || !(general = c.getDirectory()).equals(numbered = cs.getDirectory())) continue;
                toRemove.add(c);
            }
        }
        for (CompilerSet cs : toRemove) {
            this.sets.remove(cs);
        }
    }

    private void addFakeCompilerSets() {
        for (CompilerFlavor flavor : CompilerFlavorImpl.getFlavors(this.getPlatform())) {
            ToolchainManager.ToolchainDescriptor descriptor = flavor.getToolchainDescriptor();
            if (descriptor.getUpdateCenterUrl() == null || descriptor.getModuleID() == null) continue;
            boolean found = false;
            block1: for (CompilerSet cs : this.sets) {
                for (String family : cs.getCompilerFlavor().getToolchainDescriptor().getFamily()) {
                    for (String f : flavor.getToolchainDescriptor().getFamily()) {
                        if (!family.equals(f)) continue;
                        found = true;
                        break block1;
                    }
                }
            }
            if (found) continue;
            CompilerSetImpl fake = (CompilerSetImpl)CompilerSetFactory.getCustomCompilerSet(null, flavor, null, this.executionEnvironment);
            fake.setAutoGenerated(true);
            this.addUnsafe(fake);
        }
    }

    public void completeCompilerSets() {
        this.completeCompilerSets(true);
    }

    public void completeCompilerSets(boolean waitReady) {
        if (this.sets.isEmpty()) {
            this.addUnsafe(CompilerSetImpl.createEmptyCompilerSet(6));
        }
        for (CompilerSet cs : this.sets) {
            CompilerSetManagerImpl.completeCompilerSet(this.executionEnvironment, (CompilerSetImpl)cs, this.sets);
        }
        this.completeSunStudioCompilerSet(this.getPlatform());
        this.setDefaltCompilerSet();
        ArrayList<CompilerSet> toSort = new ArrayList<CompilerSet>(this.sets);
        Collections.sort(toSort, new Comparator<CompilerSet>(){

            @Override
            public int compare(CompilerSet o1, CompilerSet o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.sets.clear();
        this.sets.addAll(toSort);
        if (waitReady) {
            this.completeCompilerSetsSettings(false);
        }
    }

    private void completeCompilerSetsSettings(boolean reset) {
        for (CompilerSet cs : this.sets) {
            for (Tool tool : cs.getTools()) {
                if (tool.isReady()) continue;
                tool.waitReady(reset);
            }
        }
    }

    private void completeSunStudioCompilerSet(int platform) {
        HashSet<String> aliases = new HashSet<String>();
        for (CompilerSet cs : this.sets) {
            aliases.addAll(Arrays.asList(cs.getCompilerFlavor().getToolchainDescriptor().getAliases()));
        }
        List<ToolchainManager.ToolchainDescriptor> platfomToolCollections = ToolchainManagerImpl.getImpl().getToolchains(platform);
        for (String alias : aliases) {
            CompilerFlavor flavor;
            if (this.getCompilerSet(alias) != null) continue;
            CompilerSetImpl bestCandidate = null;
            block2: for (ToolchainManager.ToolchainDescriptor tc : platfomToolCollections) {
                if (!Arrays.asList(tc.getAliases()).contains(alias)) continue;
                for (CompilerSet cs : this.sets) {
                    if (!cs.getCompilerFlavor().getToolchainDescriptor().equals(tc)) continue;
                    bestCandidate = (CompilerSetImpl)cs;
                    break block2;
                }
            }
            if (bestCandidate == null || bestCandidate.isUrlPointer() || (flavor = CompilerFlavorImpl.toFlavor(alias, platform)) == null) continue;
            CompilerSetImpl bestCandidateCopy = bestCandidate.createCopy(this.executionEnvironment, flavor, bestCandidate.getDirectory(), alias, flavor.getToolchainDescriptor().getDisplayName(), true, true, bestCandidate.getModifyBuildPath(), bestCandidate.getModifyRunPath());
            this.addUnsafe(bestCandidateCopy);
        }
    }

    private static Tool autoComplete(ExecutionEnvironment env, CompilerSetImpl cs, List<CompilerSet> sets, ToolchainManager.ToolDescriptor descriptor, ToolKind tool) {
        ToolchainManager.AlternativePath[] paths;
        if (descriptor != null && !cs.isUrlPointer() && (paths = descriptor.getAlternativePath()) != null && paths.length > 0) {
            block5: for (ToolchainManager.AlternativePath p : paths) {
                switch (p.getKind()) {
                    case PATH: {
                        String method;
                        StringTokenizer st = new StringTokenizer(p.getPath(), ";,");
                        while (st.hasMoreTokens()) {
                            String path;
                            method = st.nextToken();
                            if ("$PATH".equals(method)) {
                                String name;
                                if (env.isLocal()) {
                                    for (String name2 : descriptor.getNames()) {
                                        path = ToolUtils.findCommand(cs, name2);
                                        if (path == null || !CompilerSetManagerImpl.notSkipedName(cs, descriptor, path, name2)) continue;
                                        return cs.addNewTool(env, CndPathUtilities.getBaseName((String)path), path, tool, null);
                                    }
                                    continue;
                                }
                                String path2 = cs.getPathCandidate(tool);
                                if (path2 == null || !CompilerSetManagerImpl.notSkipedName(cs, descriptor, path2, name = CndPathUtilities.getBaseName((String)path2))) continue;
                                return cs.addNewTool(env, name, path2, tool, null);
                            }
                            if ("$MSYS".equals(method)) {
                                if (!env.isLocal()) continue;
                                for (String name2 : descriptor.getNames()) {
                                    String path3;
                                    String dir = cs.getCommandFolder();
                                    if (dir == null || (path3 = ToolUtils.findCommand(name2, dir)) == null || !CompilerSetManagerImpl.notSkipedName(cs, descriptor, path3, name2)) continue;
                                    return cs.addNewTool(env, CndPathUtilities.getBaseName((String)path3), path3, tool, null);
                                }
                                continue;
                            }
                            if (!env.isLocal()) continue;
                            for (String name2 : descriptor.getNames()) {
                                if (!CndPathUtilities.isAbsolute((CharSequence)method)) {
                                    String directory = cs.getDirectory();
                                    method = CndFileUtils.normalizeAbsolutePath((String)(directory + "/" + method));
                                }
                                if ((path = ToolUtils.findCommand(name2, method)) == null) continue;
                                return cs.addNewTool(env, CndPathUtilities.getBaseName((String)path), path, tool, null);
                            }
                        }
                        continue block5;
                    }
                    case TOOL_FAMILY: {
                        String method;
                        StringTokenizer st = new StringTokenizer(p.getPath(), ";,");
                        while (st.hasMoreTokens()) {
                            method = st.nextToken();
                            for (CompilerSet s : sets) {
                                if (s == cs) continue;
                                for (String family : s.getCompilerFlavor().getToolchainDescriptor().getFamily()) {
                                    Tool other;
                                    if (!family.equals(method) || (other = s.findTool(tool)) == null) continue;
                                    return cs.addNewTool(env, other.getName(), other.getPath(), tool, other.getFlavor());
                                }
                            }
                        }
                        continue block5;
                    }
                    case TOOL_NAME: {
                        String method;
                        StringTokenizer st = new StringTokenizer(p.getPath(), ";,");
                        while (st.hasMoreTokens()) {
                            method = st.nextToken();
                            for (CompilerSet s : sets) {
                                Tool other;
                                String name;
                                if (s == cs || !(name = s.getCompilerFlavor().getToolchainDescriptor().getName()).equals(method) && !"*".equals(method) || (other = s.findTool(tool)) == null) continue;
                                return cs.addNewTool(env, other.getName(), other.getPath(), tool, other.getFlavor());
                            }
                        }
                        continue block5;
                    }
                }
            }
        }
        return cs.addTool(env, "", "", tool, null);
    }

    private static boolean notSkipedName(CompilerSet cs, ToolchainManager.ToolDescriptor descriptor, String path, String name) {
        if (!descriptor.skipSearch()) {
            return true;
        }
        String s = cs.getDirectory() + "/" + name;
        s = s.replace('\\', '/');
        return !(path = path.replace('\\', '/')).startsWith(s);
    }

    static void completeCompilerSet(ExecutionEnvironment env, CompilerSetImpl cs, List<CompilerSet> sets) {
        if (cs.findTool(PredefinedToolKind.CCompiler) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getC(), PredefinedToolKind.CCompiler);
        }
        if (cs.findTool(PredefinedToolKind.CCCompiler) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getCpp(), PredefinedToolKind.CCCompiler);
        }
        if (cs.findTool(PredefinedToolKind.FortranCompiler) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getFortran(), PredefinedToolKind.FortranCompiler);
        }
        if (cs.findTool(PredefinedToolKind.Assembler) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getAssembler(), PredefinedToolKind.Assembler);
        }
        if (cs.findTool(PredefinedToolKind.MakeTool) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getMake(), PredefinedToolKind.MakeTool);
        }
        if (cs.findTool(PredefinedToolKind.DebuggerTool) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getDebugger(), PredefinedToolKind.DebuggerTool);
        }
        if (cs.findTool(PredefinedToolKind.QMakeTool) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getQMake(), PredefinedToolKind.QMakeTool);
        }
        if (cs.findTool(PredefinedToolKind.CMakeTool) == null) {
            CompilerSetManagerImpl.autoComplete(env, cs, sets, cs.getCompilerFlavor().getToolchainDescriptor().getCMake(), PredefinedToolKind.CMakeTool);
        }
    }

    @Override
    public void add(CompilerSet cs) {
        if (this.sets.size() == 1 && this.sets.get(0).getName().equals("None")) {
            this.sets.remove(0);
        }
        this.sets.add(cs);
        if (this.sets.size() == 1) {
            this.setDefault(cs);
        }
        this.completeCompilerSets();
    }

    private void addUnsafe(CompilerSet cs) {
        if (this.sets.size() == 1 && this.sets.get(0).getName().equals("None")) {
            this.sets.remove(0);
        }
        this.sets.add(cs);
    }

    @Override
    public final boolean isEmpty() {
        return this.sets.isEmpty() || this.sets.size() == 1 && this.sets.get(0).getName().equals("None");
    }

    @Override
    public void remove(CompilerSet cs) {
        int idx = this.sets.indexOf(cs);
        if (idx >= 0) {
            this.sets.remove(idx);
        }
    }

    @Override
    public CompilerSet getCompilerSet(String name) {
        for (CompilerSet cs : this.sets) {
            if (!cs.getName().equals(name)) continue;
            return cs;
        }
        return null;
    }

    public CompilerSet getCompilerSet(int idx) {
        if (this.isPending()) {
            log.log(Level.WARNING, "calling getCompilerSet() on uninitialized {0}", this.getClass().getSimpleName());
        }
        if (idx >= 0 && idx < this.sets.size()) {
            return this.sets.get(idx);
        }
        return null;
    }

    @Override
    public List<CompilerSet> getCompilerSets() {
        return new ArrayList<CompilerSet>(this.sets);
    }

    @Override
    public void setDefault(CompilerSet newDefault) {
        boolean set = false;
        for (CompilerSet cs : this.getCompilerSets()) {
            ((CompilerSetImpl)cs).setAsDefault(false);
            if (cs != newDefault) continue;
            ((CompilerSetImpl)newDefault).setAsDefault(true);
            set = true;
        }
        if (!set && this.sets.size() > 0) {
            ((CompilerSetImpl)this.getCompilerSet(0)).setAsDefault(true);
        }
    }

    @Override
    public CompilerSet getDefaultCompilerSet() {
        for (CompilerSet cs : this.getCompilerSets()) {
            if (!((CompilerSetImpl)cs).isDefault()) continue;
            return cs;
        }
        return null;
    }

    @Override
    public boolean isDefaultCompilerSet(CompilerSet cs) {
        if (cs == null) {
            return false;
        }
        return ((CompilerSetImpl)cs).isDefault();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("CSM for ").append(this.executionEnvironment.toString());
        out.append(" with toolchains:[");
        for (CompilerSet compilerSet : this.sets) {
            out.append(compilerSet.getName()).append(" ");
        }
        out.append("]");
        out.append(" platform:").append(PlatformTypes.toString(this.platform));
        out.append(" in state ").append(this.state.toString());
        return out.toString();
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    private static final class FolderDescriptor {
        private final String path;
        private final boolean knownFolder;

        private FolderDescriptor(String path, boolean knownFolder) {
            this.path = path;
            this.knownFolder = knownFolder;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FolderDescriptor) {
                return this.path.equals(((FolderDescriptor)obj).path);
            }
            return false;
        }
    }

    private static enum State {
        STATE_PENDING,
        STATE_COMPLETE,
        STATE_UNINITIALIZED;

    }
}

