/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.util.ArrayList;
import java.util.Hashtable;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Option;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionClient;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;

public abstract class OptionSetSupport
implements OptionSet {
    private Hashtable<String, OptionValue> nameMap = new Hashtable(50);
    private ArrayList<OptionValue> values = new ArrayList();
    protected boolean needSave = false;

    @Override
    public ArrayList<OptionValue> values() {
        return this.values;
    }

    protected OptionSetSupport() {
    }

    protected void setup(Option[] options) {
        for (int ox = 0; ox < options.length; ++ox) {
            Option opt = options[ox];
            OptionValue ov = new OptionValue(this, opt, opt.getDefaultValue());
            this.values.add(ov);
            this.nameMap.put(opt.getName(), ov);
        }
    }

    private void assignHelp(OptionSet that, boolean copying, boolean nonClient) {
        if (this.getClass() != that.getClass()) {
            return;
        }
        ArrayList<OptionValue> these = this.values();
        ArrayList<OptionValue> those = that.values();
        if (these.size() != those.size()) {
            return;
        }
        for (int ox = 0; ox < these.size(); ++ox) {
            OptionValue thisOpt = these.get(ox);
            OptionValue thatOpt = those.get(ox);
            if (thisOpt.type() != thatOpt.type() || nonClient && thisOpt.type().isClientOption()) continue;
            if (copying) {
                thisOpt.setInitialValue(thatOpt.get());
                thisOpt.setDirty(thatOpt.isDirty());
                continue;
            }
            thisOpt.set(thatOpt.get());
        }
    }

    @Override
    public void assign(OptionSet that) {
        this.assignHelp(that, false, false);
    }

    @Override
    public void assignNonClient(OptionSet that) {
        this.assignHelp(that, false, true);
    }

    protected void copy(OptionSet that) {
        this.assignHelp(that, true, false);
    }

    @Override
    public OptionValue byName(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public OptionValue byType(Option type) {
        for (OptionValue o : this.values) {
            if (o.type() != type) continue;
            return o;
        }
        return null;
    }

    @Override
    public boolean isDirty() {
        for (OptionValue o : this.values) {
            if (!o.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearDirty() {
        for (OptionValue o : this.values) {
            o.setDirty(false);
        }
    }

    @Override
    public void applyTo(OptionClient client) {
        if (client == null) {
            return;
        }
        for (OptionValue o : this.values) {
            o.applyTo(client);
        }
    }

    @Override
    public void doneApplying() {
        for (OptionValue o : this.values) {
            o.setDirty(false);
        }
    }

    @Override
    public void markChanges() {
        for (OptionValue o : this.values) {
            o.setDirty(true);
        }
    }

    @Override
    public void deltaWithRespectTo(OptionSet that) {
        if (this.getClass() != that.getClass()) {
            return;
        }
        ArrayList<OptionValue> these = this.values();
        ArrayList<OptionValue> those = that.values();
        if (these.size() != those.size()) {
            return;
        }
        for (int ox = 0; ox < these.size(); ++ox) {
            OptionValue thisOpt = these.get(ox);
            OptionValue thatOpt = those.get(ox);
            if (thisOpt.type() != thatOpt.type()) continue;
            thisOpt.deltaWithRespectTo(thatOpt);
        }
    }

    void needSave() {
        this.needSave = true;
    }

    @Override
    public abstract void save();

    @Override
    public abstract void open();
}

