/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.io;

import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.ConsoleTopComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.ExternalTerminalPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.InternalTerminalPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.OutputPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.PioPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponentFactory;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class IOPack {
    private final TermComponent console;
    protected final ExecutionEnvironment exEnv;
    private final boolean external;
    private static boolean notified = false;

    protected IOPack(TermComponent console, ExecutionEnvironment exEnv, boolean external) {
        this.console = console;
        this.exEnv = exEnv;
        this.external = external;
    }

    public TermComponent console() {
        return this.console;
    }

    public boolean start() {
        return true;
    }

    public void open() {
        this.console.open();
    }

    public void bringDown() {
        this.console.bringDown();
    }

    public void bringUp() {
        this.console.bringUp();
    }

    public void switchTo() {
        this.console.switchTo();
    }

    public static TermComponent makeConsole(int flags) {
        return TermComponentFactory.createNewTermComponent(ConsoleTopComponent.findInstance(), flags);
    }

    public String[] getIOFiles() {
        return null;
    }

    public String getSlaveName() {
        return null;
    }

    public MacroMap updateEnv(MacroMap macroMap) {
        return macroMap;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void close() {
    }

    public static IOPack create(boolean remote, NativeDebuggerInfo ndi, Executor executor) {
        IOPack res;
        int consoleType = ndi.getConsoleType(remote);
        TermComponent console = remote || Utilities.isWindows() ? IOPack.makeConsole(0) : IOPack.makeConsole(12);
        InputOutput io = ndi.getInputOutput();
        ExecutionEnvironment exEnv = executor.getExecutionEnvironment();
        if (ndi.isClone()) {
            res = new IOPack(console, exEnv, false);
        } else if (NativeDebuggerManager.isStandalone()) {
            TermComponent pio = remote || Utilities.isWindows() ? PioPack.makePio(0) : PioPack.makePio(10);
            res = new PioPack(console, pio, exEnv);
        } else if (io == null) {
            res = new IOPack(console, exEnv, false);
        } else if (consoleType == 1) {
            res = !remote && Utilities.isWindows() ? new IOPack(console, exEnv, true) : new ExternalTerminalPack(console, ndi.getProfile().getTerminalPath(), exEnv);
        } else if (consoleType == 2) {
            if (Utilities.isWindows() && !remote) {
                IOPack.notifyAboutConsoleTypeOnce();
                res = new IOPack(console, exEnv, true);
            } else {
                res = new OutputPack(console, io, exEnv);
            }
        } else if (Utilities.isWindows() && !remote && !PtySupport.isSupportedFor((ExecutionEnvironment)exEnv)) {
            IOPack.notifyAboutConsoleTypeOnce();
            res = new IOPack(console, exEnv, true);
        } else {
            res = new InternalTerminalPack(console, io, exEnv);
        }
        res.bringUp();
        res.switchTo();
        return res;
    }

    private static void notifyAboutConsoleTypeOnce() {
        if (!notified) {
            NativeDebuggerManager.warning(Catalog.get("MSG_Console_Type_Unsupported"));
            notified = true;
        }
    }
}

