/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.conifg.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.dlight.sendto.api.ConfigurationPanel;
import org.netbeans.modules.dlight.sendto.api.ConfigurationsRegistry;
import org.netbeans.modules.dlight.sendto.api.OutputMode;
import org.netbeans.modules.dlight.sendto.conifg.ui.OutputConfigurationPanel;
import org.netbeans.modules.dlight.sendto.conifg.ui.ScriptPanel;
import org.openide.util.NbBundle;

public final class DefaultConfigurationPanel
extends ConfigurationPanel {
    private final ScriptPanel scriptPanel;
    private final ScriptPanel validationScriptPanel;
    private final OutputConfigurationPanel outputConfigPanel;

    public DefaultConfigurationPanel() {
        TreeSet<String> executors = new TreeSet<String>();
        for (Configuration configuration : ConfigurationsRegistry.getConfigurations()) {
            executors.add(configuration.get("script_executor"));
            executors.add(configuration.get("validation_script_executor"));
        }
        this.scriptPanel = new ScriptPanel(NbBundle.getMessage(DefaultConfigurationPanel.class, (String)"DefaultConfigurationPanel.scriptPanel.label.text"), NbBundle.getMessage(DefaultConfigurationPanel.class, (String)"DefaultConfigurationPanel.scriptPanel.scriptFld.toolTipText"));
        this.validationScriptPanel = new ScriptPanel(NbBundle.getMessage(DefaultConfigurationPanel.class, (String)"DefaultConfigurationPanel.validationScriptPanel.label.text"), NbBundle.getMessage(DefaultConfigurationPanel.class, (String)"DefaultConfigurationPanel.validationScriptPanel.scriptFld.toolTipText"));
        this.outputConfigPanel = new OutputConfigurationPanel();
        String[] executorsArray = executors.toArray(new String[executors.size()]);
        this.scriptPanel.setExecutors(executorsArray);
        this.validationScriptPanel.setExecutors(executorsArray);
        JPanel scriptsPanel = new JPanel(new GridLayout(2, 1, 0, 7));
        scriptsPanel.add(this.scriptPanel);
        scriptsPanel.add(this.validationScriptPanel);
        this.setLayout(new BorderLayout(0, 7));
        this.add((Component)scriptsPanel, "Center");
        this.outputConfigPanel.setMinimumSize(new Dimension(100, 30));
        this.add((Component)this.outputConfigPanel, "South");
    }

    @Override
    public void updatePanel(Configuration cfg) {
        this.scriptPanel.setScript(cfg.get("script"));
        this.scriptPanel.setExecutor(cfg.get("script_executor"));
        this.validationScriptPanel.setScript(cfg.get("validation_script"));
        this.validationScriptPanel.setExecutor(cfg.get("validation_script_executor"));
        OutputMode mode = OutputMode.parse(cfg.get("output_type"));
        this.outputConfigPanel.setOutputMode(mode);
    }

    @Override
    public void updateConfig(Configuration cfg) {
        cfg.set("script", this.scriptPanel.getScript());
        cfg.set("script_executor", this.scriptPanel.getExecutor());
        cfg.set("validation_script", this.validationScriptPanel.getScript());
        cfg.set("validation_script_executor", this.validationScriptPanel.getExecutor());
        cfg.set("output_type", this.outputConfigPanel.getOutputMode().name());
    }
}

