/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.regex.Pattern;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.utils.MIMENames;

public class CodeAssistanceConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private BooleanConfiguration buildAnalyzer;
    private BooleanConfiguration resolveSymbolicLinks;
    private VectorConfiguration<String> transientMacros;
    private VectorConfiguration<String> environmentVariables;
    private StringConfiguration tools;
    private BooleanConfiguration includeInCA;
    private StringConfiguration excludeInCA;
    public static final String DEFAULT_TOOLS = "gcc:c++:g++:clang:clang++:icc:icpc:ifort:gfortran:g77:g90:g95:cc:CC:ffortran:f77:f90:f95:ar:ld";
    private Pattern lastIgnorePattern = null;

    public CodeAssistanceConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildAnalyzer = new BooleanConfiguration(true);
        this.resolveSymbolicLinks = new BooleanConfiguration(false);
        this.tools = new StringConfiguration(null, DEFAULT_TOOLS);
        this.transientMacros = new VectorConfiguration(null);
        this.environmentVariables = new VectorConfiguration(null);
        this.includeInCA = new BooleanConfiguration(false);
        this.excludeInCA = new StringConfiguration(null, "");
    }

    public boolean getModified() {
        return this.getBuildAnalyzer().getModified() || this.getResolveSymbolicLinks().getModified() || this.getTools().getModified() || this.getEnvironmentVariables().getModified() || this.getTransientMacros().getModified() || this.getIncludeInCA().getModified() || this.getExcludeInCA().getModified();
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setBuildAnalyzer(BooleanConfiguration buildAnalyzer) {
        this.buildAnalyzer = buildAnalyzer;
    }

    public BooleanConfiguration getBuildAnalyzer() {
        return this.buildAnalyzer;
    }

    public void setResolveSymbolicLinks(BooleanConfiguration resolveSymbolicLinks) {
        this.resolveSymbolicLinks = resolveSymbolicLinks;
    }

    public BooleanConfiguration getResolveSymbolicLinks() {
        return this.resolveSymbolicLinks;
    }

    public void setTools(StringConfiguration tools) {
        this.tools = tools;
    }

    public StringConfiguration getTools() {
        return this.tools;
    }

    public VectorConfiguration<String> getTransientMacros() {
        return this.transientMacros;
    }

    public void setTransientMacros(VectorConfiguration<String> transientMacros) {
        this.transientMacros = transientMacros;
    }

    public VectorConfiguration<String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(VectorConfiguration<String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public BooleanConfiguration getIncludeInCA() {
        return this.includeInCA;
    }

    public void setIncludeInCA(BooleanConfiguration includeInCA) {
        this.includeInCA = includeInCA;
    }

    public StringConfiguration getExcludeInCA() {
        return this.excludeInCA;
    }

    public void setExcludeInCA(StringConfiguration excludeInCA) {
        this.excludeInCA = excludeInCA;
    }

    public void assign(CodeAssistanceConfiguration conf) {
        this.getBuildAnalyzer().assign(conf.getBuildAnalyzer());
        this.getResolveSymbolicLinks().assign(conf.getResolveSymbolicLinks());
        this.getTools().assign(conf.getTools());
        this.getTransientMacros().assign(conf.getTransientMacros());
        this.getEnvironmentVariables().assign(conf.getEnvironmentVariables());
        this.getIncludeInCA().assign(conf.getIncludeInCA());
        this.getExcludeInCA().assign(conf.getExcludeInCA());
    }

    public CodeAssistanceConfiguration clone() {
        CodeAssistanceConfiguration clone = new CodeAssistanceConfiguration(this.getMakeConfiguration());
        clone.setBuildAnalyzer(this.getBuildAnalyzer().clone());
        clone.setResolveSymbolicLinks(this.getResolveSymbolicLinks().clone());
        clone.setTools(this.getTools().clone());
        clone.setTransientMacros((VectorConfiguration<String>)this.getTransientMacros().clone());
        clone.setEnvironmentVariables((VectorConfiguration<String>)this.getEnvironmentVariables().clone());
        clone.setIncludeInCA(this.getIncludeInCA().clone());
        clone.setExcludeInCA(this.getExcludeInCA().clone());
        return clone;
    }

    public String toString() {
        return "{buildAnalyzer=" + this.buildAnalyzer + " tools=" + this.tools + '}';
    }

    boolean includeInCA(Item item) {
        boolean add = this.getIncludeInCA().getValue();
        if (add && MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) {
            return !this.excludeInCA(item);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean excludeInCA(Item item) {
        Pattern ignorePattern;
        String ignore = this.getExcludeInCA().getValue();
        if (ignore.isEmpty()) {
            return false;
        }
        CodeAssistanceConfiguration codeAssistanceConfiguration = this;
        synchronized (codeAssistanceConfiguration) {
            if (this.lastIgnorePattern != null && !this.lastIgnorePattern.pattern().equals(ignore)) {
                this.lastIgnorePattern = null;
            }
            if (this.lastIgnorePattern == null) {
                try {
                    this.lastIgnorePattern = Pattern.compile(ignore);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ignorePattern = this.lastIgnorePattern;
        }
        if (ignorePattern != null) {
            return ignorePattern.matcher(item.getAbsolutePath()).find();
        }
        return false;
    }
}

