/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.guitracker;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Stack;
import org.netbeans.modules.performance.guitracker.ActionTracker;

public class LoggingEventQueue
extends EventQueue {
    private static Method popMethod = null;
    private ActionTracker tr;
    private EventQueue orig = null;

    public LoggingEventQueue(ActionTracker tr) {
        this.tr = tr;
    }

    @Override
    public void postEvent(AWTEvent e) {
        this.tr.add(e);
        super.postEvent(e);
    }

    public boolean isEnabled() {
        return this.orig != null;
    }

    public void setEnabled(boolean val) {
        if (this.isEnabled() != val) {
            if (val) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    private void enable() {
        if (!this.isEnabled()) {
            this.orig = Toolkit.getDefaultToolkit().getSystemEventQueue();
            this.orig.push(this);
            System.err.println("Installed logging event queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable() {
        try {
            if (this.isEnabled()) {
                Stack<EventQueue> stack = new Stack<EventQueue>();
                EventQueue curr = Toolkit.getDefaultToolkit().getSystemEventQueue();
                while (curr != this) {
                    curr = this.popQ();
                    if (curr == this) continue;
                    stack.push(curr);
                }
                this.pop();
                curr = this.orig;
                assert (Toolkit.getDefaultToolkit().getSystemEventQueue() == this.orig);
                while (!stack.isEmpty()) {
                    EventQueue next = (EventQueue)stack.pop();
                    curr.push(next);
                    curr = next;
                }
                System.err.println("Uninstalled logging event queue");
            }
        }
        finally {
            this.orig = null;
        }
    }

    @Override
    public synchronized void push(EventQueue newEventQueue) {
    }

    private EventQueue popQ() {
        try {
            if (popMethod == null) {
                throw new IllegalStateException("Can't access EventQueue.pop");
            }
            EventQueue result = Toolkit.getDefaultToolkit().getSystemEventQueue();
            popMethod.invoke((Object)result, new Object[0]);
            return result;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Can't invoke EventQueue.pop");
        }
    }

    static {
        try {
            popMethod = EventQueue.class.getDeclaredMethod("pop", null);
            popMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

