/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class OSGiSourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    private final SuiteProject suite;

    public OSGiSourceForBinaryImpl(SuiteProject suite) {
        this.suite = suite;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        Matcher m = Pattern.compile("jar:file:.+/build/osgi/([^/-]+)-[^/]+[.]jar!/").matcher(binaryRoot.toString());
        if (m.matches()) {
            return new R(m.group(1));
        }
        return null;
    }

    private class R
    implements SourceForBinaryQuery.Result {
        private final String cnb;

        public R(String cnb) {
            this.cnb = cnb;
        }

        public FileObject[] getRoots() {
            for (Project module : ((SubprojectProvider)OSGiSourceForBinaryImpl.this.suite.getLookup().lookup(SubprojectProvider.class)).getSubprojects()) {
                FileObject[] fileObjectArray;
                NbModuleProject nbm = (NbModuleProject)module;
                if (!nbm.getCodeNameBase().equals(this.cnb)) continue;
                FileObject src = nbm.getSourceDirectory();
                if (src != null) {
                    FileObject[] fileObjectArray2 = new FileObject[1];
                    fileObjectArray = fileObjectArray2;
                    fileObjectArray2[0] = src;
                } else {
                    fileObjectArray = new FileObject[]{};
                }
                return fileObjectArray;
            }
            try {
                FileObject srcFO;
                File src;
                ModuleEntry entry = ModuleList.findOrCreateModuleListFromSuite(OSGiSourceForBinaryImpl.this.suite.getProjectDirectoryFile(), null).getEntry(this.cnb);
                if (entry != null && (src = entry.getSourceLocation()) != null && (srcFO = FileUtil.toFileObject((File)new File(src, "src"))) != null) {
                    return new FileObject[]{srcFO};
                }
            }
            catch (IOException x) {
                Logger.getLogger(OSGiSourceForBinaryImpl.class.getName()).log(Level.INFO, null, x);
            }
            return new FileObject[0];
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

