/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;

public class ContextUtil {
    private ContextUtil() {
    }

    public static String getContextName(CsmScopeElement element) {
        CsmScope scope = element.getScope();
        if (CsmKindUtilities.isClass((CsmObject)scope)) {
            CsmClass cls = (CsmClass)scope;
            CsmNamespace ns = ContextUtil.getClassNamespace(cls);
            return ns.getQualifiedName().toString();
        }
        if (CsmKindUtilities.isNamespace((Object)scope)) {
            return ((CsmNamespace)scope).getQualifiedName().toString();
        }
        if (CsmKindUtilities.isFile((CsmObject)scope)) {
            return ((CsmFile)scope).getName().toString();
        }
        return "";
    }

    public static CsmNamespace getClassNamespace(CsmClass cls) {
        CsmScope scope = cls.getScope();
        while (scope != null && CsmKindUtilities.isClass((CsmObject)scope)) {
            CsmClass outer = (CsmClass)scope;
            scope = outer.getScope();
        }
        return CsmKindUtilities.isNamespace((Object)scope) ? (CsmNamespace)scope : null;
    }

    public static String getClassFullName(CsmClass cls) {
        StringBuilder sb = new StringBuilder(cls.getName());
        CsmScope scope = cls.getScope();
        while (scope != null && CsmKindUtilities.isClass((CsmObject)scope)) {
            CsmClass outer = (CsmClass)scope;
            sb.insert(0, "::");
            sb.insert(0, outer.getName());
            scope = outer.getScope();
        }
        return sb.toString();
    }
}

