/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public class ExpressionBase
extends OffsetableBase
implements CsmExpression {
    private static final List<CsmStatement> NOT_EMPTY = Collections.unmodifiableList(new ArrayList(0));
    private List<CsmExpression> operands;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private List<CsmStatement> lambdas;

    ExpressionBase(AST ast, CsmFile file, CsmScope scope) {
        super(file, ExpressionBase.getStartOffset(ast), ExpressionBase.getEndOffset(ast));
        if (scope != null) {
            this.setScope(scope);
        }
    }

    ExpressionBase(int startOffset, int endOffset, CsmFile file, CsmScope scope) {
        super(file, startOffset, endOffset);
        if (scope != null) {
            this.setScope(scope);
        }
    }

    public CsmExpression.Kind getKind() {
        return null;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public List<CsmStatement> getLambdas() {
        if (this.lambdas == NOT_EMPTY) {
            this.createLambdas();
        }
        if (this.lambdas == null) {
            return Collections.emptyList();
        }
        return this.lambdas;
    }

    public CharSequence getExpandedText() {
        return this.getText();
    }

    public void setLambdas(List<CsmStatement> lambdas) {
        this.lambdas = lambdas;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.lambdas != null) {
            Utils.disposeAll(this.lambdas);
        }
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (scope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return scope;
    }

    protected void setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null);
        } else {
            this.scopeRef = scope;
        }
    }

    public List<CsmExpression> getOperands() {
        if (this.operands == null) {
            this.operands = new ArrayList<CsmExpression>(0);
        }
        return Collections.unmodifiableList(this.operands);
    }

    public CsmExpression getParent() {
        return null;
    }

    private synchronized void createLambdas() {
        CndUtils.assertTrueInConsole((!SwingUtilities.isEventDispatchThread() || CndUtils.isCodeCompletionUnitTestMode() ? 1 : 0) != 0, (String)"Calling Parser in UI Thread");
        if (this.lambdas == NOT_EMPTY) {
            this.lambdas = null;
            ArrayList<CsmStatement> list = new ArrayList<CsmStatement>();
            if (this.renderLambdas(list)) {
                this.lambdas = list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renderLambdas(List<CsmStatement> list) {
        boolean bl;
        block7: {
            int endOffset;
            int startOffset;
            if (!(this.getContainingFile() instanceof FileImpl)) {
                return false;
            }
            FileImpl file = (FileImpl)this.getContainingFile();
            TokenStream stream = file.getTokenStream(startOffset = this.getStartOffset(), (endOffset = this.getEndOffset()) > startOffset ? endOffset - 1 : endOffset, 0, true);
            if (stream == null) {
                int[] lineColumn = file.getLineColumn(startOffset);
                Utils.LOG.log(Level.SEVERE, "Can''t create lambdas: can''t create token stream for file {0} at {1}:{2}", new Object[]{file.getAbsolutePath(), lineColumn[0], lineColumn[1]});
                return false;
            }
            FileContent tmpFileContent = null;
            try {
                CsmParserProvider.CsmParserResult result;
                FileImpl fileImpl;
                if (TraceFlags.PARSE_HEADERS_WITH_SOURCES && (fileImpl = (FileImpl)this.getContainingFile()).getParsingFileContent() == null) {
                    tmpFileContent = CsmCorePackageAccessor.get().prepareLazyStatementParsingContent(fileImpl);
                }
                if ((result = this.resolveLazyLambdas(stream)) != null) {
                    result.render(list);
                }
                bl = true;
                if (tmpFileContent == null) break block7;
            }
            catch (Throwable throwable) {
                if (tmpFileContent != null) {
                    FileImpl fileImpl = (FileImpl)this.getContainingFile();
                    CsmCorePackageAccessor.get().releaseLazyStatementParsingContent(fileImpl, tmpFileContent);
                }
                throw throwable;
            }
            FileImpl fileImpl = (FileImpl)this.getContainingFile();
            CsmCorePackageAccessor.get().releaseLazyStatementParsingContent(fileImpl, tmpFileContent);
        }
        return bl;
    }

    private CsmParserProvider.CsmParserResult resolveLazyLambdas(TokenStream tokenStream) {
        CsmParserProvider.CsmParser parser = CsmParserProvider.createParser(this.getContainingFile());
        if (parser != null) {
            parser.init((CsmObject)this, tokenStream, null);
            return parser.parse(CsmParserProvider.CsmParser.ConstructionKind.INITIALIZER);
        }
        assert (false) : "parser not found";
        return null;
    }

    public void renderStatements(AST ast, List<CsmStatement> list, Map<Integer, CsmObject> objects) {
        while (ast != null) {
            StatementBase stmt = AstRenderer.renderStatement(ast, this.getContainingFile(), this.getScope(), objects);
            if (stmt != null) {
                list.add(stmt);
            }
            ast = ast.getNextSibling();
        }
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeExpressions(this.operands, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
        output.writeBoolean(this.lambdas == NOT_EMPTY || this.lambdas != null && !this.lambdas.isEmpty());
    }

    public ExpressionBase(RepositoryDataInput input) throws IOException {
        super(input);
        this.operands = PersistentUtils.readExpressions(new ArrayList(0), input);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        boolean hadLambdas = input.readBoolean();
        this.lambdas = hadLambdas ? NOT_EMPTY : null;
    }

    public static class ExpressionBuilder
    extends OffsetableDeclarationBase.ScopedDeclarationBuilder {
        private int level = 0;

        public void enterExpression() {
            ++this.level;
        }

        public void leaveExpression() {
            --this.level;
        }

        public boolean isTopExpression() {
            return this.level == 0;
        }

        public ExpressionBase create() {
            ExpressionBase expr = new ExpressionBase(this.getStartOffset(), this.getEndOffset(), this.getFile(), this.getScope());
            return expr;
        }
    }

    public static interface ExpressionBuilderContainer {
        public void addExpressionBuilder(ExpressionBuilder var1);
    }
}

