/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.Utilities;

class CamelCaseOperations {
    CamelCaseOperations() {
    }

    static int nextCamelCasePosition(final JTextComponent textComponent, final boolean skipEOL) throws BadLocationException {
        final int offset = textComponent.getCaretPosition();
        final Document doc = textComponent.getDocument();
        final Object[] out = new Object[]{offset, null};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    out[0] = CamelCaseOperations.nextCamelCasePositionImpl(doc, offset, skipEOL, textComponent);
                }
                catch (BadLocationException ex) {
                    out[1] = ex;
                }
            }
        };
        doc.render(r);
        if (out[1] != null) {
            throw (BadLocationException)out[1];
        }
        return (Integer)out[0];
    }

    private static int nextCamelCasePositionImpl(Document doc, int offset, boolean skipEOL, JTextComponent textComponent) throws BadLocationException {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)false);
        if (ts != null) {
            Token token = ts.token();
            String category = token.id().primaryCategory();
            if ("identifier".equals(category) || "preprocessor-user-include-literal".equals(category) || "preprocessor-system-include-literal".equals(category)) {
                CharSequence image = token.text();
                if (image != null && image.length() > 0) {
                    char charAtI;
                    int i;
                    int length = image.length();
                    int offsetInImage = offset - ts.offset();
                    int start = offsetInImage + 1;
                    char charAt = image.charAt(offsetInImage);
                    if (charAt == '_') {
                        for (i = start; i < length && (charAtI = image.charAt(i)) == '_'; ++i) {
                            ++start;
                        }
                    } else if (Character.isUpperCase(charAt)) {
                        for (i = start; i < length && Character.isUpperCase(charAtI = image.charAt(i)); ++i) {
                            ++start;
                        }
                    }
                    for (i = start; i < length; ++i) {
                        charAtI = image.charAt(i);
                        if (!Character.isUpperCase(charAtI) && charAtI != '_') continue;
                        return ts.offset() + i;
                    }
                    return ts.offset() + length;
                }
            } else if ("whitespace".equals(token.id().primaryCategory())) {
                int endWS;
                do {
                    endWS = ts.offset() + ts.token().length();
                } while ((skipEOL || ts.token().id() != CppTokenId.NEW_LINE) && ts.moveNext() && "whitespace".equals(ts.token().id().primaryCategory()));
                return endWS;
            }
        }
        return Utilities.getNextWord((JTextComponent)textComponent, (int)offset);
    }

    static int previousCamelCasePosition(final JTextComponent textComponent) throws BadLocationException {
        final int offset = textComponent.getCaretPosition();
        if (offset == 0) {
            return 0;
        }
        Document doc = textComponent.getDocument();
        final Object[] out = new Object[]{offset, null};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    out[0] = CamelCaseOperations.previousCamelCasePositionImpl(textComponent, offset);
                }
                catch (BadLocationException ex) {
                    out[1] = ex;
                }
            }
        };
        doc.render(r);
        if (out[1] != null) {
            throw (BadLocationException)out[1];
        }
        return (Integer)out[0];
    }

    private static int previousCamelCasePositionImpl(JTextComponent textComponent, int offset) throws BadLocationException {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)textComponent, (int)offset, (boolean)true, (boolean)true);
        if (ts != null) {
            Token token = ts.token();
            String category = token.id().primaryCategory();
            if ("identifier".equals(category) || "preprocessor-user-include-literal".equals(category) || "preprocessor-system-include-literal".equals(category)) {
                CharSequence image = token.text();
                if (image != null && image.length() > 0) {
                    char charAt;
                    int upperCaseOffset;
                    int offsetInImage = offset - 1 - ts.offset();
                    for (upperCaseOffset = offsetInImage - 1; upperCaseOffset > 0 && !Character.isUpperCase(charAt = image.charAt(upperCaseOffset)) && charAt != '_'; --upperCaseOffset) {
                    }
                    if (upperCaseOffset > 0) {
                        charAt = image.charAt(upperCaseOffset);
                        if (charAt == '_') {
                            for (int i = upperCaseOffset - 1; i >= 0; --i) {
                                char charAtI = image.charAt(i);
                                if (charAtI == '_') continue;
                                return ts.offset() + i + 1;
                            }
                        } else if (Character.isUpperCase(charAt)) {
                            for (int i = upperCaseOffset - 1; i >= 0; --i) {
                                char charAtI = image.charAt(i);
                                if (Character.isUpperCase(charAtI)) continue;
                                return ts.offset() + i + 1;
                            }
                        }
                    }
                    return ts.offset();
                }
            } else if ("whitespace".equals(token.id().primaryCategory())) {
                int wsOffset = ts.offset();
                while (ts.movePrevious() && "whitespace".equals(ts.token().id().primaryCategory())) {
                    wsOffset = ts.offset();
                    if (wsOffset != 0) continue;
                    return 0;
                }
                return wsOffset;
            }
        }
        return Utilities.getPreviousWord((JTextComponent)textComponent, (int)offset);
    }
}

