/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.tools.doclint.HtmlTag;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.ListIterator;

public class DocTreeMaker {
    protected static final Context.Key<DocTreeMaker> treeMakerKey = new Context.Key();
    final EnumSet<HtmlTag> sentenceBreakTags;
    public int pos = -1;
    private final JCDiagnostic.Factory diags;
    private final JavacTrees trees;

    public static DocTreeMaker instance(Context context) {
        DocTreeMaker instance = context.get(treeMakerKey);
        if (instance == null) {
            instance = new DocTreeMaker(context);
        }
        return instance;
    }

    protected DocTreeMaker(Context context) {
        context.put(treeMakerKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.pos = -1;
        this.trees = JavacTrees.instance(context);
        this.sentenceBreakTags = EnumSet.of(HtmlTag.H1, new HtmlTag[]{HtmlTag.H2, HtmlTag.H3, HtmlTag.H4, HtmlTag.H5, HtmlTag.H6, HtmlTag.PRE, HtmlTag.P});
    }

    public DocTreeMaker at(int pos) {
        this.pos = pos;
        return this;
    }

    public DocTreeMaker at(JCDiagnostic.DiagnosticPosition pos) {
        this.pos = pos == null ? -1 : pos.getStartPosition();
        return this;
    }

    public DCTree.DCAttribute Attribute(Name name, AttributeTree.ValueKind vkind, List<DCTree> value) {
        DCTree.DCAttribute tree = new DCTree.DCAttribute(name, vkind, value);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCAuthor Author(List<DCTree> name) {
        DCTree.DCAuthor tree = new DCTree.DCAuthor(name);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCLiteral Code(DCTree.DCText text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.CODE, text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCComment Comment(String text) {
        DCTree.DCComment tree = new DCTree.DCComment(text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCDeprecated Deprecated(List<DCTree> text) {
        DCTree.DCDeprecated tree = new DCTree.DCDeprecated(text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCDocComment DocComment(Tokens.Comment comment, List<DCTree> fullBody, List<DCTree> tags) {
        Pair<List<DCTree>, List<DCTree>> pair = this.splitBody(fullBody);
        DCTree.DCDocComment tree = new DCTree.DCDocComment(comment, fullBody, (List)pair.fst, (List)pair.snd, tags);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCDocComment DocComment(List<DCTree> firstSentence, List<DCTree> body, List<DCTree> tags) {
        ListBuffer<DCTree> lb = new ListBuffer<DCTree>();
        lb.addAll((Collection<DCTree>)firstSentence);
        lb.addAll((Collection<DCTree>)body);
        List<DCTree> fullBody = lb.toList();
        DCTree.DCDocComment tree = new DCTree.DCDocComment(null, fullBody, firstSentence, body, tags);
        return tree;
    }

    public DCTree.DCDocRoot DocRoot() {
        DCTree.DCDocRoot tree = new DCTree.DCDocRoot();
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCEndElement EndElement(Name name) {
        DCTree.DCEndElement tree = new DCTree.DCEndElement(name);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCEntity Entity(Name name) {
        DCTree.DCEntity tree = new DCTree.DCEntity(name);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCErroneous Erroneous(String text, DiagnosticSource diagSource, String code, Object ... args) {
        DCTree.DCErroneous tree = new DCTree.DCErroneous(text, this.diags, diagSource, code, args);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCThrows Exception(DCTree.DCReference name, List<DCTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.EXCEPTION, name, description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCIdentifier Identifier(Name name) {
        DCTree.DCIdentifier tree = new DCTree.DCIdentifier(name);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCInheritDoc InheritDoc() {
        DCTree.DCInheritDoc tree = new DCTree.DCInheritDoc();
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCLink Link(DCTree.DCReference ref, List<DCTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK, ref, label);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCLink LinkPlain(DCTree.DCReference ref, List<DCTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK_PLAIN, ref, label);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCLiteral Literal(DCTree.DCText text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.LITERAL, text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCParam Param(boolean isTypeParameter, DCTree.DCIdentifier name, List<DCTree> description) {
        DCTree.DCParam tree = new DCTree.DCParam(isTypeParameter, name, description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCReference Reference(String signature, JCTree qualExpr, Name member, List<JCTree> paramTypes) {
        DCTree.DCReference tree = new DCTree.DCReference(signature, qualExpr, member, paramTypes);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCReturn Return(List<DCTree> description) {
        DCTree.DCReturn tree = new DCTree.DCReturn(description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCSee See(List<DCTree> reference) {
        DCTree.DCSee tree = new DCTree.DCSee(reference);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCSerial Serial(List<DCTree> description) {
        DCTree.DCSerial tree = new DCTree.DCSerial(description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCSerialData SerialData(List<DCTree> description) {
        DCTree.DCSerialData tree = new DCTree.DCSerialData(description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCSerialField SerialField(DCTree.DCIdentifier name, DCTree.DCReference type, List<DCTree> description) {
        DCTree.DCSerialField tree = new DCTree.DCSerialField(name, type, description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCSince Since(List<DCTree> text) {
        DCTree.DCSince tree = new DCTree.DCSince(text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCStartElement StartElement(Name name, List<DCTree> attrs, boolean selfClosing) {
        DCTree.DCStartElement tree = new DCTree.DCStartElement(name, attrs, selfClosing);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCText Text(String text) {
        DCTree.DCText tree = new DCTree.DCText(text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCThrows Throws(DCTree.DCReference name, List<DCTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.THROWS, name, description);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCUnknownBlockTag UnknownBlockTag(Name name, List<DCTree> content) {
        DCTree.DCUnknownBlockTag tree = new DCTree.DCUnknownBlockTag(name, content);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCUnknownInlineTag UnknownInlineTag(Name name, List<DCTree> content) {
        DCTree.DCUnknownInlineTag tree = new DCTree.DCUnknownInlineTag(name, content);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCValue Value(DCTree.DCReference ref) {
        DCTree.DCValue tree = new DCTree.DCValue(ref);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCVersion Version(List<DCTree> text) {
        DCTree.DCVersion tree = new DCTree.DCVersion(text);
        tree.pos = this.pos;
        return tree;
    }

    public java.util.List<DocTree> getFirstSentence(java.util.List<? extends DocTree> list) {
        Pair<List<DCTree>, List<DCTree>> pair = this.splitBody(list);
        return new ArrayList<DocTree>((Collection)pair.fst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<List<DCTree>, List<DCTree>> splitBody(Collection<? extends DocTree> list) {
        int savedpos = this.pos;
        try {
            ListBuffer<DCTree> body = new ListBuffer<DCTree>();
            ListBuffer<DCTree> fs = new ListBuffer<DCTree>();
            if (list.isEmpty()) {
                Pair<List<DCTree>, List<DCTree>> pair = new Pair<List<DCTree>, List<DCTree>>(fs.toList(), body.toList());
                return pair;
            }
            boolean foundFirstSentence = false;
            ArrayList<? extends DocTree> alist = new ArrayList<DocTree>(list);
            ListIterator<? extends DocTree> itr = alist.listIterator();
            block7: while (itr.hasNext()) {
                boolean isFirst = !itr.hasPrevious();
                DocTree dt = itr.next();
                int spos = ((DCTree)dt).pos;
                if (foundFirstSentence) {
                    body.add((DCTree)dt);
                    continue;
                }
                switch (dt.getKind()) {
                    case TEXT: {
                        boolean sbrk;
                        DCTree.DCText tt = (DCTree.DCText)dt;
                        String s = tt.getBody();
                        DocTree peekedNext = itr.hasNext() ? alist.get(itr.nextIndex()) : null;
                        int sbreak = this.getSentenceBreak(s, peekedNext);
                        if (sbreak > 0) {
                            s = this.removeTrailingWhitespace(s.substring(0, sbreak));
                            DCTree.DCText text = this.at(spos).Text(s);
                            fs.add(text);
                            foundFirstSentence = true;
                            int nwPos = this.skipWhiteSpace(tt.getBody(), sbreak);
                            if (nwPos <= 0) continue block7;
                            DCTree.DCText text2 = this.at(spos + nwPos).Text(tt.getBody().substring(nwPos));
                            body.add(text2);
                            continue block7;
                        }
                        if (!itr.hasNext() || !(sbrk = this.isSentenceBreak(peekedNext = alist.get(itr.nextIndex()), false))) break;
                        DocTree next = itr.next();
                        s = this.removeTrailingWhitespace(s);
                        DCTree.DCText text = this.at(spos).Text(s);
                        fs.add(text);
                        body.add((DCTree)next);
                        foundFirstSentence = true;
                        continue block7;
                    }
                    default: {
                        if (!this.isSentenceBreak(dt, isFirst)) break;
                        body.add((DCTree)dt);
                        foundFirstSentence = true;
                        continue block7;
                    }
                }
                fs.add((DCTree)dt);
            }
            Pair<List<DCTree>, List<DCTree>> pair = new Pair<List<DCTree>, List<DCTree>>(fs.toList(), body.toList());
            return pair;
        }
        finally {
            this.pos = savedpos;
        }
    }

    private boolean isTextTree(DocTree tree) {
        return tree.getKind() == DocTree.Kind.TEXT;
    }

    int defaultSentenceBreak(String s) {
        int period = -1;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '.': {
                    period = i;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (period < 0) continue block4;
                    return i;
                }
                default: {
                    period = -1;
                }
            }
        }
        return -1;
    }

    int getSentenceBreak(String s, DocTree dt) {
        BreakIterator breakIterator = this.trees.getBreakIterator();
        if (breakIterator == null) {
            return this.defaultSentenceBreak(s);
        }
        breakIterator.setText(s);
        int sbrk = breakIterator.next();
        if (dt == null) {
            return sbrk;
        }
        if (sbrk < s.length() - 1) {
            return sbrk;
        }
        if (this.isTextTree(dt)) {
            TextTree ttnext = (TextTree)dt;
            String combined = s + ttnext.getBody();
            breakIterator.setText(combined);
            int sbrk2 = breakIterator.next();
            if (sbrk < sbrk2) {
                return sbrk;
            }
        }
        if (this.isSentenceBreak(dt, false)) {
            return sbrk;
        }
        String combined = s + "Dummy Sentence.";
        breakIterator.setText(combined);
        int sbrk2 = breakIterator.next();
        if (sbrk2 <= sbrk) {
            return sbrk2;
        }
        return -1;
    }

    boolean isSentenceBreak(javax.lang.model.element.Name tagName) {
        return this.sentenceBreakTags.contains((Object)HtmlTag.get(tagName));
    }

    boolean isSentenceBreak(DocTree dt, boolean isFirstDocTree) {
        switch (dt.getKind()) {
            case START_ELEMENT: {
                StartElementTree set = (StartElementTree)dt;
                return !isFirstDocTree && ((DCTree)dt).pos > 1 && this.isSentenceBreak(set.getName());
            }
            case END_ELEMENT: {
                EndElementTree eet = (EndElementTree)dt;
                return !isFirstDocTree && ((DCTree)dt).pos > 1 && this.isSentenceBreak(eet.getName());
            }
        }
        return false;
    }

    int skipWhiteSpace(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    String removeTrailingWhitespace(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return s.substring(0, i + 1);
        }
        return s;
    }
}

