/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.AnimationAction;
import custom.AnimationControl;
import custom.CustomAnimator;
import custom.SceneAnimationController;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import lts.Animator;
import lts.Relation;
import uk.ac.ic.doc.scenebeans.animation.Animation;
import uk.ac.ic.doc.scenebeans.animation.AnimationCanvas;
import uk.ac.ic.doc.scenebeans.animation.CommandException;
import uk.ac.ic.doc.scenebeans.animation.parse.XMLAnimationParser;
import uk.ac.ic.doc.scenebeans.input.MouseDispatcher;

public class SceneAnimator
extends CustomAnimator
implements AnimationControl {
    SceneAnimationController tac;
    MenuBar mb;
    Menu run;
    MenuItem pause;
    MenuItem resume;
    Menu trace;
    CheckboxMenuItem setTrace;
    CheckboxMenuItem setDebug;
    Scrollbar bar;
    Animator animator;
    Relation buttonControls;
    AnimationCanvas _canvas;
    MouseDispatcher _dispatcher;

    public SceneAnimator() {
        this.setTitle("SceneBean Animator");
        this.addWindowListener(new MyWindow());
        this.setLayout(new BorderLayout());
        this._canvas = new AnimationCanvas();
        this._canvas.setBackground(Color.white);
        this._canvas.setAnimationStretched(true);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._canvas.setRenderingHints(renderingHints);
        this._canvas.setFont(new Font("SansSerif", 1, 14));
        this.add("Center", this._canvas);
        this.bar = new Scrollbar(1, 25, 1, 1, 32);
        this._canvas.setFrameDelay(40L);
        this.add("East", this.bar);
        this.bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SceneAnimator.this._canvas.setTimeWarp((double)(33 - adjustmentEvent.getValue()) * 0.125);
            }
        });
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        this.run = new Menu("Run");
        menuBar.add(this.run);
        this.pause = new MenuItem("Pause");
        this.run.add(this.pause);
        this.resume = new MenuItem("Resume");
        this.run.add(this.resume);
        this.pause.setEnabled(true);
        this.resume.setEnabled(false);
        RunMenu runMenu = new RunMenu();
        this.pause.addActionListener(runMenu);
        this.resume.addActionListener(runMenu);
        this.trace = new Menu("Trace");
        menuBar.add(this.trace);
        this.setTrace = new CheckboxMenuItem("Trace");
        this.trace.add(this.setTrace);
        this.setTrace.setState(false);
        this.setDebug = new CheckboxMenuItem("Debug");
        this.trace.add(this.setDebug);
        this.setDebug.setState(false);
        CheckItem checkItem = new CheckItem();
        this.setDebug.addItemListener(checkItem);
        this.setTrace.addItemListener(checkItem);
        this._dispatcher = new MouseDispatcher(this._canvas.getSceneGraph(), this._canvas);
        this._dispatcher.attachTo(this._canvas);
    }

    public void init(Animator animator, File file, Relation relation, Relation relation2, boolean bl) {
        if (bl) {
            this.setTitle("Custom Animator - Replay Mode");
        }
        this.setTrace.setState(bl);
        this.animator = animator;
        if (relation == null || relation2 == null) {
            this.animator.message("Animator - must have 'controls' and 'actions'");
            this.dispose();
            return;
        }
        try {
            Object object;
            XMLAnimationParser xMLAnimationParser = new XMLAnimationParser(file, (Component)this._canvas);
            Animation animation = xMLAnimationParser.parseAnimation();
            this._canvas.setAnimation(animation);
            this.buttonControls = relation2.inverse();
            Iterator iterator = animation.getEventNames().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.buttonControls.remove(object);
            }
            object = new Relation();
            ((Relation)object).union(relation);
            ((Relation)object).union(this.buttonControls.inverse());
            this.tac = new SceneAnimationController(animator, (Relation)object, relation2, bl, this._canvas);
            iterator = animation.getCommandNames().iterator();
            while (iterator.hasNext()) {
                this.registerAction((String)iterator.next());
            }
            if (this.buttonControls.size() > 0) {
                this.createButtons(this.buttonControls);
            }
            animation.addAnimationListener(this.tac);
            this.invalidate();
            this.pack();
            this.tac.start();
            this.clearButtons(this.buttonControls);
            this.tac.restart();
        }
        catch (Exception exception) {
            this.animator.message("XML-" + exception);
            exception.printStackTrace();
            this.dispose();
        }
    }

    protected void createButtons(Relation relation) {
        Panel panel = new Panel();
        this.add("South", panel);
        Enumeration enumeration = relation.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Button button = new Button(string);
            button.setBackground(Color.green);
            button.addActionListener(new ButtonAction(string));
            this.registerButtonClearAction(string, button);
            panel.add(button);
        }
    }

    protected void clearButtons(Relation relation) {
        Enumeration enumeration = relation.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.clearControl(string);
        }
    }

    public void stop() {
        if (this.tac != null) {
            this.tac.stop();
        }
        if (this._canvas != null) {
            this._canvas.stop();
        }
    }

    public void registerAction(String string) {
        this.tac.registerAction(string, new CommandAction(string));
    }

    public void registerButtonClearAction(String string, Button button) {
        this.tac.registerAction(string, new ButtonClearAction(string, button));
    }

    public void signalControl(String string) {
        this.tac.signalControl(string);
    }

    public void clearControl(String string) {
        this.tac.clearControl(string);
    }

    class ButtonAction
    implements ActionListener {
        String name;

        public ButtonAction(String string) {
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Button button = (Button)actionEvent.getSource();
            button.setBackground(Color.red);
            SceneAnimator.this.signalControl(this.name);
        }
    }

    class RunMenu
    implements ActionListener {
        RunMenu() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SceneAnimator.this.pause) {
                if (SceneAnimator.this.tac != null) {
                    SceneAnimator.this.tac.stop();
                }
                SceneAnimator.this.pause.setEnabled(false);
                SceneAnimator.this.resume.setEnabled(true);
            } else if (actionEvent.getSource() == SceneAnimator.this.resume) {
                if (SceneAnimator.this.tac != null) {
                    SceneAnimator.this.tac.restart();
                }
                SceneAnimator.this.pause.setEnabled(true);
                SceneAnimator.this.resume.setEnabled(false);
            }
        }
    }

    class CheckItem
    implements ItemListener {
        CheckItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == SceneAnimator.this.setTrace) {
                SceneAnimator.this.tac.setTrace(SceneAnimator.this.setTrace.getState());
            } else if (itemEvent.getSource() == SceneAnimator.this.setDebug) {
                SceneAnimator.this.tac.setDebug(SceneAnimator.this.setDebug.getState());
            }
        }
    }

    class MyWindow
    extends WindowAdapter {
        MyWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SceneAnimator.this.dispose();
        }
    }

    class ButtonClearAction
    implements AnimationAction {
        String name;
        Button button;

        ButtonClearAction(String string, Button button) {
            this.name = string;
            this.button = button;
        }

        public void action() {
            this.button.setBackground(Color.green);
            SceneAnimator.this.clearControl(this.name);
        }
    }

    class CommandAction
    implements AnimationAction {
        String name;

        CommandAction(String string) {
            this.name = string;
        }

        public void action() {
            try {
                AnimationCanvas animationCanvas = SceneAnimator.this._canvas;
                synchronized (animationCanvas) {
                    SceneAnimator.this._canvas.getAnimation().invokeCommand(this.name);
                }
            }
            catch (CommandException commandException) {
                System.out.println("Animation" + commandException);
            }
        }
    }
}

