/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsr107cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheFactory;

public class CacheManager {
    private static final String FACTORY_PROPERTY_NAME = "net.sf.jsr107cache.CacheFactory";
    private static final String DEFAULT_FACTORY_NAME = "ri.cache.BasicCacheFactory";
    protected static CacheManager instance = new CacheManager();
    private final Map caches = Collections.synchronizedMap(new HashMap());

    public static CacheManager getInstance() {
        return instance;
    }

    public Cache getCache(String cacheName) {
        return (Cache)this.caches.get(cacheName);
    }

    public void registerCache(String cacheName, Cache cache) {
        this.caches.put(cacheName, cache);
    }

    public CacheFactory getCacheFactory() throws CacheException {
        String factoryName = this.findFactory(FACTORY_PROPERTY_NAME);
        try {
            ClassLoader cl = this.findClassLoader();
            Class<?> spiClass = Class.forName(factoryName, true, cl);
            return (CacheFactory)spiClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new CacheException("Could not find class: '" + factoryName + "'");
        }
        catch (ClassCastException cce) {
            throw new CacheException("Class: '" + factoryName + "' does not implement CacheFactory");
        }
        catch (InstantiationException ie) {
            throw new CacheException("Could not instantiate: '" + factoryName + "'");
        }
        catch (IllegalAccessException iae) {
            throw new CacheException("Could not find public default constructor for: '" + factoryName + "'");
        }
    }

    private ClassLoader findClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private boolean isEmptyString(String s) {
        return s == null || "".equals(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String findFactory(String factoryId) {
        block15: {
            try {
                String factoryClass = System.getProperty(factoryId);
                if (!this.isEmptyString(factoryClass)) {
                    return factoryClass;
                }
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            try {
                String configFile = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jcache.properties";
                File f = new File(configFile);
                if (!f.exists()) break block15;
                FileInputStream in = new FileInputStream(f);
                try {
                    Properties props = new Properties();
                    props.load(in);
                    String factoryClass = props.getProperty(factoryId);
                    if (!this.isEmptyString(factoryClass)) {
                        String string = factoryClass;
                        return string;
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (SecurityException ignore) {
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        try {
            ClassLoader cl = this.findClassLoader();
            InputStream is = cl.getResourceAsStream("META-INF/services/" + factoryId);
            if (is == null) return DEFAULT_FACTORY_NAME;
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            try {
                String factoryName = r.readLine();
                if (this.isEmptyString(factoryName)) return DEFAULT_FACTORY_NAME;
                String string = factoryName;
                return string;
            }
            finally {
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DEFAULT_FACTORY_NAME;
    }
}

