// Code generated by "go generate gonum.org/v1/gonum/unit/constant”; DO NOT EDIT.

// Copyright ©2019 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package constant

import (
	"fmt"
	"testing"
)

func TestAvogadroFormat(t *testing.T) {
	t.Parallel()
	for _, test := range []struct {
		format string
		want   string
	}{
		{"%v", "6.02214076e+23 mol^-1"},
		{"%.1v", "6e+23 mol^-1"},
		{"%50.1v", "                                      6e+23 mol^-1"},
		{"%50v", "                             6.02214076e+23 mol^-1"},
		{"%1v", "6.02214076e+23 mol^-1"},
		{"%#v", "constant.avogadroUnits(6.02214076e+23)"},
		{"%s", "%!s(constant.avogadroUnits=6.02214076e+23 mol^-1)"},
	} {
		got := fmt.Sprintf(test.format, Avogadro)
		if got != test.want {
			t.Errorf("Format %q: got: %q want: %q", test.format, got, test.want)
		}
	}
}
