// Copyright 2014 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

//go:build ignore

package main

/*
This program generates table.go. Invoke it as:
go run gen.go -output table.go
*/

import (
	"bytes"
	"flag"
	"fmt"
	"go/format"
	"io/ioutil"
	"log"
	"math"
)

// N is the number of entries in the sin look-up table. It must be a power of 2.
const N = 4096

var filename = flag.String("output", "table.go", "output file name")

func main() {
	b := new(bytes.Buffer)
	fmt.Fprintf(b, "// Code generated by go run gen.go; DO NOT EDIT\n\npackage f32\n\n")
	fmt.Fprintf(b, "const sinTableLen = %d\n\n", N)
	fmt.Fprintf(b, "// sinTable[i] equals sin(i * π / sinTableLen).\n")
	fmt.Fprintf(b, "var sinTable = [sinTableLen]float32{\n")
	for i := 0; i < N; i++ {
		radians := float64(i) * (math.Pi / N)
		fmt.Fprintf(b, "%v,\n", float32(math.Sin(radians)))
	}
	fmt.Fprintf(b, "}\n")

	data, err := format.Source(b.Bytes())
	if err != nil {
		log.Fatal(err)
	}
	if err := ioutil.WriteFile(*filename, data, 0644); err != nil {
		log.Fatal(err)
	}
}
