// Code generated by go.elara.ws/go-lemmy/cmd/gen (routes generator). DO NOT EDIT.

package lemmy

import "context"

// Add an admin to your site.
func (c *Client) AddAdmin(ctx context.Context, data AddAdmin) (*AddAdminResponse, error) {
	resData := &AddAdminResponse{}
	res, err := c.req(ctx, "POST", "/admin/add", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Add a moderator to your community.
func (c *Client) AddModToCommunity(ctx context.Context, data AddModToCommunity) (*AddModToCommunityResponse, error) {
	resData := &AddModToCommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/mod", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Approve a registration application
func (c *Client) ApproveRegistrationApplication(ctx context.Context, data ApproveRegistrationApplication) (*RegistrationApplicationResponse, error) {
	resData := &RegistrationApplicationResponse{}
	res, err := c.req(ctx, "PUT", "/admin/registration_application/approve", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Ban a user from a community.
func (c *Client) BanFromCommunity(ctx context.Context, data BanFromCommunity) (*BanFromCommunityResponse, error) {
	resData := &BanFromCommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/ban_user", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Ban a person from your site.
func (c *Client) BanPerson(ctx context.Context, data BanPerson) (*BanPersonResponse, error) {
	resData := &BanPersonResponse{}
	res, err := c.req(ctx, "POST", "/user/ban", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Block a community.
func (c *Client) BlockCommunity(ctx context.Context, data BlockCommunity) (*BlockCommunityResponse, error) {
	resData := &BlockCommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/block", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Block an instance.
func (c *Client) BlockInstance(ctx context.Context, data BlockInstance) (*BlockInstanceResponse, error) {
	resData := &BlockInstanceResponse{}
	res, err := c.req(ctx, "POST", "/site/block", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Block a person.
func (c *Client) BlockPerson(ctx context.Context, data BlockPerson) (*BlockPersonResponse, error) {
	resData := &BlockPersonResponse{}
	res, err := c.req(ctx, "POST", "/user/block", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Change your user password.
func (c *Client) ChangePassword(ctx context.Context, data ChangePassword) (*LoginResponse, error) {
	resData := &LoginResponse{}
	res, err := c.req(ctx, "PUT", "/user/change_password", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create a comment.
func (c *Client) CreateComment(ctx context.Context, data CreateComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "POST", "/comment", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Report a comment.
func (c *Client) CreateCommentReport(ctx context.Context, data CreateCommentReport) (*CommentReportResponse, error) {
	resData := &CommentReportResponse{}
	res, err := c.req(ctx, "POST", "/comment/report", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create a new community.
func (c *Client) CreateCommunity(ctx context.Context, data CreateCommunity) (*CommunityResponse, error) {
	resData := &CommunityResponse{}
	res, err := c.req(ctx, "POST", "/community", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create a new custom emoji
func (c *Client) CreateCustomEmoji(ctx context.Context, data CreateCustomEmoji) (*CustomEmojiResponse, error) {
	resData := &CustomEmojiResponse{}
	res, err := c.req(ctx, "POST", "/custom_emoji", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create a post.
func (c *Client) CreatePost(ctx context.Context, data CreatePost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "POST", "/post", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Report a post.
func (c *Client) CreatePostReport(ctx context.Context, data CreatePostReport) (*PostReportResponse, error) {
	resData := &PostReportResponse{}
	res, err := c.req(ctx, "POST", "/post/report", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create a private message.
func (c *Client) CreatePrivateMessage(ctx context.Context, data CreatePrivateMessage) (*PrivateMessageResponse, error) {
	resData := &PrivateMessageResponse{}
	res, err := c.req(ctx, "POST", "/private_message", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create a report for a private message.
func (c *Client) CreatePrivateMessageReport(ctx context.Context, data CreatePrivateMessageReport) (*PrivateMessageReportResponse, error) {
	resData := &PrivateMessageReportResponse{}
	res, err := c.req(ctx, "POST", "/private_message/report", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Create your site.
func (c *Client) CreateSite(ctx context.Context, data CreateSite) (*SiteResponse, error) {
	resData := &SiteResponse{}
	res, err := c.req(ctx, "POST", "/site", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Delete your account.
func (c *Client) DeleteAccount(ctx context.Context, data DeleteAccount) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/user/delete_account", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Delete a comment.
func (c *Client) DeleteComment(ctx context.Context, data DeleteComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "POST", "/comment/delete", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Delete a community.
func (c *Client) DeleteCommunity(ctx context.Context, data DeleteCommunity) (*CommunityResponse, error) {
	resData := &CommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/delete", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Delete a custom emoji
func (c *Client) DeleteCustomEmoji(ctx context.Context, data DeleteCustomEmoji) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/custom_emoji/delete", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Delete a post.
func (c *Client) DeletePost(ctx context.Context, data DeletePost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "POST", "/post/delete", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Delete a private message.
func (c *Client) DeletePrivateMessage(ctx context.Context, data DeletePrivateMessage) (*PrivateMessageResponse, error) {
	resData := &PrivateMessageResponse{}
	res, err := c.req(ctx, "POST", "/private_message/delete", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Distinguishes a comment (speak as moderator)
func (c *Client) DistinguishComment(ctx context.Context, data DistinguishComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "POST", "/comment/distinguish", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Edit a comment.
func (c *Client) EditComment(ctx context.Context, data EditComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "PUT", "/comment", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Edit a community.
func (c *Client) EditCommunity(ctx context.Context, data EditCommunity) (*CommunityResponse, error) {
	resData := &CommunityResponse{}
	res, err := c.req(ctx, "PUT", "/community", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Edit an existing custom emoji
func (c *Client) EditCustomEmoji(ctx context.Context, data EditCustomEmoji) (*CustomEmojiResponse, error) {
	resData := &CustomEmojiResponse{}
	res, err := c.req(ctx, "PUT", "/custom_emoji", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Edit a post.
func (c *Client) EditPost(ctx context.Context, data EditPost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "PUT", "/post", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Edit a private message.
func (c *Client) EditPrivateMessage(ctx context.Context, data EditPrivateMessage) (*PrivateMessageResponse, error) {
	resData := &PrivateMessageResponse{}
	res, err := c.req(ctx, "PUT", "/private_message", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Edit your site.
func (c *Client) EditSite(ctx context.Context, data EditSite) (*SiteResponse, error) {
	resData := &SiteResponse{}
	res, err := c.req(ctx, "PUT", "/site", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

/*
Export a backup of your user settings, including your saved content,
followed communities, and blocks.
*/
func (c *Client) ExportSettings(ctx context.Context) error {
	resData := &emptyResponse{}
	res, err := c.getReq(ctx, "GET", "/user/export_settings", nil, resData)
	if err != nil {
		return err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return err
	}
	return nil
}

// A moderator can feature a community post ( IE stick it to the top of a community ).
func (c *Client) FeaturePost(ctx context.Context, data FeaturePost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "POST", "/post/feature", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Follow / subscribe to a community.
func (c *Client) FollowCommunity(ctx context.Context, data FollowCommunity) (*CommunityResponse, error) {
	resData := &CommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/follow", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get a list of banned users
func (c *Client) BannedPersons(ctx context.Context) (*BannedPersonsResponse, error) {
	resData := &BannedPersonsResponse{}
	res, err := c.getReq(ctx, "GET", "/user/banned", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Fetch a Captcha.
func (c *Client) Captcha(ctx context.Context) (*GetCaptchaResponse, error) {
	resData := &GetCaptchaResponse{}
	res, err := c.getReq(ctx, "GET", "/user/get_captcha", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get / fetch comment.
func (c *Client) Comment(ctx context.Context, data GetComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.getReq(ctx, "GET", "/comment", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get / fetch comments.
func (c *Client) Comments(ctx context.Context, data GetComments) (*GetCommentsResponse, error) {
	resData := &GetCommentsResponse{}
	res, err := c.getReq(ctx, "GET", "/comment/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get / fetch a community.
func (c *Client) Community(ctx context.Context, data GetCommunity) (*GetCommunityResponse, error) {
	resData := &GetCommunityResponse{}
	res, err := c.getReq(ctx, "GET", "/community", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Fetch federated instances.
func (c *Client) FederatedInstances(ctx context.Context) (*GetFederatedInstancesResponse, error) {
	resData := &GetFederatedInstancesResponse{}
	res, err := c.getReq(ctx, "GET", "/federated_instances", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get the modlog.
func (c *Client) Modlog(ctx context.Context, data GetModlog) (*GetModlogResponse, error) {
	resData := &GetModlogResponse{}
	res, err := c.getReq(ctx, "GET", "/modlog", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get the details for a person.
func (c *Client) PersonDetails(ctx context.Context, data GetPersonDetails) (*GetPersonDetailsResponse, error) {
	resData := &GetPersonDetailsResponse{}
	res, err := c.getReq(ctx, "GET", "/user", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get mentions for your user.
func (c *Client) PersonMentions(ctx context.Context, data GetPersonMentions) (*GetPersonMentionsResponse, error) {
	resData := &GetPersonMentionsResponse{}
	res, err := c.getReq(ctx, "GET", "/user/mention", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get / fetch a post.
func (c *Client) Post(ctx context.Context, data GetPost) (*GetPostResponse, error) {
	resData := &GetPostResponse{}
	res, err := c.getReq(ctx, "GET", "/post", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get / fetch posts, with various filters.
func (c *Client) Posts(ctx context.Context, data GetPosts) (*GetPostsResponse, error) {
	resData := &GetPostsResponse{}
	res, err := c.getReq(ctx, "GET", "/post/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get / fetch private messages.
func (c *Client) PrivateMessages(ctx context.Context, data GetPrivateMessages) (*PrivateMessagesResponse, error) {
	resData := &PrivateMessagesResponse{}
	res, err := c.getReq(ctx, "GET", "/private_message/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get comment replies.
func (c *Client) Replies(ctx context.Context, data GetReplies) (*GetRepliesResponse, error) {
	resData := &GetRepliesResponse{}
	res, err := c.getReq(ctx, "GET", "/user/replies", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get counts for your reports
func (c *Client) ReportCount(ctx context.Context, data GetReportCount) (*GetReportCountResponse, error) {
	resData := &GetReportCountResponse{}
	res, err := c.getReq(ctx, "GET", "/user/report_count", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Gets the site, and your user data.
func (c *Client) Site(ctx context.Context) (*GetSiteResponse, error) {
	resData := &GetSiteResponse{}
	res, err := c.getReq(ctx, "GET", "/site", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Fetch metadata for any given site.
func (c *Client) SiteMetadata(ctx context.Context, data GetSiteMetadata) (*GetSiteMetadataResponse, error) {
	resData := &GetSiteMetadataResponse{}
	res, err := c.getReq(ctx, "GET", "/post/site_metadata", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get your unread counts
func (c *Client) UnreadCount(ctx context.Context) (*GetUnreadCountResponse, error) {
	resData := &GetUnreadCountResponse{}
	res, err := c.getReq(ctx, "GET", "/user/unread_count", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Get the unread registration applications count.
func (c *Client) UnreadRegistrationApplicationCount(ctx context.Context) (*GetUnreadRegistrationApplicationCountResponse, error) {
	resData := &GetUnreadRegistrationApplicationCountResponse{}
	res, err := c.getReq(ctx, "GET", "/admin/registration_application/count", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Hide a community from public / "All" view. Admins only.
func (c *Client) HideCommunity(ctx context.Context, data HideCommunity) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "PUT", "/community/hide", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Import a backup of your user settings.
func (c *Client) ImportSettings(ctx context.Context) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/user/import_settings", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Leave the Site admins.
func (c *Client) LeaveAdmin(ctx context.Context) (*GetSiteResponse, error) {
	resData := &GetSiteResponse{}
	res, err := c.req(ctx, "POST", "/user/leave_admin", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Like / vote on a comment.
func (c *Client) LikeComment(ctx context.Context, data CreateCommentLike) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "POST", "/comment/like", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Like / vote on a post.
func (c *Client) LikePost(ctx context.Context, data CreatePostLike) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "POST", "/post/like", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// List comment reports.
func (c *Client) CommentReports(ctx context.Context, data ListCommentReports) (*ListCommentReportsResponse, error) {
	resData := &ListCommentReportsResponse{}
	res, err := c.getReq(ctx, "GET", "/comment/report/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// List communities, with various filters.
func (c *Client) Communities(ctx context.Context, data ListCommunities) (*ListCommunitiesResponse, error) {
	resData := &ListCommunitiesResponse{}
	res, err := c.getReq(ctx, "GET", "/community/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// List login tokens for your user
func (c *Client) Logins(ctx context.Context) error {
	resData := &emptyResponse{}
	res, err := c.getReq(ctx, "GET", "/user/list_logins", nil, resData)
	if err != nil {
		return err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return err
	}
	return nil
}

// List post reports.
func (c *Client) PostReports(ctx context.Context, data ListPostReports) (*ListPostReportsResponse, error) {
	resData := &ListPostReportsResponse{}
	res, err := c.getReq(ctx, "GET", "/post/report/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// List private message reports.
func (c *Client) PrivateMessageReports(ctx context.Context, data ListPrivateMessageReports) (*ListPrivateMessageReportsResponse, error) {
	resData := &ListPrivateMessageReportsResponse{}
	res, err := c.getReq(ctx, "GET", "/private_message/report/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// List the registration applications.
func (c *Client) RegistrationApplications(ctx context.Context, data ListRegistrationApplications) (*ListRegistrationApplicationsResponse, error) {
	resData := &ListRegistrationApplicationsResponse{}
	res, err := c.getReq(ctx, "GET", "/admin/registration_application/list", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// A moderator can lock a post ( IE disable new comments ).
func (c *Client) LockPost(ctx context.Context, data LockPost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "POST", "/post/lock", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Log into lemmy.
func (c *Client) Login(ctx context.Context, data Login) (*LoginResponse, error) {
	resData := &LoginResponse{}
	res, err := c.req(ctx, "POST", "/user/login", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Mark all replies as read.
func (c *Client) MarkAllAsRead(ctx context.Context) (*GetRepliesResponse, error) {
	resData := &GetRepliesResponse{}
	res, err := c.req(ctx, "POST", "/user/mark_all_as_read", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Mark a comment as read.
func (c *Client) MarkCommentReplyAsRead(ctx context.Context, data MarkCommentReplyAsRead) (*CommentReplyResponse, error) {
	resData := &CommentReplyResponse{}
	res, err := c.req(ctx, "POST", "/comment/mark_as_read", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Mark a person mention as read.
func (c *Client) MarkPersonMentionAsRead(ctx context.Context, data MarkPersonMentionAsRead) (*PersonMentionResponse, error) {
	resData := &PersonMentionResponse{}
	res, err := c.req(ctx, "POST", "/user/mention/mark_as_read", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Mark a post as read.
func (c *Client) MarkPostAsRead(ctx context.Context, data MarkPostAsRead) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/post/mark_as_read", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Mark a private message as read.
func (c *Client) MarkPrivateMessageAsRead(ctx context.Context, data MarkPrivateMessageAsRead) (*PrivateMessageResponse, error) {
	resData := &PrivateMessageResponse{}
	res, err := c.req(ctx, "POST", "/private_message/mark_as_read", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Change your password from an email / token based reset.
func (c *Client) PasswordChangeAfterReset(ctx context.Context, data PasswordChangeAfterReset) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/user/password_change", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Reset your password.
func (c *Client) PasswordReset(ctx context.Context, data PasswordReset) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/user/password_reset", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Purge / Delete a comment from the database.
func (c *Client) PurgeComment(ctx context.Context, data PurgeComment) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/admin/purge/comment", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Purge / Delete a community from the database.
func (c *Client) PurgeCommunity(ctx context.Context, data PurgeCommunity) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/admin/purge/community", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Purge / Delete a person from the database.
func (c *Client) PurgePerson(ctx context.Context, data PurgePerson) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/admin/purge/person", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Purge / Delete a post from the database.
func (c *Client) PurgePost(ctx context.Context, data PurgePost) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/admin/purge/post", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Register a new user.
func (c *Client) Register(ctx context.Context, data Register) (*LoginResponse, error) {
	resData := &LoginResponse{}
	res, err := c.req(ctx, "POST", "/user/register", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// A moderator remove for a comment.
func (c *Client) RemoveComment(ctx context.Context, data RemoveComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "POST", "/comment/remove", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// A moderator remove for a community.
func (c *Client) RemoveCommunity(ctx context.Context, data RemoveCommunity) (*CommunityResponse, error) {
	resData := &CommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/remove", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// A moderator remove for a post.
func (c *Client) RemovePost(ctx context.Context, data RemovePost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "POST", "/post/remove", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Resolve a comment report. Only a mod can do this.
func (c *Client) ResolveCommentReport(ctx context.Context, data ResolveCommentReport) (*CommentReportResponse, error) {
	resData := &CommentReportResponse{}
	res, err := c.req(ctx, "PUT", "/comment/report/resolve", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Fetch a non-local / federated object.
func (c *Client) ResolveObject(ctx context.Context, data ResolveObject) (*ResolveObjectResponse, error) {
	resData := &ResolveObjectResponse{}
	res, err := c.getReq(ctx, "GET", "/resolve_object", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Resolve a post report. Only a mod can do this.
func (c *Client) ResolvePostReport(ctx context.Context, data ResolvePostReport) (*PostReportResponse, error) {
	resData := &PostReportResponse{}
	res, err := c.req(ctx, "PUT", "/post/report/resolve", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Resolve a report for a private message.
func (c *Client) ResolvePrivateMessageReport(ctx context.Context, data ResolvePrivateMessageReport) (*PrivateMessageReportResponse, error) {
	resData := &PrivateMessageReportResponse{}
	res, err := c.req(ctx, "PUT", "/private_message/report/resolve", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Save a comment.
func (c *Client) SaveComment(ctx context.Context, data SaveComment) (*CommentResponse, error) {
	resData := &CommentResponse{}
	res, err := c.req(ctx, "PUT", "/comment/save", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Save a post.
func (c *Client) SavePost(ctx context.Context, data SavePost) (*PostResponse, error) {
	resData := &PostResponse{}
	res, err := c.req(ctx, "PUT", "/post/save", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Save your user settings.
func (c *Client) SaveUserSettings(ctx context.Context, data SaveUserSettings) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "PUT", "/user/save_user_settings", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Search lemmy.
func (c *Client) Search(ctx context.Context, data Search) (*SearchResponse, error) {
	resData := &SearchResponse{}
	res, err := c.getReq(ctx, "GET", "/search", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Transfer your community to an existing moderator.
func (c *Client) TransferCommunity(ctx context.Context, data TransferCommunity) (*GetCommunityResponse, error) {
	resData := &GetCommunityResponse{}
	res, err := c.req(ctx, "POST", "/community/transfer", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Returns an error message if your auth token is invalid
func (c *Client) ValidateAuth(ctx context.Context) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.getReq(ctx, "GET", "/user/validate_auth", nil, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}

// Verify your email
func (c *Client) VerifyEmail(ctx context.Context, data VerifyEmail) (*SuccessResponse, error) {
	resData := &SuccessResponse{}
	res, err := c.req(ctx, "POST", "/user/verify_email", data, resData)
	if err != nil {
		return nil, err
	}
	err = resError(res, resData.Error)
	if err != nil {
		return nil, err
	}
	return resData, nil
}
