# Weaveworks Build Tools

Included in this repo are tools shared by weave.git and scope.git.  They include

- ```bazel-rules```: Bazel build rules used in our projects
- ```build```: a set of docker base-images for building weave
  projects. These should be used instead of giving each project its
  own build image.
- ```provisioning```: a set of Terraform scripts to provision virtual machines in GCP, AWS or Digital Ocean.
- ```config_management```: a set of Ansible playbooks to configure virtual machines for development, testing, etc.
- ```cover```: a tool which merges overlapping coverage reports generated by go
  test
- ```files-with-type```: a tool to search directories for files of a given
  MIME type
- ```lint```: a script to lint go, sh and hcl files; runs various tools like
  golint, go vet, errcheck, shellcheck etc
- ```rebuild-image```: a script to rebuild docker images when their input files
  change; useful when you using docker images to build your software, but you
  don't want to build the image every time.
- ```shell-lint```: a script to lint multiple shell files with 
  [shellcheck](http://www.shellcheck.net/)
- ```socks```: a simple, dockerised SOCKS proxy for getting your laptop onto
  the Weave network
- ```test```: a script to run all go unit tests in subdirectories, gather the
  coverage results, and merge them into a single report.
- ```runner```: a tool for running tests in parallel; given each test is
  suffixed with the number of hosts it requires, and the hosts available are
  contained in the environment variable HOSTS, the tool will run tests in
  parallel, on different hosts.
- ```scheduler```: an appengine application that can be used to distribute
  tests across different shards in CircleCI.

## Requirements

- ```lint``` requires shfmt to lint sh files; get shfmt with
```
curl -fsSLo shfmt https://github.com/mvdan/sh/releases/download/v1.3.0/shfmt_v1.3.0_linux_amd64
chmod +x shfmt
```
  (we pin that version, and it doesn't build from the source repo any more)

## Using build-tools.git

To allow you to tie your code to a specific version of build-tools.git, such
that future changes don't break you, we recommendation that you [`git subtree`]()
this repository into your own repository:

[`git subtree`]: http://blogs.atlassian.com/2013/05/alternatives-to-git-submodule-git-subtree/

```
git subtree add --prefix tools https://github.com/weaveworks/build-tools.git master --squash
````

To update the code in build-tools.git, the process is therefore:
- PR into build-tools.git, go through normal review process etc.
- Do `git subtree pull --prefix tools https://github.com/weaveworks/build-tools.git master --squash`
  in your repo, and PR that.

## <a name="help"></a>Getting Help

If you have any questions about, feedback for or problems with `build-tools`:

- Invite yourself to the <a href="https://slack.weave.works/" target="_blank">Weave Users Slack</a>.
- Ask a question on the [#general](https://weave-community.slack.com/messages/general/) slack channel.
- [File an issue](https://github.com/weaveworks/build-tools/issues/new).

Your feedback is always welcome!
