---
title: V1.2
weight: 100
---

# Version 1.2 release notes

The Tempo team is excited to announce the release of Tempo 1.2. This release introduces Tempo search.

## Features and enhancements

* **Recent traces search** The headline feature of Tempo 1.2 is the ability to search for data that is still in the ingester component. This experimental feature must be enabled using feature flags in both Grafana and Tempo. Refer to [Tempo search](/docs/tempo/v1.2.x/getting-started/tempo-in-grafana/#tempo-search) for details.
* **Scalable monolithic deployment mode (formerly scalable single binary deployment mode)** The new [scalable monolithic](/docs/tempo/v1.2.x/operations/deployment/#scalable-monolithic) deployment mode is operationally simpler, although less robust than a fully distributed deployment. We consider it a balanced operational mode that some may find attractive.
* **Massive performance improvements** were achieved by more efficiently batching trace data being ingested. In terms of CPU needed, Tempo v1.2 is twice as efficient as Tempo v1.1. Refer to [PR 1075](https://github.com/grafana/tempo/pull/1075) for details.
* **API improvements** Some informational endpoints were consolidated within the [`status` endpoint](https://grafana.com/docs/tempo/latest/api_docs/#status). New endpoints were also added.

## Upgrade considerations

When upgrading to Tempo v1.2, be aware of these changes:

* Support for v0 and v1 blocks were dropped as announced with Tempo v1.1. Refer to the [Tempo v1.1 changelog](https://github.com/grafana/tempo/releases/tag/v1.1.0) for details.
* [PR 1007](https://github.com/grafana/tempo/pull/1007) altered the Querier API. When upgrading components within a deployment, there will be a read outage until all queriers and query frontends have rolled to the upgraded version.
* API improvements consolidated informational endpoints within the [`status` endpoint](https://grafana.com/docs/tempo/v1.2.x/api_docs/#status).
* Metric `ingester_bytes_metric_total` is renamed `ingester_bytes_received_total` by [PR 979](https://github.com/grafana/tempo/pull/979).
* Metric `cortex_runtime_config_last_reload_successful` is renamed `tempo_runtime_config_last_reload_successful` by [PR 945](https://github.com/grafana/tempo/pull/945).
* The `tempo-cli` flag `--storage.trace.maintenance-cycle` is renamed  `-storage.trace.blocklist_poll` by [PR 897](https://github.com/grafana/tempo/pull/897).

## Bug fixes

### 1.2.1 bug fixes

* Honor the default values of configuration parameters `max_bytes_per_trace` and `max_search_bytes_per_trace`. [PR #1109](https://github.com/grafana/tempo/pull/1109) (@BitProcessor)
* Reclassify the writing of empty traces to be a warning instead of an error. [PR #1113](https://github.com/grafana/tempo/pull/1113) (@mdisibio)

### 1.2.0 bug fixes

* Fixed errors with magic numbers and other block mishandling when an ingester forcefully shuts down.  [Issue #937](https://github.com/grafana/tempo/issues/937) (@mdisibio)
* Fixed a memory leak in the compactor component.  [PR #806](https://github.com/grafana/tempo/pull/806) (@mdisibio)
* Set a span's tag `span.kind` to `client` in query-frontend to allow query frontend spans to be paired with querier server spans. [PR #975](https://github.com/grafana/tempo/pull/975) (@mapno)
*  Metric `tempodb_backend_hedged_roundtrips_total` now correctly counts hedged roundtrips. [PR #1079](https://github.com/grafana/tempo/pull/1079) (@joe-elliott)
* Updated the `go-kit` logger package to remove spurious debug logs. [PR #1094](https://github.com/grafana/tempo/pull/1094) (@bboreham)
