// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetDataSourceByNameReader is a Reader for the GetDataSourceByName structure.
type GetDataSourceByNameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDataSourceByNameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDataSourceByNameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetDataSourceByNameUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetDataSourceByNameForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDataSourceByNameInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/name/{name}] getDataSourceByName", response, response.Code())
	}
}

// NewGetDataSourceByNameOK creates a GetDataSourceByNameOK with default headers values
func NewGetDataSourceByNameOK() *GetDataSourceByNameOK {
	return &GetDataSourceByNameOK{}
}

/*
GetDataSourceByNameOK describes a response with status code 200, with default header values.

(empty)
*/
type GetDataSourceByNameOK struct {
	Payload *models.DataSource
}

// IsSuccess returns true when this get data source by name Ok response has a 2xx status code
func (o *GetDataSourceByNameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get data source by name Ok response has a 3xx status code
func (o *GetDataSourceByNameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by name Ok response has a 4xx status code
func (o *GetDataSourceByNameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by name Ok response has a 5xx status code
func (o *GetDataSourceByNameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by name Ok response a status code equal to that given
func (o *GetDataSourceByNameOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get data source by name Ok response
func (o *GetDataSourceByNameOK) Code() int {
	return 200
}

func (o *GetDataSourceByNameOK) Error() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameOk  %+v", 200, o.Payload)
}

func (o *GetDataSourceByNameOK) String() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameOk  %+v", 200, o.Payload)
}

func (o *GetDataSourceByNameOK) GetPayload() *models.DataSource {
	return o.Payload
}

func (o *GetDataSourceByNameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataSource)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByNameUnauthorized creates a GetDataSourceByNameUnauthorized with default headers values
func NewGetDataSourceByNameUnauthorized() *GetDataSourceByNameUnauthorized {
	return &GetDataSourceByNameUnauthorized{}
}

/*
GetDataSourceByNameUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetDataSourceByNameUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by name unauthorized response has a 2xx status code
func (o *GetDataSourceByNameUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by name unauthorized response has a 3xx status code
func (o *GetDataSourceByNameUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by name unauthorized response has a 4xx status code
func (o *GetDataSourceByNameUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by name unauthorized response has a 5xx status code
func (o *GetDataSourceByNameUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by name unauthorized response a status code equal to that given
func (o *GetDataSourceByNameUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get data source by name unauthorized response
func (o *GetDataSourceByNameUnauthorized) Code() int {
	return 401
}

func (o *GetDataSourceByNameUnauthorized) Error() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameUnauthorized  %+v", 401, o.Payload)
}

func (o *GetDataSourceByNameUnauthorized) String() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameUnauthorized  %+v", 401, o.Payload)
}

func (o *GetDataSourceByNameUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByNameUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByNameForbidden creates a GetDataSourceByNameForbidden with default headers values
func NewGetDataSourceByNameForbidden() *GetDataSourceByNameForbidden {
	return &GetDataSourceByNameForbidden{}
}

/*
GetDataSourceByNameForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetDataSourceByNameForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by name forbidden response has a 2xx status code
func (o *GetDataSourceByNameForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by name forbidden response has a 3xx status code
func (o *GetDataSourceByNameForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by name forbidden response has a 4xx status code
func (o *GetDataSourceByNameForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by name forbidden response has a 5xx status code
func (o *GetDataSourceByNameForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by name forbidden response a status code equal to that given
func (o *GetDataSourceByNameForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get data source by name forbidden response
func (o *GetDataSourceByNameForbidden) Code() int {
	return 403
}

func (o *GetDataSourceByNameForbidden) Error() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameForbidden  %+v", 403, o.Payload)
}

func (o *GetDataSourceByNameForbidden) String() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameForbidden  %+v", 403, o.Payload)
}

func (o *GetDataSourceByNameForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByNameForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByNameInternalServerError creates a GetDataSourceByNameInternalServerError with default headers values
func NewGetDataSourceByNameInternalServerError() *GetDataSourceByNameInternalServerError {
	return &GetDataSourceByNameInternalServerError{}
}

/*
GetDataSourceByNameInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetDataSourceByNameInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by name internal server error response has a 2xx status code
func (o *GetDataSourceByNameInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by name internal server error response has a 3xx status code
func (o *GetDataSourceByNameInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by name internal server error response has a 4xx status code
func (o *GetDataSourceByNameInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by name internal server error response has a 5xx status code
func (o *GetDataSourceByNameInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get data source by name internal server error response a status code equal to that given
func (o *GetDataSourceByNameInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get data source by name internal server error response
func (o *GetDataSourceByNameInternalServerError) Code() int {
	return 500
}

func (o *GetDataSourceByNameInternalServerError) Error() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDataSourceByNameInternalServerError) String() string {
	return fmt.Sprintf("[GET /datasources/name/{name}][%d] getDataSourceByNameInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDataSourceByNameInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByNameInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
