// Code generated by go-swagger; DO NOT EDIT.

package datasource_permissions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeletePermissionsParams creates a new DeletePermissionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeletePermissionsParams() *DeletePermissionsParams {
	return &DeletePermissionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeletePermissionsParamsWithTimeout creates a new DeletePermissionsParams object
// with the ability to set a timeout on a request.
func NewDeletePermissionsParamsWithTimeout(timeout time.Duration) *DeletePermissionsParams {
	return &DeletePermissionsParams{
		timeout: timeout,
	}
}

// NewDeletePermissionsParamsWithContext creates a new DeletePermissionsParams object
// with the ability to set a context for a request.
func NewDeletePermissionsParamsWithContext(ctx context.Context) *DeletePermissionsParams {
	return &DeletePermissionsParams{
		Context: ctx,
	}
}

// NewDeletePermissionsParamsWithHTTPClient creates a new DeletePermissionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeletePermissionsParamsWithHTTPClient(client *http.Client) *DeletePermissionsParams {
	return &DeletePermissionsParams{
		HTTPClient: client,
	}
}

/*
DeletePermissionsParams contains all the parameters to send to the API endpoint

	for the delete permissions operation.

	Typically these are written to a http.Request.
*/
type DeletePermissionsParams struct {

	// DatasourceID.
	DatasourceID string

	// PermissionID.
	PermissionID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePermissionsParams) WithDefaults() *DeletePermissionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePermissionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete permissions params
func (o *DeletePermissionsParams) WithTimeout(timeout time.Duration) *DeletePermissionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete permissions params
func (o *DeletePermissionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete permissions params
func (o *DeletePermissionsParams) WithContext(ctx context.Context) *DeletePermissionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete permissions params
func (o *DeletePermissionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete permissions params
func (o *DeletePermissionsParams) WithHTTPClient(client *http.Client) *DeletePermissionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete permissions params
func (o *DeletePermissionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatasourceID adds the datasourceID to the delete permissions params
func (o *DeletePermissionsParams) WithDatasourceID(datasourceID string) *DeletePermissionsParams {
	o.SetDatasourceID(datasourceID)
	return o
}

// SetDatasourceID adds the datasourceId to the delete permissions params
func (o *DeletePermissionsParams) SetDatasourceID(datasourceID string) {
	o.DatasourceID = datasourceID
}

// WithPermissionID adds the permissionID to the delete permissions params
func (o *DeletePermissionsParams) WithPermissionID(permissionID string) *DeletePermissionsParams {
	o.SetPermissionID(permissionID)
	return o
}

// SetPermissionID adds the permissionId to the delete permissions params
func (o *DeletePermissionsParams) SetPermissionID(permissionID string) {
	o.PermissionID = permissionID
}

// WriteToRequest writes these params to a swagger request
func (o *DeletePermissionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datasourceId
	if err := r.SetPathParam("datasourceId", o.DatasourceID); err != nil {
		return err
	}

	// path param permissionId
	if err := r.SetPathParam("permissionId", o.PermissionID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
