// Copyright 2020-2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by goyacc -o proto.y.go -l -p proto proto.y. DO NOT EDIT.
package parser

import __yyfmt__ "fmt"

//lint:file-ignore SA4006 generated parser has unused values

import (
	"math"

	"github.com/bufbuild/protocompile/ast"
)

type protoSymType struct {
	yys          int
	file         *ast.FileNode
	syn          *ast.SyntaxNode
	fileElement  ast.FileElement
	fileElements []ast.FileElement
	pkg          *ast.PackageNode
	imprt        *ast.ImportNode
	msg          *ast.MessageNode
	msgElement   ast.MessageElement
	msgElements  []ast.MessageElement
	fld          *ast.FieldNode
	mapFld       *ast.MapFieldNode
	mapType      *ast.MapTypeNode
	grp          *ast.GroupNode
	oo           *ast.OneofNode
	ooElement    ast.OneofElement
	ooElements   []ast.OneofElement
	ext          *ast.ExtensionRangeNode
	resvd        *ast.ReservedNode
	en           *ast.EnumNode
	enElement    ast.EnumElement
	enElements   []ast.EnumElement
	env          *ast.EnumValueNode
	extend       *ast.ExtendNode
	extElement   ast.ExtendElement
	extElements  []ast.ExtendElement
	svc          *ast.ServiceNode
	svcElement   ast.ServiceElement
	svcElements  []ast.ServiceElement
	mtd          *ast.RPCNode
	mtdMsgType   *ast.RPCTypeNode
	mtdElement   ast.RPCElement
	mtdElements  []ast.RPCElement
	opt          *ast.OptionNode
	opts         *compactOptionSlices
	ref          *ast.FieldReferenceNode
	optNms       *fieldRefSlices
	cmpctOpts    *ast.CompactOptionsNode
	rng          *ast.RangeNode
	rngs         *rangeSlices
	names        *nameSlices
	cid          *identSlices
	tid          ast.IdentValueNode
	sl           *valueSlices
	msgLitFlds   *messageFieldList
	msgLitFld    *ast.MessageFieldNode
	v            ast.ValueNode
	il           ast.IntValueNode
	str          []*ast.StringLiteralNode
	s            *ast.StringLiteralNode
	i            *ast.UintLiteralNode
	f            *ast.FloatLiteralNode
	id           *ast.IdentNode
	b            *ast.RuneNode
	err          error
}

const _STRING_LIT = 57346
const _INT_LIT = 57347
const _FLOAT_LIT = 57348
const _NAME = 57349
const _SYNTAX = 57350
const _IMPORT = 57351
const _WEAK = 57352
const _PUBLIC = 57353
const _PACKAGE = 57354
const _OPTION = 57355
const _TRUE = 57356
const _FALSE = 57357
const _INF = 57358
const _NAN = 57359
const _REPEATED = 57360
const _OPTIONAL = 57361
const _REQUIRED = 57362
const _DOUBLE = 57363
const _FLOAT = 57364
const _INT32 = 57365
const _INT64 = 57366
const _UINT32 = 57367
const _UINT64 = 57368
const _SINT32 = 57369
const _SINT64 = 57370
const _FIXED32 = 57371
const _FIXED64 = 57372
const _SFIXED32 = 57373
const _SFIXED64 = 57374
const _BOOL = 57375
const _STRING = 57376
const _BYTES = 57377
const _GROUP = 57378
const _ONEOF = 57379
const _MAP = 57380
const _EXTENSIONS = 57381
const _TO = 57382
const _MAX = 57383
const _RESERVED = 57384
const _ENUM = 57385
const _MESSAGE = 57386
const _EXTEND = 57387
const _SERVICE = 57388
const _RPC = 57389
const _STREAM = 57390
const _RETURNS = 57391
const _ERROR = 57392

var protoToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"_STRING_LIT",
	"_INT_LIT",
	"_FLOAT_LIT",
	"_NAME",
	"_SYNTAX",
	"_IMPORT",
	"_WEAK",
	"_PUBLIC",
	"_PACKAGE",
	"_OPTION",
	"_TRUE",
	"_FALSE",
	"_INF",
	"_NAN",
	"_REPEATED",
	"_OPTIONAL",
	"_REQUIRED",
	"_DOUBLE",
	"_FLOAT",
	"_INT32",
	"_INT64",
	"_UINT32",
	"_UINT64",
	"_SINT32",
	"_SINT64",
	"_FIXED32",
	"_FIXED64",
	"_SFIXED32",
	"_SFIXED64",
	"_BOOL",
	"_STRING",
	"_BYTES",
	"_GROUP",
	"_ONEOF",
	"_MAP",
	"_EXTENSIONS",
	"_TO",
	"_MAX",
	"_RESERVED",
	"_ENUM",
	"_MESSAGE",
	"_EXTEND",
	"_SERVICE",
	"_RPC",
	"_STREAM",
	"_RETURNS",
	"_ERROR",
	"'='",
	"';'",
	"':'",
	"'{'",
	"'}'",
	"'\\\\'",
	"'/'",
	"'?'",
	"'.'",
	"','",
	"'>'",
	"'<'",
	"'+'",
	"'-'",
	"'('",
	"')'",
	"'['",
	"']'",
	"'*'",
	"'&'",
	"'^'",
	"'%'",
	"'$'",
	"'#'",
	"'@'",
	"'!'",
	"'~'",
	"'`'",
}

var protoStatenames = [...]string{}

const protoEofCode = 1
const protoErrCode = 2
const protoInitialStackSize = 16

var protoExca = [...]int16{
	-1, 0,
	1, 4,
	-2, 0,
	-1, 1,
	1, -1,
	-2, 0,
	-1, 2,
	1, 1,
	-2, 0,
	-1, 3,
	1, 2,
	-2, 0,
	-1, 22,
	1, 3,
	-2, 0,
	-1, 94,
	55, 176,
	-2, 0,
	-1, 95,
	55, 164,
	-2, 0,
	-1, 96,
	55, 197,
	-2, 0,
	-1, 98,
	55, 210,
	-2, 0,
	-1, 118,
	55, 177,
	-2, 0,
	-1, 178,
	55, 165,
	-2, 0,
	-1, 230,
	55, 198,
	-2, 0,
	-1, 280,
	55, 211,
	-2, 0,
	-1, 291,
	55, 57,
	61, 57,
	-2, 0,
	-1, 408,
	55, 114,
	-2, 0,
	-1, 464,
	55, 115,
	-2, 0,
	-1, 613,
	55, 176,
	-2, 0,
	-1, 629,
	55, 222,
	-2, 0,
	-1, 634,
	55, 176,
	-2, 0,
	-1, 640,
	55, 223,
	-2, 0,
	-1, 649,
	55, 176,
	-2, 0,
	-1, 656,
	55, 176,
	-2, 0,
}

const protoPrivate = 57344

const protoLast = 1542

var protoAct = [...]int16{
	117, 126, 8, 404, 8, 8, 641, 393, 439, 574,
	30, 103, 104, 459, 80, 465, 435, 369, 368, 106,
	354, 81, 437, 288, 8, 281, 306, 290, 75, 78,
	79, 138, 83, 125, 132, 25, 231, 179, 29, 353,
	119, 76, 610, 293, 84, 580, 87, 88, 31, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 451, 93, 630, 605, 116, 289, 180, 447, 105,
	282, 102, 108, 114, 97, 450, 90, 90, 296, 389,
	109, 609, 363, 587, 579, 612, 449, 403, 394, 608,
	295, 586, 578, 395, 649, 405, 647, 187, 625, 613,
	233, 235, 406, 615, 115, 370, 601, 406, 596, 584,
	516, 406, 406, 406, 352, 436, 356, 357, 406, 370,
	109, 406, 624, 406, 406, 406, 577, 360, 394, 304,
	28, 370, 109, 515, 446, 362, 387, 388, 429, 90,
	394, 520, 606, 411, 386, 410, 428, 358, 385, 588,
	180, 412, 14, 405, 89, 656, 384, 92, 4, 15,
	91, 90, 16, 17, 371, 594, 400, 377, 92, 361,
	659, 657, 14, 653, 651, 645, 360, 589, 371, 15,
	187, 285, 16, 17, 382, 628, 365, 629, 644, 379,
	371, 372, 17, 19, 18, 20, 21, 364, 303, 17,
	634, 408, 13, 98, 523, 96, 95, 94, 86, 86,
	86, 86, 654, 19, 18, 20, 21, 376, 638, 635,
	627, 623, 13, 617, 599, 591, 286, 456, 374, 287,
	378, 284, 375, 621, 233, 235, 620, 373, 643, 521,
	453, 452, 433, 409, 402, 366, 24, 461, 430, 407,
	28, 355, 282, 637, 636, 600, 101, 100, 99, 85,
	583, 123, 11, 582, 11, 11, 522, 381, 302, 300,
	299, 297, 295, 391, 121, 10, 380, 10, 10, 301,
	460, 298, 513, 462, 11, 355, 398, 399, 396, 383,
	122, 9, 5, 9, 9, 455, 23, 10, 74, 431,
	401, 415, 416, 417, 418, 419, 420, 421, 422, 423,
	424, 425, 426, 9, 28, 23, 86, 28, 639, 3,
	26, 27, 22, 640, 283, 279, 280, 12, 229, 230,
	181, 177, 178, 124, 367, 182, 129, 359, 463, 464,
	118, 136, 413, 128, 468, 127, 232, 467, 120, 292,
	291, 445, 571, 525, 427, 470, 432, 236, 434, 133,
	526, 307, 472, 237, 142, 185, 528, 309, 474, 108,
	108, 438, 438, 239, 448, 295, 145, 414, 390, 392,
	466, 454, 442, 440, 107, 294, 458, 75, 443, 7,
	6, 2, 1, 0, 0, 0, 457, 0, 0, 0,
	0, 517, 514, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 518, 519, 0,
	576, 0, 108, 0, 575, 0, 0, 0, 0, 585,
	0, 0, 0, 0, 0, 0, 466, 0, 0, 0,
	0, 0, 581, 0, 0, 0, 0, 0, 0, 0,
	590, 592, 593, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 595, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 597, 0, 0,
	0, 0, 0, 0, 0, 0, 602, 0, 0, 0,
	598, 0, 0, 0, 0, 0, 0, 0, 0, 604,
	603, 0, 0, 0, 0, 0, 0, 0, 0, 607,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 614, 616, 611, 0,
	0, 0, 0, 0, 0, 0, 105, 0, 75, 108,
	619, 618, 0, 0, 626, 622, 0, 0, 0, 0,
	0, 0, 0, 0, 633, 0, 0, 631, 576, 632,
	108, 0, 575, 0, 0, 0, 0, 0, 0, 0,
	0, 642, 0, 0, 0, 646, 0, 0, 0, 0,
	648, 650, 642, 0, 0, 0, 0, 652, 0, 0,
	655, 0, 0, 0, 0, 0, 573, 658, 28, 113,
	110, 31, 32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 0, 0, 0, 0, 109, 0,
	0, 0, 0, 0, 0, 0, 394, 112, 111, 0,
	0, 0, 572, 28, 113, 110, 31, 32, 33, 34,
	35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 0,
	0, 0, 0, 109, 0, 0, 0, 0, 0, 0,
	0, 394, 112, 111, 0, 0, 441, 28, 113, 110,
	31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 0, 0, 0, 0, 109, 0, 0,
	0, 0, 0, 0, 0, 394, 112, 111, 28, 113,
	110, 31, 32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 0, 0, 0, 0, 109, 0,
	0, 0, 0, 0, 293, 0, 0, 112, 111, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 444, 0, 293, 0, 0, 0, 296,
	31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	296, 31, 32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 131, 0, 0, 0, 77,
	146, 147, 148, 149, 150, 151, 17, 152, 153, 154,
	155, 141, 140, 139, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169, 170, 0,
	135, 144, 134, 171, 172, 137, 19, 18, 20, 173,
	174, 175, 176, 0, 0, 130, 0, 0, 0, 0,
	0, 0, 143, 31, 32, 33, 34, 35, 36, 37,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 82, 529, 530, 531, 532,
	533, 534, 535, 536, 537, 538, 539, 540, 541, 542,
	543, 544, 545, 546, 547, 548, 549, 550, 551, 552,
	553, 554, 555, 556, 557, 558, 559, 560, 561, 562,
	563, 564, 565, 566, 567, 568, 569, 524, 570, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 527, 310,
	311, 312, 313, 314, 315, 316, 317, 318, 319, 320,
	321, 322, 323, 324, 325, 326, 327, 328, 329, 330,
	331, 332, 333, 334, 335, 336, 337, 338, 305, 339,
	340, 341, 342, 343, 344, 345, 346, 347, 348, 349,
	350, 351, 0, 0, 0, 0, 0, 234, 0, 0,
	0, 308, 240, 241, 242, 243, 244, 245, 246, 247,
	248, 249, 250, 141, 140, 139, 251, 252, 253, 254,
	255, 256, 257, 258, 259, 260, 261, 262, 263, 264,
	265, 0, 266, 267, 268, 269, 270, 271, 272, 273,
	274, 275, 276, 277, 278, 0, 0, 0, 0, 0,
	469, 0, 0, 0, 238, 475, 476, 477, 478, 479,
	480, 17, 481, 482, 483, 484, 0, 0, 0, 485,
	486, 487, 488, 489, 490, 491, 492, 493, 494, 495,
	496, 497, 498, 499, 471, 500, 501, 502, 503, 504,
	505, 506, 507, 508, 509, 510, 511, 512, 0, 0,
	0, 0, 0, 184, 0, 0, 0, 473, 188, 189,
	190, 191, 192, 193, 17, 194, 195, 196, 197, 198,
	199, 200, 201, 202, 203, 204, 205, 206, 207, 208,
	209, 210, 211, 212, 213, 214, 215, 216, 217, 218,
	219, 220, 221, 186, 222, 223, 224, 225, 226, 227,
	228, 397, 0, 183, 0, 0, 31, 32, 33, 34,
	35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73,
}

var protoPact = [...]int16{
	180, -1000, 200, 200, 225, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 340, 1492, 1024, 1492, 1492,
	1136, 1492, 200, -1000, 343, 237, 343, 343, -1000, 132,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 139, -1000, -1000, 1136, 183, 182,
	181, 110, 1492, 179, 236, -1000, -1000, 235, 234, -1000,
	1492, 844, 1024, 29, 1083, 1401, 1295, 110, 209, -1000,
	-1000, -1000, -1000, 207, -1000, -1000, 342, -1000, -1000, 41,
	-1000, 295, 293, -1000, -1000, -1000, -1000, 173, 1083, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 1242, 1492, 310, 1492, 1492, 276, -1000, -1000,
	-1000, -1000, 140, 1492, 50, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 172, 1401, -1000,
	-1000, -1000, -1000, -1000, -1000, 224, 156, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 166,
	1295, -1000, -1000, -1000, 206, 1242, 1492, 138, 1492, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 164,
	209, -1000, -1000, -1000, -1000, -1000, 1492, -1000, 159, -1000,
	-1000, 963, 126, 114, 56, -1000, 1449, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 1492, 1492, 137, 1492, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 223, 65, -1000, 239, 177, 222, 123, 121,
	342, 1492, 110, 308, -1000, -1000, 144, 116, -1000, 238,
	-1000, 324, -1000, -1000, -1000, 1492, 221, 1492, 110, -1000,
	-1000, 80, -1000, -1000, -1000, -1000, -1000, -1000, 719, 719,
	-1000, -1000, -1000, -1000, 902, 96, 48, 23, 220, 219,
	1492, 110, 320, -1000, 205, 310, 1024, 272, 1348, 307,
	-1000, -1000, 343, -1000, 103, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 88, 144, -1000,
	130, -1000, 218, 291, -1000, 185, 1189, -1000, -1000, -1000,
	-1000, 654, -1000, 95, -1000, 54, -1000, -23, -1000, -1000,
	1492, -1000, 288, 285, -1000, 87, -1000, -1000, 53, -1000,
	128, -1000, -1000, 152, 1348, -1000, -1000, -1000, -1000, 203,
	1492, 1492, 136, 1492, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 86, 342, 1136, -1000, 202, -1000, -1000,
	-1000, 280, 84, 80, 1136, 28, 113, 1492, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 51, -1000, -26, -1000, -1000, -1000, -1000, -1000, 108,
	-1000, 47, 75, 81, -1000, 201, -1000, 1024, 844, -1000,
	-1000, -1000, 215, 212, 1492, 110, -1000, 199, 91, -1000,
	76, -1000, 198, 163, 27, -1000, 1492, 110, -1000, 783,
	-1000, -1000, -1000, 1083, 176, -1000, 197, -1000, -1000, -1000,
	279, 278, -1000, -1000, -1000, -1000, 196, -1000, -1000, 216,
	-1000, -1000, -1000, 150, 1083, -1000, 74, 70, -1000, 149,
	216, -1000, -1000, -1000, -1000, -1000, 148, -1000, 190, 1083,
	131, -1000, -1000, -1000, -1000, 146, 1083, -1000, 145, -1000,
}

var protoPgo = [...]int16{
	0, 422, 421, 322, 349, 420, 419, 1, 13, 416,
	41, 415, 310, 3, 22, 11, 12, 7, 8, 414,
	413, 9, 409, 408, 17, 10, 407, 406, 403, 398,
	397, 396, 395, 34, 21, 394, 393, 392, 391, 390,
	14, 389, 387, 385, 26, 383, 382, 381, 380, 27,
	23, 379, 378, 377, 376, 375, 33, 374, 373, 371,
	320, 40, 370, 0, 15, 369, 368, 367, 366, 365,
	31, 20, 18, 39, 364, 363, 304, 37, 362, 361,
	360, 291, 36, 359, 358, 19, 357, 25, 356, 355,
	354, 6, 353, 348, 16,
}

var protoR1 = [...]int8{
	0, 1, 1, 1, 1, 4, 4, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 2, 5, 5, 5,
	6, 34, 34, 35, 35, 36, 36, 37, 37, 38,
	38, 39, 39, 7, 12, 12, 12, 12, 10, 15,
	15, 16, 16, 16, 19, 19, 19, 19, 19, 19,
	19, 19, 85, 85, 17, 17, 50, 49, 49, 48,
	48, 48, 48, 48, 48, 51, 51, 51, 11, 11,
	11, 11, 14, 14, 14, 23, 23, 18, 18, 18,
	20, 20, 20, 46, 46, 21, 21, 22, 22, 22,
	47, 47, 40, 40, 41, 41, 42, 42, 43, 43,
	44, 44, 45, 45, 33, 33, 33, 13, 9, 9,
	8, 56, 56, 55, 66, 66, 65, 65, 64, 64,
	64, 64, 64, 53, 53, 57, 57, 58, 58, 59,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 75, 75, 73, 73, 71, 71, 71, 74,
	74, 72, 72, 72, 24, 24, 68, 68, 69, 69,
	70, 67, 67, 76, 79, 79, 78, 78, 77, 77,
	77, 77, 77, 80, 80, 60, 63, 63, 62, 62,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 52, 52, 52, 52, 81, 84, 84, 83,
	83, 82, 82, 82, 82, 54, 54, 54, 54, 86,
	89, 89, 88, 88, 87, 87, 87, 87, 90, 90,
	94, 94, 93, 93, 92, 92, 91, 91, 91, 27,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 29, 29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29, 29, 30,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25,
}

var protoR2 = [...]int8{
	0, 1, 1, 2, 0, 2, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 4, 3, 4, 4,
	3, 1, 3, 1, 3, 1, 3, 1, 3, 1,
	3, 1, 3, 5, 1, 3, 1, 3, 3, 1,
	1, 1, 1, 1, 1, 2, 2, 2, 2, 1,
	2, 2, 1, 2, 3, 2, 1, 1, 2, 1,
	2, 2, 2, 2, 1, 3, 2, 3, 1, 3,
	5, 3, 1, 1, 1, 1, 1, 1, 3, 2,
	3, 2, 3, 1, 3, 1, 1, 3, 2, 3,
	1, 3, 1, 2, 1, 2, 1, 2, 1, 2,
	1, 2, 1, 2, 1, 1, 1, 3, 1, 3,
	3, 8, 9, 5, 0, 1, 2, 1, 1, 1,
	1, 2, 1, 5, 6, 7, 8, 5, 6, 6,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 3, 4, 1, 3, 1, 3, 3, 1,
	3, 1, 3, 3, 1, 2, 3, 1, 3, 1,
	3, 1, 3, 5, 0, 1, 2, 1, 1, 1,
	1, 1, 1, 4, 5, 5, 0, 1, 2, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 6, 7, 5, 6, 5, 0, 1, 2,
	1, 1, 1, 2, 1, 6, 7, 5, 6, 5,
	0, 1, 2, 1, 1, 1, 1, 1, 6, 8,
	4, 3, 0, 1, 2, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1,
}

var protoChk = [...]int16{
	-1000, -1, -2, -4, 8, -3, -5, -6, -7, -60,
	-76, -81, -86, 52, 2, 9, 12, 13, 44, 43,
	45, 46, -4, -3, 51, -85, 10, 11, 4, -34,
	-25, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, -12, -25, -10, 65, -25, -25,
	-40, -34, 59, -25, -85, 52, 4, -85, -85, 52,
	59, 51, 59, -40, 54, 54, 54, -34, 54, 52,
	52, 52, -25, -15, -16, -17, -85, -19, -25, 54,
	6, 64, 63, 5, -25, -10, 66, -63, -62, -61,
	-52, -76, -60, -81, -75, -56, -7, -55, -58, -68,
	52, 2, -33, -41, 39, 37, -59, 42, -70, 20,
	19, 18, -35, 59, 38, -27, 7, 8, 9, 10,
	11, 12, 14, 15, 16, 17, 21, 22, 23, 24,
	25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
	35, 40, 41, 46, 47, 48, 49, -79, -78, -77,
	-7, -80, -69, 52, 2, -32, 42, -70, 7, 8,
	9, 10, 11, 12, 14, 15, 16, 17, 18, 19,
	20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 43, 44, 45, 46, 47, 48, 49, -84,
	-83, -82, -54, -56, 2, -33, -42, -36, 59, -28,
	7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	17, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, -89,
	-88, -87, -7, -90, 52, 2, 47, 52, -50, 55,
	-49, -48, -51, 2, -11, -25, 67, 6, 16, 5,
	6, 16, 5, 55, -61, 36, -44, -38, 59, -30,
	7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34, 35, 37,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, -25, -73, -71, 5, -25, -25, -73, -67,
	-85, 59, -34, 62, 55, -77, 51, -74, -72, -24,
	5, 64, 55, -82, 52, -44, -25, 59, -34, 55,
	-87, -25, 55, -49, 60, 52, 60, 52, 53, 53,
	-23, -18, -22, -17, 62, 67, -34, 2, -25, -25,
	59, -34, 51, 52, -13, 60, 67, 40, 54, 51,
	52, 52, 60, -25, -26, 23, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, -24, 60, 52,
	40, 5, -25, 51, -25, -94, 65, -14, -16, -18,
	-20, 67, -14, -50, 61, -47, 68, 2, -18, 68,
	57, 68, 51, 51, -25, 5, 52, -71, -9, -8,
	-12, 5, 41, -66, -65, -64, -7, -53, -57, 2,
	-43, 36, -37, 59, -29, 7, 8, 9, 10, 11,
	12, 14, 15, 16, 17, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
	47, 48, 49, 5, -85, 60, 52, -13, -72, -24,
	41, 51, 5, 49, 48, -45, -39, 59, -31, 7,
	8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
	18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	49, -46, 68, 2, -21, -16, -18, 61, 68, 60,
	68, -34, 5, 5, 52, -13, 68, 60, 51, 55,
	-64, 52, -25, -25, 59, -34, 52, -13, -40, 52,
	5, 52, -13, -94, -40, 66, 59, -34, 68, 60,
	68, -18, 68, 54, -13, 52, -13, 52, -8, -15,
	51, 51, -25, 52, 61, 52, -13, 52, 52, 54,
	66, -25, -21, -63, 54, 52, 5, 5, 52, -93,
	-92, -91, -7, 52, 2, 55, -63, 52, -13, 54,
	-13, 55, -91, 55, 52, -63, 54, 55, -63, 55,
}

var protoDef = [...]int16{
	-2, -2, -2, -2, 0, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 0, 0, 0, 0, 0,
	0, 0, -2, 5, 0, 0, 0, 0, 52, 0,
	21, 463, 464, 465, 466, 467, 468, 469, 470, 471,
	472, 473, 474, 475, 476, 477, 478, 479, 480, 481,
	482, 483, 484, 485, 486, 487, 488, 489, 490, 491,
	492, 493, 494, 495, 496, 497, 498, 499, 500, 501,
	502, 503, 504, 505, 0, 34, 36, 0, 0, 0,
	0, 92, 0, 0, 0, 17, 53, 0, 0, 20,
	0, 0, 0, 0, -2, -2, -2, 93, -2, 16,
	18, 19, 22, 0, 39, 40, 41, 42, 43, 0,
	44, 0, 0, 49, 35, 37, 38, 0, -2, 179,
	180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
	190, 191, 0, 0, 0, 0, 0, 0, 157, 104,
	105, 106, 94, 0, 254, 23, 229, 230, 231, 232,
	233, 234, 235, 236, 237, 238, 239, 240, 241, 242,
	243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
	253, 255, 256, 257, 258, 259, 260, 0, -2, 167,
	168, 169, 170, 171, 172, 0, 0, 159, 300, 301,
	302, 303, 304, 305, 306, 307, 308, 309, 310, 311,
	312, 313, 314, 315, 316, 317, 318, 319, 320, 321,
	322, 323, 324, 325, 326, 327, 328, 329, 330, 331,
	332, 333, 334, 335, 336, 337, 338, 339, 340, 0,
	-2, 200, 201, 202, 204, 0, 0, 96, 0, 25,
	261, 262, 263, 264, 265, 266, 267, 268, 269, 270,
	271, 272, 273, 274, 275, 276, 277, 278, 279, 280,
	281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
	291, 292, 293, 294, 295, 296, 297, 298, 299, 0,
	-2, 213, 214, 215, 216, 217, 0, 33, 0, 55,
	56, -2, 59, 64, 0, 68, 0, 45, 48, 51,
	46, 47, 50, 175, 178, 0, 0, 100, 0, 29,
	379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
	389, 390, 391, 392, 393, 394, 395, 396, 397, 398,
	399, 400, 401, 402, 403, 404, 405, 406, 407, 408,
	409, 410, 411, 412, 413, 414, 415, 416, 417, 418,
	419, 420, 0, 0, 144, 146, 0, 0, 0, 0,
	161, 0, 95, 0, 163, 166, 0, 0, 149, 151,
	154, 0, 196, 199, 203, 0, 0, 0, 97, 209,
	212, 0, 54, 58, 60, 61, 62, 63, 0, 0,
	66, 75, 76, 77, 0, 0, 0, 0, 0, 0,
	0, 101, 0, 142, 0, 0, 0, 0, -2, 0,
	156, 160, 0, 24, 0, 130, 131, 132, 133, 134,
	135, 136, 137, 138, 139, 140, 141, 0, 0, 158,
	0, 155, 0, 0, 26, 0, 0, 67, 72, 73,
	74, 0, 65, 0, 79, 0, 88, 0, 90, 69,
	0, 71, 0, 0, 30, 0, 143, 145, 0, 108,
	0, 147, 148, 0, -2, 117, 118, 119, 120, 122,
	0, 0, 98, 0, 27, 341, 342, 343, 344, 345,
	346, 347, 348, 349, 350, 351, 352, 353, 354, 355,
	356, 357, 358, 359, 360, 361, 362, 363, 364, 365,
	366, 367, 368, 369, 370, 371, 372, 373, 374, 375,
	376, 377, 378, 0, 162, 0, 173, 0, 150, 152,
	153, 0, 0, 0, 0, 0, 102, 0, 31, 421,
	422, 423, 424, 425, 426, 427, 428, 429, 430, 431,
	432, 433, 434, 435, 436, 437, 438, 439, 440, 441,
	442, 443, 444, 445, 446, 447, 448, 449, 450, 451,
	452, 453, 454, 455, 456, 457, 458, 459, 460, 461,
	462, 0, 81, 0, 83, 85, 86, 78, 87, 0,
	89, 0, 0, 0, 194, 0, 107, 0, 0, 113,
	116, 121, 0, 0, 0, 99, 127, 0, 0, 174,
	0, 207, 0, 0, 0, 221, 0, 103, 80, 0,
	82, 91, 70, -2, 0, 192, 0, 195, 109, 110,
	0, 0, 28, 128, 129, 205, 0, 208, 218, -2,
	220, 32, 84, 0, -2, 193, 0, 0, 206, 0,
	-2, 225, 226, 227, 228, 111, 0, 123, 0, -2,
	0, 219, 224, 112, 124, 0, -2, 125, 0, 126,
}

var protoTok1 = [...]int8{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 76, 3, 74, 73, 72, 70, 3,
	65, 66, 69, 63, 60, 64, 59, 57, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 53, 52,
	62, 51, 61, 58, 75, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 67, 56, 68, 71, 3, 78, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 54, 3, 55, 77,
}

var protoTok2 = [...]int8{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50,
}

var protoTok3 = [...]int8{
	0,
}

var protoErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

/*	parser for yacc output	*/

var (
	protoDebug        = 0
	protoErrorVerbose = false
)

type protoLexer interface {
	Lex(lval *protoSymType) int
	Error(s string)
}

type protoParser interface {
	Parse(protoLexer) int
	Lookahead() int
}

type protoParserImpl struct {
	lval  protoSymType
	stack [protoInitialStackSize]protoSymType
	char  int
}

func (p *protoParserImpl) Lookahead() int {
	return p.char
}

func protoNewParser() protoParser {
	return &protoParserImpl{}
}

const protoFlag = -1000

func protoTokname(c int) string {
	if c >= 1 && c-1 < len(protoToknames) {
		if protoToknames[c-1] != "" {
			return protoToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func protoStatname(s int) string {
	if s >= 0 && s < len(protoStatenames) {
		if protoStatenames[s] != "" {
			return protoStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func protoErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !protoErrorVerbose {
		return "syntax error"
	}

	for _, e := range protoErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + protoTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := int(protoPact[state])
	for tok := TOKSTART; tok-1 < len(protoToknames); tok++ {
		if n := base + tok; n >= 0 && n < protoLast && int(protoChk[int(protoAct[n])]) == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if protoDef[state] == -2 {
		i := 0
		for protoExca[i] != -1 || int(protoExca[i+1]) != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; protoExca[i] >= 0; i += 2 {
			tok := int(protoExca[i])
			if tok < TOKSTART || protoExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if protoExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += protoTokname(tok)
	}
	return res
}

func protolex1(lex protoLexer, lval *protoSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = int(protoTok1[0])
		goto out
	}
	if char < len(protoTok1) {
		token = int(protoTok1[char])
		goto out
	}
	if char >= protoPrivate {
		if char < protoPrivate+len(protoTok2) {
			token = int(protoTok2[char-protoPrivate])
			goto out
		}
	}
	for i := 0; i < len(protoTok3); i += 2 {
		token = int(protoTok3[i+0])
		if token == char {
			token = int(protoTok3[i+1])
			goto out
		}
	}

out:
	if token == 0 {
		token = int(protoTok2[1]) /* unknown char */
	}
	if protoDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", protoTokname(token), uint(char))
	}
	return char, token
}

func protoParse(protolex protoLexer) int {
	return protoNewParser().Parse(protolex)
}

func (protorcvr *protoParserImpl) Parse(protolex protoLexer) int {
	var proton int
	var protoVAL protoSymType
	var protoDollar []protoSymType
	_ = protoDollar // silence set and not used
	protoS := protorcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	protostate := 0
	protorcvr.char = -1
	prototoken := -1 // protorcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		protostate = -1
		protorcvr.char = -1
		prototoken = -1
	}()
	protop := -1
	goto protostack

ret0:
	return 0

ret1:
	return 1

protostack:
	/* put a state and value onto the stack */
	if protoDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", protoTokname(prototoken), protoStatname(protostate))
	}

	protop++
	if protop >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoS[protop] = protoVAL
	protoS[protop].yys = protostate

protonewstate:
	proton = int(protoPact[protostate])
	if proton <= protoFlag {
		goto protodefault /* simple state */
	}
	if protorcvr.char < 0 {
		protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
	}
	proton += prototoken
	if proton < 0 || proton >= protoLast {
		goto protodefault
	}
	proton = int(protoAct[proton])
	if int(protoChk[proton]) == prototoken { /* valid shift */
		protorcvr.char = -1
		prototoken = -1
		protoVAL = protorcvr.lval
		protostate = proton
		if Errflag > 0 {
			Errflag--
		}
		goto protostack
	}

protodefault:
	/* default state action */
	proton = int(protoDef[protostate])
	if proton == -2 {
		if protorcvr.char < 0 {
			protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if protoExca[xi+0] == -1 && int(protoExca[xi+1]) == protostate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			proton = int(protoExca[xi+0])
			if proton < 0 || proton == prototoken {
				break
			}
		}
		proton = int(protoExca[xi+1])
		if proton < 0 {
			goto ret0
		}
	}
	if proton == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			protolex.Error(protoErrorMessage(protostate, prototoken))
			Nerrs++
			if protoDebug >= 1 {
				__yyfmt__.Printf("%s", protoStatname(protostate))
				__yyfmt__.Printf(" saw %s\n", protoTokname(prototoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for protop >= 0 {
				proton = int(protoPact[protoS[protop].yys]) + protoErrCode
				if proton >= 0 && proton < protoLast {
					protostate = int(protoAct[proton]) /* simulate a shift of "error" */
					if int(protoChk[protostate]) == protoErrCode {
						goto protostack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if protoDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", protoS[protop].yys)
				}
				protop--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if protoDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", protoTokname(prototoken))
			}
			if prototoken == protoEofCode {
				goto ret1
			}
			protorcvr.char = -1
			prototoken = -1
			goto protonewstate /* try again in the same state */
		}
	}

	/* reduction by production proton */
	if protoDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", proton, protoStatname(protostate))
	}

	protont := proton
	protopt := protop
	_ = protopt // guard against "declared and not used"

	protop -= int(protoR2[proton])
	// protop is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if protop+1 >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoVAL = protoS[protop+1]

	/* consult goto table to find next state */
	proton = int(protoR1[proton])
	protog := int(protoPgo[proton])
	protoj := protog + protoS[protop].yys + 1

	if protoj >= protoLast {
		protostate = int(protoAct[protog])
	} else {
		protostate = int(protoAct[protoj])
		if int(protoChk[protostate]) != -proton {
			protostate = int(protoAct[protog])
		}
	}
	// dummy call; replaced with literal code
	switch protont {

	case 1:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 2:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, protoDollar[1].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 3:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 4:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 5:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].fileElement != nil {
				protoVAL.fileElements = append(protoDollar[1].fileElements, protoDollar[2].fileElement)
			} else {
				protoVAL.fileElements = protoDollar[1].fileElements
			}
		}
	case 6:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].fileElement != nil {
				protoVAL.fileElements = []ast.FileElement{protoDollar[1].fileElement}
			} else {
				protoVAL.fileElements = nil
			}
		}
	case 7:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].imprt
		}
	case 8:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].pkg
		}
	case 9:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].opt
		}
	case 10:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].msg
		}
	case 11:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].en
		}
	case 12:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].extend
		}
	case 13:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = protoDollar[1].svc
		}
	case 14:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 15:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElement = nil
		}
	case 16:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.syn = ast.NewSyntaxNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 17:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.imprt = ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, nil, toStringValueNode(protoDollar[2].str), protoDollar[3].b)
		}
	case 18:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.imprt = ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, protoDollar[2].id.ToKeyword(), toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 19:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.imprt = ast.NewImportNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), nil, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 20:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.pkg = ast.NewPackageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 21:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 22:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 23:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 24:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 25:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 26:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 27:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 28:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 29:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 30:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 31:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 32:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 33:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			protoVAL.opt = ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, protoDollar[5].b)
		}
	case 34:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			fieldReferenceNode := ast.NewFieldReferenceNode(protoDollar[1].id)
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{fieldReferenceNode}}
		}
	case 35:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, ast.NewFieldReferenceNode(protoDollar[3].id))
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].b)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 36:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{protoDollar[1].ref}}
		}
	case 37:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, protoDollar[3].ref)
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].b)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 38:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].tid, protoDollar[3].b)
		}
	case 41:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = toStringValueNode(protoDollar[1].str)
		}
	case 43:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 44:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].f
		}
	case 45:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 46:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 47:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 48:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 49:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].i
		}
	case 50:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewPositiveUintLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 51:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].i.Val > math.MaxInt64+1 {
				// can't represent as int so treat as float literal
				protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].i)
			} else {
				protoVAL.v = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
			}
		}
	case 52:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.str = []*ast.StringLiteralNode{protoDollar[1].s}
		}
	case 53:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.str = append(protoDollar[1].str, protoDollar[2].s)
		}
	case 54:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 55:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 58:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFlds != nil {
				protoDollar[1].msgLitFlds.next = protoDollar[2].msgLitFlds
				protoVAL.msgLitFlds = protoDollar[1].msgLitFlds
			} else {
				protoVAL.msgLitFlds = protoDollar[2].msgLitFlds
			}
		}
	case 59:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 60:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 61:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 62:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 63:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 64:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 65:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].ref, protoDollar[2].b, protoDollar[3].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 66:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].ref, nil, protoDollar[2].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 67:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.msgLitFld = nil
		}
	case 68:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ref = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 69:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 70:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.ref = ast.NewAnyTypeReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b, protoDollar[4].cid.toIdentValueNode(nil), protoDollar[5].b)
		}
	case 71:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = nil
		}
	case 78:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 79:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 80:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 81:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 82:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = nil
		}
	case 83:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 84:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 87:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 88:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 89:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = nil
		}
	case 90:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 91:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 92:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 93:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 94:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 95:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 96:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 97:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 98:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 99:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 100:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 101:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 102:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 103:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 107:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, protoDollar[2].opts.options, protoDollar[2].opts.commas, protoDollar[3].b)
		}
	case 108:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionSlices{options: []*ast.OptionNode{protoDollar[1].opt}}
		}
	case 109:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].opts.options = append(protoDollar[1].opts.options, protoDollar[3].opt)
			protoDollar[1].opts.commas = append(protoDollar[1].opts.commas, protoDollar[2].b)
			protoVAL.opts = protoDollar[1].opts
		}
	case 110:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protoVAL.opt = ast.NewCompactOptionNode(optName, protoDollar[2].b, protoDollar[3].v)
		}
	case 111:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 112:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b)
		}
	case 113:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.oo = ast.NewOneofNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].ooElements, protoDollar[5].b)
		}
	case 114:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.ooElements = nil
		}
	case 116:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].ooElement != nil {
				protoVAL.ooElements = append(protoDollar[1].ooElements, protoDollar[2].ooElement)
			} else {
				protoVAL.ooElements = protoDollar[1].ooElements
			}
		}
	case 117:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].ooElement != nil {
				protoVAL.ooElements = []ast.OneofElement{protoDollar[1].ooElement}
			} else {
				protoVAL.ooElements = nil
			}
		}
	case 118:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].opt
		}
	case 119:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].fld
		}
	case 120:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].grp
		}
	case 121:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 122:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 123:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 124:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 125:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b, protoDollar[6].msgElements, protoDollar[7].b)
		}
	case 126:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 127:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.mapFld = ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 128:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapFld = ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 129:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapType = ast.NewMapTypeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, protoDollar[3].id, protoDollar[4].b, protoDollar[5].tid, protoDollar[6].b)
		}
	case 142:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ext = ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, nil, protoDollar[3].b)
		}
	case 143:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.ext = ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].cmpctOpts, protoDollar[4].b)
		}
	case 144:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 145:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 146:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, nil, nil, nil)
		}
	case 147:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), protoDollar[3].i, nil)
		}
	case 148:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 149:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 150:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 151:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, nil, nil, nil)
		}
	case 152:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), protoDollar[3].il, nil)
		}
	case 153:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 154:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.il = protoDollar[1].i
		}
	case 155:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.il = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 156:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.resvd = ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b)
		}
	case 158:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.resvd = ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b)
		}
	case 160:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.resvd = ast.NewReservedNamesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.names, protoDollar[2].names.commas, protoDollar[3].b)
		}
	case 161:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{names: []ast.StringValueNode{toStringValueNode(protoDollar[1].str)}}
		}
	case 162:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.names = append(protoDollar[1].names.names, toStringValueNode(protoDollar[3].str))
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 163:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.en = ast.NewEnumNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].enElements, protoDollar[5].b)
		}
	case 164:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.enElements = nil
		}
	case 166:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].enElement != nil {
				protoVAL.enElements = append(protoDollar[1].enElements, protoDollar[2].enElement)
			} else {
				protoVAL.enElements = protoDollar[1].enElements
			}
		}
	case 167:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].enElement != nil {
				protoVAL.enElements = []ast.EnumElement{protoDollar[1].enElement}
			} else {
				protoVAL.enElements = nil
			}
		}
	case 168:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElement = protoDollar[1].opt
		}
	case 169:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElement = protoDollar[1].env
		}
	case 170:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElement = protoDollar[1].resvd
		}
	case 171:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElement = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 172:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElement = nil
		}
	case 173:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.env = ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, nil, protoDollar[4].b)
		}
	case 174:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.env = ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, protoDollar[4].cmpctOpts, protoDollar[5].b)
		}
	case 175:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.msg = ast.NewMessageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].msgElements, protoDollar[5].b)
		}
	case 176:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.msgElements = nil
		}
	case 178:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].msgElement != nil {
				protoVAL.msgElements = append(protoDollar[1].msgElements, protoDollar[2].msgElement)
			} else {
				protoVAL.msgElements = protoDollar[1].msgElements
			}
		}
	case 179:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgElement != nil {
				protoVAL.msgElements = []ast.MessageElement{protoDollar[1].msgElement}
			} else {
				protoVAL.msgElements = nil
			}
		}
	case 180:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].fld
		}
	case 181:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].en
		}
	case 182:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].msg
		}
	case 183:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].extend
		}
	case 184:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].ext
		}
	case 185:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].grp
		}
	case 186:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].opt
		}
	case 187:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].oo
		}
	case 188:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].mapFld
		}
	case 189:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = protoDollar[1].resvd
		}
	case 190:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 191:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElement = nil
		}
	case 192:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 193:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 194:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 195:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 196:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.extend = ast.NewExtendNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].b, protoDollar[4].extElements, protoDollar[5].b)
		}
	case 197:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.extElements = nil
		}
	case 199:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].extElement != nil {
				protoVAL.extElements = append(protoDollar[1].extElements, protoDollar[2].extElement)
			} else {
				protoVAL.extElements = protoDollar[1].extElements
			}
		}
	case 200:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].extElement != nil {
				protoVAL.extElements = []ast.ExtendElement{protoDollar[1].extElement}
			} else {
				protoVAL.extElements = nil
			}
		}
	case 201:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].fld
		}
	case 202:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].grp
		}
	case 203:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 204:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 205:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 206:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 207:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 208:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 209:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.svc = ast.NewServiceNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].svcElements, protoDollar[5].b)
		}
	case 210:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.svcElements = nil
		}
	case 212:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].svcElement != nil {
				protoVAL.svcElements = append(protoDollar[1].svcElements, protoDollar[2].svcElement)
			} else {
				protoVAL.svcElements = protoDollar[1].svcElements
			}
		}
	case 213:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].svcElement != nil {
				protoVAL.svcElements = []ast.ServiceElement{protoDollar[1].svcElement}
			} else {
				protoVAL.svcElements = nil
			}
		}
	case 214:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElement = protoDollar[1].opt
		}
	case 215:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElement = protoDollar[1].mtd
		}
	case 216:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElement = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 217:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElement = nil
		}
	case 218:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mtd = ast.NewRPCNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, protoDollar[6].b)
		}
	case 219:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.mtd = ast.NewRPCNodeWithBody(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, protoDollar[6].b, protoDollar[7].mtdElements, protoDollar[8].b)
		}
	case 220:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, protoDollar[2].id.ToKeyword(), protoDollar[3].tid, protoDollar[4].b)
		}
	case 221:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, nil, protoDollar[2].tid, protoDollar[3].b)
		}
	case 222:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.mtdElements = nil
		}
	case 224:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].mtdElement != nil {
				protoVAL.mtdElements = append(protoDollar[1].mtdElements, protoDollar[2].mtdElement)
			} else {
				protoVAL.mtdElements = protoDollar[1].mtdElements
			}
		}
	case 225:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].mtdElement != nil {
				protoVAL.mtdElements = []ast.RPCElement{protoDollar[1].mtdElement}
			} else {
				protoVAL.mtdElements = nil
			}
		}
	case 226:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElement = protoDollar[1].opt
		}
	case 227:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElement = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 228:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElement = nil
		}
	}
	goto protostack /* stack new state and value */
}
