// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssooidciface provides an interface to enable mocking the AWS SSO OIDC service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssooidciface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssooidc"
)

// SSOOIDCAPI provides an interface to enable mocking the
// ssooidc.SSOOIDC service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS SSO OIDC.
//	func myFunc(svc ssooidciface.SSOOIDCAPI) bool {
//	    // Make svc.CreateToken request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := ssooidc.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSSOOIDCClient struct {
//	    ssooidciface.SSOOIDCAPI
//	}
//	func (m *mockSSOOIDCClient) CreateToken(input *ssooidc.CreateTokenInput) (*ssooidc.CreateTokenOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSSOOIDCClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SSOOIDCAPI interface {
	CreateToken(*ssooidc.CreateTokenInput) (*ssooidc.CreateTokenOutput, error)
	CreateTokenWithContext(aws.Context, *ssooidc.CreateTokenInput, ...request.Option) (*ssooidc.CreateTokenOutput, error)
	CreateTokenRequest(*ssooidc.CreateTokenInput) (*request.Request, *ssooidc.CreateTokenOutput)

	RegisterClient(*ssooidc.RegisterClientInput) (*ssooidc.RegisterClientOutput, error)
	RegisterClientWithContext(aws.Context, *ssooidc.RegisterClientInput, ...request.Option) (*ssooidc.RegisterClientOutput, error)
	RegisterClientRequest(*ssooidc.RegisterClientInput) (*request.Request, *ssooidc.RegisterClientOutput)

	StartDeviceAuthorization(*ssooidc.StartDeviceAuthorizationInput) (*ssooidc.StartDeviceAuthorizationOutput, error)
	StartDeviceAuthorizationWithContext(aws.Context, *ssooidc.StartDeviceAuthorizationInput, ...request.Option) (*ssooidc.StartDeviceAuthorizationOutput, error)
	StartDeviceAuthorizationRequest(*ssooidc.StartDeviceAuthorizationInput) (*request.Request, *ssooidc.StartDeviceAuthorizationOutput)
}

var _ SSOOIDCAPI = (*ssooidc.SSOOIDC)(nil)
