package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FtFlowSpecial invokes the ft.FtFlowSpecial API synchronously
func (client *Client) FtFlowSpecial(request *FtFlowSpecialRequest) (response *FtFlowSpecialResponse, err error) {
	response = CreateFtFlowSpecialResponse()
	err = client.DoAction(request, response)
	return
}

// FtFlowSpecialWithChan invokes the ft.FtFlowSpecial API asynchronously
func (client *Client) FtFlowSpecialWithChan(request *FtFlowSpecialRequest) (<-chan *FtFlowSpecialResponse, <-chan error) {
	responseChan := make(chan *FtFlowSpecialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FtFlowSpecial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FtFlowSpecialWithCallback invokes the ft.FtFlowSpecial API asynchronously
func (client *Client) FtFlowSpecialWithCallback(request *FtFlowSpecialRequest, callback func(response *FtFlowSpecialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FtFlowSpecialResponse
		var err error
		defer close(result)
		response, err = client.FtFlowSpecial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FtFlowSpecialRequest is the request struct for api FtFlowSpecial
type FtFlowSpecialRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// FtFlowSpecialResponse is the response struct for api FtFlowSpecial
type FtFlowSpecialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Name      string `json:"Name" xml:"Name"`
}

// CreateFtFlowSpecialRequest creates a request to invoke FtFlowSpecial API
func CreateFtFlowSpecialRequest() (request *FtFlowSpecialRequest) {
	request = &FtFlowSpecialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "FtFlowSpecial", "", "")
	request.Method = requests.POST
	return
}

// CreateFtFlowSpecialResponse creates a response to parse from FtFlowSpecial response
func CreateFtFlowSpecialResponse() (response *FtFlowSpecialResponse) {
	response = &FtFlowSpecialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
