package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLogicDatabase invokes the dms_enterprise.CreateLogicDatabase API synchronously
func (client *Client) CreateLogicDatabase(request *CreateLogicDatabaseRequest) (response *CreateLogicDatabaseResponse, err error) {
	response = CreateCreateLogicDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLogicDatabaseWithChan invokes the dms_enterprise.CreateLogicDatabase API asynchronously
func (client *Client) CreateLogicDatabaseWithChan(request *CreateLogicDatabaseRequest) (<-chan *CreateLogicDatabaseResponse, <-chan error) {
	responseChan := make(chan *CreateLogicDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLogicDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLogicDatabaseWithCallback invokes the dms_enterprise.CreateLogicDatabase API asynchronously
func (client *Client) CreateLogicDatabaseWithCallback(request *CreateLogicDatabaseRequest, callback func(response *CreateLogicDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLogicDatabaseResponse
		var err error
		defer close(result)
		response, err = client.CreateLogicDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLogicDatabaseRequest is the request struct for api CreateLogicDatabase
type CreateLogicDatabaseRequest struct {
	*requests.RpcRequest
	Tid         requests.Integer `position:"Query" name:"Tid"`
	DatabaseIds *[]string        `position:"Query" name:"DatabaseIds"  type:"Json"`
	Alias       string           `position:"Query" name:"Alias"`
}

// CreateLogicDatabaseResponse is the response struct for api CreateLogicDatabase
type CreateLogicDatabaseResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	LogicDbId    int64  `json:"LogicDbId" xml:"LogicDbId"`
}

// CreateCreateLogicDatabaseRequest creates a request to invoke CreateLogicDatabase API
func CreateCreateLogicDatabaseRequest() (request *CreateLogicDatabaseRequest) {
	request = &CreateLogicDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateLogicDatabase", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLogicDatabaseResponse creates a response to parse from CreateLogicDatabase response
func CreateCreateLogicDatabaseResponse() (response *CreateLogicDatabaseResponse) {
	response = &CreateLogicDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
