package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEvents invokes the cloudphoto.ListEvents API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/listevents.html
func (client *Client) ListEvents(request *ListEventsRequest) (response *ListEventsResponse, err error) {
	response = CreateListEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEventsWithChan invokes the cloudphoto.ListEvents API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEventsWithChan(request *ListEventsRequest) (<-chan *ListEventsResponse, <-chan error) {
	responseChan := make(chan *ListEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEventsWithCallback invokes the cloudphoto.ListEvents API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEventsWithCallback(request *ListEventsRequest, callback func(response *ListEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEventsResponse
		var err error
		defer close(result)
		response, err = client.ListEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEventsRequest is the request struct for api ListEvents
type ListEventsRequest struct {
	*requests.RpcRequest
	Cursor    string           `position:"Query" name:"Cursor"`
	Size      requests.Integer `position:"Query" name:"Size"`
	StoreName string           `position:"Query" name:"StoreName"`
	State     string           `position:"Query" name:"State"`
	Direction string           `position:"Query" name:"Direction"`
}

// ListEventsResponse is the response struct for api ListEvents
type ListEventsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	NextCursor string  `json:"NextCursor" xml:"NextCursor"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Action     string  `json:"Action" xml:"Action"`
	Events     []Event `json:"Events" xml:"Events"`
}

// CreateListEventsRequest creates a request to invoke ListEvents API
func CreateListEventsRequest() (request *ListEventsRequest) {
	request = &ListEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "ListEvents", "cloudphoto", "openAPI")
	return
}

// CreateListEventsResponse creates a response to parse from ListEvents response
func CreateListEventsResponse() (response *ListEventsResponse) {
	response = &ListEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
