package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssignRolesToUser invokes the cloudcallcenter.AssignRolesToUser API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/assignrolestouser.html
func (client *Client) AssignRolesToUser(request *AssignRolesToUserRequest) (response *AssignRolesToUserResponse, err error) {
	response = CreateAssignRolesToUserResponse()
	err = client.DoAction(request, response)
	return
}

// AssignRolesToUserWithChan invokes the cloudcallcenter.AssignRolesToUser API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/assignrolestouser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssignRolesToUserWithChan(request *AssignRolesToUserRequest) (<-chan *AssignRolesToUserResponse, <-chan error) {
	responseChan := make(chan *AssignRolesToUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssignRolesToUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssignRolesToUserWithCallback invokes the cloudcallcenter.AssignRolesToUser API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/assignrolestouser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssignRolesToUserWithCallback(request *AssignRolesToUserRequest, callback func(response *AssignRolesToUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssignRolesToUserResponse
		var err error
		defer close(result)
		response, err = client.AssignRolesToUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssignRolesToUserRequest is the request struct for api AssignRolesToUser
type AssignRolesToUserRequest struct {
	*requests.RpcRequest
	InstanceId string    `position:"Query" name:"InstanceId"`
	RoleId     *[]string `position:"Query" name:"RoleId"  type:"Repeated"`
	UserId     string    `position:"Query" name:"UserId"`
}

// AssignRolesToUserResponse is the response struct for api AssignRolesToUser
type AssignRolesToUserResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	User           User   `json:"User" xml:"User"`
}

// CreateAssignRolesToUserRequest creates a request to invoke AssignRolesToUser API
func CreateAssignRolesToUserRequest() (request *AssignRolesToUserRequest) {
	request = &AssignRolesToUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AssignRolesToUser", "", "")
	request.Method = requests.POST
	return
}

// CreateAssignRolesToUserResponse creates a response to parse from AssignRolesToUser response
func CreateAssignRolesToUserResponse() (response *AssignRolesToUserResponse) {
	response = &AssignRolesToUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
