package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSuspiciousOverallConfig invokes the aegis.DescribeSuspiciousOverallConfig API synchronously
// api document: https://help.aliyun.com/api/aegis/describesuspiciousoverallconfig.html
func (client *Client) DescribeSuspiciousOverallConfig(request *DescribeSuspiciousOverallConfigRequest) (response *DescribeSuspiciousOverallConfigResponse, err error) {
	response = CreateDescribeSuspiciousOverallConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSuspiciousOverallConfigWithChan invokes the aegis.DescribeSuspiciousOverallConfig API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspiciousoverallconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspiciousOverallConfigWithChan(request *DescribeSuspiciousOverallConfigRequest) (<-chan *DescribeSuspiciousOverallConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeSuspiciousOverallConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSuspiciousOverallConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSuspiciousOverallConfigWithCallback invokes the aegis.DescribeSuspiciousOverallConfig API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspiciousoverallconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspiciousOverallConfigWithCallback(request *DescribeSuspiciousOverallConfigRequest, callback func(response *DescribeSuspiciousOverallConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSuspiciousOverallConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeSuspiciousOverallConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSuspiciousOverallConfigRequest is the request struct for api DescribeSuspiciousOverallConfig
type DescribeSuspiciousOverallConfigRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Type     string `position:"Query" name:"Type"`
}

// DescribeSuspiciousOverallConfigResponse is the response struct for api DescribeSuspiciousOverallConfig
type DescribeSuspiciousOverallConfigResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	OverallConfig OverallConfig `json:"OverallConfig" xml:"OverallConfig"`
}

// CreateDescribeSuspiciousOverallConfigRequest creates a request to invoke DescribeSuspiciousOverallConfig API
func CreateDescribeSuspiciousOverallConfigRequest() (request *DescribeSuspiciousOverallConfigRequest) {
	request = &DescribeSuspiciousOverallConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSuspiciousOverallConfig", "vipaegis", "openAPI")
	return
}

// CreateDescribeSuspiciousOverallConfigResponse creates a response to parse from DescribeSuspiciousOverallConfig response
func CreateDescribeSuspiciousOverallConfigResponse() (response *DescribeSuspiciousOverallConfigResponse) {
	response = &DescribeSuspiciousOverallConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
