#!/bin/sh

# This test makes sure that reading and writing CSVs with escaped comma
# characters works correctly.

set -e
set -u
set -x

trap "rm -f ./output*" EXIT

# Test loading input using -D/--csv-comma
rm -f ./output1.json
"$RQ" --csv-headers --csv-comma '\t' --data ./input.csv data > output1.json
diff output1.json expected.json

# Test loading input using a DataSpec
rm -f ./output2.json
"$RQ" --data 'csv:csv.comma=\t;csv.headers=true:./input.csv' data > output2.json
diff output2.json expected.json

# Test loading input using a DataSpec in JSON format
rm -f ./output3.json
"$RQ" --data '{"format": "csv", "file_path": "./input.csv", "options": {"csv.headers": true, "csv.comma": "\t"}}' data > output3.json
diff output3.json expected.json

# Test writing back out to CSV using -o/--output-format with -D/--csv-comma
rm -f ./output4.csv
"$RQ" -I ./expected.json -o csv -D '\t' input.input > output4.csv
diff output4.csv input.csv

# Test writing back out to CSV using -O/--output
rm -f ./output5.csv
"$RQ" -I ./expected.json -O 'csv:csv.comma=\t:./output5.csv' input.input
diff output5.csv input.csv

# Test the tsv aliases end-to-end
rm -f ./output6.csv
"$RQ" -I tsv:./input.csv -O output6.tsv
diff output6.tsv input.csv
