/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import org.w3c.dom.Element;

public final class Ability
extends Feature {
    public static final String ADD_TAX_TO_BELLS = "model.ability.addTaxToBells";
    public static final String ALWAYS_OFFERED_PEACE = "model.ability.alwaysOfferedPeace";
    public static final String AMBUSH_BONUS = "model.ability.ambushBonus";
    public static final String AMBUSH_PENALTY = "model.ability.ambushPenalty";
    public static final String AMBUSH_TERRAIN = "model.ability.ambushTerrain";
    public static final String ARMED = "model.ability.armed";
    public static final String AUTOMATIC_EQUIPMENT = "model.ability.automaticEquipment";
    public static final String AUTOMATIC_PROMOTION = "model.ability.automaticPromotion";
    public static final String AUTO_PRODUCTION = "model.ability.autoProduction";
    public static final String AVOID_EXCESS_PRODUCTION = "model.ability.avoidExcessProduction";
    public static final String BETTER_FOREIGN_AFFAIRS_REPORT = "model.ability.betterForeignAffairsReport";
    public static final String BOMBARD = "model.ability.bombard";
    public static final String BOMBARD_SHIPS = "model.ability.bombardShips";
    public static final String BORN_IN_COLONY = "model.ability.bornInColony";
    public static final String BORN_IN_INDIAN_SETTLEMENT = "model.ability.bornInIndianSettlement";
    public static final String BUILD = "model.ability.build";
    public static final String BUILD_CUSTOM_HOUSE = "model.ability.buildCustomHouse";
    public static final String BUILD_FACTORY = "model.ability.buildFactory";
    public static final String CAN_BE_CAPTURED = "model.ability.canBeCaptured";
    public static final String CAN_BE_EQUIPPED = "model.ability.canBeEquipped";
    public static final String CAN_RECRUIT_UNIT = "model.ability.canRecruitUnit";
    public static final String CAPTURE_EQUIPMENT = "model.ability.captureEquipment";
    public static final String CAPTURE_GOODS = "model.ability.captureGoods";
    public static final String CAPTURE_UNITS = "model.ability.captureUnits";
    public static final String CARRY_GOODS = "model.ability.carryGoods";
    public static final String CARRY_TREASURE = "model.ability.carryTreasure";
    public static final String CARRY_UNITS = "model.ability.carryUnits";
    public static final String COASTAL_ONLY = "model.ability.coastalOnly";
    public static final String CONSUME_ALL_OR_NOTHING = "model.ability.consumeAllOrNothing";
    public static final String CUSTOM_HOUSE_TRADES_WITH_FOREIGN_COUNTRIES = "model.ability.customHouseTradesWithForeignCountries";
    public static final String DEMAND_TRIBUTE = "model.ability.demandTribute";
    public static final String DEMOTE_ON_ALL_EQUIPMENT_LOST = "model.ability.demoteOnAllEquipLost";
    public static final String DENOUNCE_HERESY = "model.ability.denounceHeresy";
    public static final String DISPOSE_ON_ALL_EQUIPMENT_LOST = "model.ability.disposeOnAllEquipLost";
    public static final String DISPOSE_ON_COMBAT_LOSS = "model.ability.disposeOnCombatLoss";
    public static final String DRESS_MISSIONARY = "model.ability.dressMissionary";
    public static final String ELECT_FOUNDING_FATHER = "model.ability.electFoundingFather";
    public static final String ESTABLISH_MISSION = "model.ability.establishMission";
    public static final String EVADE_ATTACK = "model.ability.evadeAttack";
    public static final String EXPERT_MISSIONARY = "model.ability.expertMissionary";
    public static final String EXPERT_PIONEER = "model.ability.expertPioneer";
    public static final String EXPERT_SCOUT = "model.ability.expertScout";
    public static final String EXPERT_SOLDIER = "model.ability.expertSoldier";
    public static final String EXPERTS_USE_CONNECTIONS = "model.ability.expertsUseConnections";
    public static final String EXPORT = "model.ability.export";
    public static final String FOUND_COLONY = "model.ability.foundColony";
    public static final String FOUND_IN_LOST_CITY = "model.ability.foundInLostCity";
    public static final String FOUNDS_COLONIES = "model.ability.foundsColonies";
    public static final String HAS_PORT = "model.ability.hasPort";
    public static final String IGNORE_EUROPEAN_WARS = "model.ability.ignoreEuropeanWars";
    public static final String IMPROVE_TERRAIN = "model.ability.improveTerrain";
    public static final String INCITE_NATIVES = "model.ability.inciteNatives";
    public static final String INDEPENDENCE_DECLARED = "model.ability.independenceDeclared";
    public static final String INDEPENDENT_NATION = "model.ability.independentNation";
    public static final String MERCENARY_UNIT = "model.ability.mercenaryUnit";
    public static final String MOUNTED = "model.ability.mounted";
    public static final String MOVE_TO_EUROPE = "model.ability.moveToEurope";
    public static final String MULTIPLE_ATTACKS = "model.ability.multipleAttacks";
    public static final String NATIVE = "model.ability.native";
    public static final String NAVAL_UNIT = "model.ability.navalUnit";
    public static final String NEGOTIATE = "model.ability.negotiate";
    public static final String PERSON = "model.ability.person";
    public static final String PILLAGE_UNPROTECTED_COLONY = "model.ability.pillageUnprotectedColony";
    public static final String PIRACY = "model.ability.piracy";
    public static final String PLUNDER_NATIVES = "model.ability.plunderNatives";
    public static final String PRODUCE_IN_WATER = "model.ability.produceInWater";
    public static final String REF_UNIT = "model.ability.refUnit";
    public static final String REPAIR_UNITS = "model.ability.repairUnits";
    public static final String ROYAL_EXPEDITIONARY_FORCE = "model.ability.royalExpeditionaryForce";
    public static final String RUMOURS_ALWAYS_POSITIVE = "model.ability.rumoursAlwaysPositive";
    public static final String SEE_ALL_COLONIES = "model.ability.seeAllColonies";
    public static final String SELECT_RECRUIT = "model.ability.selectRecruit";
    public static final String SPEAK_WITH_CHIEF = "model.ability.speakWithChief";
    public static final String SPY_ON_COLONY = "model.ability.spyOnColony";
    public static final String SUPPORT_UNIT = "model.ability.supportUnit";
    public static final String TEACH = "model.ability.teach";
    public static final String TRADE_WITH_FOREIGN_COLONIES = "model.ability.tradeWithForeignColonies";
    public static final String UNDEAD = "model.ability.undead";
    private boolean value = true;

    public Ability(String id) {
        this(id, null, true);
    }

    public Ability(String id, boolean value) {
        this(id, null, value);
    }

    public Ability(String id, FreeColGameObjectType source, boolean value) {
        this.setId(id);
        this.setSource(source);
        this.value = value;
    }

    public Ability(Ability template) {
        this.copyFrom(template);
        this.value = template.value;
    }

    public Ability(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(xr);
    }

    public Ability(Element e, Specification specification) {
        this.setSpecification(specification);
        this.readFromXMLElement(e);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean newValue) {
        this.value = newValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Ability) {
            return this.value == ((Ability)o).value && super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash += this.value ? 1 : 0;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.value = xr.getAttribute("value", true);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[ ").append(this.getId());
        if (this.getSource() != null) {
            sb.append(" (").append(this.getSource().getId()).append(")");
        }
        sb.append(" = ").append(this.value).append(" ]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Ability.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "ability";
    }
}

