/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.statusbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.common.BadPositionException;
import org.diylc.common.ComponentType;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.IDIYComponent;
import org.diylc.images.IconLoader;
import org.diylc.swing.ISwingUI;
import org.diylc.swingframework.MemoryBar;
import org.diylc.swingframework.miscutils.PercentageListCellRenderer;
import org.diylc.swingframework.update.UpdateLabel;

public class StatusBar
extends JPanel
implements IPlugIn {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(StatusBar.class);
    public static String UPDATE_URL = "http://www.diy-fever.com/update.xml";
    private static final Format sizeFormat = new DecimalFormat("0.##");
    private JComboBox zoomBox;
    private UpdateLabel updateLabel;
    private MemoryBar memoryPanel;
    private JLabel statusLabel;
    private JLabel sizeLabel;
    private IPlugInPort plugInPort;
    private ComponentType componentSlot;
    private Point controlPointSlot;
    private List<String> componentNamesUnderCursor;
    private List<String> selectedComponentNames;
    private List<String> stuckComponentNames;
    private String statusMessage;

    public StatusBar(ISwingUI iSwingUI) {
        this.setLayout(new GridBagLayout());
        try {
            iSwingUI.injectGUIComponent(this, 3);
        }
        catch (BadPositionException badPositionException) {
            LOG.error((Object)"Could not install status bar", (Throwable)badPositionException);
        }
    }

    private JComboBox getZoomBox() {
        if (this.zoomBox == null) {
            this.zoomBox = new JComboBox<Double>(this.plugInPort.getAvailableZoomLevels());
            this.zoomBox.setSelectedItem(this.plugInPort.getZoomLevel());
            this.zoomBox.setFocusable(false);
            this.zoomBox.setRenderer(new PercentageListCellRenderer());
            this.zoomBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatusBar.this.plugInPort.setZoomLevel((Double)StatusBar.this.zoomBox.getSelectedItem());
                }
            });
        }
        return this.zoomBox;
    }

    private UpdateLabel getUpdateLabel() {
        if (this.updateLabel == null) {
            this.updateLabel = new UpdateLabel(this.plugInPort.getCurrentVersionNumber(), UPDATE_URL);
            this.updateLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        }
        return this.updateLabel;
    }

    private MemoryBar getMemoryPanel() {
        if (this.memoryPanel == null) {
            this.memoryPanel = new MemoryBar(false);
        }
        return this.memoryPanel;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        }
        return this.statusLabel;
    }

    public JLabel getSizeLabel() {
        if (this.sizeLabel == null) {
            this.sizeLabel = new JLabel(IconLoader.Size.getIcon());
            this.sizeLabel.setFocusable(true);
            this.sizeLabel.setToolTipText("Click to calculate selection size");
            this.sizeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point2D point2D = StatusBar.this.plugInPort.calculateSelectionDimension();
                    boolean bl = ConfigurationManager.getInstance().readBoolean("metric", true);
                    String string = point2D == null ? "Selection is empty." : "Selection size: " + sizeFormat.format(point2D.getX()) + " x " + sizeFormat.format(point2D.getY()) + (bl ? " cm" : " in");
                    JOptionPane.showMessageDialog(SwingUtilities.getRootPane(StatusBar.this), string, "Information", 1);
                }
            });
        }
        return this.sizeLabel;
    }

    private void layoutComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getStatusLabel(), gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Zoom: "), "West");
        jPanel.add((Component)this.getZoomBox(), "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.getSizeLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.add((Component)this.getUpdateLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 0;
        this.add((Component)this.getMemoryPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    @Override
    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.layoutComponents();
    }

    @Override
    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.ZOOM_CHANGED, EventType.SLOT_CHANGED, EventType.AVAILABLE_CTRL_POINTS_CHANGED, EventType.SELECTION_CHANGED, EventType.STATUS_MESSAGE_CHANGED);
    }

    @Override
    public void processMessage(EventType eventType, Object ... objectArray) {
        switch (eventType) {
            case ZOOM_CHANGED: {
                if (objectArray[0].equals(this.getZoomBox().getSelectedItem())) break;
                final Double d = (Double)objectArray[0];
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusBar.this.getZoomBox().setSelectedItem(d);
                    }
                });
                break;
            }
            case SELECTION_CHANGED: {
                List list = (List)objectArray[0];
                Collection collection = (Collection)objectArray[1];
                HashSet<String> hashSet = new HashSet<String>();
                for (IDIYComponent iDIYComponent : list) {
                    hashSet.add("<font color='blue'>" + iDIYComponent.getName() + "</font>");
                }
                this.selectedComponentNames = new ArrayList<String>(hashSet);
                Collections.sort(this.selectedComponentNames);
                this.stuckComponentNames = new ArrayList<String>();
                for (IDIYComponent iDIYComponent : collection) {
                    this.stuckComponentNames.add("<font color='blue'>" + iDIYComponent.getName() + "</font>");
                }
                this.stuckComponentNames.removeAll(this.selectedComponentNames);
                Collections.sort(this.stuckComponentNames);
                this.refreshStatusText();
                break;
            }
            case SLOT_CHANGED: {
                this.componentSlot = (ComponentType)objectArray[0];
                this.controlPointSlot = (Point)objectArray[1];
                this.refreshStatusText();
                break;
            }
            case AVAILABLE_CTRL_POINTS_CHANGED: {
                this.componentNamesUnderCursor = new ArrayList<String>();
                for (IDIYComponent iDIYComponent : ((Map)objectArray[0]).keySet()) {
                    this.componentNamesUnderCursor.add("<font color='blue'>" + iDIYComponent.getName() + "</font>");
                }
                Collections.sort(this.componentNamesUnderCursor);
                this.refreshStatusText();
                break;
            }
            case STATUS_MESSAGE_CHANGED: {
                this.statusMessage = (String)objectArray[0];
            }
        }
    }

    private void refreshStatusText() {
        CharSequence charSequence;
        String string = this.statusMessage;
        if (this.componentSlot == null) {
            if (this.componentNamesUnderCursor != null && !this.componentNamesUnderCursor.isEmpty()) {
                charSequence = Utils.toCommaString(this.componentNamesUnderCursor);
                string = "<html>Drag control point(s) of " + (String)charSequence + "</html>";
            } else if (this.selectedComponentNames != null && !this.selectedComponentNames.isEmpty()) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(Utils.toCommaString(this.selectedComponentNames.subList(0, Math.min(20, this.selectedComponentNames.size()))));
                if (this.selectedComponentNames.size() > 15) {
                    ((StringBuilder)charSequence).append(" and " + (this.selectedComponentNames.size() - 15) + " more");
                }
                if (!this.stuckComponentNames.isEmpty()) {
                    ((StringBuilder)charSequence).append(" (hold <b>Ctrl</b> and drag to unstuck from ");
                    ((StringBuilder)charSequence).append(Utils.toCommaString(this.stuckComponentNames.subList(0, Math.min(5, this.stuckComponentNames.size()))));
                    if (this.stuckComponentNames.size() > 5) {
                        ((StringBuilder)charSequence).append(" and " + (this.stuckComponentNames.size() - 5) + " more");
                    }
                    ((StringBuilder)charSequence).append(")");
                }
                string = "<html>Selection: " + ((StringBuilder)charSequence).toString() + "</html>";
            }
        } else {
            switch (this.componentSlot.getCreationMethod()) {
                case POINT_BY_POINT: {
                    charSequence = this.controlPointSlot == null ? "first" : "second";
                    string = "<html>Click on the canvas to set the " + (String)charSequence + " control point of a new <font color='blue'>" + this.componentSlot.getName() + "</font> or press <b>Esc</b> to cancel</html>";
                    break;
                }
                case SINGLE_CLICK: {
                    string = "<html>Click on the canvas to create a new <font color='blue'>" + this.componentSlot.getName() + "</font> or press <b>Esc</b> to cancel</html>";
                }
            }
        }
        charSequence = string;
        SwingUtilities.invokeLater(new Runnable((String)charSequence){
            final /* synthetic */ String val$finalStatus;
            {
                this.val$finalStatus = string;
            }

            @Override
            public void run() {
                StatusBar.this.getStatusLabel().setText(this.val$finalStatus);
            }
        });
    }
}

