/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.diylc.images.IconLoader;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.plugins.file.FileFilterEnum;
import org.diylc.swingframework.export.TableExporter;
import org.diylc.swingframework.objecttable.ObjectListTable;
import org.diylc.utils.BomEntry;

public class BomDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ObjectListTable<BomEntry> table;
    private JPanel toolbar;

    public BomDialog(JFrame jFrame, List<BomEntry> list) {
        super((Frame)jFrame, "Bill of Materials");
        this.setContentPane(this.createMainPanel());
        this.getTable().setData(list);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.getTable().autoFit(Arrays.asList(3));
        }
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getToolbar(), "North");
        jPanel.add((Component)new JScrollPane((Component)this.getTable()), "Center");
        return jPanel;
    }

    private ObjectListTable<BomEntry> getTable() {
        if (this.table == null) {
            try {
                this.table = new ObjectListTable(BomEntry.class, new String[]{"getName", "getValue", "getQuantity", "getNotes/setNotes"}, null);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return this.table;
    }

    private JPanel getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JPanel();
            this.toolbar.add(new JButton(new SaveToExcelAction()));
            this.toolbar.add(new JButton(new SaveToCSVAction()));
            this.toolbar.add(new JButton(new SaveToPNGAction()));
            this.toolbar.add(new JButton(new SaveToHTMLAction()));
        }
        return this.toolbar;
    }

    class SaveToPNGAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveToPNGAction() {
            this.putValue("Name", "Save to PNG");
            this.putValue("SmallIcon", IconLoader.Image.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.PNG.getFilter(), null, FileFilterEnum.PNG.getExtensions()[0], null);
            if (file != null) {
                try {
                    TableExporter.getInstance().exportToPNG((JTable)BomDialog.this.getTable(), file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class SaveToHTMLAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveToHTMLAction() {
            this.putValue("Name", "Save to HTML");
            this.putValue("SmallIcon", IconLoader.HTML.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.HTML.getFilter(), null, FileFilterEnum.HTML.getExtensions()[0], null);
            if (file != null) {
                try {
                    TableExporter.getInstance().exportToHTML((JTable)BomDialog.this.getTable(), file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class SaveToCSVAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveToCSVAction() {
            this.putValue("Name", "Save to CSV");
            this.putValue("SmallIcon", IconLoader.CSV.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.CSV.getFilter(), null, FileFilterEnum.CSV.getExtensions()[0], null);
            if (file != null) {
                try {
                    TableExporter.getInstance().exportToCSV((JTable)BomDialog.this.getTable(), file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class SaveToExcelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveToExcelAction() {
            this.putValue("Name", "Save to Excel");
            this.putValue("SmallIcon", IconLoader.Excel.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.EXCEL.getFilter(), null, FileFilterEnum.EXCEL.getExtensions()[0], null);
            if (file != null) {
                try {
                    TableExporter.getInstance().exportToExcel((JTable)BomDialog.this.getTable(), file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

