// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/talent/v4/common.proto

package talentpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	money "google.golang.org/genproto/googleapis/type/money"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An enum that represents the size of the company.
type CompanySize int32

const (
	// Default value if the size isn't specified.
	CompanySize_COMPANY_SIZE_UNSPECIFIED CompanySize = 0
	// The company has less than 50 employees.
	CompanySize_MINI CompanySize = 1
	// The company has between 50 and 99 employees.
	CompanySize_SMALL CompanySize = 2
	// The company has between 100 and 499 employees.
	CompanySize_SMEDIUM CompanySize = 3
	// The company has between 500 and 999 employees.
	CompanySize_MEDIUM CompanySize = 4
	// The company has between 1,000 and 4,999 employees.
	CompanySize_BIG CompanySize = 5
	// The company has between 5,000 and 9,999 employees.
	CompanySize_BIGGER CompanySize = 6
	// The company has 10,000 or more employees.
	CompanySize_GIANT CompanySize = 7
)

// Enum value maps for CompanySize.
var (
	CompanySize_name = map[int32]string{
		0: "COMPANY_SIZE_UNSPECIFIED",
		1: "MINI",
		2: "SMALL",
		3: "SMEDIUM",
		4: "MEDIUM",
		5: "BIG",
		6: "BIGGER",
		7: "GIANT",
	}
	CompanySize_value = map[string]int32{
		"COMPANY_SIZE_UNSPECIFIED": 0,
		"MINI":                     1,
		"SMALL":                    2,
		"SMEDIUM":                  3,
		"MEDIUM":                   4,
		"BIG":                      5,
		"BIGGER":                   6,
		"GIANT":                    7,
	}
)

func (x CompanySize) Enum() *CompanySize {
	p := new(CompanySize)
	*p = x
	return p
}

func (x CompanySize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompanySize) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[0].Descriptor()
}

func (CompanySize) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[0]
}

func (x CompanySize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompanySize.Descriptor instead.
func (CompanySize) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{0}
}

// An enum that represents employee benefits included with the job.
type JobBenefit int32

const (
	// Default value if the type isn't specified.
	JobBenefit_JOB_BENEFIT_UNSPECIFIED JobBenefit = 0
	// The job includes access to programs that support child care, such
	// as daycare.
	JobBenefit_CHILD_CARE JobBenefit = 1
	// The job includes dental services covered by a dental
	// insurance plan.
	JobBenefit_DENTAL JobBenefit = 2
	// The job offers specific benefits to domestic partners.
	JobBenefit_DOMESTIC_PARTNER JobBenefit = 3
	// The job allows for a flexible work schedule.
	JobBenefit_FLEXIBLE_HOURS JobBenefit = 4
	// The job includes health services covered by a medical insurance plan.
	JobBenefit_MEDICAL JobBenefit = 5
	// The job includes a life insurance plan provided by the employer or
	// available for purchase by the employee.
	JobBenefit_LIFE_INSURANCE JobBenefit = 6
	// The job allows for a leave of absence to a parent to care for a newborn
	// child.
	JobBenefit_PARENTAL_LEAVE JobBenefit = 7
	// The job includes a workplace retirement plan provided by the
	// employer or available for purchase by the employee.
	JobBenefit_RETIREMENT_PLAN JobBenefit = 8
	// The job allows for paid time off due to illness.
	JobBenefit_SICK_DAYS JobBenefit = 9
	// The job includes paid time off for vacation.
	JobBenefit_VACATION JobBenefit = 10
	// The job includes vision services covered by a vision
	// insurance plan.
	JobBenefit_VISION JobBenefit = 11
)

// Enum value maps for JobBenefit.
var (
	JobBenefit_name = map[int32]string{
		0:  "JOB_BENEFIT_UNSPECIFIED",
		1:  "CHILD_CARE",
		2:  "DENTAL",
		3:  "DOMESTIC_PARTNER",
		4:  "FLEXIBLE_HOURS",
		5:  "MEDICAL",
		6:  "LIFE_INSURANCE",
		7:  "PARENTAL_LEAVE",
		8:  "RETIREMENT_PLAN",
		9:  "SICK_DAYS",
		10: "VACATION",
		11: "VISION",
	}
	JobBenefit_value = map[string]int32{
		"JOB_BENEFIT_UNSPECIFIED": 0,
		"CHILD_CARE":              1,
		"DENTAL":                  2,
		"DOMESTIC_PARTNER":        3,
		"FLEXIBLE_HOURS":          4,
		"MEDICAL":                 5,
		"LIFE_INSURANCE":          6,
		"PARENTAL_LEAVE":          7,
		"RETIREMENT_PLAN":         8,
		"SICK_DAYS":               9,
		"VACATION":                10,
		"VISION":                  11,
	}
)

func (x JobBenefit) Enum() *JobBenefit {
	p := new(JobBenefit)
	*p = x
	return p
}

func (x JobBenefit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobBenefit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[1].Descriptor()
}

func (JobBenefit) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[1]
}

func (x JobBenefit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobBenefit.Descriptor instead.
func (JobBenefit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{1}
}

// Educational degree level defined in International Standard Classification
// of Education (ISCED).
type DegreeType int32

const (
	// Default value. Represents no degree, or early childhood education.
	// Maps to ISCED code 0.
	// Ex) Kindergarten
	DegreeType_DEGREE_TYPE_UNSPECIFIED DegreeType = 0
	// Primary education which is typically the first stage of compulsory
	// education. ISCED code 1.
	// Ex) Elementary school
	DegreeType_PRIMARY_EDUCATION DegreeType = 1
	// Lower secondary education; First stage of secondary education building on
	// primary education, typically with a more subject-oriented curriculum.
	// ISCED code 2.
	// Ex) Middle school
	DegreeType_LOWER_SECONDARY_EDUCATION DegreeType = 2
	// Middle education; Second/final stage of secondary education preparing for
	// tertiary education and/or providing skills relevant to employment.
	// Usually with an increased range of subject options and streams. ISCED
	// code 3.
	// Ex) High school
	DegreeType_UPPER_SECONDARY_EDUCATION DegreeType = 3
	// Adult Remedial Education; Programmes providing learning experiences that
	// build on secondary education and prepare for labour market entry and/or
	// tertiary education. The content is broader than secondary but not as
	// complex as tertiary education. ISCED code 4.
	DegreeType_ADULT_REMEDIAL_EDUCATION DegreeType = 4
	// Associate's or equivalent; Short first tertiary programmes that are
	// typically practically-based, occupationally-specific and prepare for
	// labour market entry. These programmes may also provide a pathway to other
	// tertiary programmes. ISCED code 5.
	DegreeType_ASSOCIATES_OR_EQUIVALENT DegreeType = 5
	// Bachelor's or equivalent; Programmes designed to provide intermediate
	// academic and/or professional knowledge, skills and competencies leading
	// to a first tertiary degree or equivalent qualification. ISCED code 6.
	DegreeType_BACHELORS_OR_EQUIVALENT DegreeType = 6
	// Master's or equivalent; Programmes designed to provide advanced academic
	// and/or professional knowledge, skills and competencies leading to a
	// second tertiary degree or equivalent qualification. ISCED code 7.
	DegreeType_MASTERS_OR_EQUIVALENT DegreeType = 7
	// Doctoral or equivalent; Programmes designed primarily to lead to an
	// advanced research qualification, usually concluding with the submission
	// and defense of a substantive dissertation of publishable quality based on
	// original research. ISCED code 8.
	DegreeType_DOCTORAL_OR_EQUIVALENT DegreeType = 8
)

// Enum value maps for DegreeType.
var (
	DegreeType_name = map[int32]string{
		0: "DEGREE_TYPE_UNSPECIFIED",
		1: "PRIMARY_EDUCATION",
		2: "LOWER_SECONDARY_EDUCATION",
		3: "UPPER_SECONDARY_EDUCATION",
		4: "ADULT_REMEDIAL_EDUCATION",
		5: "ASSOCIATES_OR_EQUIVALENT",
		6: "BACHELORS_OR_EQUIVALENT",
		7: "MASTERS_OR_EQUIVALENT",
		8: "DOCTORAL_OR_EQUIVALENT",
	}
	DegreeType_value = map[string]int32{
		"DEGREE_TYPE_UNSPECIFIED":   0,
		"PRIMARY_EDUCATION":         1,
		"LOWER_SECONDARY_EDUCATION": 2,
		"UPPER_SECONDARY_EDUCATION": 3,
		"ADULT_REMEDIAL_EDUCATION":  4,
		"ASSOCIATES_OR_EQUIVALENT":  5,
		"BACHELORS_OR_EQUIVALENT":   6,
		"MASTERS_OR_EQUIVALENT":     7,
		"DOCTORAL_OR_EQUIVALENT":    8,
	}
)

func (x DegreeType) Enum() *DegreeType {
	p := new(DegreeType)
	*p = x
	return p
}

func (x DegreeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DegreeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[2].Descriptor()
}

func (DegreeType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[2]
}

func (x DegreeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DegreeType.Descriptor instead.
func (DegreeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{2}
}

// An enum that represents the employment type of a job.
type EmploymentType int32

const (
	// The default value if the employment type isn't specified.
	EmploymentType_EMPLOYMENT_TYPE_UNSPECIFIED EmploymentType = 0
	// The job requires working a number of hours that constitute full
	// time employment, typically 40 or more hours per week.
	EmploymentType_FULL_TIME EmploymentType = 1
	// The job entails working fewer hours than a full time job,
	// typically less than 40 hours a week.
	EmploymentType_PART_TIME EmploymentType = 2
	// The job is offered as a contracted, as opposed to a salaried employee,
	// position.
	EmploymentType_CONTRACTOR EmploymentType = 3
	// The job is offered as a contracted position with the understanding
	// that it's converted into a full-time position at the end of the
	// contract. Jobs of this type are also returned by a search for
	// [EmploymentType.CONTRACTOR][google.cloud.talent.v4.EmploymentType.CONTRACTOR]
	// jobs.
	EmploymentType_CONTRACT_TO_HIRE EmploymentType = 4
	// The job is offered as a temporary employment opportunity, usually
	// a short-term engagement.
	EmploymentType_TEMPORARY EmploymentType = 5
	// The job is a fixed-term opportunity for students or entry-level job
	// seekers to obtain on-the-job training, typically offered as a summer
	// position.
	EmploymentType_INTERN EmploymentType = 6
	// The is an opportunity for an individual to volunteer, where there's no
	// expectation of compensation for the provided services.
	EmploymentType_VOLUNTEER EmploymentType = 7
	// The job requires an employee to work on an as-needed basis with a
	// flexible schedule.
	EmploymentType_PER_DIEM EmploymentType = 8
	// The job involves employing people in remote areas and flying them
	// temporarily to the work site instead of relocating employees and their
	// families permanently.
	EmploymentType_FLY_IN_FLY_OUT EmploymentType = 9
	// The job does not fit any of the other listed types.
	EmploymentType_OTHER_EMPLOYMENT_TYPE EmploymentType = 10
)

// Enum value maps for EmploymentType.
var (
	EmploymentType_name = map[int32]string{
		0:  "EMPLOYMENT_TYPE_UNSPECIFIED",
		1:  "FULL_TIME",
		2:  "PART_TIME",
		3:  "CONTRACTOR",
		4:  "CONTRACT_TO_HIRE",
		5:  "TEMPORARY",
		6:  "INTERN",
		7:  "VOLUNTEER",
		8:  "PER_DIEM",
		9:  "FLY_IN_FLY_OUT",
		10: "OTHER_EMPLOYMENT_TYPE",
	}
	EmploymentType_value = map[string]int32{
		"EMPLOYMENT_TYPE_UNSPECIFIED": 0,
		"FULL_TIME":                   1,
		"PART_TIME":                   2,
		"CONTRACTOR":                  3,
		"CONTRACT_TO_HIRE":            4,
		"TEMPORARY":                   5,
		"INTERN":                      6,
		"VOLUNTEER":                   7,
		"PER_DIEM":                    8,
		"FLY_IN_FLY_OUT":              9,
		"OTHER_EMPLOYMENT_TYPE":       10,
	}
)

func (x EmploymentType) Enum() *EmploymentType {
	p := new(EmploymentType)
	*p = x
	return p
}

func (x EmploymentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EmploymentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[3].Descriptor()
}

func (EmploymentType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[3]
}

func (x EmploymentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EmploymentType.Descriptor instead.
func (EmploymentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{3}
}

// An enum that represents the required experience level required for the job.
type JobLevel int32

const (
	// The default value if the level isn't specified.
	JobLevel_JOB_LEVEL_UNSPECIFIED JobLevel = 0
	// Entry-level individual contributors, typically with less than 2 years of
	// experience in a similar role. Includes interns.
	JobLevel_ENTRY_LEVEL JobLevel = 1
	// Experienced individual contributors, typically with 2+ years of
	// experience in a similar role.
	JobLevel_EXPERIENCED JobLevel = 2
	// Entry- to mid-level managers responsible for managing a team of people.
	JobLevel_MANAGER JobLevel = 3
	// Senior-level managers responsible for managing teams of managers.
	JobLevel_DIRECTOR JobLevel = 4
	// Executive-level managers and above, including C-level positions.
	JobLevel_EXECUTIVE JobLevel = 5
)

// Enum value maps for JobLevel.
var (
	JobLevel_name = map[int32]string{
		0: "JOB_LEVEL_UNSPECIFIED",
		1: "ENTRY_LEVEL",
		2: "EXPERIENCED",
		3: "MANAGER",
		4: "DIRECTOR",
		5: "EXECUTIVE",
	}
	JobLevel_value = map[string]int32{
		"JOB_LEVEL_UNSPECIFIED": 0,
		"ENTRY_LEVEL":           1,
		"EXPERIENCED":           2,
		"MANAGER":               3,
		"DIRECTOR":              4,
		"EXECUTIVE":             5,
	}
)

func (x JobLevel) Enum() *JobLevel {
	p := new(JobLevel)
	*p = x
	return p
}

func (x JobLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[4].Descriptor()
}

func (JobLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[4]
}

func (x JobLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobLevel.Descriptor instead.
func (JobLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{4}
}

// An enum that represents the categorization or primary focus of specific
// role. This value is different than the "industry" associated with a role,
// which is related to the categorization of the company listing the job.
type JobCategory int32

const (
	// The default value if the category isn't specified.
	JobCategory_JOB_CATEGORY_UNSPECIFIED JobCategory = 0
	// An accounting and finance job, such as an Accountant.
	JobCategory_ACCOUNTING_AND_FINANCE JobCategory = 1
	// An administrative and office job, such as an Administrative Assistant.
	JobCategory_ADMINISTRATIVE_AND_OFFICE JobCategory = 2
	// An advertising and marketing job, such as Marketing Manager.
	JobCategory_ADVERTISING_AND_MARKETING JobCategory = 3
	// An animal care job, such as Veterinarian.
	JobCategory_ANIMAL_CARE JobCategory = 4
	// An art, fashion, or design job, such as Designer.
	JobCategory_ART_FASHION_AND_DESIGN JobCategory = 5
	// A business operations job, such as Business Operations Manager.
	JobCategory_BUSINESS_OPERATIONS JobCategory = 6
	// A cleaning and facilities job, such as Custodial Staff.
	JobCategory_CLEANING_AND_FACILITIES JobCategory = 7
	// A computer and IT job, such as Systems Administrator.
	JobCategory_COMPUTER_AND_IT JobCategory = 8
	// A construction job, such as General Laborer.
	JobCategory_CONSTRUCTION JobCategory = 9
	// A customer service job, such s Cashier.
	JobCategory_CUSTOMER_SERVICE JobCategory = 10
	// An education job, such as School Teacher.
	JobCategory_EDUCATION JobCategory = 11
	// An entertainment and travel job, such as Flight Attendant.
	JobCategory_ENTERTAINMENT_AND_TRAVEL JobCategory = 12
	// A farming or outdoor job, such as Park Ranger.
	JobCategory_FARMING_AND_OUTDOORS JobCategory = 13
	// A healthcare job, such as Registered Nurse.
	JobCategory_HEALTHCARE JobCategory = 14
	// A human resources job, such as Human Resources Director.
	JobCategory_HUMAN_RESOURCES JobCategory = 15
	// An installation, maintenance, or repair job, such as Electrician.
	JobCategory_INSTALLATION_MAINTENANCE_AND_REPAIR JobCategory = 16
	// A legal job, such as Law Clerk.
	JobCategory_LEGAL JobCategory = 17
	// A management job, often used in conjunction with another category,
	// such as Store Manager.
	JobCategory_MANAGEMENT JobCategory = 18
	// A manufacturing or warehouse job, such as Assembly Technician.
	JobCategory_MANUFACTURING_AND_WAREHOUSE JobCategory = 19
	// A media, communications, or writing job, such as Media Relations.
	JobCategory_MEDIA_COMMUNICATIONS_AND_WRITING JobCategory = 20
	// An oil, gas or mining job, such as Offshore Driller.
	JobCategory_OIL_GAS_AND_MINING JobCategory = 21
	// A personal care and services job, such as Hair Stylist.
	JobCategory_PERSONAL_CARE_AND_SERVICES JobCategory = 22
	// A protective services job, such as Security Guard.
	JobCategory_PROTECTIVE_SERVICES JobCategory = 23
	// A real estate job, such as Buyer's Agent.
	JobCategory_REAL_ESTATE JobCategory = 24
	// A restaurant and hospitality job, such as Restaurant Server.
	JobCategory_RESTAURANT_AND_HOSPITALITY JobCategory = 25
	// A sales and/or retail job, such Sales Associate.
	JobCategory_SALES_AND_RETAIL JobCategory = 26
	// A science and engineering job, such as Lab Technician.
	JobCategory_SCIENCE_AND_ENGINEERING JobCategory = 27
	// A social services or non-profit job, such as Case Worker.
	JobCategory_SOCIAL_SERVICES_AND_NON_PROFIT JobCategory = 28
	// A sports, fitness, or recreation job, such as Personal Trainer.
	JobCategory_SPORTS_FITNESS_AND_RECREATION JobCategory = 29
	// A transportation or logistics job, such as Truck Driver.
	JobCategory_TRANSPORTATION_AND_LOGISTICS JobCategory = 30
)

// Enum value maps for JobCategory.
var (
	JobCategory_name = map[int32]string{
		0:  "JOB_CATEGORY_UNSPECIFIED",
		1:  "ACCOUNTING_AND_FINANCE",
		2:  "ADMINISTRATIVE_AND_OFFICE",
		3:  "ADVERTISING_AND_MARKETING",
		4:  "ANIMAL_CARE",
		5:  "ART_FASHION_AND_DESIGN",
		6:  "BUSINESS_OPERATIONS",
		7:  "CLEANING_AND_FACILITIES",
		8:  "COMPUTER_AND_IT",
		9:  "CONSTRUCTION",
		10: "CUSTOMER_SERVICE",
		11: "EDUCATION",
		12: "ENTERTAINMENT_AND_TRAVEL",
		13: "FARMING_AND_OUTDOORS",
		14: "HEALTHCARE",
		15: "HUMAN_RESOURCES",
		16: "INSTALLATION_MAINTENANCE_AND_REPAIR",
		17: "LEGAL",
		18: "MANAGEMENT",
		19: "MANUFACTURING_AND_WAREHOUSE",
		20: "MEDIA_COMMUNICATIONS_AND_WRITING",
		21: "OIL_GAS_AND_MINING",
		22: "PERSONAL_CARE_AND_SERVICES",
		23: "PROTECTIVE_SERVICES",
		24: "REAL_ESTATE",
		25: "RESTAURANT_AND_HOSPITALITY",
		26: "SALES_AND_RETAIL",
		27: "SCIENCE_AND_ENGINEERING",
		28: "SOCIAL_SERVICES_AND_NON_PROFIT",
		29: "SPORTS_FITNESS_AND_RECREATION",
		30: "TRANSPORTATION_AND_LOGISTICS",
	}
	JobCategory_value = map[string]int32{
		"JOB_CATEGORY_UNSPECIFIED":            0,
		"ACCOUNTING_AND_FINANCE":              1,
		"ADMINISTRATIVE_AND_OFFICE":           2,
		"ADVERTISING_AND_MARKETING":           3,
		"ANIMAL_CARE":                         4,
		"ART_FASHION_AND_DESIGN":              5,
		"BUSINESS_OPERATIONS":                 6,
		"CLEANING_AND_FACILITIES":             7,
		"COMPUTER_AND_IT":                     8,
		"CONSTRUCTION":                        9,
		"CUSTOMER_SERVICE":                    10,
		"EDUCATION":                           11,
		"ENTERTAINMENT_AND_TRAVEL":            12,
		"FARMING_AND_OUTDOORS":                13,
		"HEALTHCARE":                          14,
		"HUMAN_RESOURCES":                     15,
		"INSTALLATION_MAINTENANCE_AND_REPAIR": 16,
		"LEGAL":                               17,
		"MANAGEMENT":                          18,
		"MANUFACTURING_AND_WAREHOUSE":         19,
		"MEDIA_COMMUNICATIONS_AND_WRITING":    20,
		"OIL_GAS_AND_MINING":                  21,
		"PERSONAL_CARE_AND_SERVICES":          22,
		"PROTECTIVE_SERVICES":                 23,
		"REAL_ESTATE":                         24,
		"RESTAURANT_AND_HOSPITALITY":          25,
		"SALES_AND_RETAIL":                    26,
		"SCIENCE_AND_ENGINEERING":             27,
		"SOCIAL_SERVICES_AND_NON_PROFIT":      28,
		"SPORTS_FITNESS_AND_RECREATION":       29,
		"TRANSPORTATION_AND_LOGISTICS":        30,
	}
)

func (x JobCategory) Enum() *JobCategory {
	p := new(JobCategory)
	*p = x
	return p
}

func (x JobCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[5].Descriptor()
}

func (JobCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[5]
}

func (x JobCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobCategory.Descriptor instead.
func (JobCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{5}
}

// An enum that represents the job posting region. In most cases, job postings
// don't need to specify a region. If a region is given, jobs are
// eligible for searches in the specified region.
type PostingRegion int32

const (
	// If the region is unspecified, the job is only returned if it
	// matches the [LocationFilter][google.cloud.talent.v4.LocationFilter].
	PostingRegion_POSTING_REGION_UNSPECIFIED PostingRegion = 0
	// In addition to exact location matching, job posting is returned when the
	// [LocationFilter][google.cloud.talent.v4.LocationFilter] in the search query
	// is in the same administrative area as the returned job posting. For
	// example, if a `ADMINISTRATIVE_AREA` job is posted in "CA, USA", it's
	// returned if [LocationFilter][google.cloud.talent.v4.LocationFilter] has
	// "Mountain View".
	//
	// Administrative area refers to top-level administrative subdivision of this
	// country. For example, US state, IT region, UK constituent nation and
	// JP prefecture.
	PostingRegion_ADMINISTRATIVE_AREA PostingRegion = 1
	// In addition to exact location matching, job is returned when
	// [LocationFilter][google.cloud.talent.v4.LocationFilter] in search query is
	// in the same country as this job. For example, if a `NATION_WIDE` job is
	// posted in "USA", it's returned if
	// [LocationFilter][google.cloud.talent.v4.LocationFilter] has 'Mountain
	// View'.
	PostingRegion_NATION PostingRegion = 2
	// Job allows employees to work remotely (telecommute).
	// If locations are provided with this value, the job is
	// considered as having a location, but telecommuting is allowed.
	PostingRegion_TELECOMMUTE PostingRegion = 3
)

// Enum value maps for PostingRegion.
var (
	PostingRegion_name = map[int32]string{
		0: "POSTING_REGION_UNSPECIFIED",
		1: "ADMINISTRATIVE_AREA",
		2: "NATION",
		3: "TELECOMMUTE",
	}
	PostingRegion_value = map[string]int32{
		"POSTING_REGION_UNSPECIFIED": 0,
		"ADMINISTRATIVE_AREA":        1,
		"NATION":                     2,
		"TELECOMMUTE":                3,
	}
)

func (x PostingRegion) Enum() *PostingRegion {
	p := new(PostingRegion)
	*p = x
	return p
}

func (x PostingRegion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PostingRegion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[6].Descriptor()
}

func (PostingRegion) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[6]
}

func (x PostingRegion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PostingRegion.Descriptor instead.
func (PostingRegion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{6}
}

// Deprecated. All resources are only visible to the owner.
//
// An enum that represents who has view access to the resource.
//
// Deprecated: Marked as deprecated in google/cloud/talent/v4/common.proto.
type Visibility int32

const (
	// Default value.
	Visibility_VISIBILITY_UNSPECIFIED Visibility = 0
	// The resource is only visible to the GCP account who owns it.
	Visibility_ACCOUNT_ONLY Visibility = 1
	// The resource is visible to the owner and may be visible to other
	// applications and processes at Google.
	Visibility_SHARED_WITH_GOOGLE Visibility = 2
	// The resource is visible to the owner and may be visible to all other API
	// clients.
	Visibility_SHARED_WITH_PUBLIC Visibility = 3
)

// Enum value maps for Visibility.
var (
	Visibility_name = map[int32]string{
		0: "VISIBILITY_UNSPECIFIED",
		1: "ACCOUNT_ONLY",
		2: "SHARED_WITH_GOOGLE",
		3: "SHARED_WITH_PUBLIC",
	}
	Visibility_value = map[string]int32{
		"VISIBILITY_UNSPECIFIED": 0,
		"ACCOUNT_ONLY":           1,
		"SHARED_WITH_GOOGLE":     2,
		"SHARED_WITH_PUBLIC":     3,
	}
)

func (x Visibility) Enum() *Visibility {
	p := new(Visibility)
	*p = x
	return p
}

func (x Visibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Visibility) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[7].Descriptor()
}

func (Visibility) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[7]
}

func (x Visibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Visibility.Descriptor instead.
func (Visibility) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{7}
}

// Option for HTML content sanitization on user input fields, for example, job
// description. By setting this option, user can determine whether and how
// sanitization is performed on these fields.
type HtmlSanitization int32

const (
	// Default value.
	HtmlSanitization_HTML_SANITIZATION_UNSPECIFIED HtmlSanitization = 0
	// Disables sanitization on HTML input.
	HtmlSanitization_HTML_SANITIZATION_DISABLED HtmlSanitization = 1
	// Sanitizes HTML input, only accepts bold, italic, ordered list, and
	// unordered list markup tags.
	HtmlSanitization_SIMPLE_FORMATTING_ONLY HtmlSanitization = 2
)

// Enum value maps for HtmlSanitization.
var (
	HtmlSanitization_name = map[int32]string{
		0: "HTML_SANITIZATION_UNSPECIFIED",
		1: "HTML_SANITIZATION_DISABLED",
		2: "SIMPLE_FORMATTING_ONLY",
	}
	HtmlSanitization_value = map[string]int32{
		"HTML_SANITIZATION_UNSPECIFIED": 0,
		"HTML_SANITIZATION_DISABLED":    1,
		"SIMPLE_FORMATTING_ONLY":        2,
	}
)

func (x HtmlSanitization) Enum() *HtmlSanitization {
	p := new(HtmlSanitization)
	*p = x
	return p
}

func (x HtmlSanitization) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HtmlSanitization) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[8].Descriptor()
}

func (HtmlSanitization) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[8]
}

func (x HtmlSanitization) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HtmlSanitization.Descriptor instead.
func (HtmlSanitization) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{8}
}

// Method for commute. Walking, biking and wheelchair accessible transit is
// still in the Preview stage.
type CommuteMethod int32

const (
	// Commute method isn't specified.
	CommuteMethod_COMMUTE_METHOD_UNSPECIFIED CommuteMethod = 0
	// Commute time is calculated based on driving time.
	CommuteMethod_DRIVING CommuteMethod = 1
	// Commute time is calculated based on public transit including bus, metro,
	// subway, and so on.
	CommuteMethod_TRANSIT CommuteMethod = 2
	// Commute time is calculated based on walking time.
	CommuteMethod_WALKING CommuteMethod = 3
	// Commute time is calculated based on biking time.
	CommuteMethod_CYCLING CommuteMethod = 4
	// Commute time is calculated based on public transit that is wheelchair
	// accessible.
	CommuteMethod_TRANSIT_ACCESSIBLE CommuteMethod = 5
)

// Enum value maps for CommuteMethod.
var (
	CommuteMethod_name = map[int32]string{
		0: "COMMUTE_METHOD_UNSPECIFIED",
		1: "DRIVING",
		2: "TRANSIT",
		3: "WALKING",
		4: "CYCLING",
		5: "TRANSIT_ACCESSIBLE",
	}
	CommuteMethod_value = map[string]int32{
		"COMMUTE_METHOD_UNSPECIFIED": 0,
		"DRIVING":                    1,
		"TRANSIT":                    2,
		"WALKING":                    3,
		"CYCLING":                    4,
		"TRANSIT_ACCESSIBLE":         5,
	}
)

func (x CommuteMethod) Enum() *CommuteMethod {
	p := new(CommuteMethod)
	*p = x
	return p
}

func (x CommuteMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommuteMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[9].Descriptor()
}

func (CommuteMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[9]
}

func (x CommuteMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommuteMethod.Descriptor instead.
func (CommuteMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{9}
}

// An enum which represents the type of a location.
type Location_LocationType int32

const (
	// Default value if the type isn't specified.
	Location_LOCATION_TYPE_UNSPECIFIED Location_LocationType = 0
	// A country level location.
	Location_COUNTRY Location_LocationType = 1
	// A state or equivalent level location.
	Location_ADMINISTRATIVE_AREA Location_LocationType = 2
	// A county or equivalent level location.
	Location_SUB_ADMINISTRATIVE_AREA Location_LocationType = 3
	// A city or equivalent level location.
	Location_LOCALITY Location_LocationType = 4
	// A postal code level location.
	Location_POSTAL_CODE Location_LocationType = 5
	// A sublocality is a subdivision of a locality, for example a city borough,
	// ward, or arrondissement. Sublocalities are usually recognized by a local
	// political authority. For example, Manhattan and Brooklyn are recognized
	// as boroughs by the City of New York, and are therefore modeled as
	// sublocalities.
	Location_SUB_LOCALITY Location_LocationType = 6
	// A district or equivalent level location.
	Location_SUB_LOCALITY_1 Location_LocationType = 7
	// A smaller district or equivalent level display.
	Location_SUB_LOCALITY_2 Location_LocationType = 8
	// A neighborhood level location.
	Location_NEIGHBORHOOD Location_LocationType = 9
	// A street address level location.
	Location_STREET_ADDRESS Location_LocationType = 10
)

// Enum value maps for Location_LocationType.
var (
	Location_LocationType_name = map[int32]string{
		0:  "LOCATION_TYPE_UNSPECIFIED",
		1:  "COUNTRY",
		2:  "ADMINISTRATIVE_AREA",
		3:  "SUB_ADMINISTRATIVE_AREA",
		4:  "LOCALITY",
		5:  "POSTAL_CODE",
		6:  "SUB_LOCALITY",
		7:  "SUB_LOCALITY_1",
		8:  "SUB_LOCALITY_2",
		9:  "NEIGHBORHOOD",
		10: "STREET_ADDRESS",
	}
	Location_LocationType_value = map[string]int32{
		"LOCATION_TYPE_UNSPECIFIED": 0,
		"COUNTRY":                   1,
		"ADMINISTRATIVE_AREA":       2,
		"SUB_ADMINISTRATIVE_AREA":   3,
		"LOCALITY":                  4,
		"POSTAL_CODE":               5,
		"SUB_LOCALITY":              6,
		"SUB_LOCALITY_1":            7,
		"SUB_LOCALITY_2":            8,
		"NEIGHBORHOOD":              9,
		"STREET_ADDRESS":            10,
	}
)

func (x Location_LocationType) Enum() *Location_LocationType {
	p := new(Location_LocationType)
	*p = x
	return p
}

func (x Location_LocationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Location_LocationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[10].Descriptor()
}

func (Location_LocationType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[10]
}

func (x Location_LocationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Location_LocationType.Descriptor instead.
func (Location_LocationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{1, 0}
}

// An enumeration describing an API access portal and exposure mechanism.
type DeviceInfo_DeviceType int32

const (
	// The device type isn't specified.
	DeviceInfo_DEVICE_TYPE_UNSPECIFIED DeviceInfo_DeviceType = 0
	// A desktop web browser, such as, Chrome, Firefox, Safari, or Internet
	// Explorer)
	DeviceInfo_WEB DeviceInfo_DeviceType = 1
	// A mobile device web browser, such as a phone or tablet with a Chrome
	// browser.
	DeviceInfo_MOBILE_WEB DeviceInfo_DeviceType = 2
	// An Android device native application.
	DeviceInfo_ANDROID DeviceInfo_DeviceType = 3
	// An iOS device native application.
	DeviceInfo_IOS DeviceInfo_DeviceType = 4
	// A bot, as opposed to a device operated by human beings, such as a web
	// crawler.
	DeviceInfo_BOT DeviceInfo_DeviceType = 5
	// Other devices types.
	DeviceInfo_OTHER DeviceInfo_DeviceType = 6
)

// Enum value maps for DeviceInfo_DeviceType.
var (
	DeviceInfo_DeviceType_name = map[int32]string{
		0: "DEVICE_TYPE_UNSPECIFIED",
		1: "WEB",
		2: "MOBILE_WEB",
		3: "ANDROID",
		4: "IOS",
		5: "BOT",
		6: "OTHER",
	}
	DeviceInfo_DeviceType_value = map[string]int32{
		"DEVICE_TYPE_UNSPECIFIED": 0,
		"WEB":                     1,
		"MOBILE_WEB":              2,
		"ANDROID":                 3,
		"IOS":                     4,
		"BOT":                     5,
		"OTHER":                   6,
	}
)

func (x DeviceInfo_DeviceType) Enum() *DeviceInfo_DeviceType {
	p := new(DeviceInfo_DeviceType)
	*p = x
	return p
}

func (x DeviceInfo_DeviceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceInfo_DeviceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[11].Descriptor()
}

func (DeviceInfo_DeviceType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[11]
}

func (x DeviceInfo_DeviceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceInfo_DeviceType.Descriptor instead.
func (DeviceInfo_DeviceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{4, 0}
}

// The type of compensation.
//
// For compensation amounts specified in non-monetary amounts,
// describe the compensation scheme in the
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description].
//
// For example, tipping format is described in
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description]
// (for example, "expect 15-20% tips based on customer bill.") and an estimate
// of the tips provided in
// [CompensationEntry.amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or
// [CompensationEntry.range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range]
// ($10 per hour).
//
// For example, equity is described in
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description]
// (for example, "1% - 2% equity vesting over 4 years, 1 year cliff") and
// value estimated in
// [CompensationEntry.amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or
// [CompensationEntry.range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range].
// If no value estimate is possible, units are
// [CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED][google.cloud.talent.v4.CompensationInfo.CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED]
// and then further clarified in
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description]
// field.
type CompensationInfo_CompensationType int32

const (
	// Default value.
	CompensationInfo_COMPENSATION_TYPE_UNSPECIFIED CompensationInfo_CompensationType = 0
	// Base compensation: Refers to the fixed amount of money paid to an
	// employee by an employer in return for work performed. Base compensation
	// does not include benefits, bonuses or any other potential compensation
	// from an employer.
	CompensationInfo_BASE CompensationInfo_CompensationType = 1
	// Bonus.
	CompensationInfo_BONUS CompensationInfo_CompensationType = 2
	// Signing bonus.
	CompensationInfo_SIGNING_BONUS CompensationInfo_CompensationType = 3
	// Equity.
	CompensationInfo_EQUITY CompensationInfo_CompensationType = 4
	// Profit sharing.
	CompensationInfo_PROFIT_SHARING CompensationInfo_CompensationType = 5
	// Commission.
	CompensationInfo_COMMISSIONS CompensationInfo_CompensationType = 6
	// Tips.
	CompensationInfo_TIPS CompensationInfo_CompensationType = 7
	// Other compensation type.
	CompensationInfo_OTHER_COMPENSATION_TYPE CompensationInfo_CompensationType = 8
)

// Enum value maps for CompensationInfo_CompensationType.
var (
	CompensationInfo_CompensationType_name = map[int32]string{
		0: "COMPENSATION_TYPE_UNSPECIFIED",
		1: "BASE",
		2: "BONUS",
		3: "SIGNING_BONUS",
		4: "EQUITY",
		5: "PROFIT_SHARING",
		6: "COMMISSIONS",
		7: "TIPS",
		8: "OTHER_COMPENSATION_TYPE",
	}
	CompensationInfo_CompensationType_value = map[string]int32{
		"COMPENSATION_TYPE_UNSPECIFIED": 0,
		"BASE":                          1,
		"BONUS":                         2,
		"SIGNING_BONUS":                 3,
		"EQUITY":                        4,
		"PROFIT_SHARING":                5,
		"COMMISSIONS":                   6,
		"TIPS":                          7,
		"OTHER_COMPENSATION_TYPE":       8,
	}
)

func (x CompensationInfo_CompensationType) Enum() *CompensationInfo_CompensationType {
	p := new(CompensationInfo_CompensationType)
	*p = x
	return p
}

func (x CompensationInfo_CompensationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompensationInfo_CompensationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[12].Descriptor()
}

func (CompensationInfo_CompensationType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[12]
}

func (x CompensationInfo_CompensationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompensationInfo_CompensationType.Descriptor instead.
func (CompensationInfo_CompensationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{7, 0}
}

// Pay frequency.
type CompensationInfo_CompensationUnit int32

const (
	// Default value.
	CompensationInfo_COMPENSATION_UNIT_UNSPECIFIED CompensationInfo_CompensationUnit = 0
	// Hourly.
	CompensationInfo_HOURLY CompensationInfo_CompensationUnit = 1
	// Daily.
	CompensationInfo_DAILY CompensationInfo_CompensationUnit = 2
	// Weekly
	CompensationInfo_WEEKLY CompensationInfo_CompensationUnit = 3
	// Monthly.
	CompensationInfo_MONTHLY CompensationInfo_CompensationUnit = 4
	// Yearly.
	CompensationInfo_YEARLY CompensationInfo_CompensationUnit = 5
	// One time.
	CompensationInfo_ONE_TIME CompensationInfo_CompensationUnit = 6
	// Other compensation units.
	CompensationInfo_OTHER_COMPENSATION_UNIT CompensationInfo_CompensationUnit = 7
)

// Enum value maps for CompensationInfo_CompensationUnit.
var (
	CompensationInfo_CompensationUnit_name = map[int32]string{
		0: "COMPENSATION_UNIT_UNSPECIFIED",
		1: "HOURLY",
		2: "DAILY",
		3: "WEEKLY",
		4: "MONTHLY",
		5: "YEARLY",
		6: "ONE_TIME",
		7: "OTHER_COMPENSATION_UNIT",
	}
	CompensationInfo_CompensationUnit_value = map[string]int32{
		"COMPENSATION_UNIT_UNSPECIFIED": 0,
		"HOURLY":                        1,
		"DAILY":                         2,
		"WEEKLY":                        3,
		"MONTHLY":                       4,
		"YEARLY":                        5,
		"ONE_TIME":                      6,
		"OTHER_COMPENSATION_UNIT":       7,
	}
)

func (x CompensationInfo_CompensationUnit) Enum() *CompensationInfo_CompensationUnit {
	p := new(CompensationInfo_CompensationUnit)
	*p = x
	return p
}

func (x CompensationInfo_CompensationUnit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompensationInfo_CompensationUnit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[13].Descriptor()
}

func (CompensationInfo_CompensationUnit) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[13]
}

func (x CompensationInfo_CompensationUnit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompensationInfo_CompensationUnit.Descriptor instead.
func (CompensationInfo_CompensationUnit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{7, 1}
}

type BatchOperationMetadata_State int32

const (
	// Default value.
	BatchOperationMetadata_STATE_UNSPECIFIED BatchOperationMetadata_State = 0
	// The batch operation is being prepared for processing.
	BatchOperationMetadata_INITIALIZING BatchOperationMetadata_State = 1
	// The batch operation is actively being processed.
	BatchOperationMetadata_PROCESSING BatchOperationMetadata_State = 2
	// The batch operation is processed, and at least one item has been
	// successfully processed.
	BatchOperationMetadata_SUCCEEDED BatchOperationMetadata_State = 3
	// The batch operation is done and no item has been successfully processed.
	BatchOperationMetadata_FAILED BatchOperationMetadata_State = 4
	// The batch operation is in the process of cancelling after
	// [google.longrunning.Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
	// is called.
	BatchOperationMetadata_CANCELLING BatchOperationMetadata_State = 5
	// The batch operation is done after
	// [google.longrunning.Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
	// is called. Any items processed before cancelling are returned in the
	// response.
	BatchOperationMetadata_CANCELLED BatchOperationMetadata_State = 6
)

// Enum value maps for BatchOperationMetadata_State.
var (
	BatchOperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INITIALIZING",
		2: "PROCESSING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "CANCELLING",
		6: "CANCELLED",
	}
	BatchOperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INITIALIZING":      1,
		"PROCESSING":        2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"CANCELLING":        5,
		"CANCELLED":         6,
	}
)

func (x BatchOperationMetadata_State) Enum() *BatchOperationMetadata_State {
	p := new(BatchOperationMetadata_State)
	*p = x
	return p
}

func (x BatchOperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchOperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4_common_proto_enumTypes[14].Descriptor()
}

func (BatchOperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4_common_proto_enumTypes[14]
}

func (x BatchOperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchOperationMetadata_State.Descriptor instead.
func (BatchOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{8, 0}
}

// Message representing a period of time between two timestamps.
type TimestampRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Begin of the period (inclusive).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of the period (exclusive).
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimestampRange) Reset() {
	*x = TimestampRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampRange) ProtoMessage() {}

func (x *TimestampRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampRange.ProtoReflect.Descriptor instead.
func (*TimestampRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{0}
}

func (x *TimestampRange) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimestampRange) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// A resource that represents a location with full geographic information.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of a location, which corresponds to the address lines field of
	// [google.type.PostalAddress][google.type.PostalAddress]. For example,
	// "Downtown, Atlanta, GA, USA" has a type of
	// [LocationType.NEIGHBORHOOD][google.cloud.talent.v4.Location.LocationType.NEIGHBORHOOD],
	// and "Kansas City, KS, USA" has a type of
	// [LocationType.LOCALITY][google.cloud.talent.v4.Location.LocationType.LOCALITY].
	LocationType Location_LocationType `protobuf:"varint,1,opt,name=location_type,json=locationType,proto3,enum=google.cloud.talent.v4.Location_LocationType" json:"location_type,omitempty"`
	// Postal address of the location that includes human readable information,
	// such as postal delivery and payments addresses. Given a postal address,
	// a postal service can deliver items to a premises, P.O. Box, or other
	// delivery location.
	PostalAddress *postaladdress.PostalAddress `protobuf:"bytes,2,opt,name=postal_address,json=postalAddress,proto3" json:"postal_address,omitempty"`
	// An object representing a latitude/longitude pair.
	LatLng *latlng.LatLng `protobuf:"bytes,3,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// Radius in miles of the job location. This value is derived from the
	// location bounding box in which a circle with the specified radius
	// centered from [google.type.LatLng][google.type.LatLng] covers the area
	// associated with the job location. For example, currently, "Mountain View,
	// CA, USA" has a radius of 6.17 miles.
	RadiusMiles float64 `protobuf:"fixed64,4,opt,name=radius_miles,json=radiusMiles,proto3" json:"radius_miles,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{1}
}

func (x *Location) GetLocationType() Location_LocationType {
	if x != nil {
		return x.LocationType
	}
	return Location_LOCATION_TYPE_UNSPECIFIED
}

func (x *Location) GetPostalAddress() *postaladdress.PostalAddress {
	if x != nil {
		return x.PostalAddress
	}
	return nil
}

func (x *Location) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

func (x *Location) GetRadiusMiles() float64 {
	if x != nil {
		return x.RadiusMiles
	}
	return 0
}

// Meta information related to the job searcher or entity
// conducting the job search. This information is used to improve the
// performance of the service.
type RequestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required if
	// [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
	// is unset or `false`.
	//
	// The client-defined scope or source of the service call, which typically
	// is the domain on
	// which the service has been implemented and is currently being run.
	//
	// For example, if the service is being run by client <em>Foo, Inc.</em>, on
	// job board www.foo.com and career site www.bar.com, then this field is
	// set to "foo.com" for use on the job board, and "bar.com" for use on the
	// career site.
	//
	// Note that any improvements to the model for a particular tenant site rely
	// on this field being set correctly to a unique domain.
	//
	// The maximum number of allowed characters is 255.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// Required if
	// [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
	// is unset or `false`.
	//
	// A unique session identification string. A session is defined as the
	// duration of an end user's interaction with the service over a certain
	// period.
	// Obfuscate this field for privacy concerns before
	// providing it to the service.
	//
	// Note that any improvements to the model for a particular tenant site rely
	// on this field being set correctly to a unique session ID.
	//
	// The maximum number of allowed characters is 255.
	SessionId string `protobuf:"bytes,2,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Required if
	// [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
	// is unset or `false`.
	//
	// A unique user identification string, as determined by the client.
	// To have the strongest positive impact on search quality
	// make sure the client-level is unique.
	// Obfuscate this field for privacy concerns before
	// providing it to the service.
	//
	// Note that any improvements to the model for a particular tenant site rely
	// on this field being set correctly to a unique user ID.
	//
	// The maximum number of allowed characters is 255.
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Only set when any of
	// [domain][google.cloud.talent.v4.RequestMetadata.domain],
	// [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
	// [user_id][google.cloud.talent.v4.RequestMetadata.user_id] isn't available
	// for some reason. It is highly recommended not to set this field and provide
	// accurate [domain][google.cloud.talent.v4.RequestMetadata.domain],
	// [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
	// [user_id][google.cloud.talent.v4.RequestMetadata.user_id] for the best
	// service experience.
	AllowMissingIds bool `protobuf:"varint,4,opt,name=allow_missing_ids,json=allowMissingIds,proto3" json:"allow_missing_ids,omitempty"`
	// The type of device used by the job seeker at the time of the call to the
	// service.
	DeviceInfo *DeviceInfo `protobuf:"bytes,5,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
}

func (x *RequestMetadata) Reset() {
	*x = RequestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestMetadata) ProtoMessage() {}

func (x *RequestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestMetadata.ProtoReflect.Descriptor instead.
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{2}
}

func (x *RequestMetadata) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *RequestMetadata) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *RequestMetadata) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *RequestMetadata) GetAllowMissingIds() bool {
	if x != nil {
		return x.AllowMissingIds
	}
	return false
}

func (x *RequestMetadata) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

// Additional information returned to client, such as debugging information.
type ResponseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique id associated with this call.
	// This id is logged for tracking purposes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResponseMetadata) Reset() {
	*x = ResponseMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMetadata) ProtoMessage() {}

func (x *ResponseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMetadata.ProtoReflect.Descriptor instead.
func (*ResponseMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{3}
}

func (x *ResponseMetadata) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Device information collected from the job seeker, candidate, or
// other entity conducting the job search. Providing this information improves
// the quality of the search results across devices.
type DeviceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the device.
	DeviceType DeviceInfo_DeviceType `protobuf:"varint,1,opt,name=device_type,json=deviceType,proto3,enum=google.cloud.talent.v4.DeviceInfo_DeviceType" json:"device_type,omitempty"`
	// A device-specific ID. The ID must be a unique identifier that
	// distinguishes the device from other devices.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeviceInfo) Reset() {
	*x = DeviceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceInfo) ProtoMessage() {}

func (x *DeviceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceInfo.ProtoReflect.Descriptor instead.
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{4}
}

func (x *DeviceInfo) GetDeviceType() DeviceInfo_DeviceType {
	if x != nil {
		return x.DeviceType
	}
	return DeviceInfo_DEVICE_TYPE_UNSPECIFIED
}

func (x *DeviceInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Custom attribute values that are either filterable or non-filterable.
type CustomAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one of
	// [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
	// [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
	// specified.
	//
	// This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
	// `CASE_INSENSITIVE_MATCH`) search.
	// For filterable `string_value`s, a maximum total number of 200 values
	// is allowed, with each `string_value` has a byte size of no more than
	// 500B. For unfilterable `string_values`, the maximum total byte size of
	// unfilterable `string_values` is 50KB.
	//
	// Empty string isn't allowed.
	StringValues []string `protobuf:"bytes,1,rep,name=string_values,json=stringValues,proto3" json:"string_values,omitempty"`
	// Exactly one of
	// [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
	// [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
	// specified.
	//
	// This field is used to perform number range search.
	// (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
	//
	// Currently at most 1
	// [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
	// supported.
	LongValues []int64 `protobuf:"varint,2,rep,packed,name=long_values,json=longValues,proto3" json:"long_values,omitempty"`
	// If the `filterable` flag is true, the custom field values may be used for
	// custom attribute filters
	// [JobQuery.custom_attribute_filter][google.cloud.talent.v4.JobQuery.custom_attribute_filter].
	// If false, these values may not be used for custom attribute filters.
	//
	// Default is false.
	Filterable bool `protobuf:"varint,3,opt,name=filterable,proto3" json:"filterable,omitempty"`
	// If the `keyword_searchable` flag is true, the keywords in custom fields are
	// searchable by keyword match.
	// If false, the values are not searchable by keyword match.
	//
	// Default is false.
	KeywordSearchable bool `protobuf:"varint,4,opt,name=keyword_searchable,json=keywordSearchable,proto3" json:"keyword_searchable,omitempty"`
}

func (x *CustomAttribute) Reset() {
	*x = CustomAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomAttribute) ProtoMessage() {}

func (x *CustomAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomAttribute.ProtoReflect.Descriptor instead.
func (*CustomAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{5}
}

func (x *CustomAttribute) GetStringValues() []string {
	if x != nil {
		return x.StringValues
	}
	return nil
}

func (x *CustomAttribute) GetLongValues() []int64 {
	if x != nil {
		return x.LongValues
	}
	return nil
}

func (x *CustomAttribute) GetFilterable() bool {
	if x != nil {
		return x.Filterable
	}
	return false
}

func (x *CustomAttribute) GetKeywordSearchable() bool {
	if x != nil {
		return x.KeywordSearchable
	}
	return false
}

// Spell check result.
type SpellingCorrection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates if the query was corrected by the spell checker.
	Corrected bool `protobuf:"varint,1,opt,name=corrected,proto3" json:"corrected,omitempty"`
	// Correction output consisting of the corrected keyword string.
	CorrectedText string `protobuf:"bytes,2,opt,name=corrected_text,json=correctedText,proto3" json:"corrected_text,omitempty"`
	// Corrected output with html tags to highlight the corrected words.
	// Corrected words are called out with the "<b><i>...</i></b>" html tags.
	//
	// For example, the user input query is "software enginear", where the second
	// word, "enginear," is incorrect. It should be "engineer". When spelling
	// correction is enabled, this value is
	// "software <b><i>engineer</i></b>".
	CorrectedHtml string `protobuf:"bytes,3,opt,name=corrected_html,json=correctedHtml,proto3" json:"corrected_html,omitempty"`
}

func (x *SpellingCorrection) Reset() {
	*x = SpellingCorrection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpellingCorrection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpellingCorrection) ProtoMessage() {}

func (x *SpellingCorrection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpellingCorrection.ProtoReflect.Descriptor instead.
func (*SpellingCorrection) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{6}
}

func (x *SpellingCorrection) GetCorrected() bool {
	if x != nil {
		return x.Corrected
	}
	return false
}

func (x *SpellingCorrection) GetCorrectedText() string {
	if x != nil {
		return x.CorrectedText
	}
	return ""
}

func (x *SpellingCorrection) GetCorrectedHtml() string {
	if x != nil {
		return x.CorrectedHtml
	}
	return ""
}

// Job compensation details.
type CompensationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job compensation information.
	//
	// At most one entry can be of type
	// [CompensationInfo.CompensationType.BASE][google.cloud.talent.v4.CompensationInfo.CompensationType.BASE],
	// which is referred as **base compensation entry** for the job.
	Entries []*CompensationInfo_CompensationEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Output only. Annualized base compensation range. Computed as base
	// compensation entry's
	// [CompensationEntry.amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
	// times
	// [CompensationEntry.expected_units_per_year][google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year].
	//
	// See
	// [CompensationEntry][google.cloud.talent.v4.CompensationInfo.CompensationEntry]
	// for explanation on compensation annualization.
	AnnualizedBaseCompensationRange *CompensationInfo_CompensationRange `protobuf:"bytes,2,opt,name=annualized_base_compensation_range,json=annualizedBaseCompensationRange,proto3" json:"annualized_base_compensation_range,omitempty"`
	// Output only. Annualized total compensation range. Computed as all
	// compensation entries'
	// [CompensationEntry.amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
	// times
	// [CompensationEntry.expected_units_per_year][google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year].
	//
	// See
	// [CompensationEntry][google.cloud.talent.v4.CompensationInfo.CompensationEntry]
	// for explanation on compensation annualization.
	AnnualizedTotalCompensationRange *CompensationInfo_CompensationRange `protobuf:"bytes,3,opt,name=annualized_total_compensation_range,json=annualizedTotalCompensationRange,proto3" json:"annualized_total_compensation_range,omitempty"`
}

func (x *CompensationInfo) Reset() {
	*x = CompensationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompensationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompensationInfo) ProtoMessage() {}

func (x *CompensationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompensationInfo.ProtoReflect.Descriptor instead.
func (*CompensationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{7}
}

func (x *CompensationInfo) GetEntries() []*CompensationInfo_CompensationEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *CompensationInfo) GetAnnualizedBaseCompensationRange() *CompensationInfo_CompensationRange {
	if x != nil {
		return x.AnnualizedBaseCompensationRange
	}
	return nil
}

func (x *CompensationInfo) GetAnnualizedTotalCompensationRange() *CompensationInfo_CompensationRange {
	if x != nil {
		return x.AnnualizedTotalCompensationRange
	}
	return nil
}

// Metadata used for long running operations returned by CTS batch APIs.
// It's used to replace
// [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata].
type BatchOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of a long running operation.
	State BatchOperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.talent.v4.BatchOperationMetadata_State" json:"state,omitempty"`
	// More detailed information about operation state.
	StateDescription string `protobuf:"bytes,2,opt,name=state_description,json=stateDescription,proto3" json:"state_description,omitempty"`
	// Count of successful item(s) inside an operation.
	SuccessCount int32 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of failed item(s) inside an operation.
	FailureCount int32 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
	// Count of total item(s) inside an operation.
	TotalCount int32 `protobuf:"varint,5,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// The time when the batch operation is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time when the batch operation status is updated. The metadata and the
	// [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
	// refreshed every minute otherwise cached data is returned.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The time when the batch operation is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is
	// set to `true`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *BatchOperationMetadata) Reset() {
	*x = BatchOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchOperationMetadata) ProtoMessage() {}

func (x *BatchOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{8}
}

func (x *BatchOperationMetadata) GetState() BatchOperationMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchOperationMetadata_STATE_UNSPECIFIED
}

func (x *BatchOperationMetadata) GetStateDescription() string {
	if x != nil {
		return x.StateDescription
	}
	return ""
}

func (x *BatchOperationMetadata) GetSuccessCount() int32 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *BatchOperationMetadata) GetFailureCount() int32 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

func (x *BatchOperationMetadata) GetTotalCount() int32 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

func (x *BatchOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchOperationMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BatchOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// A compensation entry that represents one component of compensation, such
// as base pay, bonus, or other compensation type.
//
// Annualization: One compensation entry can be annualized if
// - it contains valid
// [amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or
// [range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range].
// - and its
// [expected_units_per_year][google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year]
// is set or can be derived. Its annualized range is determined as
// ([amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or
// [range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range])
// times
// [expected_units_per_year][google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year].
type CompensationInfo_CompensationEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Compensation type.
	//
	// Default is
	// [CompensationType.COMPENSATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.CompensationInfo.CompensationType.COMPENSATION_TYPE_UNSPECIFIED].
	Type CompensationInfo_CompensationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4.CompensationInfo_CompensationType" json:"type,omitempty"`
	// Frequency of the specified amount.
	//
	// Default is
	// [CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED][google.cloud.talent.v4.CompensationInfo.CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED].
	Unit CompensationInfo_CompensationUnit `protobuf:"varint,2,opt,name=unit,proto3,enum=google.cloud.talent.v4.CompensationInfo_CompensationUnit" json:"unit,omitempty"`
	// Compensation amount. It could be a fixed amount or a floating range.
	//
	// Types that are assignable to CompensationAmount:
	//
	//	*CompensationInfo_CompensationEntry_Amount
	//	*CompensationInfo_CompensationEntry_Range
	CompensationAmount isCompensationInfo_CompensationEntry_CompensationAmount `protobuf_oneof:"compensation_amount"`
	// Compensation description.  For example, could
	// indicate equity terms or provide additional context to an estimated
	// bonus.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Expected number of units paid each year. If not specified, when
	// [Job.employment_types][google.cloud.talent.v4.Job.employment_types] is
	// FULLTIME, a default value is inferred based on
	// [unit][google.cloud.talent.v4.CompensationInfo.CompensationEntry.unit].
	// Default values:
	// - HOURLY: 2080
	// - DAILY: 260
	// - WEEKLY: 52
	// - MONTHLY: 12
	// - ANNUAL: 1
	ExpectedUnitsPerYear *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=expected_units_per_year,json=expectedUnitsPerYear,proto3" json:"expected_units_per_year,omitempty"`
}

func (x *CompensationInfo_CompensationEntry) Reset() {
	*x = CompensationInfo_CompensationEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompensationInfo_CompensationEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompensationInfo_CompensationEntry) ProtoMessage() {}

func (x *CompensationInfo_CompensationEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompensationInfo_CompensationEntry.ProtoReflect.Descriptor instead.
func (*CompensationInfo_CompensationEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{7, 0}
}

func (x *CompensationInfo_CompensationEntry) GetType() CompensationInfo_CompensationType {
	if x != nil {
		return x.Type
	}
	return CompensationInfo_COMPENSATION_TYPE_UNSPECIFIED
}

func (x *CompensationInfo_CompensationEntry) GetUnit() CompensationInfo_CompensationUnit {
	if x != nil {
		return x.Unit
	}
	return CompensationInfo_COMPENSATION_UNIT_UNSPECIFIED
}

func (m *CompensationInfo_CompensationEntry) GetCompensationAmount() isCompensationInfo_CompensationEntry_CompensationAmount {
	if m != nil {
		return m.CompensationAmount
	}
	return nil
}

func (x *CompensationInfo_CompensationEntry) GetAmount() *money.Money {
	if x, ok := x.GetCompensationAmount().(*CompensationInfo_CompensationEntry_Amount); ok {
		return x.Amount
	}
	return nil
}

func (x *CompensationInfo_CompensationEntry) GetRange() *CompensationInfo_CompensationRange {
	if x, ok := x.GetCompensationAmount().(*CompensationInfo_CompensationEntry_Range); ok {
		return x.Range
	}
	return nil
}

func (x *CompensationInfo_CompensationEntry) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CompensationInfo_CompensationEntry) GetExpectedUnitsPerYear() *wrapperspb.DoubleValue {
	if x != nil {
		return x.ExpectedUnitsPerYear
	}
	return nil
}

type isCompensationInfo_CompensationEntry_CompensationAmount interface {
	isCompensationInfo_CompensationEntry_CompensationAmount()
}

type CompensationInfo_CompensationEntry_Amount struct {
	// Compensation amount.
	Amount *money.Money `protobuf:"bytes,3,opt,name=amount,proto3,oneof"`
}

type CompensationInfo_CompensationEntry_Range struct {
	// Compensation range.
	Range *CompensationInfo_CompensationRange `protobuf:"bytes,4,opt,name=range,proto3,oneof"`
}

func (*CompensationInfo_CompensationEntry_Amount) isCompensationInfo_CompensationEntry_CompensationAmount() {
}

func (*CompensationInfo_CompensationEntry_Range) isCompensationInfo_CompensationEntry_CompensationAmount() {
}

// Compensation range.
type CompensationInfo_CompensationRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum amount of compensation. If left empty, the value is set
	// to a maximal compensation value and the currency code is set to
	// match the [currency code][google.type.Money.currency_code] of
	// min_compensation.
	MaxCompensation *money.Money `protobuf:"bytes,2,opt,name=max_compensation,json=maxCompensation,proto3" json:"max_compensation,omitempty"`
	// The minimum amount of compensation. If left empty, the value is set
	// to zero and the currency code is set to match the
	// [currency code][google.type.Money.currency_code] of max_compensation.
	MinCompensation *money.Money `protobuf:"bytes,1,opt,name=min_compensation,json=minCompensation,proto3" json:"min_compensation,omitempty"`
}

func (x *CompensationInfo_CompensationRange) Reset() {
	*x = CompensationInfo_CompensationRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompensationInfo_CompensationRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompensationInfo_CompensationRange) ProtoMessage() {}

func (x *CompensationInfo_CompensationRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompensationInfo_CompensationRange.ProtoReflect.Descriptor instead.
func (*CompensationInfo_CompensationRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4_common_proto_rawDescGZIP(), []int{7, 1}
}

func (x *CompensationInfo_CompensationRange) GetMaxCompensation() *money.Money {
	if x != nil {
		return x.MaxCompensation
	}
	return nil
}

func (x *CompensationInfo_CompensationRange) GetMinCompensation() *money.Money {
	if x != nil {
		return x.MinCompensation
	}
	return nil
}

var File_google_cloud_talent_v4_common_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4_common_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74,
	0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x82, 0x01, 0x0a, 0x0e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xe4, 0x03, 0x0a, 0x08, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x0e, 0x70, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d,
	0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x0a,
	0x07, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74,
	0x4c, 0x6e, 0x67, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x72,
	0x61, 0x64, 0x69, 0x75, 0x73, 0x5f, 0x6d, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0b, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x4d, 0x69, 0x6c, 0x65, 0x73, 0x22, 0xef,
	0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x52, 0x59, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x41,
	0x44, 0x4d, 0x49, 0x4e, 0x49, 0x53, 0x54, 0x52, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x52,
	0x45, 0x41, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x55, 0x42, 0x5f, 0x41, 0x44, 0x4d, 0x49,
	0x4e, 0x49, 0x53, 0x54, 0x52, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x52, 0x45, 0x41, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x04, 0x12,
	0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x05,
	0x12, 0x10, 0x0a, 0x0c, 0x53, 0x55, 0x42, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x49, 0x54, 0x59,
	0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x55, 0x42, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x31, 0x10, 0x07, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x55, 0x42, 0x5f, 0x4c, 0x4f,
	0x43, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x32, 0x10, 0x08, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x45,
	0x49, 0x47, 0x48, 0x42, 0x4f, 0x52, 0x48, 0x4f, 0x4f, 0x44, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x54, 0x52, 0x45, 0x45, 0x54, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0a,
	0x22, 0xd2, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x73,
	0x12, 0x43, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x31, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xda, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4e, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x6c, 0x0a, 0x0a, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x57, 0x45, 0x42, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4d,
	0x4f, 0x42, 0x49, 0x4c, 0x45, 0x5f, 0x57, 0x45, 0x42, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x41,
	0x4e, 0x44, 0x52, 0x4f, 0x49, 0x44, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x4f, 0x53, 0x10,
	0x04, 0x12, 0x07, 0x0a, 0x03, 0x42, 0x4f, 0x54, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54,
	0x48, 0x45, 0x52, 0x10, 0x06, 0x22, 0xa6, 0x01, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1f,
	0x0a, 0x0b, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x0a, 0x6c, 0x6f, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x1e, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x2d, 0x0a, 0x12, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x80,
	0x01, 0x0a, 0x12, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x72,
	0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x74, 0x6d, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x48, 0x74, 0x6d,
	0x6c, 0x22, 0xb7, 0x0a, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x54, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x8c, 0x01, 0x0a,
	0x22, 0x61, 0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1f, 0x61, 0x6e, 0x6e, 0x75,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x23,
	0x61, 0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x61, 0x6e, 0x6e, 0x75,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x65,
	0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0xc1, 0x03, 0x0a,
	0x11, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65,
	0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x4d, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74,
	0x12, 0x2c, 0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d,
	0x6f, 0x6e, 0x65, 0x79, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x52,
	0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x17, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x14, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x55, 0x6e, 0x69,
	0x74, 0x73, 0x50, 0x65, 0x72, 0x59, 0x65, 0x61, 0x72, 0x42, 0x15, 0x0a, 0x13, 0x63, 0x6f, 0x6d,
	0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x91, 0x01, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x3d, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d,
	0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d,
	0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f,
	0x6e, 0x65, 0x79, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4d,
	0x50, 0x45, 0x4e, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x42, 0x41, 0x53, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x4f, 0x4e, 0x55, 0x53, 0x10,
	0x02, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4f, 0x4e,
	0x55, 0x53, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x51, 0x55, 0x49, 0x54, 0x59, 0x10, 0x04,
	0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x54, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x53, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x49, 0x50, 0x53, 0x10, 0x07, 0x12,
	0x1b, 0x0a, 0x17, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x45, 0x4e, 0x53,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x08, 0x22, 0x9c, 0x01, 0x0a,
	0x10, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69,
	0x74, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4d, 0x50, 0x45, 0x4e, 0x53, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x4f, 0x55, 0x52, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x57,
	0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48,
	0x4c, 0x59, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x59, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x05,
	0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x4e, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x06, 0x12, 0x1b,
	0x0a, 0x17, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x45, 0x4e, 0x53, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x49, 0x54, 0x10, 0x07, 0x22, 0xa9, 0x04, 0x0a, 0x16,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49,
	0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a,
	0x0a, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x2a, 0x79, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x4e,
	0x59, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x49, 0x4e, 0x49, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4d, 0x45,
	0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d,
	0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x42, 0x49, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x42,
	0x49, 0x47, 0x47, 0x45, 0x52, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x49, 0x41, 0x4e, 0x54,
	0x10, 0x07, 0x2a, 0xe2, 0x01, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x42, 0x65, 0x6e, 0x65, 0x66, 0x69,
	0x74, 0x12, 0x1b, 0x0a, 0x17, 0x4a, 0x4f, 0x42, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x43, 0x48, 0x49, 0x4c, 0x44, 0x5f, 0x43, 0x41, 0x52, 0x45, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x44, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x4f,
	0x4d, 0x45, 0x53, 0x54, 0x49, 0x43, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x10, 0x03,
	0x12, 0x12, 0x0a, 0x0e, 0x46, 0x4c, 0x45, 0x58, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x48, 0x4f, 0x55,
	0x52, 0x53, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x45, 0x44, 0x49, 0x43, 0x41, 0x4c, 0x10,
	0x05, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x49, 0x46, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x55, 0x52, 0x41,
	0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x52, 0x45, 0x4e, 0x54, 0x41,
	0x4c, 0x5f, 0x4c, 0x45, 0x41, 0x56, 0x45, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x54,
	0x49, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x10, 0x08, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x49, 0x43, 0x4b, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x09, 0x12, 0x0c, 0x0a,
	0x08, 0x56, 0x41, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x2a, 0x8e, 0x02, 0x0a, 0x0a, 0x44, 0x65, 0x67, 0x72,
	0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x47, 0x52, 0x45, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x45,
	0x44, 0x55, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x4c, 0x4f,
	0x57, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f, 0x45, 0x44,
	0x55, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x50, 0x50,
	0x45, 0x52, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f, 0x45, 0x44, 0x55,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x44, 0x55, 0x4c,
	0x54, 0x5f, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x4c, 0x5f, 0x45, 0x44, 0x55, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x53, 0x53, 0x4f, 0x43, 0x49,
	0x41, 0x54, 0x45, 0x53, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x49, 0x56, 0x41, 0x4c, 0x45,
	0x4e, 0x54, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x41, 0x43, 0x48, 0x45, 0x4c, 0x4f, 0x52,
	0x53, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x49, 0x56, 0x41, 0x4c, 0x45, 0x4e, 0x54, 0x10,
	0x06, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x53, 0x5f, 0x4f, 0x52, 0x5f,
	0x45, 0x51, 0x55, 0x49, 0x56, 0x41, 0x4c, 0x45, 0x4e, 0x54, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16,
	0x44, 0x4f, 0x43, 0x54, 0x4f, 0x52, 0x41, 0x4c, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x49,
	0x56, 0x41, 0x4c, 0x45, 0x4e, 0x54, 0x10, 0x08, 0x2a, 0xdc, 0x01, 0x0a, 0x0e, 0x45, 0x6d, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x45,
	0x4d, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x41, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f,
	0x4e, 0x54, 0x52, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f,
	0x4e, 0x54, 0x52, 0x41, 0x43, 0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x48, 0x49, 0x52, 0x45, 0x10, 0x04,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x52, 0x59, 0x10, 0x05, 0x12,
	0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x56,
	0x4f, 0x4c, 0x55, 0x4e, 0x54, 0x45, 0x45, 0x52, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x45,
	0x52, 0x5f, 0x44, 0x49, 0x45, 0x4d, 0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x4c, 0x59, 0x5f,
	0x49, 0x4e, 0x5f, 0x46, 0x4c, 0x59, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x09, 0x12, 0x19, 0x0a, 0x15,
	0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x45, 0x4d, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x0a, 0x2a, 0x71, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x19, 0x0a, 0x15, 0x4a, 0x4f, 0x42, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x45, 0x4e, 0x54, 0x52, 0x59, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x45,
	0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x56, 0x45, 0x10, 0x05, 0x2a, 0xba, 0x06, 0x0a, 0x0b, 0x4a,
	0x6f, 0x62, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x18, 0x4a, 0x4f,
	0x42, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x43, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x46, 0x49, 0x4e, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x44, 0x4d, 0x49, 0x4e, 0x49, 0x53, 0x54,
	0x52, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x46, 0x49, 0x43,
	0x45, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x44, 0x56, 0x45, 0x52, 0x54, 0x49, 0x53, 0x49,
	0x4e, 0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x5f, 0x43, 0x41, 0x52,
	0x45, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x41, 0x53, 0x48, 0x49,
	0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44, 0x45, 0x53, 0x49, 0x47, 0x4e, 0x10, 0x05, 0x12,
	0x17, 0x0a, 0x13, 0x42, 0x55, 0x53, 0x49, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4f, 0x50, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x06, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x45, 0x41,
	0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x46, 0x41, 0x43, 0x49, 0x4c, 0x49, 0x54,
	0x49, 0x45, 0x53, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45,
	0x52, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x49, 0x54, 0x10, 0x08, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4f,
	0x4e, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x12, 0x14, 0x0a, 0x10,
	0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x10, 0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x44, 0x55, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x0b, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x54, 0x41, 0x49, 0x4e, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x56, 0x45, 0x4c, 0x10, 0x0c, 0x12,
	0x18, 0x0a, 0x14, 0x46, 0x41, 0x52, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4f,
	0x55, 0x54, 0x44, 0x4f, 0x4f, 0x52, 0x53, 0x10, 0x0d, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x45, 0x41,
	0x4c, 0x54, 0x48, 0x43, 0x41, 0x52, 0x45, 0x10, 0x0e, 0x12, 0x13, 0x0a, 0x0f, 0x48, 0x55, 0x4d,
	0x41, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x10, 0x0f, 0x12, 0x27,
	0x0a, 0x23, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52,
	0x45, 0x50, 0x41, 0x49, 0x52, 0x10, 0x10, 0x12, 0x09, 0x0a, 0x05, 0x4c, 0x45, 0x47, 0x41, 0x4c,
	0x10, 0x11, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x12, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x41, 0x4e, 0x55, 0x46, 0x41, 0x43, 0x54, 0x55, 0x52,
	0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x57, 0x41, 0x52, 0x45, 0x48, 0x4f, 0x55, 0x53,
	0x45, 0x10, 0x13, 0x12, 0x24, 0x0a, 0x20, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x43, 0x4f, 0x4d,
	0x4d, 0x55, 0x4e, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f,
	0x57, 0x52, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x14, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x49, 0x4c,
	0x5f, 0x47, 0x41, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4d, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x15, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x43, 0x41,
	0x52, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x10,
	0x16, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x4f, 0x54, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x10, 0x17, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45,
	0x41, 0x4c, 0x5f, 0x45, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x18, 0x12, 0x1e, 0x0a, 0x1a, 0x52,
	0x45, 0x53, 0x54, 0x41, 0x55, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x48, 0x4f,
	0x53, 0x50, 0x49, 0x54, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x19, 0x12, 0x14, 0x0a, 0x10, 0x53,
	0x41, 0x4c, 0x45, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x10,
	0x1a, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x43, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x1b, 0x12, 0x22,
	0x0a, 0x1e, 0x53, 0x4f, 0x43, 0x49, 0x41, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4e, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x54,
	0x10, 0x1c, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f, 0x46, 0x49, 0x54,
	0x4e, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x1d, 0x12, 0x20, 0x0a, 0x1c, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f,
	0x52, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4c, 0x4f, 0x47, 0x49,
	0x53, 0x54, 0x49, 0x43, 0x53, 0x10, 0x1e, 0x2a, 0x65, 0x0a, 0x0d, 0x50, 0x6f, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4f, 0x53, 0x54,
	0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x44, 0x4d, 0x49,
	0x4e, 0x49, 0x53, 0x54, 0x52, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x52, 0x45, 0x41, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54, 0x45, 0x10, 0x03, 0x2a, 0x6e,
	0x0a, 0x0a, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x16,
	0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x48,
	0x41, 0x52, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x10, 0x03, 0x1a, 0x02, 0x18, 0x01, 0x2a, 0x71,
	0x0a, 0x10, 0x48, 0x74, 0x6d, 0x6c, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x48, 0x54, 0x4d, 0x4c, 0x5f, 0x53, 0x41, 0x4e, 0x49, 0x54,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x48, 0x54, 0x4d, 0x4c, 0x5f, 0x53, 0x41,
	0x4e, 0x49, 0x54, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x49, 0x4d, 0x50, 0x4c, 0x45, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10,
	0x02, 0x2a, 0x7b, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54, 0x45, 0x5f, 0x4d, 0x45,
	0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x52, 0x49, 0x56, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07,
	0x57, 0x41, 0x4c, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x59, 0x43,
	0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49,
	0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x05, 0x42, 0x65,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x42, 0x0b, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x34, 0x2f, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xa2,
	0x02, 0x03, 0x43, 0x54, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_talent_v4_common_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4_common_proto_rawDescData = file_google_cloud_talent_v4_common_proto_rawDesc
)

func file_google_cloud_talent_v4_common_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4_common_proto_rawDescData)
	})
	return file_google_cloud_talent_v4_common_proto_rawDescData
}

var file_google_cloud_talent_v4_common_proto_enumTypes = make([]protoimpl.EnumInfo, 15)
var file_google_cloud_talent_v4_common_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_talent_v4_common_proto_goTypes = []any{
	(CompanySize)(0),                           // 0: google.cloud.talent.v4.CompanySize
	(JobBenefit)(0),                            // 1: google.cloud.talent.v4.JobBenefit
	(DegreeType)(0),                            // 2: google.cloud.talent.v4.DegreeType
	(EmploymentType)(0),                        // 3: google.cloud.talent.v4.EmploymentType
	(JobLevel)(0),                              // 4: google.cloud.talent.v4.JobLevel
	(JobCategory)(0),                           // 5: google.cloud.talent.v4.JobCategory
	(PostingRegion)(0),                         // 6: google.cloud.talent.v4.PostingRegion
	(Visibility)(0),                            // 7: google.cloud.talent.v4.Visibility
	(HtmlSanitization)(0),                      // 8: google.cloud.talent.v4.HtmlSanitization
	(CommuteMethod)(0),                         // 9: google.cloud.talent.v4.CommuteMethod
	(Location_LocationType)(0),                 // 10: google.cloud.talent.v4.Location.LocationType
	(DeviceInfo_DeviceType)(0),                 // 11: google.cloud.talent.v4.DeviceInfo.DeviceType
	(CompensationInfo_CompensationType)(0),     // 12: google.cloud.talent.v4.CompensationInfo.CompensationType
	(CompensationInfo_CompensationUnit)(0),     // 13: google.cloud.talent.v4.CompensationInfo.CompensationUnit
	(BatchOperationMetadata_State)(0),          // 14: google.cloud.talent.v4.BatchOperationMetadata.State
	(*TimestampRange)(nil),                     // 15: google.cloud.talent.v4.TimestampRange
	(*Location)(nil),                           // 16: google.cloud.talent.v4.Location
	(*RequestMetadata)(nil),                    // 17: google.cloud.talent.v4.RequestMetadata
	(*ResponseMetadata)(nil),                   // 18: google.cloud.talent.v4.ResponseMetadata
	(*DeviceInfo)(nil),                         // 19: google.cloud.talent.v4.DeviceInfo
	(*CustomAttribute)(nil),                    // 20: google.cloud.talent.v4.CustomAttribute
	(*SpellingCorrection)(nil),                 // 21: google.cloud.talent.v4.SpellingCorrection
	(*CompensationInfo)(nil),                   // 22: google.cloud.talent.v4.CompensationInfo
	(*BatchOperationMetadata)(nil),             // 23: google.cloud.talent.v4.BatchOperationMetadata
	(*CompensationInfo_CompensationEntry)(nil), // 24: google.cloud.talent.v4.CompensationInfo.CompensationEntry
	(*CompensationInfo_CompensationRange)(nil), // 25: google.cloud.talent.v4.CompensationInfo.CompensationRange
	(*timestamppb.Timestamp)(nil),              // 26: google.protobuf.Timestamp
	(*postaladdress.PostalAddress)(nil),        // 27: google.type.PostalAddress
	(*latlng.LatLng)(nil),                      // 28: google.type.LatLng
	(*money.Money)(nil),                        // 29: google.type.Money
	(*wrapperspb.DoubleValue)(nil),             // 30: google.protobuf.DoubleValue
}
var file_google_cloud_talent_v4_common_proto_depIdxs = []int32{
	26, // 0: google.cloud.talent.v4.TimestampRange.start_time:type_name -> google.protobuf.Timestamp
	26, // 1: google.cloud.talent.v4.TimestampRange.end_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.talent.v4.Location.location_type:type_name -> google.cloud.talent.v4.Location.LocationType
	27, // 3: google.cloud.talent.v4.Location.postal_address:type_name -> google.type.PostalAddress
	28, // 4: google.cloud.talent.v4.Location.lat_lng:type_name -> google.type.LatLng
	19, // 5: google.cloud.talent.v4.RequestMetadata.device_info:type_name -> google.cloud.talent.v4.DeviceInfo
	11, // 6: google.cloud.talent.v4.DeviceInfo.device_type:type_name -> google.cloud.talent.v4.DeviceInfo.DeviceType
	24, // 7: google.cloud.talent.v4.CompensationInfo.entries:type_name -> google.cloud.talent.v4.CompensationInfo.CompensationEntry
	25, // 8: google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range:type_name -> google.cloud.talent.v4.CompensationInfo.CompensationRange
	25, // 9: google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range:type_name -> google.cloud.talent.v4.CompensationInfo.CompensationRange
	14, // 10: google.cloud.talent.v4.BatchOperationMetadata.state:type_name -> google.cloud.talent.v4.BatchOperationMetadata.State
	26, // 11: google.cloud.talent.v4.BatchOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	26, // 12: google.cloud.talent.v4.BatchOperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	26, // 13: google.cloud.talent.v4.BatchOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	12, // 14: google.cloud.talent.v4.CompensationInfo.CompensationEntry.type:type_name -> google.cloud.talent.v4.CompensationInfo.CompensationType
	13, // 15: google.cloud.talent.v4.CompensationInfo.CompensationEntry.unit:type_name -> google.cloud.talent.v4.CompensationInfo.CompensationUnit
	29, // 16: google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount:type_name -> google.type.Money
	25, // 17: google.cloud.talent.v4.CompensationInfo.CompensationEntry.range:type_name -> google.cloud.talent.v4.CompensationInfo.CompensationRange
	30, // 18: google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year:type_name -> google.protobuf.DoubleValue
	29, // 19: google.cloud.talent.v4.CompensationInfo.CompensationRange.max_compensation:type_name -> google.type.Money
	29, // 20: google.cloud.talent.v4.CompensationInfo.CompensationRange.min_compensation:type_name -> google.type.Money
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4_common_proto_init() }
func file_google_cloud_talent_v4_common_proto_init() {
	if File_google_cloud_talent_v4_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4_common_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*TimestampRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*RequestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ResponseMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*DeviceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CustomAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*SpellingCorrection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*CompensationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*BatchOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*CompensationInfo_CompensationEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4_common_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CompensationInfo_CompensationRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_talent_v4_common_proto_msgTypes[9].OneofWrappers = []any{
		(*CompensationInfo_CompensationEntry_Amount)(nil),
		(*CompensationInfo_CompensationEntry_Range)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4_common_proto_rawDesc,
			NumEnums:      15,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_talent_v4_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_talent_v4_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_talent_v4_common_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4_common_proto = out.File
	file_google_cloud_talent_v4_common_proto_rawDesc = nil
	file_google_cloud_talent_v4_common_proto_goTypes = nil
	file_google_cloud_talent_v4_common_proto_depIdxs = nil
}
