/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SoundActionListener
implements HyperlinkListener {
    public static synchronized void playSound(final File file) {
        new SwingWorker<Void, Void>(){
            private Clip clip;
            private AudioInputStream inputStream;

            @Override
            protected Void doInBackground() throws Exception {
                this.clip = AudioSystem.getClip();
                this.inputStream = AudioSystem.getAudioInputStream(file);
                this.clip.open(this.inputStream);
                this.clip.start();
                this.clip.drain();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.clip.close();
            }
        }.execute();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        URL url;
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType()) && "file".equals((url = hyperlinkEvent.getURL()).getProtocol())) {
            try {
                String path = url.getPath();
                if (path != null && (path.endsWith(".wav") || path.endsWith(".WAV"))) {
                    SoundActionListener.playSound(new File(url.toURI()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }
}

