/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.ClassOrderingVisitor;
import org.junit.jupiter.engine.discovery.ClassSelectorResolver;
import org.junit.jupiter.engine.discovery.MethodOrderingVisitor;
import org.junit.jupiter.engine.discovery.MethodSelectorResolver;
import org.junit.jupiter.engine.discovery.predicates.IsTestClassWithTests;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;

@API(status=API.Status.INTERNAL, since="5.0")
public class DiscoverySelectorResolver {
    private static final EngineDiscoveryRequestResolver<JupiterEngineDescriptor> resolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver((Predicate)new IsTestClassWithTests()).addSelectorResolver(context -> new ClassSelectorResolver(context.getClassNameFilter(), ((JupiterEngineDescriptor)context.getEngineDescriptor()).getConfiguration())).addSelectorResolver(context -> new MethodSelectorResolver(((JupiterEngineDescriptor)context.getEngineDescriptor()).getConfiguration())).addTestDescriptorVisitor(context -> new ClassOrderingVisitor(((JupiterEngineDescriptor)context.getEngineDescriptor()).getConfiguration())).addTestDescriptorVisitor(context -> new MethodOrderingVisitor(((JupiterEngineDescriptor)context.getEngineDescriptor()).getConfiguration())).addTestDescriptorVisitor(context -> TestDescriptor::prune).build();

    public void resolveSelectors(EngineDiscoveryRequest request, JupiterEngineDescriptor engineDescriptor) {
        resolver.resolve(request, (TestDescriptor)engineDescriptor);
    }
}

