/*
 Copyright (c) 2021, 2025, Oracle and/or its affiliates.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License, version 2.0,
 as published by the Free Software Foundation.

 This program is designed to work with certain software (including
 but not limited to OpenSSL) that is licensed under separate terms,
 as designated in a particular file or component or in included license
 documentation.  The authors of MySQL hereby grant you an additional
 permission to link the program and your derivative works with the
 separately licensed software that they have either included with
 the program or referenced in the documentation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "mrs/database/query_entry_content_file.h"

#include <stdexcept>

#include "mysql/harness/logging/logging.h"

IMPORT_LOG_FUNCTIONS()

namespace mrs {
namespace database {

void QueryEntryContentFile::query_file(MySQLSession *session,
                                       const entry::UniversalId &file_id) {
  file_id_ = file_id;
  query_ = {
      "SELECT size,content FROM mysql_rest_service_metadata.content_file WHERE "
      "id=?"};

  query_ << file_id;
  received_ = false;
  Query::execute(session);

  if (!received_)
    throw std::runtime_error(
        "Query generated by `QueryEntryContentFile`, didn't return any row.");
}

void QueryEntryContentFile::on_row(const ResultRow &r) {
  if (r.size() != 2) {
    log_error(
        "While querying for content_file, the result set has unexpected number "
        "of columns: %zu",
        r.size());
    return;
  }
  auto data = r[1];
  int data_length = atoi(r[0]);

  result.assign(data, data_length);
  received_ = true;
}

}  // namespace database
}  // namespace mrs
