/*
  Copyright (c) 2021, 2025, Oracle and/or its affiliates.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2.0,
  as published by the Free Software Foundation.

  This program is designed to work with certain software (including
  but not limited to OpenSSL) that is licensed under separate terms,
  as designated in a particular file or component or in included license
  documentation.  The authors of MySQL hereby grant you an additional
  permission to link the program and your derivative works with the
  separately licensed software that they have either included with
  the program or referenced in the documentation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ROUTER_SRC_REST_MRS_SRC_MRS_DATABASE_ENTRY_AUTH_ROLE_H_
#define ROUTER_SRC_REST_MRS_SRC_MRS_DATABASE_ENTRY_AUTH_ROLE_H_

#include "mrs/database/entry/universal_id.h"

#include "helper/json/serializer_to_text.h"
#include "helper/optional.h"

namespace mrs {
namespace database {
namespace entry {

class AuthRole {
 public:
  UniversalId id;
  std::string caption;
  helper::Optional<UniversalId> derived_from_role_id;
  helper::Optional<UniversalId> specific_to_service_id;
};

inline std::string to_string(const AuthRole &entry) {
  helper::json::SerializerToText stt;
  {
    auto obj = stt.add_object();
    stt.member_add_value("id",
                         reinterpret_cast<const char *>(entry.id.raw.data()),
                         entry.id.raw.size());
    stt.member_add_value("caption", entry.caption);
  }

  return stt.get_result();
}

}  // namespace entry
}  // namespace database
}  // namespace mrs

#endif  // ROUTER_SRC_REST_MRS_SRC_MRS_DATABASE_ENTRY_AUTH_ROLE_H_
