/*
  Copyright (c) 2022, 2025, Oracle and/or its affiliates.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2.0,
  as published by the Free Software Foundation.

  This program is designed to work with certain software (including
  but not limited to OpenSSL) that is licensed under separate terms,
  as designated in a particular file or component or in included license
  documentation.  The authors of MySQL hereby grant you an additional
  permission to link the program and your derivative works with the
  separately licensed software that they have either included with
  the program or referenced in the documentation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef MYSQL_HARNESS_MAKE_SHARED_PTR_INCLUDED
#define MYSQL_HARNESS_MAKE_SHARED_PTR_INCLUDED

#include <memory>
#include <utility>

namespace mysql_harness {

template <typename T>
class MakeSharedPtr {
 public:
  using shared_ptr = std::shared_ptr<T>;

  template <typename... Args>
  MakeSharedPtr(Args &&...args) {
    ptr = std::make_shared<T>(std::forward<Args>(args)...);
  }

  operator shared_ptr &() { return ptr; }

  operator const shared_ptr &() const { return ptr; }

  template <typename Z>
  operator std::shared_ptr<Z>() {
    return ptr;
  }

  template <typename Z>
  operator const std::shared_ptr<Z>() const {
    return ptr;
  }

  T *get() const { return ptr.get(); }

  T &operator*() const { return *ptr; }

  T *operator->() const { return get(); }

  void reset(T *t) { ptr.reset(t); }

  shared_ptr copy_base() { return ptr; }

 private:
  shared_ptr ptr;
};

}  // namespace mysql_harness

#endif  // MYSQL_HARNESS_MAKE_SHARED_PTR_INCLUDED
