# -----------------------------------------------------
# Schema func_schema
# -----------------------------------------------------
# Create schema that contains various MySQL functions
--disable_query_log
--disable_result_log

--let $router_test_schemas=func_schema;$router_test_schemas
DROP SCHEMA IF EXISTS `func_schema`;

CREATE SCHEMA IF NOT EXISTS `func_schema`;
USE `func_schema`;

CREATE TABLE `func_schema`.`dummy_data` (
  `id` INTEGER NOT NULL AUTO_INCREMENT,
  `value` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `value_UNIQUE` (`value` ASC) VISIBLE);

DELIMITER $$;

CREATE FUNCTION `func_schema`.`nothing` () RETURNS INTEGER
BEGIN
  RETURN 0;
END;$$

CREATE FUNCTION `func_schema`.`func_sum` (a INTEGER, b INTEGER) RETURNS INTEGER
BEGIN
  RETURN a + b;
END;$$

CREATE FUNCTION `func_schema`.`move_char` (a VARCHAR(20)) RETURNS VARCHAR(20)
BEGIN
  RETURN CONCAT(a," appended");
END;$$

CREATE FUNCTION `func_schema`.`move_date` (a DATE) RETURNS DATE
BEGIN
  RETURN  a;
END;$$

CREATE FUNCTION `func_schema`.`move_year` (a YEAR) RETURNS YEAR
BEGIN
  RETURN  a;
END;$$

CREATE FUNCTION `func_schema`.`move_time` (a TIME) RETURNS TIME
BEGIN
  RETURN  a;
END;$$

CREATE FUNCTION `func_schema`.`move_bit` (a BIT(1)) RETURNS BIT(1)
BEGIN
  RETURN  a;
END;$$

CREATE FUNCTION `func_schema`.`move_tinyint1` (a TINYINT(1)) RETURNS TINYINT(1)
BEGIN
  RETURN  a+1;
END;$$

CREATE FUNCTION `func_schema`.`move_tinyint8` (a TINYINT(8)) RETURNS TINYINT(8)
BEGIN
  RETURN  a+1;
END;$$

CREATE FUNCTION `func_schema`.`move_decimal` (a DECIMAL) RETURNS DECIMAL
BEGIN
  RETURN  a+1;
END;$$

CREATE FUNCTION `func_schema`.`move_float` (a FLOAT) RETURNS FLOAT
BEGIN
  RETURN  a+1;
END;$$

CREATE FUNCTION `func_schema`.`move_double` (a DOUBLE) RETURNS DOUBLE
BEGIN
  RETURN  a+1;
END;$$

CREATE FUNCTION `func_schema`.`move_json` (a JSON) RETURNS JSON
BEGIN
  RETURN a;
END;$$

CREATE FUNCTION `func_schema`.`move_geo` (a GEOMETRY) RETURNS GEOMETRY
BEGIN
  RETURN a;
END;$$

CREATE FUNCTION `func_schema`.`move_line` (a LINESTRING) RETURNS LINESTRING
BEGIN
  RETURN a;
END;$$


CREATE FUNCTION `func_schema`.`return_media` () RETURNS VARBINARY(1000)
BEGIN
    RETURN X'FFD8FFE000104A46494600010101012C012C0000FFE202B04943435F50524F46494C45000101000002A06C636D73043000006D6E74725247422058595A2007E5000B0009000500310003616373704150504C0000000000000000000000000000000000000000000000000000F6D6000100000000D32D6C636D7300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000D64657363000001200000004063707274000001600000003677747074000001980000001463686164000001AC0000002C7258595A000001D8000000146258595A000001EC000000146758595A00000200000000147254524300000214000000206754524300000214000000206254524300000214000000206368726D0000023400000024646D6E640000025800000024646D64640000027C000000246D6C756300000000000000010000000C656E5553000000240000001C00470049004D00500020006200750069006C0074002D0069006E002000730052004700426D6C756300000000000000010000000C656E55530000001A0000001C005000750062006C0069006300200044006F006D00610069006E000058595A20000000000000F6D6000100000000D32D736633320000000000010C42000005DEFFFFF325000007930000FD90FFFFFBA1FFFFFDA2000003DC0000C06E58595A200000000000006FA0000038F50000039058595A20000000000000249F00000F840000B6C458595A2000000000000062970000B787000018D9706172610000000000030000000266660000F2A700000D59000013D000000A5B6368726D00000000000300000000A3D70000547C00004CCD0000999A0000266700000F5C6D6C756300000000000000010000000C656E5553000000080000001C00470049004D00506D6C756300000000000000010000000C656E5553000000080000001C0073005200470042FFDB004300593D434E4338594E484E645E596985DE90857A7A85FFC2CDA1DEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDB0043015E6464857585FF9090FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00011080008000803011100021101031101FFC40014000100000000000000000000000000000003FFC4001A1000000700000000000000000000000000001113226281F0FFC4001501010100000000000000000000000000000002FFC400161101010100000000000000000000000000001121FFDA000C03010002110311003F0077AD12D60AC8FFD9';
END;$$


CREATE FUNCTION `func_schema`.`report_back_mysql_error1` (mysql_error INTEGER) RETURNS INTEGER
BEGIN
  SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'This stored procedure signaled an error.', MYSQL_ERRNO = mysql_error;
  RETURN 2;
END;$$

CREATE FUNCTION `func_schema`.`report_back_mysql_error2` (mysql_error INTEGER, mysql_message TEXT) RETURNS INTEGER
BEGIN
  SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = mysql_message, MYSQL_ERRNO = mysql_error;
  RETURN 2;
END;$$

CREATE FUNCTION `func_schema`.`report_back_mysql_error_if`(error_out BOOLEAN) RETURNS INTEGER
BEGIN
    IF (error_out = 1) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'This stored procedured signaled an error.', MYSQL_ERRNO = 5511;
    END IF;
    RETURN 2;
END$$

CREATE FUNCTION `func_schema`.`insert_and_return`(value VARCHAR(255)) RETURNS INTEGER
BEGIN
  INSERT INTO `func_schema`.`dummy_data` (`value`) VALUES(value);

  RETURN 1;
END;$$

CREATE FUNCTION `func_schema`.`insert_and_return_no_param`() RETURNS INTEGER
BEGIN
  INSERT INTO `func_schema`.`dummy_data` (`value`) VALUES("value");

  RETURN 1;
END;$$

CREATE FUNCTION signal_warning() RETURNS INTEGER
BEGIN
    SIGNAL SQLSTATE '01000' SET MESSAGE_TEXT = 'This is a warning message';
    RETURN 44;
END;$$

CREATE FUNCTION signal_not_found() RETURNS INTEGER
BEGIN
    SIGNAL SQLSTATE '02000' SET MESSAGE_TEXT = 'data not found';
    RETURN 44;
END;$$

CREATE FUNCTION signal_exception() RETURNS INTEGER
BEGIN
    SIGNAL SQLSTATE '03000' SET MESSAGE_TEXT = 'some exception condition';
    RETURN 44;
END;$$

--enable_query_log
--enable_result_log

--echo # DB `func_schema` - created

DELIMITER ;$$
