/****************************************************************************
**
** Copyright (C) 2025 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

var vcRedistRegistryValueMinor = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x64\\Minor";
var vcRedistRegistryValueBld = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x64\\Bld";
var installVcRedist = false;

// constructor
function Component()
{
    // Visual Studio 2022 version 17.13.6 requires VC++ runtime 14.43.34810 or above
    if (
        (installer.value(vcRedistRegistryValueMinor, 0, QSettings.Registry32Format) < 43)
        || (
            (installer.value(vcRedistRegistryValueMinor, 0, QSettings.Registry32Format) == 43)
            && (installer.value(vcRedistRegistryValueBld, 0, QSettings.Registry32Format) < 34810)
        )
    )
    {
        component.setValue("RequiresAdminRights", "true");
        installVcRedist = true;
    }
    // Make the VCRedist component visible and selected by default in the (generated)
    // offline installers. This enables standalone offline installers (e.g. for Squish)
    // so that the customer can run the (generated) offline installer without extra param
    // "--show-virtual-components" and without needing to know the tools.licenseservice
    // component name as one argument on the command line
    if (installer.isOfflineOnly()) {
        component.setValue("Virtual", "false");
        component.setValue("Default", "true");
    }
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations and afterwards set some registry settings
    // so that the simulator finds its fonts and applications find the simulator
    component.createOperations();

    if (installVcRedist) {
        // return value 3010 means it need a reboot, but in most cases it is not needed for run Qt application
        // return value 5100 means there's a newer version of the runtime already installed
        component.addElevatedOperation("Execute", "{0,3010,1638,5100}", "@TargetDir@/vcredist/vc14.50.35719_VC_redist.x64.exe", "/norestart", "/quiet");
    } else {
        console.log("Microsoft Visual C++ v14 Redistributable (x64) for MSVC2022 is already installed")
    }
}
