/**************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Installer Framework.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
**************************************************************************/

// constructor
function Component()
{
}

var Dir = new function ()
{
    this.toNativeSeparator = function (path)
    {
        path = path.replace(/\/\//g, '/');
        if (systemInfo.productType === "windows")
            return path.replace(/\//g, '\\');
        return path;
    }
};

Component.prototype.createOperations = function()
{
    component.createOperations();

    // register doc & examples to QtCreator
    registerQtCreatorDocumentation(component, "/AdditionalLibraries/Qt/qtimageformats-6.0.4/Docs");
    registerQtCreatorExampleSet(component, "Qt Image Formats 6.0.4", "/AdditionalLibraries/Qt/qtimageformats-6.0.4/Docs", "/AdditionalLibraries/Qt/qtimageformats-6.0.4/Examples");

    var conan_reference = "qtimageformats/6.0.4@qt/final";
    // conanfile.py is expected to locate in the root of the sources directory
    var workingDirectory = installer.value("TargetDir") + Dir.toNativeSeparator("//AdditionalLibraries/Qt/qtimageformats-6.0.4/Src");

    // Export conan recipe into local cache
    // https://docs.conan.io/en/latest/reference/commands/return_codes.html
    component.addOperation("Execute", "{0,1,5}", "workingdirectory=" + workingDirectory,
        installer.value("QtConanBinary"), "export", ".", conan_reference,
        "UNDOEXECUTE", installer.value("QtConanBinary"), "remove", "-f", conan_reference);
}

