/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    if (installer.value("XCodeChecked") == false) {
        var xcodeVersion = installer.execute("/usr/bin/xcodebuild", new Array("-version"))[0];
        if (!xcodeVersion) {
            QMessageBox["warning"]("XcodeError",
                qsTr("Xcode installation not found!"),
                qsTr("You need to install Xcode and set up Xcode command line tools. Download Xcode from https://developer.apple.com\n"));
        }
    }
    installer.setValue("XCodeChecked", true)
}

var Dir = new function ()
{
    this.toNativeSeparator = function (path)
    {
        path = path.replace(/\/\//g, '/');
        if (systemInfo.productType === "windows")
            return path.replace(/\//g, '\\');
        return path;
    }
};

Component.prototype.createOperations = function()
{
    component.createOperations();
    try {
        var qtPath = "@TargetDir@" + "/6.4.2/macos";
        var qmakeBinary = "@TargetDir@" + "/6.4.2/macos/bin/qmake";
        addInitQtPatchOperation(component, "mac", qtPath, qmakeBinary, "qt5");

        if (installer.value("SDKToolBinary") == "")
            return;

        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addQt",
                                "--id", component.name,
                                "--name", "Qt %{Qt:Version} for macOS",
                                "--type", "Qt4ProjectManager.QtVersion.Desktop",
                                "--qmake", qmakeBinary,
                                "UNDOEXECUTE",
                                "@SDKToolBinary@", "rmQt", "--id", component.name]);

        var kitName = component.name + "_kit";
        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addKit",
                                "--id", kitName,
                                "--name", "Qt %{Qt:Version} for macOS",
                                "--Ctoolchain", "x86-macos-generic-mach_o-64bit",
                                "--Cxxtoolchain", "x86-macos-generic-mach_o-64bit",
                                "--qt", component.name,
                                "--debuggerengine", "256", // DebuggerEngineType::LldbEngineType
                                "--devicetype", "Desktop",
                                "UNDOEXECUTE",
                                "@SDKToolBinary@", "rmKit", "--id", kitName]);

        // create qt.conf file
        createQtConfFiles(component, installer.value("TargetDir") + "/6.4.2/macos", "Qt-6.4.2");

        // is this OpenSource installation?
        var isOpenSource = "true";
        if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
            // patch qconfig.pri
            var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
            component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck_mac", "QT_LICHECK =");
        }

        // QTBUG-37650
        patchQtAssistant(component, installer.value("TargetDir") + "/6.4.2/macos", "Qt-6.4.2");

    } catch(e) {
        print(e);
    }
}

//QTBUG-37650
function patchQtAssistant(aComponent, aComponentRootPath, aQtInstallationName)
{
    if (installer.value("os") == "mac") {
        print("Patching qt.conf for Assistant to: " + aComponentRootPath);
        var fileName = aComponentRootPath + "/bin/Assistant.app/Contents/Resources/" + "qt.conf";
        print("qt.conf file: " + fileName);

        aComponent.addOperation("Settings",
            "path=" + fileName,
            "method=add_array_value",
            "key=Paths/Prefix",
            "value=../../..");

        aComponent.addOperation("Settings",
        "path=" + fileName,
        "method=add_array_value",
        "key=Paths/Documentation",
        "value=../../Docs/" + aQtInstallationName);
    }
}

