/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import org.qtproject.qt5.android.QtExtractedText;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.QtNativeInputConnection;

public class QtInputConnection
extends BaseInputConnection {
    private static final int ID_SELECT_ALL = 16908319;
    private static final int ID_CUT = 0x1020020;
    private static final int ID_COPY = 0x1020021;
    private static final int ID_PASTE = 0x1020022;
    private static final int ID_COPY_URL = 16908323;
    private static final int ID_SWITCH_INPUT_METHOD = 16908324;
    private static final int ID_ADD_TO_DICTIONARY = 16908330;
    View m_view;
    boolean m_closing;

    public QtInputConnection(View view) {
        super(view, true);
        this.m_view = view;
        this.m_closing = false;
    }

    public boolean beginBatchEdit() {
        this.m_closing = false;
        return true;
    }

    public boolean endBatchEdit() {
        this.m_closing = false;
        return true;
    }

    public boolean commitCompletion(CompletionInfo completionInfo) {
        this.m_closing = false;
        return QtNativeInputConnection.commitCompletion(((Object)completionInfo.getText()).toString(), completionInfo.getPosition());
    }

    public boolean commitText(CharSequence charSequence, int n) {
        this.m_closing = false;
        return QtNativeInputConnection.commitText(((Object)charSequence).toString(), n);
    }

    public boolean deleteSurroundingText(int n, int n2) {
        this.m_closing = false;
        return QtNativeInputConnection.deleteSurroundingText(n, n2);
    }

    public boolean finishComposingText() {
        if (this.m_closing) {
            QtNative.activityDelegate().m_keyboardIsHiding = true;
            this.m_view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (QtNative.activityDelegate().m_keyboardIsHiding) {
                        QtNative.activityDelegate().m_keyboardIsVisible = false;
                    }
                }
            }, 5000L);
            this.m_closing = false;
        } else {
            this.m_closing = true;
        }
        return QtNativeInputConnection.finishComposingText();
    }

    public int getCursorCapsMode(int n) {
        return QtNativeInputConnection.getCursorCapsMode(n);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        QtExtractedText qtExtractedText = QtNativeInputConnection.getExtractedText(extractedTextRequest.hintMaxChars, extractedTextRequest.hintMaxLines, n);
        ExtractedText extractedText = new ExtractedText();
        extractedText.partialEndOffset = qtExtractedText.partialEndOffset;
        extractedText.partialStartOffset = qtExtractedText.partialStartOffset;
        extractedText.selectionEnd = qtExtractedText.selectionEnd;
        extractedText.selectionStart = qtExtractedText.selectionStart;
        extractedText.startOffset = qtExtractedText.startOffset;
        extractedText.text = qtExtractedText.text;
        return extractedText;
    }

    public CharSequence getSelectedText(int n) {
        return QtNativeInputConnection.getSelectedText(n);
    }

    public CharSequence getTextAfterCursor(int n, int n2) {
        return QtNativeInputConnection.getTextAfterCursor(n, n2);
    }

    public CharSequence getTextBeforeCursor(int n, int n2) {
        return QtNativeInputConnection.getTextBeforeCursor(n, n2);
    }

    public boolean performContextMenuAction(int n) {
        switch (n) {
            case 16908319: {
                return QtNativeInputConnection.selectAll();
            }
            case 0x1020021: {
                return QtNativeInputConnection.copy();
            }
            case 16908323: {
                return QtNativeInputConnection.copyURL();
            }
            case 0x1020020: {
                return QtNativeInputConnection.cut();
            }
            case 0x1020022: {
                return QtNativeInputConnection.paste();
            }
            case 16908324: {
                InputMethodManager inputMethodManager = (InputMethodManager)this.m_view.getContext().getSystemService("input_method");
                if (inputMethodManager != null) {
                    inputMethodManager.showInputMethodPicker();
                }
                return true;
            }
            case 16908330: {
                return true;
            }
        }
        return super.performContextMenuAction(n);
    }

    public boolean setComposingText(CharSequence charSequence, int n) {
        return QtNativeInputConnection.setComposingText(((Object)charSequence).toString(), n);
    }

    public boolean setSelection(int n, int n2) {
        return QtNativeInputConnection.setSelection(n, n2);
    }
}

