/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.positioning;

import android.app.Activity;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class QtPositioning
implements LocationListener {
    private static final String TAG = "QtPositioning";
    static LocationManager locationManager = null;
    static Object m_syncObject = new Object();
    static HashMap<Integer, QtPositioning> runningListeners = new HashMap();
    private int nativeClassReference = 0;
    private int expectedProviders = 0;
    public static final int QT_GPS_PROVIDER = 1;
    public static final int QT_NETWORK_PROVIDER = 2;
    public static final int QT_ACCESS_ERROR = 0;
    public static final int QT_CLOSED_ERROR = 1;
    public static final int QT_POSITION_UNKNOWN_SOURCE_ERROR = 2;
    public static final int QT_POSITION_NO_ERROR = 3;
    public static final int QT_SATELLITE_NO_ERROR = 2;
    public static final int QT_SATELLITE_UNKNOWN_SOURCE_ERROR = -1;
    private boolean isSingleUpdate = false;
    private int updateIntervalTime = 0;
    private Location lastGps = null;
    private Location lastNetwork = null;
    private boolean isSatelliteUpdate = false;
    private PositioningLooper looperThread = new PositioningLooper();

    public static void setActivity(Activity activity, Object object) {
        try {
            locationManager = (LocationManager)activity.getSystemService("location");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int[] providerList() {
        List list = locationManager.getAllProviders();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = ((String)list.get(i)).equals("gps") ? 0 : (((String)list.get(i)).equals("network") ? 1 : (((String)list.get(i)).equals("passive") ? 2 : -1));
        }
        return nArray;
    }

    public static Location lastKnownPosition(boolean bl) {
        Location location = null;
        Location location2 = null;
        try {
            location = locationManager.getLastKnownLocation("gps");
            if (!bl) {
                location2 = locationManager.getLastKnownLocation("network");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            location2 = null;
            location = null;
        }
        if (location != null && location2 != null) {
            long l = location2.getTime() - location.getTime();
            if (l < 14400000L) {
                return location;
            }
            return location2;
        }
        if (location != null) {
            return location;
        }
        if (location2 != null) {
            return location2;
        }
        return null;
    }

    private static boolean expectedProvidersAvailable(int n) {
        List list = locationManager.getProviders(true);
        if ((n & 1) > 0 && list.contains("gps")) {
            return true;
        }
        return (n & 2) > 0 && list.contains("network");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startUpdates(int n, int n2, int n3) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                boolean bl = false;
                QtPositioning qtPositioning = new QtPositioning();
                qtPositioning.nativeClassReference = n;
                qtPositioning.expectedProviders = n2;
                qtPositioning.isSatelliteUpdate = false;
                qtPositioning.setActiveLooper(true);
                if (n3 == 0) {
                    n3 = 1000;
                }
                qtPositioning.updateIntervalTime = n3;
                if ((n2 & 1) > 0) {
                    Log.d((String)TAG, (String)("Regular updates using GPS " + n3));
                    try {
                        locationManager.requestLocationUpdates("gps", (long)n3, 0.0f, (LocationListener)qtPositioning, qtPositioning.looper());
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                        bl = true;
                    }
                }
                if ((n2 & 2) > 0) {
                    Log.d((String)TAG, (String)("Regular updates using network " + n3));
                    try {
                        locationManager.requestLocationUpdates("network", (long)n3, 0.0f, (LocationListener)qtPositioning, qtPositioning.looper());
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                        bl = true;
                    }
                }
                if (bl) {
                    qtPositioning.setActiveLooper(false);
                    locationManager.removeUpdates((LocationListener)qtPositioning);
                    return 0;
                }
                if (!QtPositioning.expectedProvidersAvailable(n2)) {
                    return 1;
                }
                runningListeners.put(n, qtPositioning);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 2;
            }
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopUpdates(int n) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                Log.d((String)TAG, (String)"Stopping updates");
                QtPositioning qtPositioning = runningListeners.remove(n);
                locationManager.removeUpdates((LocationListener)qtPositioning);
                qtPositioning.setActiveLooper(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int requestUpdate(int n, int n2) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                boolean bl = false;
                QtPositioning qtPositioning = new QtPositioning();
                qtPositioning.nativeClassReference = n;
                qtPositioning.isSingleUpdate = true;
                qtPositioning.expectedProviders = n2;
                qtPositioning.isSatelliteUpdate = false;
                qtPositioning.setActiveLooper(true);
                if ((n2 & 1) > 0) {
                    Log.d((String)TAG, (String)"Single update using GPS");
                    try {
                        locationManager.requestSingleUpdate("gps", (LocationListener)qtPositioning, qtPositioning.looper());
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                        bl = true;
                    }
                }
                if ((n2 & 2) > 0) {
                    Log.d((String)TAG, (String)"Single update using network");
                    try {
                        locationManager.requestSingleUpdate("network", (LocationListener)qtPositioning, qtPositioning.looper());
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                        bl = true;
                    }
                }
                if (bl) {
                    qtPositioning.setActiveLooper(false);
                    locationManager.removeUpdates((LocationListener)qtPositioning);
                    return 0;
                }
                if (!QtPositioning.expectedProvidersAvailable(n2)) {
                    return 1;
                }
                runningListeners.put(n, qtPositioning);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 2;
            }
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startSatelliteUpdates(int n, int n2, boolean bl) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                boolean bl2 = false;
                QtPositioning qtPositioning = new QtPositioning();
                qtPositioning.isSatelliteUpdate = true;
                qtPositioning.nativeClassReference = n;
                qtPositioning.expectedProviders = 1;
                qtPositioning.isSingleUpdate = bl;
                qtPositioning.setActiveLooper(true);
                if (n2 == 0) {
                    n2 = 1000;
                }
                if (bl) {
                    Log.d((String)TAG, (String)("Single update for Satellites " + n2));
                } else {
                    Log.d((String)TAG, (String)("Regular updates for Satellites " + n2));
                }
                try {
                    locationManager.requestLocationUpdates("gps", (long)n2, 0.0f, (LocationListener)qtPositioning, qtPositioning.looper());
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    bl2 = true;
                }
                if (bl2) {
                    qtPositioning.setActiveLooper(false);
                    locationManager.removeUpdates((LocationListener)qtPositioning);
                    return 0;
                }
                if (!QtPositioning.expectedProvidersAvailable(qtPositioning.expectedProviders)) {
                    return 1;
                }
                runningListeners.put(n, qtPositioning);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
            return 2;
        }
    }

    public Looper looper() {
        return this.looperThread.looper();
    }

    private void setActiveLooper(boolean bl) {
        try {
            if (bl) {
                if (this.looperThread.isAlive()) {
                    return;
                }
                if (this.isSatelliteUpdate) {
                    this.looperThread.isSatelliteListener(true);
                }
                long l = System.currentTimeMillis();
                this.looperThread.start();
                while (!this.looperThread.isReady()) {
                }
                long l2 = System.currentTimeMillis();
                Log.d((String)TAG, (String)("Looper Thread startup time in ms: " + (l2 - l)));
            } else {
                this.looperThread.quitLooper();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static native void positionUpdated(Location var0, int var1, boolean var2);

    public static native void locationProvidersDisabled(int var0);

    public static native void satelliteUpdated(GpsSatellite[] var0, int var1, boolean var2);

    public void onLocationChanged(Location location) {
        if (location == null) {
            return;
        }
        if (this.isSatelliteUpdate) {
            return;
        }
        if (this.isSingleUpdate || this.expectedProviders < 3) {
            QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
            return;
        }
        if (location.getProvider().equals("gps")) {
            this.lastGps = location;
            QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
        } else if (location.getProvider().equals("network")) {
            this.lastNetwork = location;
            if (this.lastGps == null) {
                QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
                return;
            }
            long l = location.getTime() - this.lastGps.getTime();
            if (l < (long)this.updateIntervalTime) {
                return;
            }
            QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
        }
    }

    public void onStatusChanged(String string, int n, Bundle bundle) {
    }

    public void onProviderEnabled(String string) {
        Log.d((String)TAG, (String)("Enabled provider: " + string));
    }

    public void onProviderDisabled(String string) {
        Log.d((String)TAG, (String)("Disabled provider: " + string));
        if (!QtPositioning.expectedProvidersAvailable(this.expectedProviders)) {
            QtPositioning.locationProvidersDisabled(this.nativeClassReference);
        }
    }

    private class PositioningLooper
    extends Thread
    implements GpsStatus.Listener {
        private boolean looperRunning = false;
        private Looper posLooper;
        private boolean isSatelliteLooper = false;
        private LocationManager locManager = null;

        private PositioningLooper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            Handler handler = new Handler();
            if (this.isSatelliteLooper) {
                try {
                    locationManager.addGpsStatusListener((GpsStatus.Listener)this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.posLooper = Looper.myLooper();
            PositioningLooper positioningLooper = this;
            synchronized (positioningLooper) {
                this.looperRunning = true;
            }
            Looper.loop();
            positioningLooper = this;
            synchronized (positioningLooper) {
                this.looperRunning = false;
            }
        }

        public void quitLooper() {
            if (this.isSatelliteLooper) {
                locationManager.removeGpsStatusListener((GpsStatus.Listener)this);
            }
            this.looper().quit();
        }

        public synchronized boolean isReady() {
            return this.looperRunning;
        }

        public void isSatelliteListener(boolean bl) {
            this.isSatelliteLooper = bl;
        }

        public Looper looper() {
            return this.posLooper;
        }

        public void onGpsStatusChanged(int n) {
            switch (n) {
                case 3: {
                    break;
                }
                case 4: {
                    GpsSatellite[] gpsSatelliteArray;
                    GpsStatus gpsStatus = locationManager.getGpsStatus(null);
                    Iterable iterable = gpsStatus.getSatellites();
                    Iterator iterator = iterable.iterator();
                    ArrayList<GpsSatellite[]> arrayList = new ArrayList<GpsSatellite[]>();
                    while (iterator.hasNext()) {
                        gpsSatelliteArray = (GpsSatellite[])iterator.next();
                        arrayList.add(gpsSatelliteArray);
                    }
                    gpsSatelliteArray = arrayList.toArray(new GpsSatellite[arrayList.size()]);
                    QtPositioning.satelliteUpdated(gpsSatelliteArray, QtPositioning.this.nativeClassReference, QtPositioning.this.isSingleUpdate);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }
}

