/****************************************************************************
**
** Copyright (C) 2016 Petar Perisin <petar.perisin@gmail.com>
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#ifndef UTILS_ANSIESCAPECODEHANDLER_H
#define UTILS_ANSIESCAPECODEHANDLER_H

#include "utils_global.h"

#include <QTextCharFormat>

namespace Utils {

class QTCREATOR_UTILS_EXPORT FormattedText {
public:
    FormattedText() { }
    FormattedText(const FormattedText &other) : text(other.text), format(other.format) { }
    FormattedText(const QString &txt, const QTextCharFormat &fmt = QTextCharFormat()) :
        text(txt), format(fmt)
    { }

    QString text;
    QTextCharFormat format;
};

class QTCREATOR_UTILS_EXPORT AnsiEscapeCodeHandler
{
public:
    AnsiEscapeCodeHandler();
    QList<FormattedText> parseText(const FormattedText &input);
    void endFormatScope();

private:
    void setFormatScope(const QTextCharFormat &charFormat);

    bool            m_previousFormatClosed;
    QTextCharFormat m_previousFormat;
    QString         m_pendingText;
};

} // namespace Utils

#endif // UTILS_ANSIESCAPECODEHANDLER_H
