import{ObjectWrapper as e,Settings as t,Revealer as i,UIString as s,Throttler as n}from"../common/common.js";import{DockController as o}from"../components/components.js";import{userMetrics as a,UserMetrics as l,InspectorFrontendHost as r,Platform as h}from"../host/host.js";import{Geometry as c,Toolbar as d,UIUtils as u,Utils as m,ContextMenu as _,Widget as p,ZoomManager as g,Tooltip as v,ResizerWidget as S,RootView as b,SplitWidget as w,ListWidget as f,ARIAUtils as I,SettingsUI as C,ViewManager as E}from"../ui/ui.js";import{InspectorBackend as M}from"../protocol_client/protocol_client.js";import{NetworkManager as x,SDKModel as D,EmulationModel as L,ResourceTreeModel as y,ScreenCaptureModel as R,CSSModel as z,OverlayModel as T,DOMModel as U}from"../sdk/sdk.js";import{StringUtilities as A}from"../platform/platform.js";import{ThrottlingManager as O}from"../mobile_throttling/mobile_throttling.js";import{CSSWorkspaceBinding as k}from"../bindings/bindings.js";class F{constructor(){this.title="",this.type=B.Unknown,this.vertical={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this.horizontal={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this.deviceScaleFactor=1,this.capabilities=[H.Touch,H.Mobile],this.userAgent="",this.userAgentMetadata=null,this.modes=[],this.isDualScreen=!1,this.verticalSpanned={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this.horizontalSpanned={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this._show=j.Default,this._showByDefault=!0,this._extension=null}static fromJSONV1(e){try{function t(e,t,i,s){if("object"!=typeof e||null===e||!e.hasOwnProperty(t)){if(void 0!==s)return s;throw new Error("Emulated device is missing required property '"+t+"'")}const n=e[t];if(typeof n!==i||null===n)throw new Error("Emulated device property '"+t+"' has wrong type '"+typeof n+"'");return n}function i(e,i){const s=t(e,i,"number");if(s!==Math.abs(s))throw new Error("Emulated device value '"+i+"' must be integer");return s}function s(e){return new c.Insets(i(e,"left"),i(e,"top"),i(e,"right"),i(e,"bottom"))}function n(e){const s={};if(s.r=i(e,"r"),s.r<0||s.r>255)throw new Error("color has wrong r value: "+s.r);if(s.g=i(e,"g"),s.g<0||s.g>255)throw new Error("color has wrong g value: "+s.g);if(s.b=i(e,"b"),s.b<0||s.b>255)throw new Error("color has wrong b value: "+s.b);if(s.a=t(e,"a","number"),s.a<0||s.a>1)throw new Error("color has wrong a value: "+s.a);return s}function o(e){const o={};if(o.width=i(e,"width"),o.width<0||o.width>ee||o.width<Y)throw new Error("Emulated device has wrong width: "+o.width);if(o.height=i(e,"height"),o.height<0||o.height>ee||o.height<Y)throw new Error("Emulated device has wrong height: "+o.height);const a=t(e.outline,"insets","object",null);if(a){if(o.outlineInsets=s(a),o.outlineInsets.left<0||o.outlineInsets.top<0)throw new Error("Emulated device has wrong outline insets");o.outlineImage=t(e.outline,"image","string")}return e.hinge&&(o.hinge=function(e){const t={};if(t.width=i(e,"width"),t.width<0||t.width>ee)throw new Error("Emulated device has wrong hinge width: "+t.width);if(t.height=i(e,"height"),t.height<0||t.height>ee)throw new Error("Emulated device has wrong hinge height: "+t.height);if(t.x=i(e,"x"),t.x<0||t.x>ee)throw new Error("Emulated device has wrong x offset: "+t.height);if(t.y=i(e,"y"),t.x<0||t.x>ee)throw new Error("Emulated device has wrong y offset: "+t.height);return e.contentColor&&(t.contentColor=n(e.contentColor)),e.outlineColor&&(t.outlineColor=n(e.outlineColor)),t}(t(e,"hinge","object",void 0))),o}const a=new F;a.title=t(e,"title","string"),a.type=t(e,"type","string");const l=t(e,"user-agent","string");a.userAgent=x.MultitargetNetworkManager.patchUserAgentWithChromeVersion(l);const r=t(e,"user-agent-metadata","object",null);r&&(void 0===r.brands&&(r.brands=x.MultitargetNetworkManager.getChromeBrands()),void 0===r.fullVersion&&(r.fullVersion=x.MultitargetNetworkManager.getChromeVersion())),a.userAgentMetadata=r;const h=t(e,"capabilities","object",[]);if(!Array.isArray(h))throw new Error("Emulated device capabilities must be an array");a.capabilities=[];for(let e=0;e<h.length;++e){if("string"!=typeof h[e])throw new Error("Emulated device capability must be a string");a.capabilities.push(h[e])}if(a.deviceScaleFactor=t(e.screen,"device-pixel-ratio","number"),a.deviceScaleFactor<0||a.deviceScaleFactor>100)throw new Error("Emulated device has wrong deviceScaleFactor: "+a.deviceScaleFactor);if(a.vertical=o(t(e.screen,"vertical","object")),a.horizontal=o(t(e.screen,"horizontal","object")),a.isDualScreen=t(e,"dual-screen","boolean",!1),a.isDualScreen&&(a.verticalSpanned=o(t(e.screen,"vertical-spanned","object",null)),a.horizontalSpanned=o(t(e.screen,"horizontal-spanned","object",null))),a.isDualScreen&&(!a.verticalSpanned||!a.horizontalSpanned))throw new Error("Emulated device '"+a.title+"'has dual screen without spanned orientations");const d=t(e,"modes","object",[{title:"default",orientation:"vertical"},{title:"default",orientation:"horizontal"}]);if(!Array.isArray(d))throw new Error("Emulated device modes must be an array");a.modes=[];for(let e=0;e<d.length;++e){const i={};if(i.title=t(d[e],"title","string"),i.orientation=t(d[e],"orientation","string"),i.orientation!==V&&i.orientation!==W&&i.orientation!==P&&i.orientation!==N)throw new Error("Emulated device mode has wrong orientation '"+i.orientation+"'");const n=a.orientationByName(i.orientation);if(i.insets=s(t(d[e],"insets","object",{left:0,top:0,right:0,bottom:0})),i.insets.top<0||i.insets.left<0||i.insets.right<0||i.insets.bottom<0||i.insets.top+i.insets.bottom>n.height||i.insets.left+i.insets.right>n.width)throw new Error("Emulated device mode '"+i.title+"'has wrong mode insets");i.image=t(d[e],"image","string",null),a.modes.push(i)}return a._showByDefault=t(e,"show-by-default","boolean",void 0),a._show=t(e,"show","string",j.Default),a}catch(e){return null}}static deviceComparator(e,t){const i=e._extension&&e._extension.descriptor().order||-1,s=t._extension&&t._extension.descriptor().order||-1;return i>s?1:s>i||e.title<t.title?-1:e.title>t.title?1:0}extension(){return this._extension}setExtension(e){this._extension=e}modesForOrientation(e){const t=[];for(let i=0;i<this.modes.length;i++)this.modes[i].orientation===e&&t.push(this.modes[i]);return t}getSpanPartner(e){switch(e.orientation){case V:return this.modesForOrientation(P)[0];case W:return this.modesForOrientation(N)[0];case P:return this.modesForOrientation(V)[0];default:return this.modesForOrientation(W)[0]}}getRotationPartner(e){switch(e.orientation){case N:return this.modesForOrientation(P)[0];case P:return this.modesForOrientation(N)[0];case W:return this.modesForOrientation(V)[0];default:return this.modesForOrientation(W)[0]}}_toJSON(){const e={};e.title=this.title,e.type=this.type,e["user-agent"]=this.userAgent,e.capabilities=this.capabilities,e.screen={},e.screen["device-pixel-ratio"]=this.deviceScaleFactor,e.screen.vertical=this._orientationToJSON(this.vertical),e.screen.horizontal=this._orientationToJSON(this.horizontal),this.isDualScreen&&(e.screen["vertical-spanned"]=this._orientationToJSON(this.verticalSpanned),e.screen["horizontal-spanned"]=this._orientationToJSON(this.horizontalSpanned)),e.modes=[];for(let t=0;t<this.modes.length;++t){const i={};i.title=this.modes[t].title,i.orientation=this.modes[t].orientation,i.insets={},i.insets.left=this.modes[t].insets.left,i.insets.top=this.modes[t].insets.top,i.insets.right=this.modes[t].insets.right,i.insets.bottom=this.modes[t].insets.bottom,this.modes[t].image&&(i.image=this.modes[t].image),e.modes.push(i)}return e["show-by-default"]=this._showByDefault,e["dual-screen"]=this.isDualScreen,e.show=this._show,e}_orientationToJSON(e){const t={};return t.width=e.width,t.height=e.height,e.outlineInsets&&(t.outline={},t.outline.insets={},t.outline.insets.left=e.outlineInsets.left,t.outline.insets.top=e.outlineInsets.top,t.outline.insets.right=e.outlineInsets.right,t.outline.insets.bottom=e.outlineInsets.bottom,t.outline.image=e.outlineImage),e.hinge&&(t.hinge={},t.hinge.width=e.hinge.width,t.hinge.height=e.hinge.height,t.hinge.x=e.hinge.x,t.hinge.y=e.hinge.y,e.hinge.contentColor&&(t.hinge.contentColor={},t.hinge.contentColor.r=e.hinge.contentColor.r,t.hinge.contentColor.g=e.hinge.contentColor.g,t.hinge.contentColor.b=e.hinge.contentColor.b,t.hinge.contentColor.a=e.hinge.contentColor.a),e.hinge.outlineColor&&(t.hinge.outlineColor={},t.hinge.outlineColor.r=e.hinge.outlineColor.r,t.hinge.outlineColor.g=e.hinge.outlineColor.g,t.hinge.outlineColor.b=e.hinge.outlineColor.b,t.hinge.outlineColor.a=e.hinge.outlineColor.a)),t}modeImage(e){return e.image?this._extension?this._extension.module().substituteURL(e.image):e.image:""}outlineImage(e){const t=this.orientationByName(e.orientation);return t.outlineImage?this._extension?this._extension.module().substituteURL(t.outlineImage):t.outlineImage:""}orientationByName(e){switch(e){case P:return this.verticalSpanned;case N:return this.horizontalSpanned;case V:return this.vertical;default:return this.horizontal}}show(){return this._show===j.Default?this._showByDefault:this._show===j.Always}setShow(e){this._show=e?j.Always:j.Never}copyShowFrom(e){this._show=e._show}touch(){return-1!==this.capabilities.indexOf(H.Touch)}mobile(){return-1!==this.capabilities.indexOf(H.Mobile)}}const W="horizontal",V="vertical",N="horizontal-spanned",P="vertical-spanned",B={Phone:"phone",Tablet:"tablet",Notebook:"notebook",Desktop:"desktop",Unknown:"unknown"},H={Touch:"touch",Mobile:"mobile"},j={Always:"Always",Default:"Default",Never:"Never"};let q;class Q extends e.ObjectWrapper{constructor(){super(),this._standardSetting=t.Settings.instance().createSetting("standardEmulatedDeviceList",[]),this._standard=new Set,this._listFromJSONV1(this._standardSetting.get(),this._standard),this._updateStandardDevices(),this._customSetting=t.Settings.instance().createSetting("customEmulatedDeviceList",[]),this._custom=new Set,this._listFromJSONV1(this._customSetting.get(),this._custom)||this.saveCustomDevices()}static instance(){return q||(q=new Q),q}_updateStandardDevices(){const e=new Set,t=self.runtime.extensions("emulated-device");for(const i of t){const t=F.fromJSONV1(i.descriptor().device);t.setExtension(i),e.add(t)}this._copyShowValues(this._standard,e),this._standard=e,this.saveStandardDevices()}_listFromJSONV1(e,t){if(!Array.isArray(e))return!1;let i=!0;for(let s=0;s<e.length;++s){const n=F.fromJSONV1(e[s]);n?(t.add(n),n.modes.length||(n.modes.push({title:"",orientation:W,insets:new c.Insets(0,0,0,0),image:null}),n.modes.push({title:"",orientation:V,insets:new c.Insets(0,0,0,0),image:null}))):i=!1}return i}standard(){return[...this._standard]}custom(){return[...this._custom]}revealCustomSetting(){i.reveal(this._customSetting)}addCustomDevice(e){this._custom.add(e),this.saveCustomDevices()}removeCustomDevice(e){this._custom.delete(e),this.saveCustomDevices()}saveCustomDevices(){const e=[];this._custom.forEach(t=>e.push(t._toJSON())),this._customSetting.set(e),this.dispatchEventToListeners(J.CustomDevicesUpdated)}saveStandardDevices(){const e=[];this._standard.forEach(t=>e.push(t._toJSON())),this._standardSetting.set(e),this.dispatchEventToListeners(J.StandardDevicesUpdated)}_copyShowValues(e,t){const i=new Map;for(const t of e)i.set(t.title,t);for(const e of t){const t=i.get(e.title);t&&e.copyShowFrom(t)}}}const J={CustomDevicesUpdated:Symbol("CustomDevicesUpdated"),StandardDevicesUpdated:Symbol("StandardDevicesUpdated")};var Z=Object.freeze({__proto__:null,EmulatedDevice:F,Horizontal:W,Vertical:V,HorizontalSpanned:N,VerticalSpanned:P,Type:B,Capability:H,_Show:j,EmulatedDevicesList:Q,Events:J,Mode:void 0,Orientation:void 0});class $ extends e.ObjectWrapper{constructor(){super(),this._screenRect=new c.Rect(0,0,1,1),this._visiblePageRect=new c.Rect(0,0,1,1),this._availableSize=new c.Size(1,1),this._preferredSize=new c.Size(1,1),this._initialized=!1,this._appliedDeviceSize=new c.Size(1,1),this._appliedDeviceScaleFactor=window.devicePixelRatio,this._appliedUserAgentType=K.Desktop,this._experimentDualScreenSupport=Root.Runtime.experiments.isEnabled("dualScreenSupport"),this._scaleSetting=t.Settings.instance().createSetting("emulation.deviceScale",1),this._scaleSetting.get()||this._scaleSetting.set(1),this._scaleSetting.addChangeListener(this._scaleSettingChanged,this),this._widthSetting=t.Settings.instance().createSetting("emulation.deviceWidth",400),this._widthSetting.get()<Y&&this._widthSetting.set(Y),this._widthSetting.get()>ee&&this._widthSetting.set(ee),this._widthSetting.addChangeListener(this._widthSettingChanged,this),this._heightSetting=t.Settings.instance().createSetting("emulation.deviceHeight",0),this._heightSetting.get()&&this._heightSetting.get()<Y&&this._heightSetting.set(Y),this._heightSetting.get()>ee&&this._heightSetting.set(ee),this._heightSetting.addChangeListener(this._heightSettingChanged,this),this._uaSetting=t.Settings.instance().createSetting("emulation.deviceUA",K.Mobile),this._uaSetting.addChangeListener(this._uaSettingChanged,this),this._deviceScaleFactorSetting=t.Settings.instance().createSetting("emulation.deviceScaleFactor",0),this._deviceScaleFactorSetting.addChangeListener(this._deviceScaleFactorSettingChanged,this),this._deviceOutlineSetting=t.Settings.instance().moduleSetting("emulation.showDeviceOutline"),this._deviceOutlineSetting.addChangeListener(this._deviceOutlineSettingChanged,this),this._toolbarControlsEnabledSetting=t.Settings.instance().createSetting("emulation.toolbarControlsEnabled",!0,t.SettingStorageType.Session),this._type=X.None,this._device=null,this._mode=null,this._fitScale=1,this._touchEnabled=!1,this._touchMobile=!1,this._emulationModel=null,this._onModelAvailable=null,D.TargetManager.instance().observeModels(L.EmulationModel,this)}static widthValidator(e){let t,i=!1;return/^[\d]+$/.test(e)?e>ee?t=ls`Width must be less than or equal to ${ee}.`:e<Y?t=ls`Width must be greater than or equal to ${Y}.`:i=!0:t=ls`Width must be a number.`,{valid:i,errorMessage:t}}static heightValidator(e){let t,i=!1;return/^[\d]+$/.test(e)?e>ee?t=ls`Height must be less than or equal to ${ee}.`:e<Y?t=ls`Height must be greater than or equal to ${Y}.`:i=!0:t=ls`Height must be a number.`,{valid:i,errorMessage:t}}static scaleValidator(e){let t,i=!1;const s=Number(e.trim());return e?Number.isNaN(s)?t=ls`Device pixel ratio must be a number or blank.`:e>ie?t=ls`Device pixel ratio must be less than or equal to ${ie}.`:e<te?t=ls`Device pixel ratio must be greater than or equal to ${te}.`:i=!0:i=!0,{valid:i,errorMessage:t}}setAvailableSize(e,t){this._availableSize=e,this._preferredSize=t,this._initialized=!0,this._calculateAndEmulate(!1)}emulate(e,t,i,s){const n=this._type!==e||this._device!==t||this._mode!==i;if(this._type=e,e===X.Device){if(console.assert(t&&i,"Must pass device and mode for device emulation"),this._mode=i,this._device=t,this._initialized){const e=t.orientationByName(i.orientation);this._scaleSetting.set(s||this._calculateFitScale(e.width,e.height,this._currentOutline(),this._currentInsets()))}}else this._device=null,this._mode=null;e!==X.None&&a.actionTaken(l.Action.DeviceModeEnabled),this._calculateAndEmulate(n)}setWidth(e){const t=Math.min(ee,this._preferredScaledWidth());e=Math.max(Math.min(e,t),1),this._widthSetting.set(e)}setWidthAndScaleToFit(e){e=Math.max(Math.min(e,ee),1),this._scaleSetting.set(this._calculateFitScale(e,this._heightSetting.get())),this._widthSetting.set(e)}setHeight(e){const t=Math.min(ee,this._preferredScaledHeight());(e=Math.max(Math.min(e,t),0))===this._preferredScaledHeight()&&(e=0),this._heightSetting.set(e)}setHeightAndScaleToFit(e){e=Math.max(Math.min(e,ee),0),this._scaleSetting.set(this._calculateFitScale(this._widthSetting.get(),e)),this._heightSetting.set(e)}setScale(e){this._scaleSetting.set(e)}device(){return this._device}mode(){return this._mode}type(){return this._type}screenImage(){return this._device&&this._mode?this._device.modeImage(this._mode):""}outlineImage(){return this._device&&this._mode&&this._deviceOutlineSetting.get()?this._device.outlineImage(this._mode):""}outlineRect(){return this._outlineRect}screenRect(){return this._screenRect}visiblePageRect(){return this._visiblePageRect}scale(){return this._scale}fitScale(){return this._fitScale}appliedDeviceSize(){return this._appliedDeviceSize}appliedDeviceScaleFactor(){return this._appliedDeviceScaleFactor}appliedUserAgentType(){return this._appliedUserAgentType}isFullHeight(){return!this._heightSetting.get()}_isMobile(){switch(this._type){case X.Device:return this._device.mobile();case X.None:return!1;case X.Responsive:return this._uaSetting.get()===K.Mobile||this._uaSetting.get()===K.MobileNoTouch}return!1}enabledSetting(){return t.Settings.instance().createSetting("emulation.showDeviceMode",!1)}scaleSetting(){return this._scaleSetting}uaSetting(){return this._uaSetting}deviceScaleFactorSetting(){return this._deviceScaleFactorSetting}deviceOutlineSetting(){return this._deviceOutlineSetting}toolbarControlsEnabledSetting(){return this._toolbarControlsEnabledSetting}reset(){this._deviceScaleFactorSetting.set(0),this._scaleSetting.set(1),this.setWidth(400),this.setHeight(0),this._uaSetting.set(K.Mobile)}modelAdded(e){if(!this._emulationModel&&e.supportsDeviceEmulation()){if(this._emulationModel=e,this._onModelAvailable){const e=this._onModelAvailable;this._onModelAvailable=null,e()}const t=e.target().model(y.ResourceTreeModel);t&&t.addEventListener(y.Events.FrameResized,this._onFrameResized,this)}else e.emulateTouch(this._touchEnabled,this._touchMobile)}modelRemoved(e){this._emulationModel===e&&(this._emulationModel=null)}inspectedURL(){return this._emulationModel?this._emulationModel.target().inspectedURL():null}_onFrameResized(){const e=this._emulationModel?this._emulationModel.overlayModel():null;e&&this._showHingeIfApplicable(e)}_scaleSettingChanged(){this._calculateAndEmulate(!1)}_widthSettingChanged(){this._calculateAndEmulate(!1)}_heightSettingChanged(){this._calculateAndEmulate(!1)}_uaSettingChanged(){this._calculateAndEmulate(!0)}_deviceScaleFactorSettingChanged(){this._calculateAndEmulate(!1)}_deviceOutlineSettingChanged(){this._calculateAndEmulate(!1)}_preferredScaledWidth(){return Math.floor(this._preferredSize.width/(this._scaleSetting.get()||1))}_preferredScaledHeight(){return Math.floor(this._preferredSize.height/(this._scaleSetting.get()||1))}_currentOutline(){let e=new c.Insets(0,0,0,0);if(this._type!==X.Device)return e;const t=this._device.orientationByName(this._mode.orientation);return this._deviceOutlineSetting.get()&&(e=t.outlineInsets||e),e}_currentInsets(){return this._type!==X.Device?new c.Insets(0,0,0,0):this._mode.insets}_calculateAndEmulate(e){this._emulationModel||(this._onModelAvailable=this._calculateAndEmulate.bind(this,e));const t=this._isMobile(),i=this._emulationModel?this._emulationModel.overlayModel():null;if(i&&this._showHingeIfApplicable(i),this._type===X.Device){const i=this._device.orientationByName(this._mode.orientation),s=this._currentOutline(),n=this._currentInsets();this._fitScale=this._calculateFitScale(i.width,i.height,s,n),this._appliedUserAgentType=t?this._device.touch()?K.Mobile:K.MobileNoTouch:this._device.touch()?K.DesktopTouch:K.Desktop,this._applyDeviceMetrics(new c.Size(i.width,i.height),n,s,this._scaleSetting.get(),this._device.deviceScaleFactor,t,this._mode.orientation===W?Protocol.Emulation.ScreenOrientationType.LandscapePrimary:Protocol.Emulation.ScreenOrientationType.PortraitPrimary,e),this._applyUserAgent(this._device.userAgent,this._device.userAgentMetadata),this._applyTouch(this._device.touch(),t)}else if(this._type===X.None)this._fitScale=this._calculateFitScale(this._availableSize.width,this._availableSize.height),this._appliedUserAgentType=K.Desktop,this._applyDeviceMetrics(this._availableSize,new c.Insets(0,0,0,0),new c.Insets(0,0,0,0),1,0,t,null,e),this._applyUserAgent("",null),this._applyTouch(!1,!1);else if(this._type===X.Responsive){let i=this._widthSetting.get();(!i||i>this._preferredScaledWidth())&&(i=this._preferredScaledWidth());let s=this._heightSetting.get();(!s||s>this._preferredScaledHeight())&&(s=this._preferredScaledHeight());const n=t?oe:0;this._fitScale=this._calculateFitScale(this._widthSetting.get(),this._heightSetting.get()),this._appliedUserAgentType=this._uaSetting.get(),this._applyDeviceMetrics(new c.Size(i,s),new c.Insets(0,0,0,0),new c.Insets(0,0,0,0),this._scaleSetting.get(),this._deviceScaleFactorSetting.get()||n,t,s>=i?Protocol.Emulation.ScreenOrientationType.PortraitPrimary:Protocol.Emulation.ScreenOrientationType.LandscapePrimary,e),this._applyUserAgent(t?se:"",t?ne:null),this._applyTouch(this._uaSetting.get()===K.DesktopTouch||this._uaSetting.get()===K.Mobile,this._uaSetting.get()===K.Mobile)}i&&i.setShowViewportSizeOnResize(this._type===X.None),this.dispatchEventToListeners(G.Updated)}_calculateFitScale(e,t,i,s){const n=i?i.left+i.right:0,o=i?i.top+i.bottom:0,a=s?s.left+s.right:0,l=s?s.top+s.bottom:0;let r=Math.min(e?this._preferredSize.width/(e+n):1,t?this._preferredSize.height/(t+o):1);r=Math.min(Math.floor(100*r),100);let h=r;for(;h>.7*r;){let i=!0;if(e&&(i=i&&Number.isInteger((e-a)*h/100)),t&&(i=i&&Number.isInteger((t-l)*h/100)),i)return h/100;h-=1}return r/100}setSizeAndScaleToFit(e,t){this._scaleSetting.set(this._calculateFitScale(e,t)),this.setWidth(e),this.setHeight(t)}_applyUserAgent(e,t){x.MultitargetNetworkManager.instance().setUserAgentOverride(e,t)}_applyDeviceMetrics(e,t,i,s,n,o,a,l){e.width=Math.max(1,Math.floor(e.width)),e.height=Math.max(1,Math.floor(e.height));let r=e.width-t.left-t.right,h=e.height-t.top-t.bottom;this._emulatedPageSize=new c.Size(r,h);const d=t.left,u=t.top,m=a===Protocol.Emulation.ScreenOrientationType.LandscapePrimary?90:0;if(this._appliedDeviceSize=e,this._appliedDeviceScaleFactor=n||window.devicePixelRatio,this._screenRect=new c.Rect(Math.max(0,(this._availableSize.width-e.width*s)/2),i.top*s,e.width*s,e.height*s),this._outlineRect=new c.Rect(this._screenRect.left-i.left*s,0,(i.left+e.width+i.right)*s,(i.top+e.height+i.bottom)*s),this._visiblePageRect=new c.Rect(d*s,u*s,Math.min(r*s,this._availableSize.width-this._screenRect.left-d*s),Math.min(h*s,this._availableSize.height-this._screenRect.top-u*s)),this._scale=s,1===s&&this._availableSize.width>=e.width&&this._availableSize.height>=e.height&&(r=0,h=0),this._visiblePageRect.width===r*s&&this._visiblePageRect.height===h*s&&Number.isInteger(r*s)&&Number.isInteger(h*s)&&(r=0,h=0),this._emulationModel)if(l&&this._emulationModel.resetPageScaleFactor(),r||h||o||n||1!==s||a){const t={width:r,height:h,deviceScaleFactor:n,mobile:o,scale:s,screenWidth:e.width,screenHeight:e.height,positionX:d,positionY:u,dontSetVisibleSize:!0};a&&(t.screenOrientation={type:a,angle:m}),this._emulationModel.emulateDevice(t)}else this._emulationModel.emulateDevice(null)}exitHingeMode(){const e=this._emulationModel?this._emulationModel.overlayModel():null;e&&e.showHingeForDualScreen(!1)}async captureScreenshot(e,t){const i=this._emulationModel?this._emulationModel.target().model(R.ScreenCaptureModel):null;if(!i)return null;const s=this._emulationModel?this._emulationModel.overlayModel():null;let n;if(s&&s.setShowViewportSizeOnResize(!1),e){const e=await i.fetchLayoutMetrics();if(!e)return null;const s=Math.min(16384/this._appliedDeviceScaleFactor,e.contentHeight);if(n={width:Math.floor(e.contentWidth),height:Math.floor(s),deviceScaleFactor:this._appliedDeviceScaleFactor,mobile:this._isMobile()},t={x:0,y:0,width:n.width,height:n.height,scale:1},this._device){const e=this._mode.orientation===W?Protocol.Emulation.ScreenOrientationType.LandscapePrimary:Protocol.Emulation.ScreenOrientationType.PortraitPrimary,t=e===Protocol.Emulation.ScreenOrientationType.LandscapePrimary?90:0;n.screenOrientation={type:e,angle:t}}await this._emulationModel.resetPageScaleFactor(),await this._emulationModel.emulateDevice(n)}const o=await i.captureScreenshot("png",100,t);if(e){if(this._device){const e=this._device.orientationByName(this._mode.orientation);n.width=e.width,n.height=e.height}else n.width=0,n.height=0;await this._emulationModel.emulateDevice(n)}return this._calculateAndEmulate(!1),o}_applyTouch(e,t){this._touchEnabled=e,this._touchMobile=t;for(const i of D.TargetManager.instance().models(L.EmulationModel))i.emulateTouch(e,t)}_showHingeIfApplicable(e){const t=this._device&&this._mode?this._device.orientationByName(this._mode.orientation):null;this._experimentDualScreenSupport&&t&&t.hinge?e.showHingeForDualScreen(!0,t.hinge):e.showHingeForDualScreen(!1)}}const G={Updated:"Updated"},X={None:"None",Responsive:"Responsive",Device:"Device"},K={Mobile:s.UIString("Mobile"),MobileNoTouch:s.UIString("Mobile (no touch)"),Desktop:s.UIString("Desktop"),DesktopTouch:s.UIString("Desktop (touch)")},Y=50,ee=9999,te=0,ie=10,se=x.MultitargetNetworkManager.patchUserAgentWithChromeVersion("Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36"),ne={brands:x.MultitargetNetworkManager.getChromeBrands(),fullVersion:x.MultitargetNetworkManager.getChromeVersion(),platform:"Android",platformVersion:"6.0",architecture:"",model:"Nexus 5",mobile:!0},oe=2;var ae=Object.freeze({__proto__:null,DeviceModeModel:$,Events:G,Type:X,UA:K,MinDeviceSize:Y,MaxDeviceSize:ee,MinDeviceScaleFactor:te,MaxDeviceScaleFactor:ie,MaxDeviceNameLength:50,_defaultMobileUserAgent:se,_defaultMobileUserAgentMetadata:ne,defaultMobileScaleFactor:oe});class le{constructor(e,i,s){this._model=e;const n=e.device();n&&this._recordDeviceChange(n,null),this._showMediaInspectorSetting=i,this._showRulersSetting=s,this._experimentDualScreenSupport=Root.Runtime.experiments.isEnabled("dualScreenSupport"),this._deviceOutlineSetting=this._model.deviceOutlineSetting(),this._showDeviceScaleFactorSetting=t.Settings.instance().createSetting("emulation.showDeviceScaleFactor",!1),this._showDeviceScaleFactorSetting.addChangeListener(this._updateDeviceScaleFactorVisibility,this),this._showUserAgentTypeSetting=t.Settings.instance().createSetting("emulation.showUserAgentType",!1),this._showUserAgentTypeSetting.addChangeListener(this._updateUserAgentTypeVisibility,this),this._autoAdjustScaleSetting=t.Settings.instance().createSetting("emulation.autoAdjustScale",!0),this._lastMode=new Map,this._element=document.createElement("div"),this._element.classList.add("device-mode-toolbar");const o=this._element.createChild("div","device-mode-toolbar-spacer");o.createChild("div","device-mode-toolbar-spacer");const a=new d.Toolbar("",o);a.makeWrappable(),this._fillLeftToolbar(a);const l=new d.Toolbar("",this._element);l.makeWrappable(),this._fillMainToolbar(l);const r=this._element.createChild("div","device-mode-toolbar-spacer"),h=new d.Toolbar("device-mode-toolbar-fixed-size",r);h.makeWrappable(),this._fillRightToolbar(h);const c=new d.Toolbar("device-mode-toolbar-fixed-size",r);c.makeWrappable(),this._fillModeToolbar(c),r.createChild("div","device-mode-toolbar-spacer");const u=new d.Toolbar("device-mode-toolbar-options",r);function m(){const t=e.toolbarControlsEnabledSetting().get();a.setEnabled(t),l.setEnabled(t),h.setEnabled(t),c.setEnabled(t),u.setEnabled(t)}u.makeWrappable(),this._fillOptionsToolbar(u),this._emulatedDevicesList=Q.instance(),this._emulatedDevicesList.addEventListener(J.CustomDevicesUpdated,this._deviceListChanged,this),this._emulatedDevicesList.addEventListener(J.StandardDevicesUpdated,this._deviceListChanged,this),this._persistenceSetting=t.Settings.instance().createSetting("emulation.deviceModeValue",{device:"",orientation:"",mode:""}),this._model.toolbarControlsEnabledSetting().addChangeListener(m),m()}_recordDeviceChange(e,t){e!==t&&e&&e.isDualScreen&&a.dualScreenDeviceEmulated(l.DualScreenDeviceEmulated.DualScreenDeviceSelected)}_createEmptyToolbarElement(){const e=document.createElement("div");return e.classList.add("device-mode-empty-toolbar-element"),e}_fillLeftToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._deviceSelectItem=new d.ToolbarMenuButton(this._appendDeviceMenuItems.bind(this)),this._deviceSelectItem.setGlyph(""),this._deviceSelectItem.turnIntoSelect(),this._deviceSelectItem.setDarkText(),e.appendToolbarItem(this._deviceSelectItem)}_fillMainToolbar(e){const t=u.createInput("device-mode-size-input","text");t.maxLength=4,t.title=s.UIString("Width"),this._updateWidthInput=u.bindInput(t,this._applyWidth.bind(this),$.widthValidator,!0),this._widthInput=t,this._widthItem=this._wrapToolbarItem(t),e.appendToolbarItem(this._widthItem);const i=document.createElement("div");i.classList.add("device-mode-x"),i.textContent="×",this._xItem=this._wrapToolbarItem(i),e.appendToolbarItem(this._xItem);const n=u.createInput("device-mode-size-input","text");n.maxLength=4,n.title=s.UIString("Height (leave empty for full)"),this._updateHeightInput=u.bindInput(n,this._applyHeight.bind(this),(function(e){if(!e)return{valid:!0};return $.heightValidator(e)}),!0),this._heightInput=n,this._heightItem=this._wrapToolbarItem(n),e.appendToolbarItem(this._heightItem)}_applyWidth(e){const t=e?Number(e):0;this._model.setWidthAndScaleToFit(t)}_applyHeight(e){const t=e?Number(e):0;this._model.setHeightAndScaleToFit(t)}_fillRightToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._scaleItem=new d.ToolbarMenuButton(this._appendScaleMenuItems.bind(this)),this._scaleItem.setTitle(s.UIString("Zoom")),this._scaleItem.setGlyph(""),this._scaleItem.turnIntoSelect(),this._scaleItem.setDarkText(),e.appendToolbarItem(this._scaleItem),e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._deviceScaleItem=new d.ToolbarMenuButton(this._appendDeviceScaleMenuItems.bind(this)),this._deviceScaleItem.setVisible(this._showDeviceScaleFactorSetting.get()),this._deviceScaleItem.setTitle(s.UIString("Device pixel ratio")),this._deviceScaleItem.setGlyph(""),this._deviceScaleItem.turnIntoSelect(),this._deviceScaleItem.setDarkText(),e.appendToolbarItem(this._deviceScaleItem),e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._uaItem=new d.ToolbarMenuButton(this._appendUserAgentMenuItems.bind(this)),this._uaItem.setVisible(this._showUserAgentTypeSetting.get()),this._uaItem.setTitle(s.UIString("Device type")),this._uaItem.setGlyph(""),this._uaItem.turnIntoSelect(),this._uaItem.setDarkText(),e.appendToolbarItem(this._uaItem),this._throttlingConditionsItem=O.throttlingManager().createMobileThrottlingButton(),e.appendToolbarItem(this._throttlingConditionsItem)}_fillModeToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._modeButton=new d.ToolbarButton("","largeicon-rotate-screen"),this._modeButton.addEventListener(d.ToolbarButton.Events.Click,this._modeMenuClicked,this),e.appendToolbarItem(this._modeButton),this._experimentDualScreenSupport&&(this._spanButton=new d.ToolbarButton("","largeicon-dual-screen"),this._spanButton.addEventListener(d.ToolbarButton.Events.Click,this._spanClicked,this),e.appendToolbarItem(this._spanButton))}_fillOptionsToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement()));const t=new d.ToolbarMenuButton(this._appendOptionsMenuItems.bind(this));t.setTitle(s.UIString("More options")),e.appendToolbarItem(t)}_appendScaleMenuItems(e){this._model.type()===X.Device&&e.footerSection().appendItem(s.UIString("Fit to window (%.0f%%)",100*this._model.fitScale()),this._onScaleMenuChanged.bind(this,this._model.fitScale()),!1),e.footerSection().appendCheckboxItem(ls`Auto-adjust zoom`,this._onAutoAdjustScaleChanged.bind(this),this._autoAdjustScaleSetting.get());const t=function(t,i){e.defaultSection().appendCheckboxItem(t,this._onScaleMenuChanged.bind(this,i),this._model.scaleSetting().get()===i,!1)}.bind(this);t(s.UIString("50%"),.5),t(s.UIString("75%"),.75),t(s.UIString("100%"),1),t(s.UIString("125%"),1.25),t(s.UIString("150%"),1.5)}_onScaleMenuChanged(e){this._model.scaleSetting().set(e)}_onAutoAdjustScaleChanged(){this._autoAdjustScaleSetting.set(!this._autoAdjustScaleSetting.get())}_appendDeviceScaleMenuItems(e){const t=this._model.deviceScaleFactorSetting(),i=this._model.uaSetting().get()===K.Mobile||this._model.uaSetting().get()===K.MobileNoTouch?oe:window.devicePixelRatio;function n(e,i,s){e.appendCheckboxItem(i,t.set.bind(t,s),t.get()===s)}n(e.headerSection(),s.UIString("Default: %.1f",i),0),n(e.defaultSection(),s.UIString("1"),1),n(e.defaultSection(),s.UIString("2"),2),n(e.defaultSection(),s.UIString("3"),3)}_appendUserAgentMenuItems(e){const t=this._model.uaSetting();function i(i,s){e.defaultSection().appendCheckboxItem(i,t.set.bind(t,s),t.get()===s)}i(K.Mobile,K.Mobile),i(K.MobileNoTouch,K.MobileNoTouch),i(K.Desktop,K.Desktop),i(K.DesktopTouch,K.DesktopTouch)}_appendOptionsMenuItems(e){const t=this._model;function i(e,i,s,n,o){void 0===o&&(o=t.type()===X.None),e.appendItem(i.get()?s:n,i.set.bind(i,!i.get()),o)}i(e.headerSection(),this._deviceOutlineSetting,s.UIString("Hide device frame"),s.UIString("Show device frame"),t.type()!==X.Device),i(e.headerSection(),this._showMediaInspectorSetting,s.UIString("Hide media queries"),s.UIString("Show media queries")),i(e.headerSection(),this._showRulersSetting,s.UIString("Hide rulers"),s.UIString("Show rulers")),i(e.defaultSection(),this._showDeviceScaleFactorSetting,s.UIString("Remove device pixel ratio"),s.UIString("Add device pixel ratio")),i(e.defaultSection(),this._showUserAgentTypeSetting,s.UIString("Remove device type"),s.UIString("Add device type")),e.appendItemsAtLocation("deviceModeMenu"),e.footerSection().appendItem(s.UIString("Reset to defaults"),this._reset.bind(this)),e.footerSection().appendItem(ls`Close DevTools`,r.InspectorFrontendHostInstance.closeWindow.bind(r.InspectorFrontendHostInstance))}_reset(){this._deviceOutlineSetting.set(!1),this._showDeviceScaleFactorSetting.set(!1),this._showUserAgentTypeSetting.set(!1),this._showMediaInspectorSetting.set(!1),this._showRulersSetting.set(!1),this._model.reset()}_wrapToolbarItem(e){const t=createElement("div");return m.createShadowRootWithCoreStyles(t,"emulation/deviceModeToolbar.css").appendChild(e),new d.ToolbarItem(t)}_emulateDevice(e){const t=this._autoAdjustScaleSetting.get()?void 0:this._model.scaleSetting().get();this._recordDeviceChange(e,this._model.device()),this._model.emulate(X.Device,e,this._lastMode.get(e)||e.modes[0],t)}_switchToResponsive(){this._model.emulate(X.Responsive,null,null)}_filterDevices(e){return(e=e.filter((function(e){return e.show()}))).sort(F.deviceComparator),e}_standardDevices(){return this._filterDevices(this._emulatedDevicesList.standard())}_customDevices(){return this._filterDevices(this._emulatedDevicesList.custom())}_allDevices(){return this._standardDevices().concat(this._customDevices())}_appendDeviceMenuItems(e){function t(t){if(!t.length)return;const i=e.section();for(const e of t)i.appendCheckboxItem(e.title,this._emulateDevice.bind(this,e),this._model.device()===e,!1)}e.headerSection().appendCheckboxItem(s.UIString("Responsive"),this._switchToResponsive.bind(this),this._model.type()===X.Responsive,!1),t.call(this,this._standardDevices()),t.call(this,this._customDevices()),e.footerSection().appendItem(s.UIString("Edit…"),this._emulatedDevicesList.revealCustomSetting.bind(this._emulatedDevicesList),!1)}_deviceListChanged(){const e=this._model.device();if(!e)return;const t=this._allDevices();-1===t.indexOf(e)&&(t.length?this._emulateDevice(t[0]):this._model.emulate(X.Responsive,null,null))}_updateDeviceScaleFactorVisibility(){this._deviceScaleItem.setVisible(this._showDeviceScaleFactorSetting.get())}_updateUserAgentTypeVisibility(){this._uaItem.setVisible(this._showUserAgentTypeSetting.get())}_spanClicked(e){const t=this._model.device();if(!t.isDualScreen)return;a.dualScreenDeviceEmulated(l.DualScreenDeviceEmulated.SpanButtonClicked);const i=this._autoAdjustScaleSetting.get()?void 0:this._model.scaleSetting().get(),s=t.getSpanPartner(this._model.mode());s&&this._model.emulate(this._model.type(),t,s,i)}_modeMenuClicked(e){const t=this._model.device(),i=this._model,n=this._autoAdjustScaleSetting;if(i.type()===X.Responsive){const e=i.appliedDeviceSize();return void(n.get()?i.setSizeAndScaleToFit(e.height,e.width):(i.setWidth(e.height),i.setHeight(e.width)))}if((t.isDualScreen||2===t.modes.length)&&t.modes[0].orientation!==t.modes[1].orientation){const e=n.get()?void 0:i.scaleSetting().get();return void i.emulate(i.type(),i.device(),t.getRotationPartner(i.mode()),e)}const o=new _.ContextMenu(e.data,!1,this._modeButton.element.totalOffsetLeft(),this._modeButton.element.totalOffsetTop()+this._modeButton.element.offsetHeight);function a(e,i){const s=t.modesForOrientation(e);if(s.length)if(1===s.length)l(s[0],i);else for(let e=0;e<s.length;e++)l(s[e],i+" – "+s[e].title)}function l(e,t){o.defaultSection().appendCheckboxItem(t,r.bind(null,e),i.mode()===e,!1)}function r(e){const t=n.get()?void 0:i.scaleSetting().get();i.emulate(i.type(),i.device(),e,t)}a(V,s.UIString("Portrait")),a(W,s.UIString("Landscape")),o.show()}element(){return this._element}update(){this._model.type()!==this._cachedModelType&&(this._cachedModelType=this._model.type(),this._widthInput.disabled=this._model.type()!==X.Responsive,this._heightInput.disabled=this._model.type()!==X.Responsive,this._deviceScaleItem.setEnabled(this._model.type()===X.Responsive),this._uaItem.setEnabled(this._model.type()===X.Responsive),this._experimentDualScreenSupport&&this._spanButton.setEnabled(!1),this._model.type()===X.Responsive?(this._modeButton.setEnabled(!0),this._modeButton.setTitle(ls`Rotate`)):this._modeButton.setEnabled(!1));const e=this._model.appliedDeviceSize();this._updateHeightInput(this._model.type()===X.Responsive&&this._model.isFullHeight()?"":String(e.height)),this._updateWidthInput(String(e.width)),this._heightInput.placeholder=e.height,this._model.scale()!==this._cachedScale&&(this._scaleItem.setText(s.UIString("%.0f%%",100*this._model.scale())),this._cachedScale=this._model.scale());const t=this._model.appliedDeviceScaleFactor();t!==this._cachedDeviceScale&&(this._deviceScaleItem.setText(s.UIString("DPR: %.1f",t)),this._cachedDeviceScale=t);const i=this._model.appliedUserAgentType();i!==this._cachedUaType&&(this._uaItem.setText(i),this._cachedUaType=i);let n=s.UIString("None");if(this._model.type()===X.Responsive&&(n=s.UIString("Responsive")),this._model.type()===X.Device&&(n=this._model.device().title),this._deviceSelectItem.setText(n),this._model.device()!==this._cachedModelDevice){const e=this._model.device();if(e){const t=e?e.modes.length:0;this._modeButton.setEnabled(t>=2),this._modeButton.setTitle(2===t?s.UIString("Rotate"):s.UIString("Screen orientation options")),this._experimentDualScreenSupport&&(e.isDualScreen&&this._spanButton.setEnabled(!0),this._spanButton.setTitle(s.UIString("Toggle dual-screen mode")))}this._cachedModelDevice=e}if(this._model.type()===X.Device&&this._lastMode.set(this._model.device(),this._model.mode()),this._model.mode()!==this._cachedModelMode&&this._model.type()!==X.None){this._cachedModelMode=this._model.mode();const e=this._persistenceSetting.get();this._model.device()?(e.device=this._model.device().title,e.orientation=this._model.mode()?this._model.mode().orientation:"",e.mode=this._model.mode()?this._model.mode().title:""):(e.device="",e.orientation="",e.mode=""),this._persistenceSetting.set(e)}}restore(){for(const e of this._allDevices())if(e.title===this._persistenceSetting.get().device)for(const t of e.modes)if(t.orientation===this._persistenceSetting.get().orientation&&t.title===this._persistenceSetting.get().mode)return this._lastMode.set(e,t),void this._emulateDevice(e);this._model.emulate(X.Responsive,null,null)}}var re=Object.freeze({__proto__:null,DeviceModeToolbar:le});class he extends p.Widget{constructor(e,t){super(!0),this.registerRequiredCSS("emulation/mediaQueryInspector.css"),this.contentElement.classList.add("media-inspector-view"),this.contentElement.addEventListener("click",this._onMediaQueryClicked.bind(this),!1),this.contentElement.addEventListener("contextmenu",this._onContextMenu.bind(this),!1),this._mediaThrottler=new n.Throttler(0),this._getWidthCallback=e,this._setWidthCallback=t,this._scale=1,D.TargetManager.instance().observeModels(z.CSSModel,this),g.ZoomManager.instance().addEventListener(g.Events.ZoomChanged,this._renderMediaQueries.bind(this),this)}modelAdded(e){this._cssModel||(this._cssModel=e,this._cssModel.addEventListener(z.Events.StyleSheetAdded,this._scheduleMediaQueriesUpdate,this),this._cssModel.addEventListener(z.Events.StyleSheetRemoved,this._scheduleMediaQueriesUpdate,this),this._cssModel.addEventListener(z.Events.StyleSheetChanged,this._scheduleMediaQueriesUpdate,this),this._cssModel.addEventListener(z.Events.MediaQueryResultChanged,this._scheduleMediaQueriesUpdate,this))}modelRemoved(e){e===this._cssModel&&(this._cssModel.removeEventListener(z.Events.StyleSheetAdded,this._scheduleMediaQueriesUpdate,this),this._cssModel.removeEventListener(z.Events.StyleSheetRemoved,this._scheduleMediaQueriesUpdate,this),this._cssModel.removeEventListener(z.Events.StyleSheetChanged,this._scheduleMediaQueriesUpdate,this),this._cssModel.removeEventListener(z.Events.MediaQueryResultChanged,this._scheduleMediaQueriesUpdate,this),delete this._cssModel)}setAxisTransform(e){Math.abs(this._scale-e)<1e-8||(this._scale=e,this._renderMediaQueries())}_onMediaQueryClicked(e){const t=e.target.enclosingNodeOrSelfWithClass("media-inspector-bar");if(!t)return;const i=t._model;if(i.section()===ce.Max)return void this._setWidthCallback(i.maxWidthExpression().computedLength());if(i.section()===ce.Min)return void this._setWidthCallback(i.minWidthExpression().computedLength());this._getWidthCallback()!==i.minWidthExpression().computedLength()?this._setWidthCallback(i.minWidthExpression().computedLength()):this._setWidthCallback(i.maxWidthExpression().computedLength())}_onContextMenu(e){if(!this._cssModel||!this._cssModel.isEnabled())return;const t=e.target.enclosingNodeOrSelfWithClass("media-inspector-bar");if(!t)return;const i=t._locations,n=new Map;for(let e=0;e<i.length;++e){const t=k.CSSWorkspaceBinding.instance().rawLocationToUILocation(i[e]);if(!t)continue;const s=A.sprintf("%s:%d:%d",t.uiSourceCode.url(),t.lineNumber+1,t.columnNumber+1);n.set(s,t)}const o=[...n.keys()].sort(),a=new _.ContextMenu(e),l=a.defaultSection().appendSubMenuItem(s.UIString("Reveal in source code"));for(let e=0;e<o.length;++e){const t=o[e];l.defaultSection().appendItem(t,this._revealSourceLocation.bind(this,n.get(t)))}a.show()}_revealSourceLocation(e){i.reveal(e)}_scheduleMediaQueriesUpdate(){this.isShowing()&&this._mediaThrottler.schedule(this._refetchMediaQueries.bind(this))}_refetchMediaQueries(){return this.isShowing()&&this._cssModel?this._cssModel.mediaQueriesPromise().then(this._rebuildMediaQueries.bind(this)):Promise.resolve()}_squashAdjacentEqual(e){const t=[];for(let i=0;i<e.length;++i){const s=t.peekLast();s&&s.equals(e[i])||t.push(e[i])}return t}_rebuildMediaQueries(e){let t=[];for(let i=0;i<e.length;++i){const s=e[i];if(s.mediaList)for(let e=0;e<s.mediaList.length;++e){const i=s.mediaList[e],n=de.createFromMediaQuery(s,i);n&&t.push(n)}}t.sort((function(e,t){return e.compareTo(t)})),t=this._squashAdjacentEqual(t);let i=this._cachedQueryModels&&this._cachedQueryModels.length===t.length;for(let e=0;i&&e<t.length;++e)i=i&&this._cachedQueryModels[e].equals(t[e]);i||(this._cachedQueryModels=t,this._renderMediaQueries())}_renderMediaQueries(){if(!this._cachedQueryModels||!this.isShowing())return;const e=[];let t=null;for(let i=0;i<this._cachedQueryModels.length;++i){const s=this._cachedQueryModels[i];t&&t.model.dimensionsEqual(s)?t.active=t.active||s.active():(t={active:s.active(),model:s,locations:[]},e.push(t));const n=s.rawLocation();n&&t.locations.push(n)}this.contentElement.removeChildren();let i=null;for(let t=0;t<e.length;++t){t&&e[t].model.section()===e[t-1].model.section()||(i=this.contentElement.createChild("div","media-inspector-marker-container"));const s=e[t],n=this._createElementFromMediaQueryModel(s.model);n._model=s.model,n._locations=s.locations,n.classList.toggle("media-inspector-marker-inactive",!s.active),i.appendChild(n)}}_zoomFactor(){return g.ZoomManager.instance().zoomFactor()/this._scale}wasShown(){this._scheduleMediaQueriesUpdate()}_createElementFromMediaQueryModel(e){const t=this._zoomFactor(),i=e.minWidthExpression()?e.minWidthExpression().computedLength()/t:0,s=e.maxWidthExpression()?e.maxWidthExpression().computedLength()/t:0,n=document.createElement("div");if(n.classList.add("media-inspector-bar"),e.section()===ce.Max){n.createChild("div","media-inspector-marker-spacer");const t=n.createChild("div","media-inspector-marker media-inspector-marker-max-width");t.style.width=s+"px",t.title=e.mediaText(),o(t,e.maxWidthExpression(),!1,!1),o(t,e.maxWidthExpression(),!0,!0),n.createChild("div","media-inspector-marker-spacer")}if(e.section()===ce.MinMax){n.createChild("div","media-inspector-marker-spacer");const t=n.createChild("div","media-inspector-marker media-inspector-marker-min-max-width");t.style.width=.5*(s-i)+"px",t.title=e.mediaText(),o(t,e.maxWidthExpression(),!0,!1),o(t,e.minWidthExpression(),!1,!0),n.createChild("div","media-inspector-marker-spacer").style.flex="0 0 "+i+"px";const a=n.createChild("div","media-inspector-marker media-inspector-marker-min-max-width");a.style.width=.5*(s-i)+"px",a.title=e.mediaText(),o(a,e.minWidthExpression(),!0,!1),o(a,e.maxWidthExpression(),!1,!0),n.createChild("div","media-inspector-marker-spacer")}if(e.section()===ce.Min){const t=n.createChild("div","media-inspector-marker media-inspector-marker-min-width media-inspector-marker-min-width-left");t.title=e.mediaText(),o(t,e.minWidthExpression(),!1,!1),n.createChild("div","media-inspector-marker-spacer").style.flex="0 0 "+i+"px";const s=n.createChild("div","media-inspector-marker media-inspector-marker-min-width media-inspector-marker-min-width-right");s.title=e.mediaText(),o(s,e.minWidthExpression(),!0,!0)}function o(e,t,i,s){e.createChild("div","media-inspector-marker-label-container "+(i?"media-inspector-marker-label-container-left":"media-inspector-marker-label-container-right")).createChild("span","media-inspector-marker-label "+(s?"media-inspector-label-left":"media-inspector-label-right")).textContent=t.value()+t.unit()}return n}}const ce={Max:0,MinMax:1,Min:2};class de{constructor(e,t,i,s){this._cssMedia=e,this._minWidthExpression=t,this._maxWidthExpression=i,this._active=s,this._section=i&&!t?ce.Max:t&&i?ce.MinMax:ce.Min}static createFromMediaQuery(e,t){let i=null,s=Number.MAX_VALUE,n=null,o=Number.MIN_VALUE;const a=t.expressions();for(let e=0;e<a.length;++e){const t=a[e],l=t.feature();if(-1===l.indexOf("width"))continue;const r=t.computedLength();l.startsWith("max-")&&r<s?(i=t,s=r):l.startsWith("min-")&&r>o&&(n=t,o=r)}return o>s||!i&&!n?null:new de(e,n,i,t.active())}equals(e){return 0===this.compareTo(e)}dimensionsEqual(e){return!(this.section()!==e.section()||this.minWidthExpression()&&this.minWidthExpression().computedLength()!==e.minWidthExpression().computedLength()||this.maxWidthExpression()&&this.maxWidthExpression().computedLength()!==e.maxWidthExpression().computedLength())}compareTo(e){if(this.section()!==e.section())return this.section()-e.section();if(this.dimensionsEqual(e)){const t=this.rawLocation(),i=e.rawLocation();return t||i?t&&!i?1:!t&&i?-1:this.active()!==e.active()?this.active()?-1:1:t.url.compareTo(i.url)||t.lineNumber-i.lineNumber||t.columnNumber-i.columnNumber:this.mediaText().compareTo(e.mediaText())}return this.section()===ce.Max?e.maxWidthExpression().computedLength()-this.maxWidthExpression().computedLength():this.section()===ce.Min?this.minWidthExpression().computedLength()-e.minWidthExpression().computedLength():this.minWidthExpression().computedLength()-e.minWidthExpression().computedLength()||e.maxWidthExpression().computedLength()-this.maxWidthExpression().computedLength()}section(){return this._section}mediaText(){return this._cssMedia.text}rawLocation(){return this._rawLocation||(this._rawLocation=this._cssMedia.rawLocation()),this._rawLocation}minWidthExpression(){return this._minWidthExpression}maxWidthExpression(){return this._maxWidthExpression}active(){return this._active}}var ue=Object.freeze({__proto__:null,MediaQueryInspector:he,Section:ce,MediaQueryUIModel:de});class me extends p.VBox{constructor(){super(!0),this.wrapperInstance,this.setMinimumSize(150,150),this.element.classList.add("device-mode-view"),this.registerRequiredCSS("emulation/deviceModeView.css"),v.Tooltip.addNativeOverrideContainer(this.contentElement),this._model=self.singleton($),this._model.addEventListener(G.Updated,this._updateUI,this),this._mediaInspector=new he(()=>this._model.appliedDeviceSize().width,this._model.setWidth.bind(this._model)),this._showMediaInspectorSetting=t.Settings.instance().moduleSetting("showMediaQueryInspector"),this._showMediaInspectorSetting.addChangeListener(this._updateUI,this),this._showRulersSetting=t.Settings.instance().moduleSetting("emulation.showRulers"),this._showRulersSetting.addChangeListener(this._updateUI,this),this._topRuler=new _e(!0,this._model.setWidthAndScaleToFit.bind(this._model)),this._topRuler.element.classList.add("device-mode-ruler-top"),this._leftRuler=new _e(!1,this._model.setHeightAndScaleToFit.bind(this._model)),this._leftRuler.element.classList.add("device-mode-ruler-left"),this._createUI(),g.ZoomManager.instance().addEventListener(g.Events.ZoomChanged,this._zoomChanged,this)}_createUI(){this._toolbar=new le(this._model,this._showMediaInspectorSetting,this._showRulersSetting),this.contentElement.appendChild(this._toolbar.element()),this._contentClip=this.contentElement.createChild("div","device-mode-content-clip vbox"),this._responsivePresetsContainer=this._contentClip.createChild("div","device-mode-presets-container"),this._populatePresetsContainer(),this._mediaInspectorContainer=this._contentClip.createChild("div","device-mode-media-container"),this._contentArea=this._contentClip.createChild("div","device-mode-content-area"),this._outlineImage=this._contentArea.createChild("img","device-mode-outline-image hidden fill"),this._outlineImage.addEventListener("load",this._onImageLoaded.bind(this,this._outlineImage,!0),!1),this._outlineImage.addEventListener("error",this._onImageLoaded.bind(this,this._outlineImage,!1),!1),this._screenArea=this._contentArea.createChild("div","device-mode-screen-area"),this._screenImage=this._screenArea.createChild("img","device-mode-screen-image hidden"),this._screenImage.addEventListener("load",this._onImageLoaded.bind(this,this._screenImage,!0),!1),this._screenImage.addEventListener("error",this._onImageLoaded.bind(this,this._screenImage,!1),!1),this._bottomRightResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-bottom-right-resizer"),this._bottomRightResizerElement.createChild("div",""),this._createResizer(this._bottomRightResizerElement,2,1),this._bottomLeftResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-bottom-left-resizer"),this._bottomLeftResizerElement.createChild("div",""),this._createResizer(this._bottomLeftResizerElement,-2,1),this._rightResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-right-resizer"),this._rightResizerElement.createChild("div",""),this._createResizer(this._rightResizerElement,2,0),this._leftResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-left-resizer"),this._leftResizerElement.createChild("div",""),this._createResizer(this._leftResizerElement,-2,0),this._bottomResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-bottom-resizer"),this._bottomResizerElement.createChild("div",""),this._createResizer(this._bottomResizerElement,0,1),this._bottomResizerElement.addEventListener("dblclick",this._model.setHeight.bind(this._model,0),!1),this._bottomResizerElement.title=s.UIString("Double-click for full height"),this._pageArea=this._screenArea.createChild("div","device-mode-page-area"),this._pageArea.createChild("slot")}_populatePresetsContainer(){const e=[320,375,425,768,1024,1440,2560],t=[s.UIString("Mobile S"),s.UIString("Mobile M"),s.UIString("Mobile L"),s.UIString("Tablet"),s.UIString("Laptop"),s.UIString("Laptop L"),s.UIString("4K")];this._presetBlocks=[];const i=this._responsivePresetsContainer.createChild("div","device-mode-presets-container-inner");for(let s=e.length-1;s>=0;--s){const o=i.createChild("div","fill device-mode-preset-bar-outer").createChild("div","device-mode-preset-bar");o.createChild("span").textContent=t[s]+" – "+e[s]+"px",o.addEventListener("click",n.bind(this,e[s]),!1),o.__width=e[s],this._presetBlocks.push(o)}function n(e,t){this._model.emulate(X.Responsive,null,null),this._model.setWidthAndScaleToFit(e),t.consume()}}_createResizer(e,t,i){const s=new S.ResizerWidget;s.addElement(e);let n=t?"ew-resize":"ns-resize";return t*i>0&&(n="nwse-resize"),t*i<0&&(n="nesw-resize"),s.setCursor(n),s.addEventListener(S.Events.ResizeStart,this._onResizeStart,this),s.addEventListener(S.Events.ResizeUpdate,this._onResizeUpdate.bind(this,t,i)),s.addEventListener(S.Events.ResizeEnd,this._onResizeEnd,this),s}_onResizeStart(e){this._slowPositionStart=null,this._resizeStart=this._model.screenRect().size()}_onResizeUpdate(e,t,i){i.data.shiftKey!==!!this._slowPositionStart&&(this._slowPositionStart=i.data.shiftKey?{x:i.data.currentX,y:i.data.currentY}:null);let s=i.data.currentX-i.data.startX,n=i.data.currentY-i.data.startY;if(this._slowPositionStart&&(s=(i.data.currentX-this._slowPositionStart.x)/10+this._slowPositionStart.x-i.data.startX,n=(i.data.currentY-this._slowPositionStart.y)/10+this._slowPositionStart.y-i.data.startY),e){const t=s*g.ZoomManager.instance().zoomFactor();let i=this._resizeStart.width+t*e;i=Math.round(i/this._model.scale()),i>=Y&&i<=ee&&this._model.setWidth(i)}if(t){const e=n*g.ZoomManager.instance().zoomFactor();let i=this._resizeStart.height+e*t;i=Math.round(i/this._model.scale()),i>=Y&&i<=ee&&this._model.setHeight(i)}}exitHingeMode(){this._model&&this._model.exitHingeMode()}_onResizeEnd(e){delete this._resizeStart,a.actionTaken(l.Action.ResizedViewInResponsiveMode)}_updateUI(){function e(e,t){e.style.left=t.left+"px",e.style.top=t.top+"px",e.style.width=t.width+"px",e.style.height=t.height+"px"}if(!this.isShowing())return;const t=g.ZoomManager.instance().zoomFactor();let i=!1;const s=this._showRulersSetting.get()&&this._model.type()!==X.None;let n=!1,o=!1;const a=this._model.screenRect().scale(1/t);a.isEqual(this._cachedCssScreenRect)||(e(this._screenArea,a),o=!0,i=!0,this._cachedCssScreenRect=a);const l=this._model.visiblePageRect().scale(1/t);l.isEqual(this._cachedCssVisiblePageRect)||(e(this._pageArea,l),i=!0,this._cachedCssVisiblePageRect=l);const r=this._model.outlineRect().scale(1/t);r.isEqual(this._cachedOutlineRect)||(e(this._outlineImage,r),i=!0,this._cachedOutlineRect=r),this._contentClip.classList.toggle("device-mode-outline-visible",!!this._model.outlineImage());const h=this._model.type()===X.Responsive;h!==this._cachedResizable&&(this._rightResizerElement.classList.toggle("hidden",!h),this._leftResizerElement.classList.toggle("hidden",!h),this._bottomResizerElement.classList.toggle("hidden",!h),this._bottomRightResizerElement.classList.toggle("hidden",!h),this._bottomLeftResizerElement.classList.toggle("hidden",!h),this._cachedResizable=h);const c=this._showMediaInspectorSetting.get()&&this._model.type()!==X.None;if(c!==this._cachedMediaInspectorVisible&&(c?this._mediaInspector.show(this._mediaInspectorContainer):this._mediaInspector.detach(),n=!0,i=!0,this._cachedMediaInspectorVisible=c),s!==this._cachedShowRulers&&(this._contentClip.classList.toggle("device-mode-rulers-visible",s),s?(this._topRuler.show(this._contentArea),this._leftRuler.show(this._contentArea)):(this._topRuler.detach(),this._leftRuler.detach()),n=!0,i=!0,this._cachedShowRulers=s),this._model.scale()!==this._cachedScale){o=!0,i=!0;for(const e of this._presetBlocks)e.style.width=e.__width*this._model.scale()+"px";this._cachedScale=this._model.scale()}this._toolbar.update(),this._loadImage(this._screenImage,this._model.screenImage()),this._loadImage(this._outlineImage,this._model.outlineImage()),this._mediaInspector.setAxisTransform(this._model.scale()),i&&this.doResize(),o&&(this._topRuler.render(this._model.scale()),this._leftRuler.render(this._model.scale()),this._topRuler.element.positionAt(this._cachedCssScreenRect?this._cachedCssScreenRect.left:0,this._cachedCssScreenRect?this._cachedCssScreenRect.top:0),this._leftRuler.element.positionAt(this._cachedCssScreenRect?this._cachedCssScreenRect.left:0,this._cachedCssScreenRect?this._cachedCssScreenRect.top:0)),n&&this._contentAreaResized()}_loadImage(e,t){e.getAttribute("srcset")!==t&&(e.setAttribute("srcset",t),t||e.classList.toggle("hidden",!0))}_onImageLoaded(e,t){e.classList.toggle("hidden",!t)}setNonEmulatedAvailableSize(e){if(this._model.type()!==X.None)return;const t=g.ZoomManager.instance().zoomFactor(),i=e.getBoundingClientRect(),s=new c.Size(Math.max(i.width*t,1),Math.max(i.height*t,1));this._model.setAvailableSize(s,s)}_contentAreaResized(){const e=g.ZoomManager.instance().zoomFactor(),t=this._contentArea.getBoundingClientRect(),i=new c.Size(Math.max(t.width*e,1),Math.max(t.height*e,1)),s=new c.Size(Math.max((t.width-2*this._handleWidth)*e,1),Math.max((t.height-this._handleHeight)*e,1));this._model.setAvailableSize(i,s)}_measureHandles(){const e=this._rightResizerElement.classList.contains("hidden");this._rightResizerElement.classList.toggle("hidden",!1),this._bottomResizerElement.classList.toggle("hidden",!1),this._handleWidth=this._rightResizerElement.offsetWidth,this._handleHeight=this._bottomResizerElement.offsetHeight,this._rightResizerElement.classList.toggle("hidden",e),this._bottomResizerElement.classList.toggle("hidden",e)}_zoomChanged(){delete this._handleWidth,delete this._handleHeight,this.isShowing()&&(this._measureHandles(),this._contentAreaResized())}onResize(){this.isShowing()&&this._contentAreaResized()}wasShown(){this._measureHandles(),this._toolbar.restore()}willHide(){this._model.emulate(X.None,null,null)}async captureScreenshot(){const e=await this._model.captureScreenshot(!1);if(null===e)return;const t=new Image;t.src="data:image/png;base64,"+e,t.onload=async()=>{const e=t.naturalWidth/this._model.screenRect().width,i=this._model.outlineRect().scale(e),s=this._model.screenRect().scale(e),n=this._model.visiblePageRect().scale(e),o=s.left+n.left-i.left,a=s.top+n.top-i.top,l=createElement("canvas");l.width=Math.floor(i.width),l.height=Math.floor(i.height);const r=l.getContext("2d");r.imageSmoothingEnabled=!1,this._model.outlineImage()&&await this._paintImage(r,this._model.outlineImage(),i.relativeTo(i)),this._model.screenImage()&&await this._paintImage(r,this._model.screenImage(),s.relativeTo(i)),r.drawImage(t,Math.floor(o),Math.floor(a)),this._saveScreenshot(l)}}async captureFullSizeScreenshot(){const e=await this._model.captureScreenshot(!0);if(null!==e)return this._saveScreenshotBase64(e)}async captureAreaScreenshot(e){const t=await this._model.captureScreenshot(!1,e);if(null!==t)return this._saveScreenshotBase64(t)}_saveScreenshotBase64(e){const t=new Image;t.src="data:image/png;base64,"+e,t.onload=()=>{const e=createElement("canvas");e.width=t.naturalWidth,e.height=t.naturalHeight;const i=e.getContext("2d");i.imageSmoothingEnabled=!1,i.drawImage(t,0,0),this._saveScreenshot(e)}}_paintImage(e,t,i){return new Promise(s=>{const n=new Image;n.crossOrigin="Anonymous",n.srcset=t,n.onerror=s,n.onload=()=>{e.drawImage(n,i.left,i.top,i.width,i.height),s()}})}_saveScreenshot(e){const t=this._model.inspectedURL();let i="";if(t){const e=A.removeURLFragment(t);i=A.trimURL(e)}this._model.type()===X.Device&&(i+=s.UIString("(%s)",this._model.device().title));const n=createElement("a");n.download=i+".png",e.toBlob(e=>{n.href=URL.createObjectURL(e),n.click()})}}class _e extends p.VBox{constructor(e,t){super(),this.element.classList.add("device-mode-ruler"),this._contentElement=this.element.createChild("div","device-mode-ruler-content").createChild("div","device-mode-ruler-inner"),this._horizontal=e,this._scale=1,this._count=0,this._throttler=new n.Throttler(0),this._applyCallback=t}render(e){this._scale=e,this._throttler.schedule(this._update.bind(this))}onResize(){this._throttler.schedule(this._update.bind(this))}_update(){const e=g.ZoomManager.instance().zoomFactor(),t=this._horizontal?this._contentElement.offsetWidth:this._contentElement.offsetHeight;this._scale===this._renderedScale&&e===this._renderedZoomFactor||(this._contentElement.removeChildren(),this._count=0,this._renderedScale=this._scale,this._renderedZoomFactor=e);const i=t*e/this._scale,s=Math.ceil(i/5);let n=1;this._scale<.8&&(n=2),this._scale<.6&&(n=4),this._scale<.4&&(n=8),this._scale<.2&&(n=16),this._scale<.1&&(n=32);for(let e=s;e<this._count;e++)e%n||this._contentElement.lastChild.remove();for(let t=this._count;t<s;t++){if(t%n)continue;const i=this._contentElement.createChild("div","device-mode-ruler-marker");if(t&&(this._horizontal?i.style.left=5*t*this._scale/e+"px":i.style.top=5*t*this._scale/e+"px",!(t%20))){const e=i.createChild("div","device-mode-ruler-text");e.textContent=5*t,e.addEventListener("click",this._onMarkerClick.bind(this,5*t),!1)}t%10?t%5||i.classList.add("device-mode-ruler-marker-medium"):i.classList.add("device-mode-ruler-marker-large")}return this._count=s,Promise.resolve()}_onMarkerClick(e){this._applyCallback.call(null,e)}}var pe=Object.freeze({__proto__:null,DeviceModeView:me,Ruler:_e});class ge extends p.VBox{constructor(e){super(),me.wrapperInstance=this,this._inspectedPagePlaceholder=e,this._deviceModeView=null,this._toggleDeviceModeAction=self.UI.actionRegistry.action("emulation.toggle-device-mode");const t=self.singleton($);this._showDeviceModeSetting=t.enabledSetting(),this._showDeviceModeSetting.setRequiresUserAction(!!Root.Runtime.queryParam("hasOtherClients")),this._showDeviceModeSetting.addChangeListener(this._update.bind(this,!1)),D.TargetManager.instance().addModelListener(T.OverlayModel,T.Events.ScreenshotRequested,this._screenshotRequestedFromOverlay,this),this._update(!0)}_toggleDeviceMode(){this._showDeviceModeSetting.set(!this._showDeviceModeSetting.get())}_captureScreenshot(e,t){return this._deviceModeView||(this._deviceModeView=new me),this._deviceModeView.setNonEmulatedAvailableSize(this._inspectedPagePlaceholder.element),e?this._deviceModeView.captureFullSizeScreenshot():t?this._deviceModeView.captureAreaScreenshot(t):this._deviceModeView.captureScreenshot(),!0}_screenshotRequestedFromOverlay(e){const t=e.data;this._captureScreenshot(!1,t)}_update(e){if(this._toggleDeviceModeAction.setToggled(this._showDeviceModeSetting.get()),!e){const e=this._deviceModeView&&this._deviceModeView.isShowing();if(this._showDeviceModeSetting.get()===e)return}this._showDeviceModeSetting.get()?(this._deviceModeView||(this._deviceModeView=new me),this._deviceModeView.show(this.element),this._inspectedPagePlaceholder.clearMinimumSize(),this._inspectedPagePlaceholder.show(this._deviceModeView.element)):(this._deviceModeView&&(this._deviceModeView.exitHingeMode(),this._deviceModeView.detach()),this._inspectedPagePlaceholder.restoreMinimumSize(),this._inspectedPagePlaceholder.show(this.element))}}var ve=Object.freeze({__proto__:null,DeviceModeWrapper:ge,ActionDelegate:class{handleAction(e,t){if(me.wrapperInstance)switch(t){case"emulation.capture-screenshot":return me.wrapperInstance._captureScreenshot();case"emulation.capture-node-screenshot":{const e=self.UI.context.flavor(U.DOMNode);if(!e)return!0;return async function(){const t=await e.resolveToObject(),i=await t.callFunction((function(){const e=this.getBoundingClientRect(),t=this.ownerDocument.documentElement.getBoundingClientRect();return JSON.stringify({x:e.left-t.left,y:e.top-t.top,width:e.width,height:e.height,scale:1})})),s=JSON.parse(i.object.value),n=await e.domModel().target().pageAgent().invoke_getLayoutMetrics({}),o=!n[M.ProtocolError]&&n.visualViewport.zoom||1;s.x*=o,s.y*=o,s.width*=o,s.height*=o,me.wrapperInstance._captureScreenshot(!1,s)}(),!0}case"emulation.capture-full-height-screenshot":return me.wrapperInstance._captureScreenshot(!0);case"emulation.toggle-device-mode":return me.wrapperInstance._toggleDeviceMode(),!0}return!1}}});class Se extends p.Widget{constructor(){super(!0),this.registerRequiredCSS("emulation/inspectedPagePlaceholder.css"),g.ZoomManager.instance().addEventListener(g.Events.ZoomChanged,this.onResize,this),this.restoreMinimumSize()}onResize(){this._updateId&&this.element.window().cancelAnimationFrame(this._updateId),this._updateId=this.element.window().requestAnimationFrame(this.update.bind(this,!1))}restoreMinimumSize(){this.setMinimumSize(150,150)}clearMinimumSize(){this.setMinimumSize(1,1)}_dipPageRect(){const e=g.ZoomManager.instance().zoomFactor(),t=this.element.getBoundingClientRect(),i=this.element.ownerDocument.body.getBoundingClientRect(),s=Math.max(t.left*e,i.left*e),n=Math.max(t.top*e,i.top*e),o=Math.min(t.bottom*e,i.bottom*e);return{x:s,y:n,width:Math.min(t.right*e,i.right*e)-s,height:o-n}}update(e){delete this._updateId;const t=this._dipPageRect(),i={x:Math.round(t.x),y:Math.round(t.y),height:Math.max(1,Math.round(t.height)),width:Math.max(1,Math.round(t.width))};e&&(--i.height,this.dispatchEventToListeners(we.Update,i),++i.height),this.dispatchEventToListeners(we.Update,i)}}const be=function(){return self.singleton(Se)},we={Update:Symbol("Update")};var fe=Object.freeze({__proto__:null,InspectedPagePlaceholder:Se,instance:be,Events:we});let Ie;class Ce{constructor(){self.Components.dockController.addEventListener(o.Events.BeforeDockSideChanged,this._openToolboxWindow,this)}static _instance(){return Ie||(Ie=new Ce),Ie}presentUI(e){const t=new b.RootView;this._rootSplitWidget=new w.SplitWidget(!1,!0,"InspectorView.splitViewState",555,300,!0),this._rootSplitWidget.show(t.element),this._rootSplitWidget.setSidebarWidget(self.UI.inspectorView),this._rootSplitWidget.setDefaultFocusedChild(self.UI.inspectorView),self.UI.inspectorView.setOwnerSplit(this._rootSplitWidget),this._inspectedPagePlaceholder=be(),this._inspectedPagePlaceholder.addEventListener(we.Update,this._onSetInspectedPageBounds.bind(this),this),this._deviceModeView=new ge(this._inspectedPagePlaceholder),self.Components.dockController.addEventListener(o.Events.BeforeDockSideChanged,this._onBeforeDockSideChange,this),self.Components.dockController.addEventListener(o.Events.DockSideChanged,this._onDockSideChange,this),self.Components.dockController.addEventListener(o.Events.AfterDockSideChanged,this._onAfterDockSideChange,this),this._onDockSideChange(),console.timeStamp("AdvancedApp.attachToBody"),t.attachToDocument(e),t.focus(),this._inspectedPagePlaceholder.update()}_openToolboxWindow(e){if(e.data.to!==o.State.Undocked)return;if(this._toolboxWindow)return;const t=window.location.href.replace("devtools_app.html","toolbox.html");this._toolboxWindow=window.open(t,void 0)}toolboxLoaded(e){u.initializeUIUtils(e,t.Settings.instance().createSetting("uiTheme","default")),u.installComponentRootStyles(e.body),_.ContextMenu.installHandler(e),v.Tooltip.installHandler(e),this._toolboxRootView=new b.RootView,this._toolboxRootView.attachToDocument(e),this._updateDeviceModeView()}_updateDeviceModeView(){this._isDocked()?this._rootSplitWidget.setMainWidget(this._deviceModeView):this._toolboxRootView&&this._deviceModeView.show(this._toolboxRootView.element)}_onBeforeDockSideChange(e){e.data.to===o.State.Undocked&&this._toolboxRootView&&(this._rootSplitWidget.hideSidebar(),this._inspectedPagePlaceholder.update()),this._changingDockSide=!0}_onDockSideChange(e){this._updateDeviceModeView();const t=e?e.data.to:self.Components.dockController.dockSide();t===o.State.Undocked?this._updateForUndocked():this._toolboxRootView&&e&&e.data.from===o.State.Undocked?this._rootSplitWidget.hideSidebar():this._updateForDocked(t)}_onAfterDockSideChange(e){this._changingDockSide&&(e.data.from===o.State.Undocked&&this._updateForDocked(e.data.to),this._changingDockSide=!1,this._inspectedPagePlaceholder.update())}_updateForDocked(e){this._rootSplitWidget.resizerElement().style.transform=e===o.State.DockedToRight?"translateX(2px)":e===o.State.DockedToLeft?"translateX(-2px)":"",this._rootSplitWidget.setVertical(e===o.State.DockedToRight||e===o.State.DockedToLeft),this._rootSplitWidget.setSecondIsSidebar(e===o.State.DockedToRight||e===o.State.DockedToBottom),this._rootSplitWidget.toggleResizer(this._rootSplitWidget.resizerElement(),!0),this._rootSplitWidget.toggleResizer(self.UI.inspectorView.topResizerElement(),e===o.State.DockedToBottom),this._rootSplitWidget.showBoth()}_updateForUndocked(){this._rootSplitWidget.toggleResizer(this._rootSplitWidget.resizerElement(),!1),this._rootSplitWidget.toggleResizer(self.UI.inspectorView.topResizerElement(),!1),this._rootSplitWidget.hideMain()}_isDocked(){return self.Components.dockController.dockSide()!==o.State.Undocked}_onSetInspectedPageBounds(e){if(this._changingDockSide)return;const t=this._inspectedPagePlaceholder.element.window();if(!t.innerWidth||!t.innerHeight)return;if(!this._inspectedPagePlaceholder.isShowing())return;const i=e.data;console.timeStamp("AdvancedApp.setInspectedPageBounds"),r.InspectorFrontendHostInstance.setInspectedPageBounds(i)}}var Ee=Object.freeze({__proto__:null,AdvancedApp:Ce,AdvancedAppProvider:class{createApp(){return Ce._instance()}}});class Me extends p.VBox{constructor(){super(),this.element.classList.add("settings-tab-container"),this.element.classList.add("devices-settings-tab"),this.registerRequiredCSS("emulation/devicesSettingsTab.css");this.element.createChild("header").createChild("h1").createTextChild(ls`Emulated Devices`),this.containerElement=this.element.createChild("div","settings-container-wrapper").createChild("div","settings-tab settings-content settings-container");const e=this.containerElement.createChild("div","devices-button-row");this._addCustomButton=u.createTextButton(s.UIString("Add custom device..."),this._addCustomDevice.bind(this)),e.appendChild(this._addCustomButton),this._list=new f.ListWidget(this,!1),this._list.registerRequiredCSS("emulation/devicesSettingsTab.css"),this._list.element.classList.add("devices-list"),this._list.show(this.containerElement),this._muteUpdate=!1,this._emulatedDevicesList=Q.instance(),this._emulatedDevicesList.addEventListener(J.CustomDevicesUpdated,this._devicesUpdated,this),this._emulatedDevicesList.addEventListener(J.StandardDevicesUpdated,this._devicesUpdated,this),this.setDefaultFocusedElement(this._addCustomButton)}wasShown(){super.wasShown(),this._devicesUpdated()}_devicesUpdated(){if(this._muteUpdate)return;this._list.clear();let e=this._emulatedDevicesList.custom().slice();for(let t=0;t<e.length;++t)this._list.appendItem(e[t],!0);this._list.appendSeparator(),e=this._emulatedDevicesList.standard().slice(),e.sort(F.deviceComparator);for(let t=0;t<e.length;++t)this._list.appendItem(e[t],!1)}_muteAndSaveDeviceList(e){this._muteUpdate=!0,e?this._emulatedDevicesList.saveCustomDevices():this._emulatedDevicesList.saveStandardDevices(),this._muteUpdate=!1}_addCustomDevice(){const e=new F;e.deviceScaleFactor=0,e.horizontal.width=700,e.horizontal.height=400,e.vertical.width=400,e.vertical.height=700,this._list.addNewItem(this._emulatedDevicesList.custom().length,e)}_toNumericInputValue(e){return e?String(e):""}renderItem(e,t){const i=e,s=document.createElement("label");s.classList.add("devices-list-item");const n=s.createChild("input","devices-list-checkbox");return n.type="checkbox",n.checked=i.show(),n.addEventListener("click",function(e){const s=n.checked;i.setShow(s),this._muteAndSaveDeviceList(t),e.consume()}.bind(this),!1),s.appendChild(document.createTextNode(i.title)),s}removeItemRequested(e,t){this._emulatedDevicesList.removeCustomDevice(e)}commitEdit(e,t,i){const s=e;s.title=t.control("title").value.trim(),s.vertical.width=t.control("width").value?parseInt(t.control("width").value,10):0,s.vertical.height=t.control("height").value?parseInt(t.control("height").value,10):0,s.horizontal.width=s.vertical.height,s.horizontal.height=s.vertical.width,s.deviceScaleFactor=t.control("scale").value?parseFloat(t.control("scale").value):0,s.userAgent=t.control("user-agent").value,s.modes=[],s.modes.push({title:"",orientation:V,insets:new c.Insets(0,0,0,0),image:null}),s.modes.push({title:"",orientation:W,insets:new c.Insets(0,0,0,0),image:null}),s.capabilities=[];const n=t.control("ua-type").value;n!==K.Mobile&&n!==K.MobileNoTouch||s.capabilities.push(H.Mobile),n!==K.Mobile&&n!==K.DesktopTouch||s.capabilities.push(H.Touch),i?this._emulatedDevicesList.addCustomDevice(s):this._emulatedDevicesList.saveCustomDevices(),this._addCustomButton.scrollIntoViewIfNeeded(),this._addCustomButton.focus()}beginEdit(e){const t=e,i=this._createEditor();let s;return i.control("title").value=t.title,i.control("width").value=this._toNumericInputValue(t.vertical.width),i.control("height").value=this._toNumericInputValue(t.vertical.height),i.control("scale").value=this._toNumericInputValue(t.deviceScaleFactor),i.control("user-agent").value=t.userAgent,s=t.mobile()?t.touch()?K.Mobile:K.MobileNoTouch:t.touch()?K.DesktopTouch:K.Desktop,i.control("ua-type").value=s,i}_createEditor(){if(this._editor)return this._editor;const e=new f.Editor;this._editor=e;const t=e.contentElement().createChild("div","devices-edit-fields");t.createChild("div","hbox").appendChild(e.createInput("title","text",ls`Device Name`,(function(e,t,i){let s,n=!1;const o=i.value.trim();o.length>=50?s=ls`Device name must be less than ${50} characters.`:0===o.length?s=ls`Device name cannot be empty.`:n=!0;return{valid:n,errorMessage:s}})));const i=t.createChild("div","hbox");i.appendChild(e.createInput("width","text",ls`Width`,(function(e,t,i){return $.widthValidator(i.value)}))),i.appendChild(e.createInput("height","text",ls`Height`,(function(e,t,i){return $.heightValidator(i.value)})));const s=e.createInput("scale","text",ls`Device pixel ratio`,(function(e,t,i){return $.scaleValidator(i.value)}));s.classList.add("device-edit-fixed"),i.appendChild(s);const n=t.createChild("div","hbox");n.appendChild(e.createInput("user-agent","text",ls`User agent string`,()=>({valid:!0})));const o=[K.Mobile,K.MobileNoTouch,K.Desktop,K.DesktopTouch],a=e.createSelect("ua-type",o,()=>({valid:!0}),ls`User agent type`);return a.classList.add("device-edit-fixed"),n.appendChild(a),e}}var xe=Object.freeze({__proto__:null,DevicesSettingsTab:Me});class De extends p.VBox{constructor(){super(!0),this.registerRequiredCSS("emulation/sensors.css"),this.contentElement.classList.add("sensors-view"),this._LocationSetting=t.Settings.instance().createSetting("emulation.locationOverride",""),this._Location=L.Location.parseSetting(this._LocationSetting.get()),this._LocationOverrideEnabled=!1,this._createLocationSection(this._Location),this.contentElement.createChild("div").classList.add("panel-section-separator"),this._deviceOrientationSetting=t.Settings.instance().createSetting("emulation.deviceOrientationOverride",""),this._deviceOrientation=L.DeviceOrientation.parseSetting(this._deviceOrientationSetting.get()),this._deviceOrientationOverrideEnabled=!1,this._createDeviceOrientationSection(),this.contentElement.createChild("div").classList.add("panel-section-separator"),this._appendTouchControl(),this.contentElement.createChild("div").classList.add("panel-section-separator"),this._appendIdleEmulator()}static instance(){return De._instanceObject||(De._instanceObject=new De),De._instanceObject}_createLocationSection(e){const n=this.contentElement.createChild("section","sensors-group"),o=u.createLabel(ls`Location`,"sensors-group-title");n.appendChild(o);const a=n.createChild("div","geo-fields");let l=0;const r={title:s.UIString("No override"),location:ye.NoOverride};this._locationSelectElement=a.createChild("select","chrome-select"),I.bindLabelToControl(o,this._locationSelectElement),this._locationSelectElement.appendChild(new Option(r.title,r.location)),this._customLocationsGroup=this._locationSelectElement.createChild("optgroup"),this._customLocationsGroup.label=ls`Overrides`;const c=t.Settings.instance().moduleSetting("emulation.locations"),d=u.createTextButton(ls`Manage`,()=>i.reveal(c));I.setAccessibleName(d,ls`Manage the list of locations`),a.appendChild(d);const m=()=>{this._customLocationsGroup.removeChildren();for(const[t,i]of c.get().entries())this._customLocationsGroup.appendChild(new Option(i.title,JSON.stringify(i))),e.latitude===i.lat&&e.longitude===i.long&&(l=t+1)};c.addChangeListener(m),m();const _={title:s.UIString("Other…"),location:ye.Custom};this._locationSelectElement.appendChild(new Option(_.title,_.location));const p=this._locationSelectElement.createChild("optgroup");p.label=ls`Error`,p.appendChild(new Option(ls`Location unavailable`,ye.Unavailable)),this._locationSelectElement.selectedIndex=l,this._locationSelectElement.addEventListener("change",this._LocationSelectChanged.bind(this)),this._fieldsetElement=a.createChild("fieldset"),this._fieldsetElement.disabled=!this._LocationOverrideEnabled,this._fieldsetElement.id="location-override-section";const g=this._fieldsetElement.createChild("div","latlong-group"),v=this._fieldsetElement.createChild("div","latlong-group"),S=this._fieldsetElement.createChild("div","latlong-group"),b=this._fieldsetElement.createChild("div","latlong-group"),w=h.isMac()?"⌘":"Ctrl",f=ls`Adjust with mousewheel or up/down keys. ${w}: ±10, Shift: ±1, Alt: ±0.01`;this._latitudeInput=u.createInput("","number"),g.appendChild(this._latitudeInput),this._latitudeInput.setAttribute("step","any"),this._latitudeInput.value=0,this._latitudeSetter=u.bindInput(this._latitudeInput,this._applyLocationUserInput.bind(this),L.Location.latitudeValidator,!0,.1),this._latitudeSetter(String(e.latitude)),this._latitudeInput.title=f,g.appendChild(u.createLabel(ls`Latitude`,"latlong-title",this._latitudeInput)),this._longitudeInput=u.createInput("","number"),v.appendChild(this._longitudeInput),this._longitudeInput.setAttribute("step","any"),this._longitudeInput.value=0,this._longitudeSetter=u.bindInput(this._longitudeInput,this._applyLocationUserInput.bind(this),L.Location.longitudeValidator,!0,.1),this._longitudeSetter(String(e.longitude)),this._longitudeInput.title=f,v.appendChild(u.createLabel(ls`Longitude`,"latlong-title",this._longitudeInput)),this._timezoneInput=u.createInput("","text"),S.appendChild(this._timezoneInput),this._timezoneInput.value="Europe/Berlin",this._timezoneSetter=u.bindInput(this._timezoneInput,this._applyLocationUserInput.bind(this),L.Location.timezoneIdValidator,!1),this._timezoneSetter(e.timezoneId),S.appendChild(u.createLabel(ls`Timezone ID`,"timezone-title",this._timezoneInput)),this._timezoneError=S.createChild("div","timezone-error"),this._localeInput=u.createInput("","text"),b.appendChild(this._localeInput),this._localeInput.value="en-US",this._localeSetter=u.bindInput(this._localeInput,this._applyLocationUserInput.bind(this),L.Location.localeValidator,!1),this._localeSetter(e.locale),b.appendChild(u.createLabel(ls`Locale`,"locale-title",this._localeInput)),this._localeError=b.createChild("div","locale-error")}_LocationSelectChanged(){this._fieldsetElement.disabled=!1,this._timezoneError.textContent="";const e=this._locationSelectElement.options[this._locationSelectElement.selectedIndex].value;if(e===ye.NoOverride)this._LocationOverrideEnabled=!1,this._clearFieldsetElementInputs(),this._fieldsetElement.disabled=!0;else if(e===ye.Custom){this._LocationOverrideEnabled=!0;const e=L.Location.parseUserInput(this._latitudeInput.value.trim(),this._longitudeInput.value.trim(),this._timezoneInput.value.trim(),this._localeInput.value.trim());if(!e)return;this._Location=e}else if(e===ye.Unavailable)this._LocationOverrideEnabled=!0,this._Location=new L.Location(0,0,"","",!0);else{this._LocationOverrideEnabled=!0;const t=JSON.parse(e);this._Location=new L.Location(t.lat,t.long,t.timezoneId,t.locale,!1),this._latitudeSetter(t.lat),this._longitudeSetter(t.long),this._timezoneSetter(t.timezoneId),this._localeSetter(t.locale)}this._applyLocation(),e===ye.Custom&&this._latitudeInput.focus()}_applyLocationUserInput(){const e=L.Location.parseUserInput(this._latitudeInput.value.trim(),this._longitudeInput.value.trim(),this._timezoneInput.value.trim(),this._localeInput.value.trim());e&&(this._timezoneError.textContent="",this._setSelectElementLabel(this._locationSelectElement,ye.Custom),this._Location=e,this._applyLocation())}_applyLocation(){this._LocationOverrideEnabled?this._LocationSetting.set(this._Location.toSetting()):this._LocationSetting.remove();for(const e of D.TargetManager.instance().models(L.EmulationModel))e.emulateLocation(this._LocationOverrideEnabled?this._Location:null).catch(e=>{switch(e.type){case"emulation-set-timezone":this._timezoneError.textContent=e.message;break;case"emulation-set-locale":this._localeError.textContent=e.message}})}_clearFieldsetElementInputs(){this._latitudeSetter(0),this._longitudeSetter(0),this._timezoneSetter(""),this._localeSetter("")}_createDeviceOrientationSection(){const e=this.contentElement.createChild("section","sensors-group"),t=u.createLabel(ls`Orientation`,"sensors-group-title");e.appendChild(t);const i=e.createChild("div","orientation-content"),n=i.createChild("div","orientation-fields"),o={title:s.UIString("Off"),orientation:ye.NoOverride},a={title:s.UIString("Custom orientation"),orientation:ye.Custom};this._orientationSelectElement=this.contentElement.createChild("select","chrome-select"),I.bindLabelToControl(t,this._orientationSelectElement),this._orientationSelectElement.appendChild(new Option(o.title,o.orientation)),this._orientationSelectElement.appendChild(new Option(a.title,a.orientation));const l=Re;for(let e=0;e<l.length;++e){const t=this._orientationSelectElement.createChild("optgroup");t.label=l[e].title;const i=l[e].value;for(let e=0;e<i.length;++e)t.appendChild(new Option(i[e].title,i[e].orientation))}this._orientationSelectElement.selectedIndex=0,n.appendChild(this._orientationSelectElement),this._orientationSelectElement.addEventListener("change",this._orientationSelectChanged.bind(this)),this._deviceOrientationFieldset=this._createDeviceOrientationOverrideElement(this._deviceOrientation),this._stageElement=i.createChild("div","orientation-stage"),this._orientationLayer=this._stageElement.createChild("div","orientation-layer"),this._boxElement=this._orientationLayer.createChild("section","orientation-box orientation-element"),this._boxElement.createChild("section","orientation-front orientation-element"),this._boxElement.createChild("section","orientation-top orientation-element"),this._boxElement.createChild("section","orientation-back orientation-element"),this._boxElement.createChild("section","orientation-left orientation-element"),this._boxElement.createChild("section","orientation-right orientation-element"),this._boxElement.createChild("section","orientation-bottom orientation-element"),u.installDragHandle(this._stageElement,this._onBoxDragStart.bind(this),e=>{this._onBoxDrag(e)},null,"-webkit-grabbing","-webkit-grab"),n.appendChild(this._deviceOrientationFieldset),this._enableOrientationFields(!0),this._setBoxOrientation(this._deviceOrientation,!1)}_enableOrientationFields(e){e?(this._deviceOrientationFieldset.disabled=!0,this._stageElement.classList.add("disabled"),this._stageElement.title=ls`Enable orientation to rotate`):(this._deviceOrientationFieldset.disabled=!1,this._stageElement.classList.remove("disabled"),this._stageElement.title=ls`Shift+drag horizontally to rotate around the y-axis`)}_orientationSelectChanged(){const e=this._orientationSelectElement.options[this._orientationSelectElement.selectedIndex].value;if(this._enableOrientationFields(!1),e===ye.NoOverride)this._deviceOrientationOverrideEnabled=!1,this._enableOrientationFields(!0);else if(e===ye.Custom)this._deviceOrientationOverrideEnabled=!0,this._alphaElement.focus();else{const t=JSON.parse(e);this._deviceOrientationOverrideEnabled=!0,this._deviceOrientation=new L.DeviceOrientation(t[0],t[1],t[2]),this._setDeviceOrientation(this._deviceOrientation,Le.SelectPreset)}}_applyDeviceOrientation(){this._deviceOrientationOverrideEnabled&&this._deviceOrientationSetting.set(this._deviceOrientation.toSetting());for(const e of D.TargetManager.instance().models(L.EmulationModel))e.emulateDeviceOrientation(this._deviceOrientationOverrideEnabled?this._deviceOrientation:null)}_setSelectElementLabel(e,t){const i=Array.prototype.map.call(e.options,e=>e.value);e.selectedIndex=i.indexOf(t)}_applyDeviceOrientationUserInput(){this._setDeviceOrientation(L.DeviceOrientation.parseUserInput(this._alphaElement.value.trim(),this._betaElement.value.trim(),this._gammaElement.value.trim()),Le.UserInput),this._setSelectElementLabel(this._orientationSelectElement,ye.Custom)}_resetDeviceOrientation(){this._setDeviceOrientation(new L.DeviceOrientation(0,90,0),Le.ResetButton),this._setSelectElementLabel(this._orientationSelectElement,"[0, 90, 0]")}_setDeviceOrientation(e,t){if(!e)return;function i(e){return Math.round(1e4*e)/1e4}t!==Le.UserInput&&(this._alphaSetter(i(e.alpha)),this._betaSetter(i(e.beta)),this._gammaSetter(i(e.gamma)));const s=t!==Le.UserDrag;this._setBoxOrientation(e,s),this._deviceOrientation=e,this._applyDeviceOrientation(),I.alert(ls`Device orientation set to alpha: ${e.alpha}, beta: ${e.beta}, gamma: ${e.gamma}`,this._orientationSelectElement)}_createAxisInput(e,t,i){const s=e.createChild("div","orientation-axis-input-container");return s.appendChild(t),s.appendChild(u.createLabel(i,"",t)),t.type="number",u.bindInput(t,this._applyDeviceOrientationUserInput.bind(this),L.DeviceOrientation.validator,!0)}_createDeviceOrientationOverrideElement(e){const t=createElement("fieldset");t.classList.add("device-orientation-override-section");const i=t.createChild("td","orientation-inputs-cell");this._alphaElement=u.createInput(),this._alphaElement.setAttribute("step","any"),this._alphaSetter=this._createAxisInput(i,this._alphaElement,s.UIString("α (alpha)")),this._alphaSetter(String(e.alpha)),this._betaElement=u.createInput(),this._betaElement.setAttribute("step","any"),this._betaSetter=this._createAxisInput(i,this._betaElement,s.UIString("β (beta)")),this._betaSetter(String(e.beta)),this._gammaElement=u.createInput(),this._gammaElement.setAttribute("step","any"),this._gammaSetter=this._createAxisInput(i,this._gammaElement,s.UIString("γ (gamma)")),this._gammaSetter(String(e.gamma));const n=u.createTextButton(s.UIString("Reset"),this._resetDeviceOrientation.bind(this),"orientation-reset-button");return I.setAccessibleName(n,ls`Reset device orientation`),n.setAttribute("type","reset"),i.appendChild(n),t}_setBoxOrientation(e,t){t?this._stageElement.classList.add("is-animating"):this._stageElement.classList.remove("is-animating");const i=new WebKitCSSMatrix;this._boxMatrix=i.rotate(-e.beta,e.gamma,-e.alpha);const s=new c.EulerAngles(e.alpha,e.beta,e.gamma);this._orientationLayer.style.transform=s.toRotate3DString()}_onBoxDrag(e){const t=this._calculateRadiusVector(e.x,e.y);if(!t)return!0;let i,s;e.consume(!0),e.shiftKey?(i=new c.Vector(0,0,-1),s=(this._mouseDownVector.x-t.x)*ze):(i=c.crossProduct(this._mouseDownVector,t),s=c.calculateAngle(this._mouseDownVector,t));let n=new WebKitCSSMatrix;n=n.rotate(-90,0,0).rotateAxisAngle(i.x,i.y,i.z,s).rotate(90,0,0).multiply(this._originalBoxMatrix);const o=c.EulerAngles.fromRotationMatrix(n),a=new L.DeviceOrientation(-o.alpha,-o.beta,o.gamma);return this._setDeviceOrientation(a,Le.UserDrag),this._setSelectElementLabel(this._orientationSelectElement,ye.Custom),!1}_onBoxDragStart(e){return!!this._deviceOrientationOverrideEnabled&&(this._mouseDownVector=this._calculateRadiusVector(e.x,e.y),this._originalBoxMatrix=this._boxMatrix,!!this._mouseDownVector&&(e.consume(!0),!0))}_calculateRadiusVector(e,t){const i=this._stageElement.getBoundingClientRect(),s=Math.max(i.width,i.height)/2,n=(e-i.left-i.width/2)/s,o=(t-i.top-i.height/2)/s,a=n*n+o*o;return a>.5?new c.Vector(n,o,.5/Math.sqrt(a)):new c.Vector(n,o,Math.sqrt(1-a))}_appendTouchControl(){const e=this.contentElement.createChild("div","touch-section"),i=C.createControlForSetting(t.Settings.instance().moduleSetting("emulation.touch"),ls`Forces touch instead of click`);i&&e.appendChild(i)}_appendIdleEmulator(){const e=this.contentElement.createChild("div","idle-section"),i=C.createControlForSetting(t.Settings.instance().moduleSetting("emulation.idleDetection"),ls`Forces selected idle state emulation`);i&&e.appendChild(i)}}const Le={UserInput:"userInput",UserDrag:"userDrag",ResetButton:"resetButton",SelectPreset:"selectPreset"},ye={NoOverride:"noOverride",Custom:"custom",Unavailable:"unavailable"},Re=[{title:ls`Presets`,value:[{title:s.UIString("Portrait"),orientation:"[0, 90, 0]"},{title:s.UIString("Portrait upside down"),orientation:"[180, -90, 0]"},{title:s.UIString("Landscape left"),orientation:"[0, 90, -90]"},{title:s.UIString("Landscape right"),orientation:"[0, 90, 90]"},{title:s.UIString("Display up"),orientation:"[0, 0, 0]"},{title:s.UIString("Display down"),orientation:"[0, 180, 0]"}]}];const ze=16;var Te=Object.freeze({__proto__:null,SensorsView:De,DeviceOrientationModificationSource:Le,NonPresetOptions:ye,PresetOrientations:Re,ShowActionDelegate:class{handleAction(e,t){return E.ViewManager.instance().showView("sensors"),!0}},ShiftDragOrientationSpeed:ze});class Ue extends p.VBox{constructor(){super(!0),this.registerRequiredCSS("emulation/locationsSettingsTab.css"),this.contentElement.createChild("div","header").textContent=s.UIString("Custom locations");const e=u.createTextButton(s.UIString("Add location…"),this._addButtonClicked.bind(this),"add-locations-button");this.contentElement.appendChild(e),this._list=new f.ListWidget(this),this._list.element.classList.add("locations-list"),this._list.registerRequiredCSS("emulation/locationsSettingsTab.css"),this._list.show(this.contentElement),this._customSetting=t.Settings.instance().moduleSetting("emulation.locations"),this._customSetting.addChangeListener(this._locationsUpdated,this),this.setDefaultFocusedElement(e)}wasShown(){super.wasShown(),this._locationsUpdated()}_locationsUpdated(){this._list.clear();const e=this._customSetting.get();for(let t=0;t<e.length;++t)this._list.appendItem(e[t],!0);this._list.appendSeparator()}_addButtonClicked(){this._list.addNewItem(this._customSetting.get().length,{title:"",lat:0,long:0,timezoneId:"",locale:""})}renderItem(e,t){const i=e,s=document.createElement("div");s.classList.add("locations-list-item");const n=s.createChild("div","locations-list-text locations-list-title").createChild("div","locations-list-title-text");return n.textContent=i.title,n.title=i.title,s.createChild("div","locations-list-separator"),s.createChild("div","locations-list-text").textContent=i.lat,s.createChild("div","locations-list-separator"),s.createChild("div","locations-list-text").textContent=i.long,s.createChild("div","locations-list-separator"),s.createChild("div","locations-list-text").textContent=i.timezoneId,s.createChild("div","locations-list-separator"),s.createChild("div","locations-list-text").textContent=i.locale,s}removeItemRequested(e,t){const i=this._customSetting.get();i.splice(t,1),this._customSetting.set(i)}commitEdit(e,t,i){const s=e;s.title=t.control("title").value.trim();const n=t.control("lat").value.trim();s.lat=n?parseFloat(n):0;const o=t.control("long").value.trim();s.long=o?parseFloat(o):0;const a=t.control("timezoneId").value.trim();s.timezoneId=a;const l=t.control("locale").value.trim();s.locale=l;const r=this._customSetting.get();i&&r.push(s),this._customSetting.set(r)}beginEdit(e){const t=e,i=this._createEditor();return i.control("title").value=t.title,i.control("lat").value=String(t.lat),i.control("long").value=String(t.long),i.control("timezoneId").value=t.timezoneId,i.control("locale").value=t.locale,i}_createEditor(){if(this._editor)return this._editor;const e=new f.Editor;this._editor=e;const t=e.contentElement(),i=t.createChild("div","locations-edit-row");i.createChild("div","locations-list-text locations-list-title").textContent=s.UIString("Location name"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=s.UIString("Lat"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=s.UIString("Long"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=s.UIString("Timezone ID"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=s.UIString("Locale");const n=t.createChild("div","locations-edit-row");n.createChild("div","locations-list-text locations-list-title locations-input-container").appendChild(e.createInput("title","text",ls`Location name`,(function(e,t,i){const s=i.value.trim();let n;s.length?s.length>50&&(n=ls`Location name must be less than ${50} characters`):n=ls`Location name cannot be empty`;if(n)return{valid:!1,errorMessage:n};return{valid:!0}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible");let o=n.createChild("div","locations-list-text locations-input-container");return o.appendChild(e.createInput("lat","text",ls`Latitude`,(function(e,t,i){const s=i.value.trim(),n=Number(s);if(!s)return{valid:!0};let o;Number.isNaN(n)?o=ls`Latitude must be a number`:parseFloat(s)<-90?o=ls`Latitude must be greater than or equal to ${-90}`:parseFloat(s)>90&&(o=ls`Latitude must be less than or equal to ${90}`);if(o)return{valid:!1,errorMessage:o};return{valid:!0}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible"),o=n.createChild("div","locations-list-text locations-list-text-longitude locations-input-container"),o.appendChild(e.createInput("long","text",ls`Longitude`,(function(e,t,i){const s=i.value.trim(),n=Number(s);if(!s)return{valid:!0};let o;Number.isNaN(n)?o=ls`Longitude must be a number`:parseFloat(s)<-180?o=ls`Longitude must be greater than or equal to ${-180}`:parseFloat(s)>180&&(o=ls`Longitude must be less than or equal to ${180}`);if(o)return{valid:!1,errorMessage:o};return{valid:!0}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible"),o=n.createChild("div","locations-list-text locations-input-container"),o.appendChild(e.createInput("timezoneId","text",ls`Timezone ID`,(function(e,t,i){const s=i.value.trim();if(""===s||/[a-zA-Z]/.test(s))return{valid:!0};return{valid:!1,errorMessage:ls`Timezone ID must contain alphabetic characters`}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible"),o=n.createChild("div","locations-list-text locations-input-container"),o.appendChild(e.createInput("locale","text",ls`Locale`,(function(e,t,i){const s=i.value.trim();if(""===s||/[a-zA-Z]{2}/.test(s))return{valid:!0};return{valid:!1,errorMessage:ls`Locale must contain alphabetic characters`}}))),e}}var Ae=Object.freeze({__proto__:null,LocationsSettingsTab:Ue,Item:void 0});export{Ee as AdvancedApp,ae as DeviceModeModel,re as DeviceModeToolbar,pe as DeviceModeView,ve as DeviceModeWrapper,xe as DevicesSettingsTab,Z as EmulatedDevices,fe as InspectedPagePlaceholder,Ae as LocationsSettingsTab,ue as MediaQueryInspector,Te as SensorsView};
