import{IssuesManager}from'../browser_sdk/browser_sdk.js';import{Console,Throttler}from'../common/common.js';import{ConsoleModel}from'../sdk/sdk.js';import{Toolbar,Utils,ViewManager,ARIAUtils}from'../ui/ui.js';class WarningErrorCounter{constructor(){WarningErrorCounter._instanceForTest=this;const countersWrapper=createElement('div');this._toolbarItem=new Toolbar.ToolbarItem(countersWrapper);this._counter=createElement('div');this._counter.addEventListener('click',Console.Console.instance().show.bind(Console.Console.instance()),false);const shadowRoot=Utils.createShadowRootWithCoreStyles(this._counter,'console_counters/errorWarningCounter.css');countersWrapper.appendChild(this._counter);this._violationCounter=createElement('div');this._violationCounter.addEventListener('click',()=>{ViewManager.ViewManager.instance().showView('lighthouse');});const violationShadowRoot=Utils.createShadowRootWithCoreStyles(this._violationCounter,'console_counters/errorWarningCounter.css');if(Root.Runtime.experiments.isEnabled('spotlight')){countersWrapper.appendChild(this._violationCounter);}
this._issuesCounter=createElement('div');this._issuesCounter.addEventListener('click',()=>{ViewManager.ViewManager.instance().showView('issues-pane');});const issuesShadowRoot=Utils.createShadowRootWithCoreStyles(this._issuesCounter,'console_counters/errorWarningCounter.css');if(Root.Runtime.experiments.isEnabled('issuesPane')){countersWrapper.appendChild(this._issuesCounter);}
this._errors=this._createItem(shadowRoot,'smallicon-error');this._warnings=this._createItem(shadowRoot,'smallicon-warning');if(Root.Runtime.experiments.isEnabled('spotlight')){this._violations=this._createItem(violationShadowRoot,'smallicon-info');}
if(Root.Runtime.experiments.isEnabled('issuesPane')){this._issues=this._createItem(issuesShadowRoot,'smallicon-issue-blue-text');}
this._titles='';this._errorCount=-1;this._warningCount=-1;this._violationCount=-1;this._issuesCount=-1;this._throttler=new Throttler.Throttler(100);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.ConsoleCleared,this._update,this);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.MessageAdded,this._update,this);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.MessageUpdated,this._update,this);IssuesManager.IssuesManager.instance().addEventListener(IssuesManager.Events.IssuesCountUpdated,this._update,this);this._update();}
_updatedForTest(){}
_createItem(shadowRoot,iconType){const item=createElementWithClass('span','counter-item');ARIAUtils.markAsHidden(item);const icon=item.createChild('span','','dt-icon-label');icon.type=iconType;const text=icon.createChild('span');shadowRoot.appendChild(item);return{item:item,text:text};}
_updateItem(item,count,first){item.item.classList.toggle('hidden',!count);item.item.classList.toggle('counter-item-first',first);item.text.textContent=count;}
_update(){this._updatingForTest=true;this._throttler.schedule(this._updateThrottled.bind(this));}
_updateThrottled(){const errors=ConsoleModel.ConsoleModel.instance().errors();const warnings=ConsoleModel.ConsoleModel.instance().warnings();const violations=ConsoleModel.ConsoleModel.instance().violations();const issues=IssuesManager.IssuesManager.instance().numberOfIssues();if(errors===this._errorCount&&warnings===this._warningCount&&violations===this._violationCount&&issues===this._issuesCount){return Promise.resolve();}
this._errorCount=errors;this._warningCount=warnings;this._violationCount=violations;this._issuesCount=issues;this._counter.classList.toggle('hidden',!(errors||warnings));this._violationCounter.classList.toggle('hidden',!violations);this._toolbarItem.setVisible(!!(errors||warnings||violations));let errorCountTitle='';if(errors===1){errorCountTitle=ls`${errors} error`;}else{errorCountTitle=ls`${errors} errors`;}
this._updateItem(this._errors,errors,false);let warningCountTitle='';if(warnings===1){warningCountTitle=ls`${warnings} warning`;}else{warningCountTitle=ls`${warnings} warnings`;}
this._updateItem(this._warnings,warnings,!errors);if(Root.Runtime.experiments.isEnabled('spotlight')){let violationCountTitle='';if(violations===1){violationCountTitle=ls`${violations} violation`;}else{violationCountTitle=ls`${violations} violations`;}
this._updateItem(this._violations,violations,true);this._violationCounter.title=violationCountTitle;}
if(Root.Runtime.experiments.isEnabled('issuesPane')){let issuesCountTitle='';if(issues===1){issuesCountTitle=ls`${issues} issue`;}else{issuesCountTitle=ls`${issues} issues`;}
this._updateItem(this._issues,issues,true);this._issuesCounter.title=issuesCountTitle;}
this._titles='';if(errors&warnings){this._titles=ls`${errorCountTitle}, ${warningCountTitle}`;}else if(errors){this._titles=errorCountTitle;}else if(warnings){this._titles=warningCountTitle;}
this._counter.title=this._titles;ARIAUtils.setAccessibleName(this._counter,this._titles);self.UI.inspectorView.toolbarItemResized();this._updatingForTest=false;this._updatedForTest();return Promise.resolve();}
item(){return this._toolbarItem;}}
var WarningErrorCounter$1=Object.freeze({__proto__:null,WarningErrorCounter:WarningErrorCounter});export{WarningErrorCounter$1 as WarningErrorCounter};