/*
 * Copyright (C) 2012 Apple Inc. All rights reserved.
 * Copyright (C) 2019 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(ASYNC_SCROLLING)

#include <WebCore/ScrollingConstraints.h>
#include <WebCore/ScrollingPlatformLayer.h>
#include <WebCore/ScrollingTreeNode.h>
#include <WebCore/ScrollingTreeViewportConstrainedNode.h>
#include <wtf/RefPtr.h>
#include <wtf/TZoneMalloc.h>

namespace WebCore {

class ScrollingTreeStickyNode : public ScrollingTreeViewportConstrainedNode {
    WTF_MAKE_TZONE_ALLOCATED(ScrollingTreeStickyNode);
public:
    virtual ~ScrollingTreeStickyNode();

    FloatSize scrollDeltaSinceLastCommit() const;
    WEBCORE_EXPORT bool isCurrentlySticking() const;

protected:
    ScrollingTreeStickyNode(ScrollingTree&, ScrollingNodeID);

    bool commitStateBeforeChildren(const ScrollingStateNode&) override;

    FloatPoint computeClippingLayerPosition() const;
    std::optional<FloatRect> findConstrainingRect() const;
    std::pair<std::optional<FloatRect>, FloatPoint> computeConstrainingRectAndAnchorLayerPosition() const;
    void dumpProperties(WTF::TextStream&, OptionSet<ScrollingStateTreeAsTextBehavior>) const override;

    virtual FloatPoint layerTopLeft() const = 0;
    virtual bool hasViewportClippingLayer() const { return false; }
    const ViewportConstraints& constraints() const final { return m_constraints; }

    bool isCurrentlySticking(const FloatRect& constrainingRect) const;

    StickyPositionViewportConstraints m_constraints;
};

} // namespace WebCore

SPECIALIZE_TYPE_TRAITS_SCROLLING_NODE(ScrollingTreeStickyNode, isStickyNode())

#endif // ENABLE(ASYNC_SCROLLING)
